/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.util.ArrayList;
import util.settings.Property;
import util.settings.PropertyManager;

public class StringArrayProperty
extends Property {
    private String[] mDefaultValue;
    private String[] mCachedValue;

    public StringArrayProperty(PropertyManager manager, String key, String[] defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
    }

    public String[] getDefault() {
        return this.mDefaultValue;
    }

    public boolean containsItem(String str) {
        return this.indexOfItem(str) != -1;
    }

    public void removeItem(String str) {
        int index;
        String[] arr = this.getStringArray();
        if (arr != null && (index = this.indexOfItem(str)) != -1) {
            String[] newArr = new String[arr.length - 1];
            System.arraycopy(arr, 0, newArr, 0, index);
            System.arraycopy(arr, index + 1, newArr, index, arr.length - index - 1);
            this.setStringArray(newArr);
        }
    }

    public void addItem(String str) {
        String[] arr = this.getStringArray();
        if (arr == null) {
            this.setStringArray(new String[]{str});
        } else if (this.indexOfItem(str) == -1) {
            String[] newArr = new String[arr.length + 1];
            System.arraycopy(arr, 0, newArr, 0, arr.length);
            newArr[newArr.length - 1] = str;
            this.setStringArray(newArr);
        }
    }

    private int indexOfItem(String str) {
        String[] arr = this.getStringArray();
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] == null ? str == null : arr[i].equals(str))) continue;
                return i;
            }
        }
        return -1;
    }

    public String[] getStringArray() {
        if (this.mCachedValue == null) {
            String asString = this.getProperty();
            this.mCachedValue = asString == null ? this.mDefaultValue : this.splitStrings(asString);
        }
        return this.mCachedValue;
    }

    public void setStringArray(String[] value) {
        if (value == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        boolean equalsDefault = false;
        if (this.mDefaultValue != null && value.length == this.mDefaultValue.length) {
            equalsDefault = true;
            for (int i = 0; i < value.length; ++i) {
                if (value[i].equals(this.mDefaultValue[i])) continue;
                equalsDefault = false;
                break;
            }
        }
        if (equalsDefault) {
            this.setProperty(null);
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < value.length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append(this.addSlashes(value[i]));
            }
            this.setProperty(buffer.toString());
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }

    private String[] splitStrings(String string) {
        String[] splitted = string.split(",");
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (String element : splitted) {
            if (element.endsWith("\\") && (this.countEndSlashes(element) & 1) == 1) {
                current.append(element.substring(0, element.length() - 1));
                current.append(',');
                continue;
            }
            current.append(element);
            list.add(current.toString().replaceAll("\\\\\\\\", "\\\\"));
            current = new StringBuilder();
        }
        return list.toArray(new String[list.size()]);
    }

    private int countEndSlashes(String str) {
        int count = 0;
        for (int pos = str.length() - 1; pos > 0 && str.charAt(pos) == '\\'; --pos) {
            ++count;
        }
        return count;
    }

    public String toString() {
        return this.getProperty();
    }

    private String addSlashes(String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll(",", "\\\\,");
        return string;
    }
}

