/*
 * Decompiled with CFR 0.152.
 */
package util.ui.view;

import java.awt.Component;
import java.util.ArrayList;
import util.ui.view.SplitView;
import util.ui.view.View;
import util.ui.view.ViewProperty;

public class Node {
    private Node mParent;
    private Component mLeafComponent;
    private Component mContent;
    private ArrayList<Node> mNodes;
    private ViewProperty mProperty;
    private View mView;
    private boolean mIsValid;

    public Node(Node parent) {
        this.mParent = parent;
        this.mNodes = new ArrayList();
        if (this.mParent != null) {
            this.mParent.add(this);
        }
        this.mIsValid = false;
    }

    private void markAsInvalid() {
        this.mIsValid = false;
        if (this.mParent != null) {
            this.mParent.markAsInvalid();
        }
    }

    public Component getComponent() {
        if (this.mIsValid) {
            return this.mContent;
        }
        Node[] nodes = this.getNodes();
        if (nodes.length == 0) {
            if (this.mLeafComponent == null) {
                throw new RuntimeException("non-empty leaf expected");
            }
            this.mContent = this.mLeafComponent;
        } else {
            if (nodes.length == 1) {
                return nodes[0].getComponent();
            }
            Component[] comps = new Component[nodes.length];
            for (int i = 0; i < comps.length; ++i) {
                comps[i] = nodes[i].getComponent();
            }
            this.mView = new SplitView();
            this.mView.setComponents(comps);
            ViewProperty prop = this.getProperty();
            this.mView.setProperty(prop);
            this.mContent = this.mView.getContent();
        }
        this.mIsValid = true;
        return this.mContent;
    }

    public void setProperty(ViewProperty prop) {
        this.mProperty = prop;
    }

    public ViewProperty getProperty() {
        return this.mProperty;
    }

    public void setLeaf(Component comp) {
        this.markAsInvalid();
        this.mLeafComponent = comp;
    }

    public Component getLeaf() {
        return this.mLeafComponent;
    }

    public void add(Node node) {
        this.mNodes.add(node);
    }

    public Node[] getNodes() {
        ArrayList<Node> nodesList = new ArrayList<Node>();
        for (Node n : this.mNodes) {
            if (!n.hasComponent()) continue;
            nodesList.add(n);
        }
        Node[] result = new Node[nodesList.size()];
        nodesList.toArray(result);
        return result;
    }

    public void storeProperties() {
        Node[] nodes;
        if (this.mView != null) {
            this.mView.storeProperties();
        }
        for (Node node : nodes = this.getNodes()) {
            node.storeProperties();
        }
    }

    public void update() {
        Node[] nodes;
        if (this.mView != null) {
            this.mView.update();
        }
        for (Node node : nodes = this.getNodes()) {
            node.update();
        }
    }

    public boolean hasComponent() {
        if (this.getLeaf() != null) {
            return true;
        }
        for (Node n : this.mNodes) {
            if (!n.hasComponent()) continue;
            return true;
        }
        return false;
    }
}

