;; Example 4-1  Drawing a Smooth-Shaded Triangle

(use gl)
(use gl.glut)

(define (init)
  (gl-clear-color 0.0 0.0 0.0 0.0)
  (gl-shade-model GL_SMOOTH))

(define (triangle)
  (gl-begin GL_TRIANGLES)
  (gl-color '#f32(1.0 0.0 0.0))
  (gl-vertex '#f32(5.0 5.0))
  (gl-color '#f32(0.0 1.0 0.0))
  (gl-vertex '#f32(25.0 5.0))
  (gl-color '#f32(0.0 0.0 1.0))
  (gl-vertex '#f32(5.0 25.0))
  (gl-end))

(define (disp)
  (gl-clear GL_COLOR_BUFFER_BIT)
  (triangle)
  (gl-flush)
  )

(define (reshape w h)
  (gl-viewport 0 0 w h)
  (gl-matrix-mode GL_PROJECTION)
  (gl-load-identity)
  (if (<= w h)
      (glu-ortho-2d 0.0 30.0 0.0 (* 30.0 (/ h w)))
      (glu-ortho-2d 0.0 (* 30.0 (/ w h)) 0.0 30.0))
  (gl-matrix-mode GL_MODELVIEW)
  )

(define (keyboard key x y)
  (when (= key 27) (exit 0)))

(define (main args)
  (glut-init args)
  (glut-init-display-mode (logior GLUT_SINGLE GLUT_RGB))
  (glut-init-window-size 500 500)
  (glut-init-window-position 100 100)
  (glut-create-window *program-name*)
  (init)
  (glut-display-func disp)
  (glut-reshape-func reshape)
  (glut-keyboard-func keyboard)
  (glut-main-loop)
  0)
