'******************************************************************************
'Microsoft Confidential.  2002-2003 Microsoft Corporation. All rights reserved.
'
' This file may contain preliminary information or inaccuracies, 
' and may not correctly represent any associated Microsoft 
' Product as commercially released. All Materials are provided entirely 
' AS IS. To the extent permitted by law, MICROSOFT MAKES NO 
' WARRANTY OF ANY KIND, DISCLAIMS ALL EXPRESS, IMPLIED AND STATUTORY 
' WARRANTIES, AND ASSUMES NO LIABILITY TO YOU FOR ANY DAMAGES OF 
' ANY TYPE IN CONNECTION WITH THESE MATERIALS OR ANY INTELLECTUAL PROPERTY IN THEM. 
'******************************************************************************



Option Explicit

Const READ   = 1
Const WRITE  = 2
Const APPEND = 8

Dim logFileName
Dim fsObj
Dim fileObj

logFileName = "register_app.log"

Set fsObj   = CreateObject("Scripting.FileSystemObject")

' check whether the file exists
If not fsObj.FileExists(logFileName) Then
    Set fileObj = fsObj.CreateTextFile(logFileName)
    fileObj.Close
    Set fileObj = fsObj.OpenTextFile(logFileName, APPEND)
Else
    Set fileObj = fsObj.OpenTextFile(logFileName, APPEND)
    fileObj.WriteBlankLines(2)
End If

fileObj.WriteLine "--------------------------------------------------------------------------------"
fileObj.WriteLine "| Tivoli Storage Manager for virtual Environments"
fileObj.WriteLine "| register_app.vbs log"
fileObj.WriteLine "| Current date and time: " & Now
fileObj.WriteLine "--------------------------------------------------------------------------------"



fileObj.WriteLine "" 
fileObj.WriteLine "REGISTER_APP.VBS version 1.6 for Windows Server 2008"
fileObj.WriteLine "Copyright (C) Microsoft Corporation 2002-2003. All rights reserved."
fileObj.WriteLine ""


'******************************************************************************
' Parse command line arguments
'******************************************************************************
Dim Args
Set Args = Wscript.Arguments
If Args.Count < 1 Then 
	PrintsUsage
End If

Dim ProviderName, ProviderDLL, ProviderDescription
If Args.Item(0) = "-register" Then 
	If Args.Count <> 4 Then PrintsUsage

	ProviderName = Args.Item(1)
	ProviderDLL = Args.Item(2)
	ProviderDescription = Args.Item(3)

	UninstallProvider
	InstallProvider
    fileObj.Close
	Wscript.Quit 0
End If 

If Args.Item(0) = "-unregister" Then 
	If Not Args.Count = 2 Then PrintsUsage
	ProviderName = Args.Item(1)
	UninstallProvider
    fileObj.Close
	Wscript.Quit 0
End If

' Wrong options?
PrintsUsage

fileObj.Close
Wscript.Quit 0

'******************************************************************************
' Prints the usage
'******************************************************************************
Sub PrintsUsage

	fileObj.WriteLine "Usage:" 
	fileObj.WriteLine "" 
	fileObj.WriteLine " 1) Registering a VSS/VDS Provider as a COM+ application:" 
	fileObj.WriteLine "      CScript.exe " & Wscript.ScriptName & " -register <Provider_Name> <Provider.DLL>  <Provider_Description>" 
	fileObj.WriteLine "" 
	fileObj.WriteLine " 2) Unregistering a COM+ application associated with a VSS/VDS provider:" 
	fileObj.WriteLine "      CScript.exe " & Wscript.ScriptName & " -unregister <Provider_Name>" 
	fileObj.WriteLine "" 
    fileObj.Close
	Wscript.Quit 1

End Sub


'******************************************************************************
' Installs the Provider
'******************************************************************************
Sub InstallProvider
	On Error Resume Next

	fileObj.WriteLine "Creating a new COM+ application:" 

	fileObj.WriteLine "- Creating the catalog object "
	Dim cat
	Set cat = CreateObject("COMAdmin.COMAdminCatalog") 	
	CheckError 101

	fileObj.WriteLine "- Get the Applications collection"
	Dim collApps
	Set collApps = cat.GetCollection("Applications")
	CheckCollectionError 102, cat

	fileObj.WriteLine "- Populate..." 
	collApps.Populate 
	CheckCollectionError 103, collApps

	fileObj.WriteLine "- Add new application object" 
	Dim app
	Set app = collApps.Add 
	CheckCollectionError 104, collApps

	fileObj.WriteLine "- Set app name = " & ProviderName & " "
	app.Value("Name") = ProviderName
	CheckObjectError 105, collApps, app

	fileObj.WriteLine "- Set app description = " & ProviderDescription & " "
	app.Value("Description") = ProviderDescription 
	CheckObjectError 106, collApps, app

	' Only roles added below are allowed to call in.
	fileObj.WriteLine "- Set app access check = true "
	app.Value("ApplicationAccessChecksEnabled") = 1   
	CheckObjectError 107, collApps, app


   
  ' Encrypting communication
  fileObj.WriteLine "- Set encrypted COM communication = 6"
  app.Value("Authentication") = 6
  CheckObjectError 108, collApps, app
  
  ' Secure references
  fileObj.WriteLine "- Set secure references = 2"
  app.Value("AuthenticationCapability") = 2
  CheckObjectError 109, collApps, app
  
  
  ' Do not allow impersonation
  fileObj.WriteLine "- Set impersonation = 2" 
  app.Value("ImpersonationLevel") = 2
  CheckObjectError 110, collApps, app
  
  fileObj.WriteLine "- Save changes..."
  collApps.SaveChanges
  CheckCollectionError 111, cat 
 
  fileObj.WriteLine "- Create service for application..." 
  cat.CreateServiceForApplication ProviderName, ProviderName , "SERVICE_AUTO_START", "SERVICE_ERROR_NORMAL", "", ".\localsystem", "", 0
  CheckCollectionError 112, cat


	fileObj.WriteLine "- Add the DLL component"
	cat.InstallComponent ProviderName, ProviderDLL , "", ""
        CheckCollectionError 113, cat

	'
	' Add the new role for the Local SYSTEM account
	'

	fileObj.WriteLine "Secure the COM+ application:"
	fileObj.WriteLine "- Get roles collection"
	Dim collRoles
	Set collRoles = collApps.GetCollection("Roles", app.Key)
	CheckCollectionError 120, cat

	fileObj.WriteLine "- Populate..."
	collRoles.Populate
	CheckCollectionError 121, collRoles

	fileObj.WriteLine "- Add new role"
	Dim role
	Set role = collRoles.Add
	CheckCollectionError 122, collRoles

	fileObj.WriteLine "- Set name = Administrators "
	role.Value("Name") = "Administrators"
	CheckObjectError 123, collRoles, role

	fileObj.WriteLine "- Set description = Administrators group "
	role.Value("Description") = "Administrators group"
	CheckObjectError 124, collRoles, role

	fileObj.WriteLine "- Save changes ..."
	collRoles.SaveChanges
	CheckCollectionError 125, collRoles
	
	'
	' Add users into role
	'

	fileObj.WriteLine "Granting user permissions:"
	Dim collUsersInRole
	Set collUsersInRole = collRoles.GetCollection("UsersInRole", role.Key)
	CheckCollectionError 130, collRoles

	fileObj.WriteLine "- Populate..."
	collUsersInRole.Populate
	CheckCollectionError 131, collUsersInRole

	fileObj.WriteLine "- Add new user"
	Dim user
	Set user = collUsersInRole.Add
	CheckCollectionError 132, collUsersInRole

	fileObj.WriteLine "- Searching for the Administrators account using WMI..."

	' Get the Administrators account domain and name
	Dim strQuery
	strQuery = "select * from Win32_Account where SID='S-1-5-32-544' and localAccount=TRUE"
	Dim objSet
	set objSet = GetObject("winmgmts:").ExecQuery(strQuery)
	CheckError 133

	Dim obj, Account
	for each obj in objSet
	    set Account = obj
		exit for
	next

	fileObj.WriteLine "- Set user name = .\" & Account.Name & " "
	user.Value("User") = ".\" & Account.Name
	CheckObjectError 134, collUsersInRole, user

	fileObj.WriteLine "- Add new user"
	Set user = collUsersInRole.Add
	CheckCollectionError 135, collUsersInRole

    fileObj.WriteLine "- Searching for the system account using WMI..."

	strQuery = "select * from Win32_Account where SID='S-1-5-18' and localAccount=TRUE"
	set objSet = GetObject("winmgmts:").ExecQuery(strQuery)
	CheckError 136

	for each obj in objSet
	    set Account = obj
	    exit for
	next

	fileObj.WriteLine "- Set user name = " & Account.Name & " "
	user.Value("User") = Account.Name
	CheckObjectError 137, collUsersInRole, user

	fileObj.WriteLine "- Save changes..."
	collUsersInRole.SaveChanges
	CheckCollectionError 138, cat
	
	Set app      = Nothing
	Set cat      = Nothing
	Set role     = Nothing
	Set user     = Nothing

	Set collApps = Nothing
	Set collRoles = Nothing
	Set collUsersInRole	= Nothing

	set objSet   = Nothing
	set obj      = Nothing

	fileObj.WriteLine "Done." 

	On Error GoTo 0
End Sub


'******************************************************************************
' Uninstalls the Provider
'******************************************************************************
Sub UninstallProvider
	On Error Resume Next

	fileObj.WriteLine "Unregistering the existing application..." 

	fileObj.WriteLine "- Create the catalog object"
	Dim cat
	Set cat = CreateObject("COMAdmin.COMAdminCatalog")
	CheckError 201
	
	fileObj.WriteLine "- Get the Applications collection"
	Dim collApps
	Set collApps = cat.GetCollection("Applications")
	CheckCollectionError 202, cat

	fileObj.WriteLine "- Populate..."
	collApps.Populate
	CheckCollectionError 203, collApps
	
	fileObj.WriteLine "- Search for " & ProviderName & " application..."
	Dim numApps
	numApps = collApps.Count
	Dim i
	For i = numApps - 1 To 0 Step -1
	    If collApps.Item(i).Value("Name") = ProviderName Then
	        collApps.Remove(i)
		CheckCollectionError 204, collApps
                fileObj.WriteLine "- Application " & ProviderName & " removed!"
	    End If
	Next
	
	fileObj.WriteLine "- Saving changes..."
	collApps.SaveChanges
	CheckCollectionError 205, collApps

	Set collApps = Nothing
	Set cat      = Nothing

	fileObj.WriteLine "Done." 

	On Error GoTo 0
End Sub



'******************************************************************************
' Sub CheckError
'******************************************************************************
Sub CheckError(exitCode)
    Dim scriptRc

    If Err = 0 Then Exit Sub
    scriptRc = DumpVBScriptError(exitCode)

    fileObj.Close
    Wscript.Quit scriptRc
End Sub


'******************************************************************************
' Sub CheckCollectionError
'******************************************************************************
Sub CheckCollectionError(exitCode, coll)
    Dim rcComPlus
    Dim scriptRc

    If Err = 0 Then Exit Sub
    scriptRc = DumpVBScriptError(exitCode)

    rcComPlus = DumpComPlusError(coll.GetCollection("ErrorInfo"))

    fileObj.Close

    If rcComPlus = 0 Then 
      Wscript.Quit scriptRc
    Else
      Wscript.Quit rcComPlus
    End If
End Sub


'******************************************************************************
' Sub CheckObjectError
'******************************************************************************
Sub CheckObjectError(exitCode, coll, object)
    Dim rcComPlus
    Dim scriptRc

    If Err = 0 Then Exit Sub
    scriptRc = DumpVBScriptError(exitCode)

    rcComPlus = DumpComPlusError(coll.GetCollection("ErrorInfo", object.Key))

    fileObj.Close

    If rcComPlus = 0 Then 
      Wscript.Quit scriptRc
    Else
      Wscript.Quit rcComPlus
    End If
End Sub



'******************************************************************************
' Sub DumpVBScriptError
'******************************************************************************
Function DumpVBScriptError(exitCode)
    fileObj.WriteLine vbNewLine & "ERROR:"
    fileObj.WriteLine "- Error code: " & Err & " [0x" & Hex(Err) & "]"
    fileObj.WriteLine "- Exit code: " & exitCode
    fileObj.WriteLine "- Description: " & Err.Description
    fileObj.WriteLine "- Source: " & Err.Source
    fileObj.WriteLine "- Help file: " & Err.Helpfile
    fileObj.WriteLine "- Help context: " & Err.HelpContext

    DumpVBScriptError = Err
End Function


'******************************************************************************
' Sub DumpComPlusError
'******************************************************************************
Function DumpComPlusError(errors)
    errors.Populate
    fileObj.WriteLine "- COM+ Errors detected: (" & errors.Count & ")"

    Dim error
    Dim I
    For I = 0 to errors.Count - 1
	Set error = errors.Item(I)
        fileObj.WriteLine "   * (COM+ ERROR " & I & ") on " & error.Value("Name")
        fileObj.WriteLine "       ErrorCode: " & error.Value("ErrorCode") & " [0x" & Hex(error.Value("ErrorCode")) & "]"
        fileObj.WriteLine "       MajorRef: " & error.Value("MajorRef")
        fileObj.WriteLine "       MinorRef: " & error.Value("MinorRef")

        DumpComPlusError = error.Value("ErrorCode")
    Next
End Function
