/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;

public abstract class CallSite {
    MethodHandle target;
    private static final MethodHandle GET_TARGET;
    private static final MethodHandle THROW_UCS;
    private static final long TARGET_OFFSET;

    CallSite(MethodType methodType) {
        this.target = this.makeUninitializedCallSite(methodType);
    }

    CallSite(MethodHandle methodHandle) {
        methodHandle.type();
        this.target = methodHandle;
    }

    CallSite(MethodType methodType, MethodHandle methodHandle) throws Throwable {
        this(methodType);
        ConstantCallSite constantCallSite = (ConstantCallSite)this;
        MethodHandle methodHandle2 = (MethodHandle)methodHandle.invokeWithArguments(constantCallSite);
        this.checkTargetChange(this.target, methodHandle2);
        this.target = methodHandle2;
    }

    public MethodType type() {
        return this.target.type();
    }

    public abstract MethodHandle getTarget();

    public abstract void setTarget(MethodHandle var1);

    void checkTargetChange(MethodHandle methodHandle, MethodHandle methodHandle2) {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        if (!methodType2.equals((Object)methodType)) {
            throw CallSite.wrongTargetType(methodHandle2, methodType);
        }
    }

    private static WrongMethodTypeException wrongTargetType(MethodHandle methodHandle, MethodType methodType) {
        return new WrongMethodTypeException(String.valueOf(methodHandle) + " should be of type " + methodType);
    }

    public abstract MethodHandle dynamicInvoker();

    MethodHandle makeDynamicInvoker() {
        BoundMethodHandle boundMethodHandle = GET_TARGET.bindArgumentL(0, this);
        MethodHandle methodHandle = MethodHandles.exactInvoker(this.type());
        return MethodHandles.foldArguments(methodHandle, boundMethodHandle);
    }

    private static Object uninitializedCallSite(Object ... objectArray) {
        throw new IllegalStateException("uninitialized call site");
    }

    private MethodHandle makeUninitializedCallSite(MethodType methodType) {
        MethodType methodType2 = methodType.basicType();
        MethodHandle methodHandle = methodType2.form().cachedMethodHandle(2);
        if (methodHandle == null) {
            methodHandle = THROW_UCS.asType(methodType2);
            methodHandle = methodType2.form().setCachedMethodHandle(2, methodHandle);
        }
        return methodHandle.viewAsType(methodType, false);
    }

    void setTargetNormal(MethodHandle methodHandle) {
        MethodHandleNatives.setCallSiteTargetNormal(this, methodHandle);
    }

    MethodHandle getTargetVolatile() {
        return (MethodHandle)MethodHandleStatics.UNSAFE.getObjectVolatile(this, TARGET_OFFSET);
    }

    void setTargetVolatile(MethodHandle methodHandle) {
        MethodHandleNatives.setCallSiteTargetVolatile(this, methodHandle);
    }

    static CallSite makeSite(MethodHandle methodHandle, String string, MethodType methodType, Object object, Class<?> clazz) {
        CallSite callSite;
        MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP.in(clazz);
        try {
            Object object2;
            object = CallSite.maybeReBox(object);
            if (object == null) {
                object2 = methodHandle.invoke(lookup, string, methodType);
            } else if (!object.getClass().isArray()) {
                object2 = methodHandle.invoke(lookup, string, methodType, object);
            } else {
                Object[] objectArray = (Object[])object;
                CallSite.maybeReBoxElements(objectArray);
                switch (objectArray.length) {
                    case 0: {
                        object2 = methodHandle.invoke(lookup, string, methodType);
                        break;
                    }
                    case 1: {
                        object2 = methodHandle.invoke(lookup, string, methodType, objectArray[0]);
                        break;
                    }
                    case 2: {
                        object2 = methodHandle.invoke(lookup, string, methodType, objectArray[0], objectArray[1]);
                        break;
                    }
                    case 3: {
                        object2 = methodHandle.invoke(lookup, string, methodType, objectArray[0], objectArray[1], objectArray[2]);
                        break;
                    }
                    case 4: {
                        object2 = methodHandle.invoke(lookup, string, methodType, objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
                        break;
                    }
                    case 5: {
                        object2 = methodHandle.invoke(lookup, string, methodType, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4]);
                        break;
                    }
                    case 6: {
                        object2 = methodHandle.invoke(lookup, string, methodType, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5]);
                        break;
                    }
                    default: {
                        if (3 + objectArray.length > 254) {
                            throw new BootstrapMethodError("too many bootstrap method arguments");
                        }
                        MethodType methodType2 = methodHandle.type();
                        MethodType methodType3 = MethodType.genericMethodType(3 + objectArray.length);
                        MethodHandle methodHandle2 = methodHandle.asType(methodType3);
                        MethodHandle methodHandle3 = methodType3.invokers().spreadInvoker(3);
                        object2 = methodHandle3.invokeExact(methodHandle2, lookup, string, methodType, objectArray);
                    }
                }
            }
            if (!(object2 instanceof CallSite)) {
                throw new ClassCastException("bootstrap method failed to produce a CallSite");
            }
            callSite = (CallSite)object2;
            if (!callSite.getTarget().type().equals((Object)methodType)) {
                throw CallSite.wrongTargetType(callSite.getTarget(), methodType);
            }
        }
        catch (Throwable throwable) {
            BootstrapMethodError bootstrapMethodError = throwable instanceof BootstrapMethodError ? (BootstrapMethodError)throwable : new BootstrapMethodError("call site initialization exception", throwable);
            throw bootstrapMethodError;
        }
        return callSite;
    }

    private static Object maybeReBox(Object object) {
        int n;
        if (object instanceof Integer && (n = ((Integer)object).intValue()) == (byte)n) {
            object = n;
        }
        return object;
    }

    private static void maybeReBoxElements(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = CallSite.maybeReBox(objectArray[i]);
        }
    }

    static {
        MethodHandleImpl.initStatics();
        try {
            GET_TARGET = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(CallSite.class, "getTarget", MethodType.methodType(MethodHandle.class));
            THROW_UCS = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(CallSite.class, "uninitializedCallSite", MethodType.methodType(Object.class, Object[].class));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
        try {
            TARGET_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(CallSite.class.getDeclaredField("target"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

