# Hawaiian Starlines

## Introduction

These are the star lines developed by Nainoa Thompson and used by the Polynesian Voyaging Society to navigate Polynesian sailing canoes using traditional techniques of non instrument navigation across thousands of miles of open ocean. For years, Hawaiian navigators have memorized the position of stars as they rise and set in order to know oneʻs bearing.   Wayfinder Nainoa Thompson developed a system of organization to help memorize the position of stars throughout the celestial sphere by dividing the sky into four evenly sized star lines.

## Description

### History

The knowledge of Hawaiian star navigation has been passed down orally for many generations.   Much of the knowledge regarding stars and navigation were lost until the Hawaiian Renaissance in the early 1970s. Polynesian Voyage Society (PVS), founded in 1973, created Hokule’a in 1975. Hokule’a is a traditional Hawaiian voyaging canoe with the mission to revive the art of way finding. A man from Satawal, Micronesia named Mau Piailug was a master navigator/wayfinder. The knowledge of wayfinding and using the sky to navigate was passed down to Mau from his ancestors. Nainoa Thompson, current President of PVS, asked Mau to teach his knowledge of navigation to him with the intention of reviving the knowledge that was once lost to the Hawaiians. With the knowledge learned from Mau, the Hawaiian star compass and star lines were created.

### Star Lines

Each star line is a group of main stars that will be remembered by the navigators. The stars connect making constellations. Navigators remember the rising/setting houses of these stars, the stars that connect in each line, and the lines that point directly to North and South. The star lines’ position in the night sky slowly change over time, each starline being more prevalent at night according to the season. The star lines with their according season are as follows:
<p> <table class="layout">
<tr>
	<td><notr>1.</notr></td>
	<td><notr>Ke Ka o Makali‘i</notr></td>
	<td>November to April </td>
</tr>
<tr>
	<td><notr>2.</notr></td>
	<td><notr>Ka Iwikuamo‘o</notr></td>
	<td>April to July </td>
</tr>
<tr>
	<td><notr>3.</notr></td>
	<td><notr>Manaiakalani</notr></td>
	<td>May to October </td>
</tr>
<tr>
	<td><notr>4.</notr></td>
	<td><notr>Ka Lupe o Kawelo</notr></td>
	<td>September to February</td>
</tr>
</table> </p>

### <notr>Ke Ka o Makali’i</notr>

The direct translation means the “Bailer of *Makali’i*”. The lines are shaped as a canoe bailer which scoops *Ka Hei-Hei o Na Keiki* (Orion) and *Makali’i* (Pleiades) up into the night sky. In voyaging a bailer is used to scoop up water out of the hulls.

The main stars of *Ke Ka o Makali’i* from North to South are *Hokulei* (Capella), *Nanamua* (Castor), *Nanahope* (Pollux), *Puana* (Procyon), and *‘A’a* (Sirius). These stars connect together to create the bailer in the sky. Mintaka in Orion is an important star in this line because it rises/sets directly east or west giving the navigator an easy pointer star for direction. Mirzim (next to *‘A’a* (Sirius)) and *Ke Ali’i Kona i Ka Lewa* (Canopus) connect together to create a southern pointer. *‘Ekekeuehuehu* (&theta; Aur, Mahasim) and *‘Ekekeu’ena’ena* (&beta; Aur, Menkalinan) connect to create a northern pointer. Different north/south pointers are found in the star lines and used heavily by navigators.

### <notr>Ka Iwikuamo’o</notr>

*Ka Iwikuamo’o* translates to the backbone (directly: Bone back-lizard). This star line is depicted as the backbone of a lizard or *mo’o* in this sky culture. It can also be representing a genealogical backbone, each star representing a generation.

The star line itself starts with *Hokupa’a* (North Star), the ultimate northern pointer due to the star never moving in the sky, always above north. *Hokupa’a* connects down to *Na Hiku* (Big Dipper). *Na Hiku* translates to “The Seven” as there is seven stars in the Big Dipper. *Hokule’a* (Arcturus) and *Hikianalia* (Spica) are the two stars in the middle of the star line. The two PVS canoes are named after these two stars. *Hokule’a* is the “zenith” star of Hawai’i, meaning it will be directly overhead when you are at the latitude of the Hawaiian Islands. *Hokule’a* is very important to navigators on finding their way back to Hawai’i. The meaning of *Hokule’a* is “the star of gladness” because it is the star used to find home bringing joy. Next to *Hikianalia* is *Me’e*, a combination of four stars that create a box. *Me’e* connects down to *Hanaiakamalama* (Southern Cross) which is the southern pointer for *Ka Iwikuamo’o*.

### <notr>Manaiakalani</notr>

*Manaiakalani* translates to “The Chief's Fishline”. This refers to the legend of the demi god Maui and his fish hook. Maui is credited for pulling up the islands with his magical fish hook.

This star line consists of two constellations. The Navigator’s Triangle on the north and Maui’s fish hook on the south. The Navigator’s Triangle is made of three stars *Hawaiki* (Deneb), *Keoe* (Vega), and *Humu* (Altair). (It is the same figure as the Summer Triangle for modern amateur astronomers.) These stars also represent the Polynesian triangle: Hawai’i (*Hawaiki*), Rapanui (*Keoe*), and Aotearoa (*Humu*). These three islands are pulled by the fish hook of Maui (Scorpius).

The northern pointer is found in the Navigator’s Triangle when you connect *Hawaiki* (Deneb) and *Momonapikowalu* (&gamma; Cyg, Sadr). Southern pointers are in the fish hook when you connect *Mili’opu* (&delta; Sco, Dschubba) and *Kahe* (&pi; Sco, Nur), the stars on the top of the hook.

### <notr>Ka Lupe o Kawelo</notr>

*Ka Lupe o Kawelo* translates to “The Kite of Kawelo”. Kawelo was a great chief of Kaua’i and O’ahu and this star line represents the kite which was lost as a child.

The star line starts with *‘Iwakeli’i*, meaning Chief Frigate Bird (*Fregata Minor*). The shape of this constellation (which is Cassiopeia's W in the West) resembles the *‘iwa* bird that is known for leading voyagers to land. The center of the star line is the Kite of Kawelo (equal to the Great Square of Pegasus). The four stars that make the kite are named after Kawelo’s greatest ancestors: *Manokalanipo* (&delta; Peg, Alpheratz), *Kakuhihewa* (&beta; Peg, Scheat), *Pi’ilani* (&gamma; Peg, Algenib), and *Keawe* (&alpha; Peg, Markab). All four were famous chiefs of their time. The star line then connects south to two stars *Pi’ikea* (&beta; Cet, Deneb Kaitos) and *Kukaniloko* (&alpha; PsA, Fomalhaut).

The northern pointer is found in *Manokalanipo* (&delta; Peg, Alpheratz) and *Kealohalani-po-keao* (&beta; Cas, Caph) of *‘Iwakeli’i*. The southern pointer is connected with *Keawe* (&alpha; Peg, Markab) and *Kukaniloko* (&alpha; PsA, Fomalhaut).

## References

 - [#1]: [Polynesian Voyaging Society](http://hokulea.com)
 - [#2]: [Hawaiian Voyaging Society](http://pvs.kcc.hawaii.edu/ike/hookele/hawaiian_star_lines.html)
 - [#3]: [Imiloa](http://www.imiloahawaii.org/71/star-paths)
 - [#4]: [Hawaiian Star Lines and Names for Stars](http://archive.hokulea.com/ike/hookele/hawaiian_star_lines.html)

 The Hawaiian Star Compass landscape which should be used with this skyculture is available at the [Stellarium Landscapes](https://stellarium.org/landscapes.html) collection.

## Authors

 The *master navigator* behind this sky culture was Mau Piailug of Satawal, who taught the Polynesian art of celestial navigation to Nainoa Thompson, who developed this version of the sky culture that was used from 2013-17 by Hawaiians to sail around the world during the Malama Honua Voyage of Hokule’a, the Polynesian voyaging canoe. Stellarium has been used as a tool by the navigators of Hokule’a and this sky culture serves as a tool for practicing Polynesian navigation.

The technical implementation of the sky culture included here was contributed in 2017 by teachers Darren Kamalu and Christopher Blake, Students Jonah Apo, Nicholas Koanui, Brenden Aila and the Celestial Navigation class at Kamehameha Schools Kapalama, Honolulu, Hawai’i. Artwork by Kealoha Kaneakua.

## License

CC BY-SA 4.0
