/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/




#ifndef SOUNDCORE_H
#define SOUNDCORE_H

#include <AL/al.h>
#include <AL/alut.h>
#include <string>
using namespace std;

#include "LList.h"
#include "Vector.h"

typedef struct{
	Vector *s;
	Vector *v;
	Vector s_static;
	Vector v_static;
	int still;
	int isplaying;
	ALuint alid;
} EffectType;

typedef struct{
	ALuint alid;
	ALenum error;
	char filename[128];
} SampleType;

class SoundCore{
public:
	void Update();
	int LoadSample(char* filename);
	int Play(char* filename,int loopmode,Vector* sourcepos,Vector* sourcev);
	int Play(char* filename,int loopmode,Vector sourcepos,Vector sourcev);
	int Play(char* filename);
	void SetPaused(int target_paused);
	void Cleanup();
	void SetEar(Vector* newpos,Vector* newvel,Vector* newface,Vector* newup);
	void SetVolume(float);
	float GetVolume();
	int StopEffect(int target_effect);
	void PrintALError(ALenum code);
	Vector *s;
	Vector *v;
	Vector *orientation_face;
	Vector *orientation_up;
	SoundCore();
	~SoundCore();
	int Init();
	int verbose;
private:
	float volume;
	LList<EffectType> effectlist;
	LList<SampleType> samplelist;

	void HandleMixError();
	int paused;
	float reference_distance;
};

#endif //SOUNDCORE_H
