#
# Display centered feedback on the last line... 
#
# $Id: feedback.tcl,v 1.7 2011/01/23 14:23:45 rader Exp $
#

proc Feedback { str } {
  global prompt feedback_wait after_id debug color_bg
  global color_fg_feedback color_fg_error
  global feedback_centering_fudge

  if { $debug } { puts "Feedback: \"$str\"" }
  if { $after_id != "" } { after cancel $after_id }
  .t.ent configure -state normal
  .t.ent delete 0 end
  set r [expr 100 -  [string length $str]]
  set x [expr $r / 2 - $feedback_centering_fudge ]
  set s ""
  for { set i 0 } { $i < $x } { incr i } { set s "$s " }

  if { [regexp {^Warning} $str ] ||
       [regexp {\.\.\. usage error} $str ] || 
       [regexp {aborted \.\.\.} $str ] || 
       [regexp {\.\.\. no matches} $str ] } {
    .t.ent configure -disabledforeground $color_fg_error
  } else { 
    .t.ent configure -disabledforeground $color_fg_feedback
  }
  .t.ent insert end "${s}$str" 
  .t.ent configure -state disabled
  update idletasks
  focus .t.lb
  if { [regexp {workaround} $str] } { 
    # sleep 1...
    after 1000
    .t.ent configure -state normal
    .t.ent delete 0 end 
  } else { 
    # post for N seconds...
    set after_id [after [expr $feedback_wait * 1000 ] { 
      .t.ent configure -state normal
      .t.ent delete 0 end 
    }]
  }
  .t.ent configure -state disabled
}

