/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "skeltr_key_relations.h"
#include <gaminggear/hid_uid.h>

SkeltrKeyRelation const skeltr_key_relations[SKELTR_KEYS_NUM] = {
		{HID_UID_KB_ESCAPE, HID_UID_KB_ESCAPE, SKELTR_KEY_RELATION_TYPE_NOTHING, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},

		{HID_UID_KB_F1,           SKELTR_KEY_TYPE_MULTIMEDIA_MUTE_MASTER_VOLUME, SKELTR_KEY_RELATION_TYPE_FUNCTION,  0,  15, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F2,           SKELTR_KEY_TYPE_MULTIMEDIA_VOLUME_DOWN,        SKELTR_KEY_RELATION_TYPE_FUNCTION,  1,  16, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F3,           SKELTR_KEY_TYPE_MULTIMEDIA_VOLUME_UP,          SKELTR_KEY_RELATION_TYPE_FUNCTION,  2,  17, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F4,           SKELTR_KEY_TYPE_APP_CALCULATOR,                SKELTR_KEY_RELATION_TYPE_FUNCTION,  3,  18, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F5,           SKELTR_KEY_TYPE_MULTIMEDIA_PLAY_PAUSE,         SKELTR_KEY_RELATION_TYPE_FUNCTION,  4,  19, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F6,           SKELTR_KEY_TYPE_MULTIMEDIA_STOP,               SKELTR_KEY_RELATION_TYPE_FUNCTION,  5,  20, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F7,           SKELTR_KEY_TYPE_MULTIMEDIA_PREVIOUS_TRACK,     SKELTR_KEY_RELATION_TYPE_FUNCTION,  6,  21, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F8,           SKELTR_KEY_TYPE_MULTIMEDIA_NEXT_TRACK,         SKELTR_KEY_RELATION_TYPE_FUNCTION,  7,  22, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F9,           SKELTR_KEY_TYPE_APP_MY_COMPUTER,               SKELTR_KEY_RELATION_TYPE_FUNCTION,  8,  23, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F10,          SKELTR_KEY_TYPE_APP_BROWSER,                   SKELTR_KEY_RELATION_TYPE_FUNCTION,  9,  24, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F11,          SKELTR_KEY_TYPE_LIGHT,                         SKELTR_KEY_RELATION_TYPE_FUNCTION, 10,  25, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F12,          SKELTR_KEY_TYPE_RECORD,                        SKELTR_KEY_RELATION_TYPE_FUNCTION, 11,  26, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_PRINT_SCREEN, SKELTR_KEY_TYPE_DISABLED,                      SKELTR_KEY_RELATION_TYPE_FUNCTION, 12,  27, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_SCROLL_LOCK,  SKELTR_KEY_TYPE_DISABLED,                      SKELTR_KEY_RELATION_TYPE_FUNCTION, 13,  28, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_PAUSE,        SKELTR_KEY_TYPE_SYSTEM_SLEEP,                  SKELTR_KEY_RELATION_TYPE_FUNCTION, 14,  29, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},

/* m1 */{SKELTR_KEY_TYPE_SHIFT_1, SKELTR_KEY_TYPE_CTRL_1, SKELTR_KEY_RELATION_TYPE_MACRO, 0, 5, 0, 5, 0},
/* m2 */{SKELTR_KEY_TYPE_SHIFT_2, SKELTR_KEY_TYPE_CTRL_2, SKELTR_KEY_RELATION_TYPE_MACRO, 1, 6, 1, 6, 1},
/* m3 */{SKELTR_KEY_TYPE_SHIFT_3, SKELTR_KEY_TYPE_CTRL_3, SKELTR_KEY_RELATION_TYPE_MACRO, 2, 7, 2, 7, 2},
/* m4 */{SKELTR_KEY_TYPE_SHIFT_4, SKELTR_KEY_TYPE_CTRL_4, SKELTR_KEY_RELATION_TYPE_MACRO, 3, 8, 3, 8, 3},
/* m5 */{SKELTR_KEY_TYPE_SHIFT_5, SKELTR_KEY_TYPE_CTRL_5, SKELTR_KEY_RELATION_TYPE_MACRO, 4, 9, 4, 9, 4},

/* t1 */{SKELTR_KEY_TYPE_PROFILE_DOWN, HID_UID_KB_CAPS_LOCK,                   SKELTR_KEY_RELATION_TYPE_THUMBSTER, 0, 3, 10, 13, 10},
/* t2 */{SKELTR_KEY_TYPE_OPEN_DRIVER,  SKELTR_KEY_TYPE_MULTIMEDIA_OPEN_PLAYER, SKELTR_KEY_RELATION_TYPE_THUMBSTER, 1, 4, 11, 14, 11},
/* t3 */{SKELTR_KEY_TYPE_PROFILE_UP,   SKELTR_KEY_TYPE_APP_EMAIL,              SKELTR_KEY_RELATION_TYPE_THUMBSTER, 2, 5, 12, 15, 12},

		{0x35,                 0x35,                 SKELTR_KEY_RELATION_TYPE_PRIMARY,  126, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_1,         HID_UID_KB_1,         SKELTR_KEY_RELATION_TYPE_EASYZONE, 143,   0, SKELTR_KEY_RELATION_INVALID,  16, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_2,         HID_UID_KB_2,         SKELTR_KEY_RELATION_TYPE_EASYZONE,  23,   1, SKELTR_KEY_RELATION_INVALID,  17, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_3,         HID_UID_KB_3,         SKELTR_KEY_RELATION_TYPE_EASYZONE,  71,   2, SKELTR_KEY_RELATION_INVALID,  18, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_4,         HID_UID_KB_4,         SKELTR_KEY_RELATION_TYPE_EASYZONE,  53,   3, SKELTR_KEY_RELATION_INVALID,  19, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_5,         HID_UID_KB_5,         SKELTR_KEY_RELATION_TYPE_EASYZONE,  39,   4, SKELTR_KEY_RELATION_INVALID,  20, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_6,         HID_UID_KB_6,         SKELTR_KEY_RELATION_TYPE_PRIMARY,   29, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_7,         HID_UID_KB_7,         SKELTR_KEY_RELATION_TYPE_PRIMARY,   15, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_8,         HID_UID_KB_8,         SKELTR_KEY_RELATION_TYPE_PRIMARY,   94, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_9,         HID_UID_KB_9,         SKELTR_KEY_RELATION_TYPE_PRIMARY,    3, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_0,         HID_UID_KB_0,         SKELTR_KEY_RELATION_TYPE_PRIMARY,   87, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x2D,                 0x2D,                 SKELTR_KEY_RELATION_TYPE_PRIMARY,   86, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x2E,                 0x2E,                 SKELTR_KEY_RELATION_TYPE_PRIMARY,  102, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_BACKSPACE, HID_UID_KB_BACKSPACE, SKELTR_KEY_RELATION_TYPE_PRIMARY,   65, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},

		{HID_UID_KB_TAB,   HID_UID_KB_TAB,   SKELTR_KEY_RELATION_TYPE_PRIMARY,  121, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_Q,     HID_UID_KB_Q,     SKELTR_KEY_RELATION_TYPE_EASYZONE, 120,   5, SKELTR_KEY_RELATION_INVALID,  21, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_W,     HID_UID_KB_W,     SKELTR_KEY_RELATION_TYPE_EASYZONE,  72,   6, SKELTR_KEY_RELATION_INVALID,  22, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_E,     HID_UID_KB_E,     SKELTR_KEY_RELATION_TYPE_EASYZONE, 112,   7, SKELTR_KEY_RELATION_INVALID,  23, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_R,     HID_UID_KB_R,     SKELTR_KEY_RELATION_TYPE_EASYZONE, 104,   8, SKELTR_KEY_RELATION_INVALID,  24, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_T,     HID_UID_KB_T,     SKELTR_KEY_RELATION_TYPE_EASYZONE, 105,   9, SKELTR_KEY_RELATION_INVALID,  25, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_Z,     HID_UID_KB_Z,     SKELTR_KEY_RELATION_TYPE_PRIMARY,   57, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_U,     HID_UID_KB_U,     SKELTR_KEY_RELATION_TYPE_PRIMARY,   56, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_I,     HID_UID_KB_I,     SKELTR_KEY_RELATION_TYPE_PRIMARY,   96, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_O,     HID_UID_KB_O,     SKELTR_KEY_RELATION_TYPE_PRIMARY,   40, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_P,     HID_UID_KB_P,     SKELTR_KEY_RELATION_TYPE_PRIMARY,   80, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x2F,             0x2F,             SKELTR_KEY_RELATION_TYPE_PRIMARY,   81, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x30,             0x30,             SKELTR_KEY_RELATION_TYPE_PRIMARY,   97, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_ENTER, HID_UID_KB_ENTER, SKELTR_KEY_RELATION_TYPE_PRIMARY,   68, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},

		{HID_UID_KB_CAPS_LOCK, HID_UID_KB_CAPS_LOCK, SKELTR_KEY_RELATION_TYPE_CAPSLOCK, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, HID_UID_KB_CAPS_LOCK},
		{HID_UID_KB_A,         HID_UID_KB_A,         SKELTR_KEY_RELATION_TYPE_EASYZONE,  58,  10, SKELTR_KEY_RELATION_INVALID,  26, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_S,         HID_UID_KB_S,         SKELTR_KEY_RELATION_TYPE_EASYZONE,  98,  11, SKELTR_KEY_RELATION_INVALID,  27, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_D,         HID_UID_KB_D,         SKELTR_KEY_RELATION_TYPE_EASYZONE,  42,  12, SKELTR_KEY_RELATION_INVALID,  28, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_F,         HID_UID_KB_F,         SKELTR_KEY_RELATION_TYPE_EASYZONE, 106,  13, SKELTR_KEY_RELATION_INVALID,  29, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_G,         HID_UID_KB_G,         SKELTR_KEY_RELATION_TYPE_EASYZONE, 107,  14, SKELTR_KEY_RELATION_INVALID,  30, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_H,         HID_UID_KB_H,         SKELTR_KEY_RELATION_TYPE_PRIMARY,   59, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_J,         HID_UID_KB_J,         SKELTR_KEY_RELATION_TYPE_PRIMARY,  122, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_K,         HID_UID_KB_K,         SKELTR_KEY_RELATION_TYPE_PRIMARY,   74, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_L,         HID_UID_KB_L,         SKELTR_KEY_RELATION_TYPE_PRIMARY,  114, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x33,                 0x33,                 SKELTR_KEY_RELATION_TYPE_PRIMARY,   82, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x34,                 0x34,                 SKELTR_KEY_RELATION_TYPE_PRIMARY,   43, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x32,                 0x32,                 SKELTR_KEY_RELATION_TYPE_PRIMARY,   34, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},

		{HID_UID_KB_LEFT_SHIFT,  HID_UID_KB_LEFT_SHIFT,  SKELTR_KEY_RELATION_TYPE_PRIMARY,   50, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x64,                   0x64,                   SKELTR_KEY_RELATION_TYPE_PRIMARY,   75, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_Y,           HID_UID_KB_Y,           SKELTR_KEY_RELATION_TYPE_EASYZONE, 124,  15, SKELTR_KEY_RELATION_INVALID,  31, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_X,           HID_UID_KB_X,           SKELTR_KEY_RELATION_TYPE_EASYZONE,  76,  16, SKELTR_KEY_RELATION_INVALID,  32, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_C,           HID_UID_KB_C,           SKELTR_KEY_RELATION_TYPE_EASYZONE, 116,  17, SKELTR_KEY_RELATION_INVALID,  33, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_V,           HID_UID_KB_V,           SKELTR_KEY_RELATION_TYPE_EASYZONE, 108,  18, SKELTR_KEY_RELATION_INVALID,  34, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_B,           HID_UID_KB_B,           SKELTR_KEY_RELATION_TYPE_EASYZONE, 109,  19, SKELTR_KEY_RELATION_INVALID,  35, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_N,           HID_UID_KB_N,           SKELTR_KEY_RELATION_TYPE_PRIMARY,   60, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_M,           HID_UID_KB_M,           SKELTR_KEY_RELATION_TYPE_PRIMARY,   61, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x36,                   0x36,                   SKELTR_KEY_RELATION_TYPE_PRIMARY,  100, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x37,                   0x37,                   SKELTR_KEY_RELATION_TYPE_PRIMARY,   44, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{0x38,                   0x38,                   SKELTR_KEY_RELATION_TYPE_PRIMARY,   85, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_RIGHT_SHIFT, HID_UID_KB_RIGHT_SHIFT, SKELTR_KEY_RELATION_TYPE_PRIMARY,   10, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},

		{HID_UID_KB_LEFT_CONTROL,  HID_UID_KB_LEFT_CONTROL,  SKELTR_KEY_RELATION_TYPE_PRIMARY, 140, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_LEFT_GUI,      HID_UID_KB_LEFT_GUI,      SKELTR_KEY_RELATION_TYPE_PRIMARY,  33, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_LEFT_ALT,      HID_UID_KB_LEFT_ALT,      SKELTR_KEY_RELATION_TYPE_PRIMARY, 130, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_SPACE,         HID_UID_KB_SPACE,         SKELTR_KEY_RELATION_TYPE_PRIMARY, 131, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_RIGHT_ALT,     HID_UID_KB_RIGHT_ALT,     SKELTR_KEY_RELATION_TYPE_PRIMARY,  21, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{SKELTR_KEY_TYPE_FN,       SKELTR_KEY_TYPE_FN,       SKELTR_KEY_RELATION_TYPE_FN, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_APPLICATION,   HID_UID_KB_APPLICATION,   SKELTR_KEY_RELATION_TYPE_PRIMARY,  45, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_RIGHT_CONTROL, HID_UID_KB_RIGHT_CONTROL, SKELTR_KEY_RELATION_TYPE_PRIMARY, 142, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},

		{HID_UID_KB_INSERT,    HID_UID_KB_INSERT,    SKELTR_KEY_RELATION_TYPE_PRIMARY,  54, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_HOME,      HID_UID_KB_HOME,      SKELTR_KEY_RELATION_TYPE_PRIMARY,  30, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_PAGE_UP,   HID_UID_KB_PAGE_UP,   SKELTR_KEY_RELATION_TYPE_PRIMARY,  38, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_DELETE,    HID_UID_KB_DELETE,    SKELTR_KEY_RELATION_TYPE_PRIMARY, 134, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_END,       HID_UID_KB_END,       SKELTR_KEY_RELATION_TYPE_PRIMARY,  31, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_PAGE_DOWN, HID_UID_KB_PAGE_DOWN, SKELTR_KEY_RELATION_TYPE_PRIMARY, 110, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},

		{HID_UID_KB_UP_ARROW,    HID_UID_KB_UP_ARROW,    SKELTR_KEY_RELATION_TYPE_PRIMARY, 103, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_LEFT_ARROW,  HID_UID_KB_LEFT_ARROW,  SKELTR_KEY_RELATION_TYPE_PRIMARY,  62, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_DOWN_ARROW,  HID_UID_KB_DOWN_ARROW,  SKELTR_KEY_RELATION_TYPE_PRIMARY, 133, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KB_RIGHT_ARROW, HID_UID_KB_RIGHT_ARROW, SKELTR_KEY_RELATION_TYPE_PRIMARY, 111, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},

		{HID_UID_KP_NUM_LOCK, HID_UID_KP_NUM_LOCK, SKELTR_KEY_RELATION_TYPE_PRIMARY, 132, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_DIV,      HID_UID_KP_DIV,      SKELTR_KEY_RELATION_TYPE_PRIMARY,  52, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_MUL,      HID_UID_KP_MUL,      SKELTR_KEY_RELATION_TYPE_PRIMARY,  28, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_MINUS,    HID_UID_KP_MINUS,    SKELTR_KEY_RELATION_TYPE_PRIMARY,  37, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_PLUS,     HID_UID_KP_PLUS,     SKELTR_KEY_RELATION_TYPE_PRIMARY,  24, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_ENTER,    HID_UID_KP_ENTER,    SKELTR_KEY_RELATION_TYPE_PRIMARY,  26, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_1,        HID_UID_KP_1,        SKELTR_KEY_RELATION_TYPE_PRIMARY,  19, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_2,        HID_UID_KP_2,        SKELTR_KEY_RELATION_TYPE_PRIMARY,  67, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_3,        HID_UID_KP_3,        SKELTR_KEY_RELATION_TYPE_PRIMARY,  84, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_4,        HID_UID_KP_4,        SKELTR_KEY_RELATION_TYPE_PRIMARY,  25, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_5,        HID_UID_KP_5,        SKELTR_KEY_RELATION_TYPE_PRIMARY,   9, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_6,        HID_UID_KP_6,        SKELTR_KEY_RELATION_TYPE_PRIMARY,  89, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_7,        HID_UID_KP_7,        SKELTR_KEY_RELATION_TYPE_PRIMARY, 128, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_8,        HID_UID_KP_8,        SKELTR_KEY_RELATION_TYPE_PRIMARY,  48, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_9,        HID_UID_KP_9,        SKELTR_KEY_RELATION_TYPE_PRIMARY,  32, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_0,        HID_UID_KP_0,        SKELTR_KEY_RELATION_TYPE_PRIMARY,   1, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
		{HID_UID_KP_DELETE,   HID_UID_KP_DELETE,   SKELTR_KEY_RELATION_TYPE_PRIMARY,  35, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID, SKELTR_KEY_RELATION_INVALID},
};

gchar *skeltr_hid_to_special_keyname(guint8 hid) {
	gchar *text = NULL;

	switch(hid) {
	case SKELTR_KEY_TYPE_SHIFT_1:
		text = "M1";
		break;
	case SKELTR_KEY_TYPE_SHIFT_2:
		text = "M2";
		break;
	case SKELTR_KEY_TYPE_SHIFT_3:
		text = "M3";
		break;
	case SKELTR_KEY_TYPE_SHIFT_4:
		text = "M4";
		break;
	case SKELTR_KEY_TYPE_SHIFT_5:
		text = "M5";
		break;
	case SKELTR_KEY_TYPE_FN:
		text = "FN";
		break;
	case SKELTR_KEY_TYPE_PROFILE_DOWN:
		text = "T1";
		break;
	case SKELTR_KEY_TYPE_OPEN_DRIVER:
		text = "T2";
		break;
	case SKELTR_KEY_TYPE_PROFILE_UP:
		text = "T3";
		break;
	default:
		break;
	}

	if (text)
		return g_strdup(text);
	else
		return NULL;
}
