/**[txh]********************************************************************

  Copyright (c) 2002 Jos Angel Snchez Caso (JASC)

  skeletons by Salvador E. Tropea (SET)

  Description:
  Windows GUI Display routines.

***************************************************************************/

#include <tv/configtv.h>

#define Uses_stdio
#define Uses_stdlib
#define Uses_TDisplay
#define Uses_TScreen
#define Uses_TEvent
#define Uses_TEditor
#define Uses_TGKey
#define Uses_TMouse
#define Uses_TGroup
#define Uses_TVCodePage
#define Uses_TProgram
#define Uses_TRect
#define Uses_TEvent
#define Uses_alloca
// PATH_MAX:
#define Uses_limits
#include <tv.h>

#if defined(TVOS_Win32) && !defined(TV_Disable_WinGr_Driver)

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <shellapi.h>


#include <tv/wingr/screen.h>
#include <tv/wingr/key.h>
#include <tv/wingr/mouse.h>

const int maxTitleSize= 256;

char *     TDisplayWinGr::className= "TVISION for windows"; /* Make the classname into a global variable */
HINSTANCE TDisplayWinGr::TvWinInstance;

char       TDisplayWinGr::cShapeFr;
char       TDisplayWinGr::cShapeTo;

unsigned   TDisplayWinGr::xPos= UINT_MAX; /* X axis of the cursor */
unsigned   TDisplayWinGr::yPos= UINT_MAX; /* Y axis of the cursor */
unsigned   TDisplayWinGr::zPos;           /* Z axis of the cursor (means size )*/
int        TDisplayWinGr::sizeChanged= 0; /* Resizinf counter                  */
int        TDisplayWinGr::forceRedraw= 0;

TEvent     TDisplayWinGr::storedEvent;    /* Correctly processes message queue */
HWND       TDisplayWinGr::hwnd= NULL;     /* Main window handler */
HDC        TDisplayWinGr::hdc;            /* A device context used for drawing */
COLORREF   TDisplayWinGr::colorMap[ 16 ];

HCURSOR    TDisplayWinGr::normCursor;
HCURSOR    TDisplayWinGr::sizeCursor;
HCURSOR    TDisplayWinGr::handCursor;

bitmapFontRec TDisplayWinGr::primary  = { 0,0,0,0,0 };
bitmapFontRec TDisplayWinGr::secondary= { 0,0,0,0,0 };

         RECT TDisplayWinGr::wGeo= { 0, 0, 0, 0 };

/*
 *    JASC, marz 2006
 *
 *   drag 'n' drop support
 */
 
char   TDisplayWinGr::dragDropName[ PATH_MAX ];
int    TDisplayWinGr::dragDropIdx= 0;
void * TDisplayWinGr::dragDropHnd= NULL;


/*
 *  At least font limits have the hardcoded fonts
 */
 
int TDisplayWinGr::foWmin=  8;
int TDisplayWinGr::foHmin= 16;
int TDisplayWinGr::foWmax= 10;
int TDisplayWinGr::foHmax= 20;
         
unsigned  TDisplayWinGr::dmPelsWidth ;
unsigned  TDisplayWinGr::dmPelsHeight;

         


uchar TDisplayWinGr::shapeFont10x20[]=
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x4C,0x80,0x4C,0x80,0x7C,0x80,0x79,0x80,0x73,0x80,0x73,0x80,0x73,0x80,0x7F,0x80,0x73,0x80,0x73,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x39,0x80,0x6D,0x80,0x67,0x00,0x00,0x00,0x39,0x80,0x6D,0x80,0x67,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x80,0x36,0x00,0x66,0x00,0x66,0x00,0x66,0x00,0x66,0x00,0x67,0x80,0x66,0x00,0x66,0x00,0x66,0x00,0x66,0x00,0x36,0x00,0x1F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x6D,0x80,0x6D,0x80,0x6F,0x80,0x6C,0x00,0x6C,0x00,0x6D,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x3F,0x00,0x7F,0x80,0x7F,0x80,0x3F,0x00,0x1E,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x66,0x00,0x66,0x00,0x66,0x00,0x7E,0x00,0x66,0x00,0x66,0x00,0x66,0x00,0x00,0x00,0x1F,0x80,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x7C,0x00,0x60,0x00,0x60,0x00,0x78,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x0F,0x80,0x0C,0x00,0x0C,0x00,0x0F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x3C,0x00,0x66,0x00,0x60,0x00,0x60,0x00,0x66,0x00,0x3C,0x00,0x00,0x00,0x1F,0x00,0x19,0x80,0x19,0x80,0x1F,0x00,0x1E,0x00,0x1B,0x00,0x19,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x3E,0x00,0x00,0x00,0x0F,0x80,0x0C,0x00,0x0C,0x00,0x0F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x55,0x40,0x00,0x00,0xAA,0x80,0x00,0x00,0x55,0x40,0x00,0x00,0xAA,0x80,0x00,0x00,0x55,0x40,0x00,0x00,0xAA,0x80,0x00,0x00,0x55,0x40,0x00,0x00,0xAA,0x80,0x00,0x00,0x55,0x40,0x00,0x00,0xAA,0x80,0x00,0x00
, 0x55,0x40,0xAA,0x80,0x55,0x40,0xAA,0x80,0x55,0x40,0xAA,0x80,0x55,0x40,0xAA,0x80,0x55,0x40,0xAA,0x80,0x55,0x40,0xAA,0x80,0x55,0x40,0xAA,0x80,0x55,0x40,0xAA,0x80,0x55,0x40,0xAA,0x80,0x55,0x40,0xAA,0x80
, 0x55,0x40,0xFF,0xC0,0xAA,0x80,0xFF,0xC0,0x55,0x40,0xFF,0xC0,0xAA,0x80,0xFF,0xC0,0x55,0x40,0xFF,0xC0,0xAA,0x80,0xFF,0xC0,0x55,0x40,0xFF,0xC0,0xAA,0x80,0xFF,0xC0,0x55,0x40,0xFF,0xC0,0xAA,0x80,0xFF,0xC0
, 0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0
, 0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00,0xF8,0x00
, 0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0
, 0x00,0x00,0x00,0x00,0x66,0x00,0x76,0x00,0x7E,0x00,0x7E,0x00,0x6E,0x00,0x66,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x66,0x00,0x66,0x00,0x66,0x00,0x3C,0x00,0x3C,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x1F,0x80,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x38,0x00,0x0E,0x00,0x03,0x80,0x0E,0x00,0x38,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x0E,0x00,0x38,0x00,0xE0,0x00,0x38,0x00,0x0E,0x00,0x03,0x80,0x00,0x00,0x00,0x00,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x06,0x00,0x7F,0x80,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x18,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x07,0x80,0x1F,0x80,0x7F,0x80,0x7F,0x80,0x1F,0x80,0x07,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x78,0x00,0x7E,0x00,0x7F,0x80,0x7F,0x80,0x7E,0x00,0x78,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x3F,0x00,0x6D,0x80,0x4C,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x4C,0x80,0x6D,0x80,0x3F,0x00,0x1E,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0xFF,0x80,0xFF,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0xFF,0x80,0xFF,0x80,0x60,0x00,0x30,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x3F,0x00,0x6D,0x80,0x4C,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x4C,0x80,0x6D,0x80,0x3F,0x00,0x1E,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x33,0x00,0x61,0x80,0xFF,0xC0,0xFF,0xC0,0x61,0x80,0x33,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x19,0x80,0x31,0x80,0x7F,0x80,0x7F,0x80,0x30,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x33,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x80,0x0D,0x80,0x0D,0x80,0x3F,0xC0,0x1B,0x00,0x1B,0x00,0x1B,0x00,0x7F,0x80,0x36,0x00,0x36,0x00,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x3F,0x00,0x6D,0x80,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x3F,0x00,0x0D,0x80,0x0D,0x80,0x0D,0x80,0x6D,0x80,0x3F,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x39,0x80,0x6D,0x80,0x6F,0x00,0x3B,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x1B,0x80,0x1E,0xC0,0x36,0xC0,0x33,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x36,0x00,0x36,0x00,0x36,0x00,0x3C,0x00,0x18,0x00,0x38,0x00,0x6C,0x00,0x66,0xC0,0x63,0x80,0x63,0x00,0x77,0x80,0x3C,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0x00,0x1E,0x00,0x7F,0x80,0x1E,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x33,0x00,0x1E,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1C,0x00,0x3C,0x00,0x6C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x01,0x80,0x01,0x80,0x03,0x00,0x0E,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x01,0x80,0x03,0x00,0x0E,0x00,0x03,0x00,0x01,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x07,0x00,0x0F,0x00,0x1B,0x00,0x33,0x00,0x63,0x00,0x63,0x00,0x7F,0x80,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x6E,0x00,0x73,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x00,0x60,0x00,0x60,0x00,0x6E,0x00,0x73,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x01,0x80,0x01,0x80,0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x01,0x80,0x01,0x80,0x21,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x67,0x80,0x6F,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x6F,0x00,0x66,0x00,0x60,0x00,0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x7F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x66,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x66,0x00,0x7E,0x00,0x63,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x63,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x63,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x63,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7E,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7E,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x67,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1E,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x7F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xC0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x63,0x00,0x63,0x00,0x36,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x63,0x00,0x63,0x00,0x66,0x00,0x66,0x00,0x7C,0x00,0x66,0x00,0x66,0x00,0x63,0x00,0x63,0x00,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x73,0x80,0x73,0x80,0x7F,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x71,0x80,0x71,0x80,0x79,0x80,0x79,0x80,0x6D,0x80,0x6D,0x80,0x67,0x80,0x67,0x80,0x63,0x80,0x63,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x63,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x63,0x00,0x7E,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x6D,0x80,0x67,0x80,0x33,0x00,0x1F,0x00,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x63,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x63,0x00,0x7E,0x00,0x66,0x00,0x63,0x00,0x63,0x00,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x60,0x00,0x60,0x00,0x30,0x00,0x1E,0x00,0x03,0x00,0x01,0x80,0x01,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x33,0x00,0x33,0x00,0x1E,0x00,0x1E,0x00,0x1E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x73,0x80,0x73,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x33,0x00,0x33,0x00,0x1E,0x00,0x1E,0x00,0x0C,0x00,0x1E,0x00,0x1E,0x00,0x33,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x33,0x00,0x33,0x00,0x1E,0x00,0x1E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x01,0x80,0x01,0x80,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x01,0x80,0x3F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x3E,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x6E,0x00,0x73,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x73,0x00,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x1D,0x80,0x33,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x7F,0x80,0x60,0x00,0x60,0x00,0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x19,0x80,0x19,0x80,0x18,0x00,0x18,0x00,0x7E,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x80,0x63,0x80,0x63,0x00,0x63,0x00,0x63,0x00,0x3E,0x00,0x60,0x00,0x3F,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x3F,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x6E,0x00,0x73,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x3C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x07,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x31,0x80,0x31,0x80,0x31,0x80,0x1F,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x63,0x00,0x66,0x00,0x6C,0x00,0x78,0x00,0x7C,0x00,0x66,0x00,0x63,0x00,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x5B,0x00,0x7F,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6E,0x00,0x73,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6E,0x00,0x73,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x73,0x00,0x6E,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1D,0x80,0x33,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x39,0x80,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x60,0x00,0x3F,0x00,0x01,0x80,0x01,0x80,0x61,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x7E,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x19,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x33,0x00,0x33,0x00,0x1E,0x00,0x1E,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x6D,0x80,0x6D,0x80,0x6D,0x80,0x7F,0x80,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x33,0x00,0x1E,0x00,0x0C,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x01,0x80,0x61,0x80,0x33,0x00,0x1E,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x80,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x78,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x07,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x07,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x39,0x80,0x6D,0x80,0x67,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x33,0x00,0x33,0x00,0x1E,0x00,0x1E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00
, 0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xC0,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00
, 0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x0F,0xC0,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00
, 0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0xF8,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00
, 0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0xFF,0xC0,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xC0,0x04,0x00,0x07,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x13,0xC0,0x10,0x00,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00
, 0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x10,0x00,0x13,0xC0,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00
, 0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x13,0xC0,0x10,0x00,0x13,0xC0,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x08,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0xF2,0x00,0x02,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0xF3,0xC0,0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x02,0x00,0xF2,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00
, 0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0xF2,0x00,0x02,0x00,0xF2,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0xF3,0xC0,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00
, 0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0xF3,0xC0,0x00,0x00,0xF3,0xC0,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00,0x12,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x61,0x00,0x60,0x00,0x60,0x00,0x61,0x00,0x33,0x00,0x1E,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x19,0x80,0x19,0x80,0x18,0x00,0x18,0x00,0x7E,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x7C,0x00,0x56,0xC0,0x73,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x3F,0x00,0x6D,0x80,0x6C,0x00,0x6C,0x00,0x6C,0x00,0x3F,0x00,0x0D,0x80,0x0D,0x80,0x0D,0x80,0x6D,0x80,0x3F,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x3F,0x00,0x0C,0x00,0x3F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x63,0x00,0x30,0x00,0x3C,0x00,0x66,0x00,0x33,0x00,0x19,0x80,0x0F,0x00,0x03,0x00,0x31,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x5E,0x80,0x52,0x80,0x50,0x80,0x52,0x80,0x5E,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x21,0x80,0x01,0x80,0x3F,0x80,0x61,0x80,0x61,0x80,0x3E,0x80,0x00,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x80,0x0D,0x80,0x1B,0x00,0x36,0x00,0x6C,0x00,0xD8,0x00,0x6C,0x00,0x36,0x00,0x1B,0x00,0x0D,0x80,0x04,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x7F,0x80,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x5E,0x80,0x52,0x80,0x5E,0x80,0x54,0x80,0x56,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x33,0x00,0x1E,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x0C,0x00,0x0C,0x00,0x00,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x36,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x36,0x00,0x06,0x00,0x0C,0x00,0x06,0x00,0x36,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x77,0x00,0x7D,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x80,0x7F,0x80,0x7D,0x80,0x7D,0x80,0x7D,0x80,0x3D,0x80,0x0D,0x80,0x0D,0x80,0x0D,0x80,0x0D,0x80,0x0D,0x80,0x0D,0x80,0x0D,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x1E,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x36,0x00,0x1C,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x38,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x36,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x36,0x00,0x1C,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x00,0x6C,0x00,0x36,0x00,0x1B,0x00,0x0D,0x80,0x06,0xC0,0x0D,0x80,0x1B,0x00,0x36,0x00,0x6C,0x00,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x60,0x00,0x20,0x80,0x21,0x00,0x72,0x00,0x04,0x00,0x09,0x00,0x13,0x00,0x25,0x00,0x4F,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x60,0x00,0x20,0x80,0x21,0x00,0x72,0x00,0x04,0x00,0x0B,0x00,0x14,0x80,0x20,0x80,0x41,0x00,0x02,0x00,0x07,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x08,0x00,0x30,0x80,0x09,0x00,0x72,0x00,0x04,0x00,0x09,0x00,0x13,0x00,0x25,0x00,0x4F,0x80,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x30,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x7F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x7F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x7F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x19,0x00,0x3F,0x00,0x26,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x7F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x7F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x1E,0x00,0x33,0x00,0x33,0x00,0x1E,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x7F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x1E,0x00,0x36,0x00,0x36,0x00,0x66,0x00,0x66,0x00,0x7F,0x80,0x66,0x00,0x66,0x00,0x66,0x00,0x66,0x00,0x66,0x00,0x67,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x61,0x80,0x33,0x00,0x1E,0x00,0x0C,0x00,0x06,0x00,0x36,0x00,0x1C,0x00
, 0x00,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x00,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7E,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7E,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7E,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7E,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x00,0x00,0x3F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x3F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x3F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x3F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x63,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0xF9,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x63,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x19,0x00,0x3F,0x00,0x26,0x00,0x00,0x00,0x61,0x80,0x71,0x80,0x79,0x80,0x79,0x80,0x6D,0x80,0x6D,0x80,0x67,0x80,0x67,0x80,0x63,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x19,0x00,0x3F,0x00,0x26,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x63,0x00,0x36,0x00,0x1C,0x00,0x1C,0x00,0x36,0x00,0x63,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x80,0x1F,0x00,0x33,0x00,0x63,0x80,0x63,0x80,0x65,0x80,0x65,0x80,0x65,0x80,0x69,0x80,0x69,0x80,0x69,0x80,0x71,0x80,0x33,0x00,0x3E,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x33,0x00,0x33,0x00,0x1E,0x00,0x1E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x3F,0x00,0x31,0x80,0x31,0x80,0x31,0x80,0x31,0x80,0x31,0x80,0x3F,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x1B,0x00,0x31,0x80,0x31,0x80,0x33,0x00,0x76,0x00,0x36,0x00,0x33,0x00,0x31,0x80,0x31,0x80,0x31,0x80,0x33,0x00,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x01,0x80,0x3F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x3E,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x01,0x80,0x3F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x3E,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x01,0x80,0x3F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x3E,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x00,0x3F,0x00,0x26,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x01,0x80,0x3F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x3E,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x01,0x80,0x3F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x3E,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x33,0x00,0x1E,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x01,0x80,0x3F,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x3E,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3B,0x00,0x4D,0x80,0x0D,0x80,0x0F,0x00,0x3C,0x00,0x6C,0x00,0x6C,0x80,0x37,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x31,0x80,0x1F,0x00,0x0C,0x00,0x06,0x00,0x36,0x00,0x1C,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x7F,0x80,0x60,0x00,0x60,0x00,0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x7F,0x80,0x60,0x00,0x60,0x00,0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x7F,0x80,0x60,0x00,0x60,0x00,0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x7F,0x80,0x60,0x00,0x60,0x00,0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x00,0x00,0x3C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x3C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x3C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x3C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x07,0xC0,0x01,0x80,0x1D,0x80,0x33,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x00,0x3F,0x00,0x26,0x00,0x00,0x00,0x6E,0x00,0x73,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x00,0x3F,0x00,0x26,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x7F,0x80,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x1F,0x00,0x33,0x00,0x65,0x80,0x65,0x80,0x69,0x80,0x69,0x80,0x33,0x00,0x3E,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x01,0x80,0x61,0x80,0x33,0x00,0x1E,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x3E,0x00,0x33,0x00,0x31,0x80,0x31,0x80,0x31,0x80,0x33,0x00,0x3E,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0x33,0x00,0x00,0x00,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x61,0x80,0x33,0x80,0x1D,0x80,0x01,0x80,0x61,0x80,0x33,0x00,0x1E,0x00
};

uchar TDisplayWinGr::shapeFont8x16[]=
{ 0x00,0x00,0x7E,0xC3,0x99,0x99,0xF3,0xE7,0xE7,0xFF,0xE7,0xE7,0x7E,0x00,0x00,0x00 // 0
, 0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x6E,0xF8,0xD8,0xD8,0xDC,0xD8,0xD8,0xD8,0xF8,0x6E,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x6E,0xDB,0xDB,0xDF,0xD8,0xDB,0x6E,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x88,0x88,0xF8,0x88,0x88,0x00,0x3E,0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00 // 
, 0x00,0xF8,0x80,0xE0,0x80,0x80,0x00,0x3E,0x20,0x38,0x20,0x20,0x00,0x00,0x00,0x00 // 
, 0x00,0x70,0x88,0x80,0x88,0x70,0x00,0x3C,0x22,0x3C,0x24,0x22,0x00,0x00,0x00,0x00 // 
, 0x00,0x80,0x80,0x80,0x80,0xF8,0x00,0x3E,0x20,0x38,0x20,0x20,0x00,0x00,0x00,0x00 // 
, 0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44 // \t
, 0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA // \n
, 0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77 // 
, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF // \r
, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0 // 
, 0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F // 
, 0x00,0x88,0xC8,0xA8,0x98,0x88,0x00,0x20,0x20,0x20,0x20,0x3E,0x00,0x00,0x00,0x00 // 
, 0x00,0x88,0x88,0x50,0x50,0x20,0x00,0x3E,0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x0E,0x38,0xE0,0x38,0x0E,0x00,0xFE,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0xE0,0x38,0x0E,0x38,0xE0,0x00,0xFE,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x06,0x0C,0xFE,0x18,0x30,0xFE,0x60,0xC0,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x06,0x1E,0x7E,0xFE,0x7E,0x1E,0x06,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0xC0,0xF0,0xFC,0xFE,0xFC,0xF0,0xC0,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00 // 0x1A
, 0x00,0x00,0x00,0x00,0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x28,0x6C,0xFE,0x6C,0x28,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x06,0x36,0x66,0xFE,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 //
, 0x00,0x00,0x18,0x3C,0x3C,0x3C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00 // !
, 0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // "
, 0x00,0x00,0x00,0x6C,0x6C,0xFE,0x6C,0x6C,0x6C,0xFE,0x6C,0x6C,0x00,0x00,0x00,0x00 // #
, 0x00,0x10,0x10,0x7C,0xD6,0xD0,0xD0,0x7C,0x16,0x16,0xD6,0x7C,0x10,0x10,0x00,0x00 // $
, 0x00,0x00,0x00,0x00,0xC2,0xC6,0x0C,0x18,0x30,0x60,0xC6,0x86,0x00,0x00,0x00,0x00 // %
, 0x00,0x00,0x38,0x6C,0x6C,0x38,0x76,0xDC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // &
, 0x00,0x18,0x18,0x18,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // '
, 0x00,0x00,0x0C,0x18,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x0C,0x00,0x00,0x00,0x00 // (
, 0x00,0x00,0x30,0x18,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x18,0x30,0x00,0x00,0x00,0x00 // )
, 0x00,0x00,0x00,0x00,0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,0x00,0x00,0x00,0x00 // *
, 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00 // +
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x30,0x00,0x00,0x00 // ,
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // -
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00 // .
, 0x00,0x00,0x00,0x00,0x00,0x06,0x0C,0x18,0x30,0x60,0xC0,0x00,0x00,0x00,0x00,0x00 // /
, 0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xD6,0xD6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 0
, 0x00,0x00,0x18,0x38,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00,0x00,0x00 // 1
, 0x00,0x00,0x7C,0xC6,0x06,0x0C,0x18,0x30,0x60,0xC0,0xC6,0xFE,0x00,0x00,0x00,0x00 // 2
, 0x00,0x00,0x7C,0xC6,0x06,0x06,0x3C,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00 // 3
, 0x00,0x00,0x0C,0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00,0x00 // 4
, 0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xFC,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00 // 5
, 0x00,0x00,0x38,0x60,0xC0,0xC0,0xFC,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 6
, 0x00,0x00,0xFE,0xC6,0x06,0x06,0x0C,0x18,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00 // 7
, 0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7C,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 8
, 0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x06,0x0C,0x78,0x00,0x00,0x00,0x00 // 9
, 0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00 // :
, 0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x30,0x00,0x00,0x00,0x00 // ;
, 0x00,0x00,0x00,0x06,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x06,0x00,0x00,0x00,0x00 // <
, 0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // =
, 0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x60,0x00,0x00,0x00,0x00 // >
, 0x00,0x00,0x7C,0xC6,0xC6,0x0C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00 // ?
, 0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xDE,0xDE,0xDE,0xDC,0xC0,0x7C,0x00,0x00,0x00,0x00 // @
, 0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // A
, 0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,0x00 // B
, 0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x00,0x00,0x00,0x00 // C
, 0x00,0x00,0xF8,0x6C,0x66,0x66,0x66,0x66,0x66,0x66,0x6C,0xF8,0x00,0x00,0x00,0x00 // D
, 0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00 // E
, 0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00 // F
, 0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xDE,0xC6,0xC6,0x66,0x3A,0x00,0x00,0x00,0x00 // G
, 0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // H
, 0x00,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // I
, 0x00,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00 // J
, 0x00,0x00,0xE6,0x66,0x66,0x6C,0x78,0x78,0x6C,0x66,0x66,0xE6,0x00,0x00,0x00,0x00 // K
, 0x00,0x00,0xF0,0x60,0x60,0x60,0x60,0x60,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00 // L
, 0x00,0x00,0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // M
, 0x00,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // N
, 0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // O
, 0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00 // P
, 0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xD6,0xDE,0x7C,0x0C,0x0E,0x00,0x00 // Q
, 0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x6C,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00 // R
, 0x00,0x00,0x7C,0xC6,0xC6,0x64,0x38,0x0C,0x06,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // S
, 0x00,0x00,0x7E,0x7E,0x5A,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // T
, 0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // U
, 0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x6C,0x38,0x10,0x00,0x00,0x00,0x00 // V
, 0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0xEE,0x6C,0x00,0x00,0x00,0x00 // W
, 0x00,0x00,0xC6,0xC6,0x6C,0x7C,0x38,0x38,0x7C,0x6C,0xC6,0xC6,0x00,0x00,0x00,0x00 // X
, 0x00,0x00,0x66,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // Y
, 0x00,0x00,0xFE,0xC6,0x86,0x0C,0x18,0x30,0x60,0xC2,0xC6,0xFE,0x00,0x00,0x00,0x00 // Z
, 0x00,0x00,0x3C,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x00,0x00,0x00,0x00 // [
, 0x00,0x00,0x00,0x00,0x00,0xC0,0x60,0x30,0x18,0x0C,0x06,0x00,0x00,0x00,0x00,0x00 // \ .
, 0x00,0x00,0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00,0x00,0x00,0x00 // ]
, 0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // ^
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00 // _
, 0x00,0x30,0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // `
, 0x00,0x00,0x00,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // a
, 0x00,0x00,0xE0,0x60,0x60,0x78,0x6C,0x66,0x66,0x66,0x66,0x7C,0x00,0x00,0x00,0x00 // b
, 0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC0,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00 // c
, 0x00,0x00,0x1C,0x0C,0x0C,0x3C,0x6C,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // d
, 0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00 // e
, 0x00,0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00 // f
, 0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0xCC,0x78,0x00 // g
, 0x00,0x00,0xE0,0x60,0x60,0x6C,0x76,0x66,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00 // h
, 0x00,0x00,0x18,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // i
, 0x00,0x00,0x06,0x06,0x00,0x0E,0x06,0x06,0x06,0x06,0x06,0x06,0x66,0x66,0x3C,0x00 // j
, 0x00,0x00,0xE0,0x60,0x60,0x66,0x6C,0x78,0x78,0x6C,0x66,0xE6,0x00,0x00,0x00,0x00 // k
, 0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // l
, 0x00,0x00,0x00,0x00,0x00,0xEC,0xFE,0xD6,0xD6,0xD6,0xD6,0xC6,0x00,0x00,0x00,0x00 // m
, 0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00 // n
, 0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // o
, 0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00 // p
, 0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0x0C,0x1E,0x00 // q
, 0x00,0x00,0x00,0x00,0x00,0xDC,0x76,0x66,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00 // r
, 0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0x60,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00,0x00 // s
, 0x00,0x00,0x10,0x30,0x30,0xFC,0x30,0x30,0x30,0x30,0x36,0x1C,0x00,0x00,0x00,0x00 // t
, 0x00,0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // u
, 0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00,0x00,0x00,0x00 // v
, 0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0x6C,0x00,0x00,0x00,0x00 // w
, 0x00,0x00,0x00,0x00,0x00,0xC6,0x6C,0x38,0x38,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00 // x
, 0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0xF8,0x00 // y
, 0x00,0x00,0x00,0x00,0x00,0xFE,0xCC,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,0x00 // z
, 0x00,0x00,0x0E,0x18,0x18,0x18,0x70,0x18,0x18,0x18,0x18,0x0E,0x00,0x00,0x00,0x00 // {
, 0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00 // |
, 0x00,0x00,0x70,0x18,0x18,0x18,0x0E,0x18,0x18,0x18,0x18,0x70,0x00,0x00,0x00,0x00 // }
, 0x00,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // ~
, 0x00,0x66,0x00,0x66,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 // 
, 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 // 
, 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 // 
, 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 // 
, 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00 // 
, 0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x60,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6F,0x60,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C // 
, 0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x60,0x6F,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C // 
, 0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6F,0x60,0x6F,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0C,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0xEC,0x0C,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0xEF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x0C,0xEC,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C // 
, 0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0xEC,0x0C,0xEC,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xEF,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C // 
, 0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0xEF,0x00,0xEF,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x82,0xFE,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x18,0x3C,0x3C,0x3C,0x18,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x10,0x7C,0xD6,0xD0,0xD0,0xD0,0xD6,0x7C,0x10,0x00,0x00,0x00 // 
, 0x00,0x00,0x38,0x6C,0x60,0x60,0xF0,0x60,0x60,0x66,0xF6,0x6C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0xC6,0x7C,0x6C,0x6C,0x7C,0xC6,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x66,0x66,0x3C,0x18,0x7E,0x18,0x7E,0x18,0x18,0x18,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00 // 
, 0x00,0x7C,0xC6,0x60,0x38,0x6C,0xC6,0xC6,0x6C,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00 // 
, 0x00,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x3C,0x42,0x99,0xA5,0xA1,0xA5,0x99,0x42,0x3C,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x36,0x6C,0xD8,0x6C,0x36,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x3C,0x42,0xB9,0xA5,0xB9,0xA5,0xA5,0x42,0x3C,0x00,0x00,0x00,0x00,0x00 // 
, 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x7E,0x00,0x00,0x00,0x00 // 
, 0x38,0x6C,0x18,0x30,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x38,0x6C,0x18,0x6C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xF6,0xC0,0xC0,0xC0,0x00 // 
, 0x00,0x00,0x7F,0xD6,0xD6,0x76,0x36,0x36,0x36,0x36,0x36,0x36,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x6C,0x38,0x00 // 
, 0x30,0x70,0x30,0x30,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0xD8,0x6C,0x36,0x6C,0xD8,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x60,0xE0,0x60,0x66,0x0C,0x18,0x30,0x66,0xCE,0x1A,0x3F,0x06,0x06,0x00,0x00 // 
, 0x00,0x60,0xE0,0x60,0x66,0x0C,0x18,0x30,0x6E,0xDB,0x06,0x0C,0x1F,0x00,0x00,0x00 // 
, 0x70,0xD8,0x30,0xD8,0x76,0x0C,0x18,0x30,0x66,0xCE,0x1A,0x3F,0x06,0x06,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x30,0x60,0xC6,0xC6,0x7C,0x00,0x00 // 
, 0x60,0x30,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // 
, 0x0C,0x18,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // 
, 0x10,0x38,0x6C,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // 
, 0x76,0xDC,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // 
, 0x00,0x6C,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // 
, 0x38,0x6C,0x38,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x3E,0x78,0xD8,0xD8,0xFC,0xD8,0xD8,0xD8,0xD8,0xDE,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x0C,0x66,0x3C,0x00 // 
, 0x60,0x30,0x00,0xFE,0x66,0x60,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00 // 
, 0x0C,0x18,0x00,0xFE,0x66,0x60,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00 // 
, 0x10,0x38,0x6C,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00 // 
, 0x00,0x6C,0x00,0xFE,0x66,0x60,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00 // 
, 0x60,0x30,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x06,0x0C,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x18,0x3C,0x66,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x00,0x66,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0xF8,0x6C,0x66,0x66,0xF6,0x66,0x66,0x66,0x6C,0xF8,0x00,0x00,0x00,0x00 // 
, 0x76,0xDC,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00 // 
, 0x60,0x30,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x0C,0x18,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x10,0x38,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x76,0xDC,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x66,0x3C,0x18,0x3C,0x66,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x7E,0xC6,0xCE,0xCE,0xDE,0xF6,0xE6,0xE6,0xC6,0xFC,0x00,0x00,0x00,0x00 // 
, 0x60,0x30,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x0C,0x18,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x10,0x38,0x6C,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x6C,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x06,0x0C,0x00,0x66,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0xF0,0x60,0x7C,0x66,0x66,0x66,0x66,0x7C,0x60,0xF0,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xCC,0xC6,0xC6,0xC6,0xD6,0xDC,0x80,0x00,0x00,0x00 // 
, 0x00,0x60,0x30,0x18,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x18,0x30,0x60,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x10,0x38,0x6C,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x76,0xDC,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x6C,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x38,0x6C,0x38,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x7E,0xDB,0x1B,0x7F,0xD8,0xDB,0x7E,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC0,0xC0,0xC0,0xC6,0x7C,0x18,0x6C,0x38,0x00 // 
, 0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x0C,0x18,0x30,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x6C,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x60,0x30,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x00,0x0C,0x18,0x30,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x00,0x18,0x3C,0x66,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x6C,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00 // 
, 0x00,0x78,0x30,0x78,0x0C,0x7E,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x76,0xDC,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00 // 
, 0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x0C,0x18,0x30,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x76,0xDC,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x7E,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0x00,0x00,0x7E,0xCE,0xDE,0xFE,0xF6,0xE6,0xFC,0x00,0x00,0x00,0x00 // 
, 0x00,0x60,0x30,0x18,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x18,0x30,0x60,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x30,0x78,0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x00,0x00,0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00 // 
, 0x00,0x0C,0x18,0x30,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0xF8,0x00 // 
, 0x00,0x00,0xF0,0x60,0x60,0x7C,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00,0x00 // 
, 0x00,0x00,0x00,0x6C,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0xF8,0x00 // 255
};

TScreenFont256   TDisplayWinGr::font8x16 ={ 8,  16, (uchar *)shapeFont8x16  };
TScreenFont256   TDisplayWinGr::font10x20={ 10, 20, shapeFont10x20 };
TScreenFont256 * TDisplayWinGr::defaultFont= &TDisplayWinGr::font8x16;


/*
 *  JASC, ene 2006, new raster fonts
 */

int TDisplayWinGr::selectFont( bitmapFontRec  & fontResource 
                             , TScreenFont256 * fontData )
{ if ( !hdc )      /* No resources now */
  { return( -1 );
  }

  if ( !fontData )
  { fontData= TDisplayWinGr::defaultFont;
  }

  if ( !fontResource.bitmapMemo )
  { fontResource.bitmapMemo= CreateCompatibleDC( hdc ); /* Memory needed */ 
  } 
  
  if ( fontResource.bitmapRaster )
  { DeleteObject( fontResource.bitmapRaster );  /* Free rersources */
  }    
  
/*
 * Bitmaps are word aligned but fonts are byte aligned Aghh... 
 */  
 
  ushort * data= (ushort *)fontData->data;
  ushort *  dst= (ushort *) alloca( 256 * sizeof( ushort ) * fontData->h );
  
  if ((( fontData->w - 8 ) % 16 ) == 0 )   /* 8, 24, 40 etc ... (byte aligned) */
  { int sz= 256 * fontData->h ;   /* Iterate whole chars     */
    uchar * src= fontData->data;
    data= dst;                    /* Point to the new buffer */
         
     while ( sz -- )
     { *dst ++ =  *src ++;  // *src ++;
     }
  }       
        
/*
 *  Arrange all 256 chars in a single row
 */      
 
  fontResource.w= fontData->w;
  fontResource.h= fontData->h;
      
  fontResource.bitmapRaster= 
    CreateBitmap( fontData->w
                , fontData->h * 256   /* 256 chars        */
                , 1 ,  1              /* Monochome bitmap */
                , data );             /* font data        */ 

                                
  fontResource.bitmapObject= 
    SelectObject( fontResource.bitmapMemo
                , fontResource.bitmapRaster ); 
                
/*
 * The this hardcoded bitmap fonts have evidently a fixed codepage.
 */

  TVCodePage::SetScreenCodePage( TVCodePage::ISOLatin1Linux );
  return( 0 );                
}                
                            

/* 
 *  JASC, feb 2006, Emulated DOS modes
 */

VideoModeData TDisplayWinGr::videoModes[]=
{{ smBW80   ,   80, 25, 8, 16 } 
,{ smCO80   ,   80, 25, 8, 16 } 
,{ smCO80x25,   80, 25, 8, 16 } 
,{ smMono   ,   80, 25, 8, 16 } 
,{ smFont8x8,   80, 50, 8,  8 }

/*
 *   Modes defined by Robert
 * Extended
 */
 
,{ smCO80x28,   80,28, 8, 12 }
,{ smCO80x35,   80,35, 8, 12 }
,{ smCO80x40,   80,40, 8, 12 }
,{ smCO80x43,   80,43, 8,  8 }
,{ smCO80x50,   80,50, 8,  8 }
  
/* Tweaked
 */
,{ smCO80x30,   80,30, 8, 12  }
,{ smCO80x34,   80,34, 8, 12  }
,{ smCO90x30,   90,30, 7, 12  }
,{ smCO90x34,   90,34, 5, 12  }
,{ smCO94x30,   94,30, 5, 12  }
,{ smCO94x34,   94,34, 5, 12  }
,{ smCO82x25,   82,25, 0,  0  }    /* Created by SET to get 8x16 char cells */

/* Common VESA text modes
 */
 
,{ smCO80x60 ,  80, 60, 8,  8 }
,{ smCO132x25, 132, 25, 5, 12 }
,{ smCO132x43, 132, 43, 5, 12 }
,{ smCO132x50, 132, 50, 4,  6 } 
,{ smCO132x60, 132, 60, 4,  6 }
,{}};

  
        
/* 
 *  JASC, feb 2006, Load a windows font
 */

int TDisplayWinGr::SetFontCrt( bitmapFontRec & fontResource
                             , ushort w, ushort h )
{ HGDIOBJ fontObject;
  int     loop;
  RECT    celda;
  char    letra;
  
  if ( !hdc )      /* No resources now */
  { return( -1 );
  }

  HFONT hFont= CreateFont( h                     /* Font height        */
                         , w                     /* Font width         */
                         , 0                     /* Escapement         */
                         , 0                     /* Orientation        */
                         , FW_DONTCARE           /* Weigth             */
                         , false                 /* Italic             */
                         , false                 /* Underline          */
                         , false                 /* Bold               */
                         , OEM_CHARSET           /* Charset            */
                         , OUT_DEFAULT_PRECIS    /* output precision   */
                         , CLIP_DEFAULT_PRECIS   /* clipping precision */
                         , DEFAULT_QUALITY       /* output quality     */
                         , DEFAULT_PITCH         /* pitch and family   */
                         , "Terminal" );         /* typeface name      */


  if ( !fontResource.bitmapMemo )
  { fontResource.bitmapMemo= CreateCompatibleDC( hdc ); /* Memory needed */ 
  } 

  if ( fontResource.bitmapRaster )
  { DeleteObject( fontResource.bitmapRaster );  /* Free rersources */
  }    

  fontResource.h= h;
  fontResource.w= w;
  
  fontResource.bitmapRaster= 
  CreateBitmap( fontResource.w
              , fontResource.h * 256  /* 256 chars        */
              , 1 ,  1                /* Monochome bitmap */
              , NULL );               /* font data        */
            
  fontResource.bitmapObject= 
    SelectObject( fontResource.bitmapMemo
                , fontResource.bitmapRaster ); 
  fontObject=        
    SelectObject( fontResource.bitmapMemo
                , hFont ); 


  SetBkColor  ( fontResource.bitmapMemo, 0 );  // Color de fondo
  SetTextColor( fontResource.bitmapMemo, 1 );  // Color de fondo
  
  for( loop= 0                         /* Fill in the bitmap */
     ; loop<256
     ; loop ++ )
  { letra= loop;                        /* poiter problems */ 

    celda.top=    fontResource.h * loop;
    celda.bottom= fontResource.h + celda.top;
    celda.left=   0;
    celda.right=  fontResource.w;

    DrawText( fontResource.bitmapMemo   /* Memory device   */
            , &letra, 1
            , &celda

            , DT_NOPREFIX
            | DT_SINGLELINE
            | DT_BOTTOM ); 
  }        
  
  TVCodePage::SetScreenCodePage( TVCodePage::PC437 );
  
  DeleteObject( hFont );  /* Not needed yet */
  return( 0 );
}


/* 
 *  JASC, feb 2006, Load a mode
 */

int TDisplayWinGr::SetFontMode( bitmapFontRec & fontResource 
                              , ushort newMode )
{ const VideoModeData * ptr;
  
  for( ptr= videoModes 
     ; ptr->mode
     ; ptr ++ )
  { if ( (ushort)ptr->mode == newMode )
    { SetFontCrt( fontResource
                , ptr->wFont            /* Font height        */
                , ptr->hFont );         /* Font width         */
    }    
  }  
  return( -1 );
}       
  
/*
 *
 */
void TDisplayWinGr::lowSetCursor( int x
                                , int y
                                , bool dir )
{ ushort * dst;
  char fg, bg;
  uchar letra;
  int to, fr;

  if ( THWMouseWinGr::lastCursor == sizeCursor )   /* Resizing window */
  { return;
  }

  if ( !TScreen::screenBuffer )
  { return; 
  }

  if ( zPos  )                   // Cursor not visible now
  { dir= false; 
  }
  
  if ((unsigned) x >= (unsigned)getCols() ) // JASC, this tests both bounds
  { return; 
  }
  
  if ((unsigned) y >= (unsigned)getRows() ) // JASC, this tests both bounds 
  { return; 
  }

  dst = TScreen::screenBuffer    // Calc new cursor position
      + x
      + y*TScreen::screenWidth;   

  if ( dir )
  { bg= attrColor(*dst) >>  4;   // Swap colors (reverse)
    fg= attrColor(*dst) & 0xF; 
  }
  else
  { fg= attrColor(*dst) >>  4;   // Normal  
    bg= attrColor(*dst) & 0xF; 
  }

  letra= attrChar( *dst );
       
  SetBkColor  ( hdc, colorMap[(int)bg] );  // Background color
  SetTextColor( hdc, colorMap[(int)fg] );  // Foreground color
  
  fr= dir ? cShapeFr:0;
  to= dir ? cShapeTo:primary.h;

  BitBlt( hdc
        , x * primary.w
        , y * primary.h + fr
        , primary.w
        , to - fr - 1
        , primary.bitmapMemo
        , 0, letra * primary.h
        , SRCCOPY );

  }
  

  
/*
 *   JASC, feb 2006
 *
 *  Those functions assure that the screen size have suitable values
 */
int TDisplayWinGr::CheckWindowSize( RECT & windowArea )
{ int w= wGeo.right ;
  int h= wGeo.bottom;
  int recalcFlag;

/*
 * Check a reasonable minimun size
 */
 
  TScreen::screenWidth = TScreen::screenWidth < 10 ? 10 : TScreen::screenWidth;
  TScreen::screenHeight= TScreen::screenHeight<  3 ?  3 : TScreen::screenHeight;

  wGeo.right=  TScreen::screenWidth  * primary.w;  /* quantize width   */
  wGeo.bottom= TScreen::screenHeight * primary.h;  /* quantize height  */


  if (( wGeo.right  == w )             /* No changes, all done */
   && ( wGeo.bottom == h ))
  { return( 0 );
  }

  
  do
  { windowArea= wGeo;                   /* Desired client size and pos */
    AdjustWindowRectEx( &windowArea               /* IN/OUT variable  */
                      , TScreenWinGr::style
                      , 0                         /* No windows menu  */
                      , TScreenWinGr::exStyle );  /* Extended styles  */
  
  
  /*
   * Windows dont have the same criteria in about ofsets in giving and demanding
   */
    windowArea.right += wGeo.left - windowArea.left;
    windowArea.bottom+= wGeo.top  -  windowArea.top;
  
  /*
   *  Check out of boundaries (Bigger than device size)
   */

    recalcFlag= 0;
  
    if ( windowArea.right > (ushort)dmPelsWidth )   /* Too wide           */
    { TScreen::screenWidth --;                      /* Reduce width       */
      wGeo.right-= primary.w;
      recalcFlag ++;                                /* Request a new step */
    }
  
    if ( windowArea.bottom > (ushort)dmPelsHeight ) /* Too tall           */
    { TScreen::screenWidth --;                      /* Reduce height      */
      wGeo.bottom-= primary.h;                      /* quantize height  */
      recalcFlag ++;                                /* Request a new step */
    }
  }
  while( recalcFlag );

  return( 1 );                              /* Must be resized      */
}

/*
 *
 */

void TDisplayWinGr::winRecalc( )
{ RECT windowArea;

  if ( CheckWindowSize( windowArea ) )
  { MoveWindow( hwnd
              , windowArea.left
              , windowArea.top
              , windowArea.right
              , windowArea.bottom
              , true );            /* repaintin soon */
  }
}




/*
 *    JASC 2002
 *
 *    10/3/2006 --> Draq 'n' drop support
 */
int TDisplayWinGr::testEvents( UINT   message
                             , WPARAM wParam
                             , LPARAM lParam )
{ PAINTSTRUCT ps;        /* Also used during window drawing   */

  switch( message )
  { int w, h;

    case WM_DROPFILES:                         // JASC, mar 2006, drag 'n' drop support
      dragDropHnd= (void *)wParam;
      dragDropIdx= DragQueryFile( (HDROP)dragDropHnd  // DragQueryFile is very overloaded
                                , 0xFFFFFFFF
                                , NULL
                                , 0 );

/*
 *  JASC 2006
 *
 *    Enable this block to make dragging a directory opens a file dialog
 *  is not a good idea since windows file manages is better
 *
 *    if ( dragDropIdx == 1 )             // Test posibility of a directory
 *    { DragQueryFile( (HDROP)dragDropHnd  // DragQueryFile is very overloaded
 *                   , 1
 *                   , dragDropName
 *                   , sizeof( dragDropName ));
 *
 *      if ( GetFileAttributes( dragDropName ) & FILE_ATTRIBUTE_DIRECTORY )
 *      { dragDropIdx= -1;                 // Mark as directory
 *      }
 *    }
 */
    return( 7 );

    case WM_PASTE:
      Beep();
    return( 1 );
  
    case WM_QUIT:
      storedEvent.what= evCommand;
      storedEvent.message.command= cmQuit;
      DestroyWindow( hwnd );
    return( 1 );

    case WM_DESTROY:                 /* send a WM_QUIT to the messagequeue */
      PostQuitMessage(0);
    exit( 0 );

    case WM_MOVE:                    /* Catch the window position */
      wGeo.left= LOWORD( lParam );
      wGeo.top = HIWORD( lParam );
    return( 0 );

    case WM_SIZE:
      sizeChanged++;
      if (  primary.w )
      { switch( wParam )
        { case SIZE_MINIMIZED:
          return(0);

          case SIZE_RESTORED:
          if ( !lParam )
          { return( 1 );
          }

          case SIZE_MAXIMIZED:
            w= LOWORD( lParam );  /* JASC, Integer aritmetics */
            h= HIWORD( lParam );  /* JASC, Integer aritmetics */

            w+= primary.w / 2; h+= primary.h / 2;   /* quantize (nearest) */
            w/= primary.w    ; h/= primary.h    ;

            TScreen::screenWidth = w < 0x100 ? w : 0xFF;  /* TScreen::screenWidth is a uchar !!! */
            TScreen::screenHeight= h < 0x100 ? h : 0xFF;  /* TScreen::screenHeight is a uchar !!! */
            winRecalc();
          break;
        }
      }
    return( 4 );

    case WM_PAINT: /* The window needs to be painted (redrawn). */
      BeginPaint( hwnd, &ps );

      if ( !sizeChanged )                       /* if size changed, later repainting. crash repaninting now */
      { if ( TScreen::screenBuffer )
        { int x= ps.rcPaint.left  / primary.w;
          int y= ps.rcPaint.top   / primary.h;
          int w= ps.rcPaint.right / primary.w;
          int h= ps.rcPaint.bottom/ primary.h;

          w-= x; h -= y;

          unsigned ofs= getCols()*y+x;
          ushort  *src= TScreen::screenBuffer+ofs;

          forceRedraw++ ;
              
          while (h>=0)
          { TScreen::setCharacters( ofs
                                  , src
                                  , w+1 );
            src+= getCols();         /* Next line         */
            ofs+= getCols();
            h --; y ++;              /* A line minus left */
          }
        }
      }                      

      forceRedraw= 0;
      EndPaint( hwnd, &ps );
    return( 5 ); 
  }
    
  return( 0 );     /* for messages that we don't deal with */
}    


/*
 *
 */
LRESULT CALLBACK WindowProcedure( HWND hwnd    /* This function is called by the Windowsfunction DispatchMessage( ) */
                                , UINT message
                                , WPARAM wParam
                                , LPARAM lParam )
{ int res;

  if ( THWMouseWinGr::hwnd )

  { if ( TDisplayWinGr::primary.h )             /* Cells on screen      */
    { if ( THWMouseWinGr::testEvents( message   /* Try for mouse envens */
                                    , wParam
                                    , lParam ))
      { return( 0 );                            /* Mouse event found    */
      }
    }


    if ( TGKeyWinGr::testEvents( message      /* Try for key envens */
                               , wParam
                                   , lParam ))
    { return( 0 );                            /* Key event found    */
    }


    if ( TDisplayWinGr::testEvents( message   /* Try another interesting envents */
                                  , wParam
                                  , lParam ))
    { return( 0 );                           /* Interesting event found    */
    }
  }

  res= DefWindowProc( hwnd           // Other events must be forwardwed
                    , message
                    , wParam
                    , lParam );
/*
 *  JASC, from WIN32 app reference:
 *
 *    Threads that do not contain windows should use the Sleep function
 *  with a sleep time of zero milliseconds
 *  to give up the remainder of their current time slice.
 */


 return( res );
                       
}

/*
 *  JASC 2002
 *
 *    Main windows queue
 *
 *  first feeds drag 'n' drop files to the caller
 *  Processes windows messages
 *  releases CPU inan adaptative way.
 *
 */


bool TDisplayWinGr::processEvent(  )
{ static int timer= 1;

  MSG message;                  /* Here messages to the application is saved */
  
  switch ( dragDropIdx )                           // Pending drag n drop
  { case  0: break;
/*
 *  For dragging directories, not a good idea
 *  case -1:
 *     SetCurrentDirectory( dragDropName );
 *     storedEvent.what= evCommand;
 *     storedEvent.message.command= cmOpen;       // Use this old editor command
 *     storedEvent.message.infoPtr= NULL;         // Opens a file dialog
 *     dragDropIdx= 0;
 *   return( true );
 */
    default:
      storedEvent.what= evCommand;
      storedEvent.message.command= cmOpen;       // Use this old editor command
      storedEvent.message.infoPtr= dragDropName; // Point to the file name

      DragQueryFile( (HDROP)dragDropHnd                 // Load name
                   , -- dragDropIdx
                   , dragDropName
                   , sizeof( dragDropName ));

      if ( GetFileAttributes( dragDropName )
         & ( FILE_ATTRIBUTE_DIRECTORY
           | FILE_ATTRIBUTE_TEMPORARY
           | FILE_ATTRIBUTE_OFFLINE ))
      { storedEvent.what= evNothing;
      }

      if ( !dragDropIdx )                       // Free resources last time
      { DragFinish( (HDROP) dragDropHnd );
        dragDropHnd= 0;
      }
    return( true );
  }

  if ( timer > 100 )  // Adaptative timer
  { timer= 100 ;
  }

  if ( MsgWaitForMultipleObjects
       ( 0                                // Handles in the object array
       , NULL                             // Handle array
       , false                            // D'ont care
       , timer ++
       , QS_ALLINPUT ) == WAIT_OBJECT_0 ) // Wait for every message
  { if ( GetMessage( &message
                    , NULL                // Default window
                    , 0, 0  ))            // All messages
      switch( message.message )           // Catch some keys
      { case WM_KEYUP:
        case WM_KEYDOWN:
          TGKeyWinGr::testEvents( message.message    /* Try for key envens */
                                , message.wParam
                                , message.lParam );
      }

      if ( message.message != WM_TIMER )
      { timer= 0;                     /* Reset adaptative counter    */
      }
      
      TranslateMessage( &message );   /* Arrange key events              */
      DispatchMessage ( &message );   /* Send message to WindowProcedure */
      return( true );
  }
  return( false );
}


/*
 *  JASC, jul 2002
 *
 */
void TDisplayWinGr::SetCursorPos( unsigned x
                                , unsigned y )
{ if (( x != (unsigned)xPos )
   || ( y != (unsigned)yPos ))
  { lowSetCursor( xPos         // Remove old cursor
                , yPos
                , false ); 
  }

  xPos= x; yPos= y;                // Update cursor position
  lowSetCursor( x
                  , y
                  , true ); 
  }

/*
 *
 */
void TDisplayWinGr::GetCursorPos( unsigned & x
                                , unsigned & y )
{ x= xPos;
  y= yPos; 
}


/*
 *
 */
 void TDisplayWinGr::GetCursorShape( unsigned & start  // From SET code
                                   , unsigned & end )
{ start= cShapeFr; start*= 100; start/= primary.h;    // Force integer aritmethic
  end  = cShapeTo; end  *= 100; end  /= primary.h; 
}


/*
 *
 */
void TDisplayWinGr::SetCursorShape( unsigned start    // From SET code
                                  , unsigned end )
{ lowSetCursor( xPos       // First of all, remove old cursor
              , yPos
              , false );

  cShapeFr= ( start*primary.h ) / 100; // Force integer aritmethic
  cShapeTo= (   end*primary.h ) / 100;

  if ( start>=end && getShowCursorEver() )
  { return; 
  }

  if ((unsigned)cShapeFr > (unsigned)primary.h )  // Pretty range test  ( 1 test 2 comprobations )
  { cShapeFr= primary.h; 
  }

  if ((unsigned)cShapeTo > (unsigned)primary.h )  // Pretty range test  ( 1 test 2 comprobations )
  { cShapeTo= primary.h; 
  }

  if ( start >= end )
  { zPos |=  1;         /* Disable cursor */
  }
  else
  { zPos &= ~1; 
  }

  lowSetCursor( xPos
              , yPos
              , true ); 
}


/*
 *
 */
ushort TDisplayWinGr::GetRows()
{ return( TScreen::screenHeight ); 
}

/*
 *
 */
ushort TDisplayWinGr::GetCols() 
{ return( TScreen::screenWidth ); 
}


/*
 *
 */
int TDisplayWinGr::CheckForWindowSize()
{ int ret= sizeChanged;

  sizeChanged= 0;
  return( ret ); 
}

/*
 *  Retrieves window manager window title
 */
const char * TDisplayWinGr::GetWindowTitle(void)
{ static char buff[ maxTitleSize ];

  GetWindowText( hwnd
               , buff
               , sizeof( buff) );

  return( buff );}


/* 
 *  Window manager window title
 */
int TDisplayWinGr::SetWindowTitle( const char *name )
{ SetWindowText( hwnd
               , name );

  return(0); 
}


/* 
 *   Returns hardware video mode
 */
ushort TDisplayWinGr::GetCrtMode()
{ return( TScreen::screenMode );
}


/*
 *     JASC, feb 2006
 *
 *    Emulates harware crt mode
 *
 *    The CRT mode controls three ortogonaly arranged hardware properties,
 *  colors, font size, and screen resolution, but the interface only takes one.
 *    As a solution, the tree "colored" modes ( BW80, CO80 and Mono )
 *  can change the color (and put a standard font if no one), the other modes
 *  manage the font and display size in fixed steps, and the user change to
 *  other window sizes.
 *
 */
void TDisplayWinGr::SetCrtMode( ushort newMode )
{ const VideoModeData * ptr;

  SetCursorShape(0x58,0x64);
  
  if ( newMode == 0xFFFF ) 
  { return;
  }
     
  switch ( newMode )
  { case smBW80:     /* SET fonts */ 
    case smCO80:
    case smMono:
      if ( !TScreenWinGr::screenWidth )  /* Respect previous changes */
      { TScreenWinGr::screenWidth= 80;
      }

      if ( !TScreenWinGr::screenHeight )
      { TScreenWinGr::screenHeight= 25;
      }
      
      if ( !TScreenWinGr::screenMode )
      { selectFont(   primary, TScreenWinGr::defaultFont );
        selectFont( secondary, TScreenWinGr::defaultFont );
      }

      TScreen::screenMode= newMode;
    break;
    
    default:         /* Windows fonts */
      SetFontMode( primary,    newMode );
      SetFontMode( secondary,  newMode );
      
      for( ptr= videoModes
         ; ptr->mode
         ; ptr ++ )
      { if ( (ushort)ptr->mode == newMode )
        { TScreenWinGr::screenWidth=  ptr->wScreen;
          TScreenWinGr::screenHeight= ptr->hScreen;
        }
      }  
    break;     
  }
  sizeChanged++;
}

/*
 *  Try to find a suitable font
 */
typedef struct
{ LONG minError;   /* Keeps track of the more adjusted font */
  LONG desiredW;   /* The size we are locking for           */
  LONG desiredH;
  ushort fontW;    /* More adjusted font size               */
  ushort fontH;
} fontData;
 

int CALLBACK checkFonts( const LOGFONTA   * lplf   // address of logical-font data structure
                       , const TEXTMETRIC * lpntm  // address of physical-font data structure
                       , long unsigned int         // type of font
                       , LPARAM lpData )           // address of application-defined data
{ fontData * data= (fontData *) lpData;

  if ( lplf->lfItalic )                  // No italics (bad box drawings)
  { return( 2 ); 
  }
  
  if ( lplf->lfUnderline )               // No underlines (evident)
  { return( 3 ); 
  }

  if ( lpntm->tmPitchAndFamily           // Only fixed width
     & TMPF_FIXED_PITCH )
  { return( 4 ); 
  }

/*
 *  Estimate the average error as sum of sqares
 */
  int ew= lpntm->tmMaxCharWidth - data->desiredW; ew *= ew;
  int eh= lpntm->tmHeight       - data->desiredH; eh *= eh;

  long error= ew + eh;

  TDisplayWinGr::foWmin= lpntm->tmMaxCharWidth
                       < TDisplayWinGr::foWmin
                       ? lpntm->tmMaxCharWidth
                       : TDisplayWinGr::foWmin;
                       
  TDisplayWinGr::foWmax= lpntm->tmMaxCharWidth
                       > TDisplayWinGr::foWmax
                       ? lpntm->tmMaxCharWidth
                       : TDisplayWinGr::foWmax;
                       
  TDisplayWinGr::foHmin= lpntm->tmHeight
                       < TDisplayWinGr::foHmin
                       ? lpntm->tmHeight
                       : TDisplayWinGr::foHmin;
                       
  TDisplayWinGr::foHmax= lpntm->tmHeight
                       > TDisplayWinGr::foHmax
                       ? lpntm->tmHeight
                       : TDisplayWinGr::foHmax;

  if ( error < data->minError )
  { data->minError= error;
    data->fontW   = lpntm->tmMaxCharWidth;
    data->fontH   = lpntm->tmHeight;
  }

  return( 1 /* error */ );  /* rerunrning "error" stops if the font matchs */
}


/*
 *
 *
 */
int TDisplayWinGr::SetCrtModeRes( unsigned fW
                                , unsigned fH )
{ fontData suitable;

  suitable.minError= 0x7FFF;
  suitable.desiredW= fW;
  suitable.desiredH= fH;

  EnumFontFamilies( hdc           /* Iterate font list */
                  , "Terminal"
                  , checkFonts
                  , (LPARAM)&suitable );

  if (( fW == 8 ) &&  ( fH == 16 ))
  { selectFont(   primary, &TDisplayWinGr::font8x16 );
    selectFont( secondary, &TDisplayWinGr::font8x16 );
    return( 1 );
  }

  if (( fW == 10 ) && ( fH == 20 ))
  { selectFont(   primary, &TDisplayWinGr::font10x20 );
    selectFont( secondary, &TDisplayWinGr::font10x20 );
    return( 1 );
  }

  SetFontCrt( primary,    suitable.fontW, suitable.fontH );
  SetFontCrt( secondary,  suitable.fontW, suitable.fontH );

  sizeChanged++;
  return( 0 );
}

/*
 *
 *
 */
void TDisplayWinGr::TestAllFonts( unsigned fW
                                , unsigned fH )

{ fontData suitable;

  HDC hdc= CreateIC( "DISPLAY"
                   , ""
                   , NULL
                   , NULL );

  suitable.minError= 0x7FFF;
  suitable.desiredW= fW;
  suitable.desiredH= fH;

  EnumFontFamilies( hdc                    /* Iterate font list */
                  , "Terminal"
                  , checkFonts
                  , (LPARAM)&suitable );
  DeleteDC( hdc );                         /* Free resources */

  if (( fW == 8 ) &&  ( fH == 16 ))
  { primary.w= secondary.w= fW;
    primary.h= secondary.h= fH;
    return;
  }

  if (( fW == 10 ) && ( fH == 20 ))
  { primary.w= secondary.w= fW;
    primary.h= secondary.h= fH;
    return;
  }

  primary.w= secondary.w= suitable.fontW;  /* Best fitting    */
  primary.h= secondary.h= suitable.fontH;
}


/* 
 *   Free resources
 */
TDisplayWinGr::~TDisplayWinGr() 
{ 
}

/* 
 *  Tries a beep in the sound card. If not, the speaker !!!
 */
void TDisplayWinGr::Beep()
{  MessageBeep(0xFFFFFFFF); 
}

/* 
 *  Links funnction pointers
 */
void TDisplayWinGr::Init()
{ getRows=            GetRows;
  getCols=            GetCols;
  setCrtMode=         SetCrtMode;
  getCrtMode=         GetCrtMode;
  setCursorPos=       SetCursorPos;
  getCursorPos=       GetCursorPos;
  setWindowTitle=     SetWindowTitle;
  getWindowTitle=     GetWindowTitle;
  getCursorShape=     GetCursorShape;
  setCursorShape=     SetCursorShape;
  checkForWindowSize= CheckForWindowSize;
  beep=               Beep;

// TProgram::doNotReleaseCPU= true;    // annoys windows loop, implemented here

}  


#else

#include <tv/wingr/screen.h>
#include <tv/wingr/key.h>
#include <tv/wingr/mouse.h>

#endif // TVOS_Win32


