#!/usr/bin/env bash
# =============================================================================
# Title:                    make-gnupg-artifacts.sh
# Description:              POSIX shell script to create GnuPG build artifacts
# Author:                   Peter J. Mello, Hooty McOwlface
# Version:                  2.0.0
# Usage:                    [sudo] bash make-gnupg-artifacts.sh
# Notes:                    Developed and tested on Kubuntu 19.04, intended for
#                           use on Ubuntu and its derivatives > version 18.04
# Bash Version:             5.0.3
# SPDX-License-Identifier:  Apache-2.0
# =============================================================================
# Copyright 2019 Peter J. Mello
# Copyright 2024 FreePG Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# =============================================================================

# Basic shell built-ins to promote safe operation
set -eu -o pipefail
shopt -qs failglob

# Export environment variable to keep all build processes using bash shell
typeset -x CONFIG_SHELL=$(command -v bash)

# Determine GnuPG version from the latest git tag
GNUPG_VER=$(git describe || true)
if [[ $GNUPG_VER ]]; then
  GNUPG_VER=${GNUPG_VER#*-}
  GNUPG_VER=${GNUPG_VER%%-*}
else
  GNUPG_VER=unknown
fi

ARCH=$(uname -m)-$(uname -s)

# Build GnuPG artifacts
echo "Building GnuPG artifacts..."
mkdir -p .public
find /usr/local -name locale -prune -o \! -type d -print0 | \
  tar -cjf .public/gnupg-${GNUPG_VER}-freepg-${ARCH}.tar.bz2 --null --files-from=-

# Inform user of the success of all processes
echo "Successfully gathered GnuPG version ${GNUPG_VER}-freepg artifacts to .public/"
exit 0
