#ifndef _SGIDVH_H
#define _SGIDVH_H

#define VDNAMESIZE	8

#define	VHMAGIC		0xbe5a941
#define	NPARTAB		16
#define	NVDIR		15
#define BFNAMESIZE	16

struct device_parameters {
	unsigned char	dp_skew;
	unsigned char	dp_gap1;
	unsigned char	dp_gap2;
	unsigned char	dp_spares_cyl;
	unsigned short	dp_cyls;
	unsigned short	dp_shd0;
	unsigned short	dp_trks0;
	unsigned char	dp_ctq_depth;
	unsigned char	dp_cylshi;
	unsigned short	dp_unused;
	unsigned short	dp_secs;
	unsigned short	dp_secbytes;
	unsigned short	dp_interleave;
	int	dp_flags;
	int	dp_datarate;
	int	dp_nretries;
	int	dp_mspw;
	unsigned short dp_xgap1;
	unsigned short dp_xsync;
	unsigned short dp_xrdly;
	unsigned short dp_xgap2;
	unsigned short dp_xrgate;
	unsigned short dp_xwcont;
};

struct volume_directory {
	char	vd_name[VDNAMESIZE];
	int	vd_lbn;
	int	vd_nbytes;
};

#define swap_vol_dir(x)	\
	swap32(&((x).vd_lbn)); \
	swap32(&((x).vd_nbytes));

struct partition_table {
	int	pt_nblks;
	int	pt_firstlbn;
	int	pt_type;
};

#define swap_par_tab(x)	\
	swap32(&((x).pt_nblks)); \
	swap32(&((x).pt_firstlbn)); \
	swap32(&((x).pt_type));

struct volume_header {
	int vh_magic;
	short vh_rootpt;
	short vh_swappt;
	char vh_bootfile[BFNAMESIZE];
	struct device_parameters vh_dp;
	struct volume_directory vh_vd[NVDIR];
	struct partition_table vh_pt[NPARTAB];
	int vh_csum;
	int vh_fill;
};

#define swap_vol_hdr(x)	\
	swap32(&((x).vh_magic)); \
	swap16(&((x).vh_rootpt)); \
	swap16(&((x).vh_swappt)); \
	swap32(&((x).vh_csum)); \
	swap32(&((x).vh_fill));

#endif
