###
# Copyright (c) 2008, Kevin Funk
# Copyright (c) 2014-2019 James Lu <james@overdrivenetworks.com>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   * Redistributions of source code must retain the above copyright notice,
#     this list of conditions, and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright notice,
#     this list of conditions, and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the author of this software nor the name of
#     contributors to this software may be used to endorse or promote products
#     derived from this software without specific prior written consent.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

###

import supybot.conf as conf
import supybot.registry as registry

from .local import accountsdb

def configure(advanced):
    # This will be called by supybot to configure this module.  advanced is
    # a bool that specifies whether the user identified himself as an advanced
    # user or not.  You should effect your configuration by manipulating the
    # registry as appropriate.
    from supybot.questions import expect, anything, something, yn
    conf.registerPlugin('LastFM', True)


LastFM = conf.registerPlugin('LastFM')
conf.registerGlobalValue(LastFM, 'apiKey',
     registry.String('', """Sets the API key for this plugin: http://www.last.fm/api/account/create""", private=True))
conf.registerChannelValue(LastFM, "fetchYouTubeLink",
    registry.Boolean(False, """Determines whether the bot will try to
        fetch a YouTube link for the track given in 'np'. This is an
        experimental feature, and requires the DDG plugin in this repository
        to be loaded."""))
conf.registerChannelValue(LastFM, "showExtendedInfo",
    registry.Boolean(False, """Determines whether the bot will show extended info
        for tracks in 'np' (currently the track tags and user play count). Note:
        this requires a second API call to be made for each 'np' call, which may
        be expensive in high traffic situations."""))

conf.registerGlobalValue(LastFM, accountsdb.CONFIG_OPTION_NAME, accountsdb.CONFIG_OPTION)

# vim:set shiftwidth=4 tabstop=4 expandtab textwidth=79:
