/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReplaceImportFromClauseFix
extends LocalQuickFixOnPsiElement {
    @NlsSafe
    private final String myUnquotedNewName;

    public ES6ReplaceImportFromClauseFix(@NotNull ES6ImportExportDeclaration importDeclaration, @NotNull @IntentionName String unquotedNewName) {
        if (importDeclaration == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(0);
        }
        if (unquotedNewName == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)importDeclaration);
        this.myUnquotedNewName = unquotedNewName;
    }

    @NotNull
    public String getText() {
        return ES6ReplaceImportFromClauseFix.getActionText(StringUtil.wrapWithDoubleQuote((String)this.myUnquotedNewName));
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("es6.replace.import.family.name", new Object[0]);
        if (string == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(6);
        }
        if (!startElement.isValid()) {
            return;
        }
        if (!(startElement instanceof ES6ImportExportDeclaration)) {
            return;
        }
        ES6ImportExportDeclaration importDeclaration = (ES6ImportExportDeclaration)startElement;
        ES6FromClause clause = importDeclaration.getFromClause();
        ES6ReplaceImportFromClauseFix.changeImportFromText(clause, this.myUnquotedNewName);
    }

    public static void changeImportFromText(@Nullable ES6FromClause clause, @NlsSafe String unquotedText) {
        ASTNode node;
        ASTNode oldValue;
        if (clause == null) {
            return;
        }
        if (!IntentionPreviewUtils.isPreviewElement((PsiElement)clause)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (!FileModificationService.getInstance().prepareFileForWrite(clause.getContainingFile())) {
                return;
            }
        }
        if ((oldValue = (node = clause.getNode()).findChildByType(JSTokenTypes.STRING_LITERALS)) == null) {
            return;
        }
        String quote = ES6ImportPsiUtil.getQuote((PsiElement)clause, oldValue);
        String x = "import {a} from " + quote + unquotedText + quote;
        ES6ImportDeclaration createdDeclaration = JSPsiElementFactory.createJSSourceElement(x, (PsiElement)clause, ES6ImportDeclaration.class);
        if (createdDeclaration.getFromClause() == null) {
            return;
        }
        clause.replace((PsiElement)createdDeclaration.getFromClause());
    }

    @NotNull
    public static String getActionText(@NotNull String with) {
        if (with == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(7);
        }
        String string = JavaScriptBundle.message("es6.replace.import.action.name", with);
        if (string == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedNewName";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8 -> new IllegalStateException(string);
        };
    }
}

