/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSParameterCompletionProvider;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFunctionCompletionContributor
extends CompletionContributor {
    private final boolean isUnitTest;
    public static final Key<Boolean> TEST_MARKER = new Key("JSFunctionCompletionContributor.tests.marker");
    LookupElementWeigher myWeigher = new LookupElementWeigher("priority"){

        @NotNull
        public Double weigh(@NotNull LookupElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            Double d = JSCompletionUtil.getLookupElementPriority(element);
            if (d == null) {
                1.$$$reportNull$$$0(1);
            }
            return d;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private static final InsertHandler<LookupElement> FUNCTION_EXPRESSION_INSERT_HANDLER = (context2, item) -> {
        String lookupString = item.getLookupString();
        int lBraceIndex = lookupString.indexOf(123);
        if (lBraceIndex < 0) {
            return;
        }
        int caretPosition = lBraceIndex + (lBraceIndex < lookupString.length() - 1 && Character.isWhitespace(lookupString.charAt(lBraceIndex + 1)) ? 2 : 1);
        if (caretPosition < lookupString.length()) {
            CaretModel caretModel = context2.getEditor().getCaretModel();
            caretModel.moveToOffset(caretModel.getOffset() - lookupString.length() + caretPosition);
        }
    };

    JSFunctionCompletionContributor() {
        this.isUnitTest = ApplicationManager.getApplication().isUnitTestMode();
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        int i;
        JSExpression contextExpression;
        if (parameters2 == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters2, result2);
        PsiElement parent = JSUtils.getParentSkipParentheses(parameters2.getPosition());
        JSExpression jSExpression = contextExpression = parent instanceof JSExpression ? (JSExpression)parent : null;
        if (!(contextExpression instanceof JSReferenceExpression) || ((JSReferenceExpression)contextExpression).getQualifier() != null) {
            return;
        }
        PsiElement firstParent = parameters2.getPosition().getParent();
        if (firstParent instanceof JSReferenceExpression && JSParameterCompletionProvider.isIncompleteArrowFunctionParameter((JSReferenceExpression)firstParent)) {
            return;
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)contextExpression));
        if (expectedType == null || !expectedType.isSourceStrict() && !(expectedType instanceof JSUnionType)) {
            return;
        }
        JSFunctionTypeImpl jsFunctionType = JSFunctionCompletionContributor.getFunctionTypeOrNull(expectedType, (PsiElement)contextExpression);
        if (jsFunctionType == null) {
            return;
        }
        result2 = result2.withRelevanceSorter(CompletionSorter.emptySorter().weigh(this.myWeigher));
        if (JSCompletionUtil.isUnparsedContextBeforeGenerics(parent.getParent())) {
            return;
        }
        CommonCodeStyleSettings commonSettings = JSCodeStyleSettings.getCommonSettings(parameters2.getPosition());
        JSCodeStyleSettings jsCodeStyleSettings = JSCodeStyleSettings.getSettings(parameters2.getPosition());
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(parameters2.getPosition());
        boolean generateArrowFunction = dialect != null && dialect.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS);
        List<String> functionParams = JSFunctionCompletionContributor.getParameterNames((PsiElement)contextExpression, jsFunctionType);
        int n = i = functionParams.isEmpty() ? 0 : 1;
        while (i <= functionParams.size()) {
            this.addSignature(result2, functionParams.subList(0, i), commonSettings, jsCodeStyleSettings, generateArrowFunction, i);
            ++i;
        }
    }

    @NotNull
    private static List<String> getParameterNames(@NotNull PsiElement scope2, @NotNull JSFunctionTypeImpl functionType) {
        if (scope2 == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(2);
        }
        if (functionType == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(3);
        }
        HashSet<String> usedParameterNames = new HashSet<String>();
        ArrayList<String> parameters2 = new ArrayList<String>();
        int index = 0;
        for (Pair<String, JSParameterTypeDecorator> pair : functionType.getParametersWithName()) {
            ++index;
            if (!StringUtil.isEmpty((String)((String)pair.first))) {
                String variableName = JSNameSuggestionsUtil.ensureUniqueVariableName((String)pair.first, scope2, usedParameterNames, false);
                usedParameterNames.add(variableName);
                parameters2.add(variableName);
                continue;
            }
            if (((JSParameterTypeDecorator)pair.second).getSimpleType() == null) continue;
            List<String> candidates = JSNameSuggestionsUtil.generateVariableNamesFromType(((JSParameterTypeDecorator)pair.second).getSimpleType(), scope2, usedParameterNames);
            Object usedName = (String)ContainerUtil.getFirstItem(candidates);
            usedName = !StringUtil.isEmpty((String)usedName) ? usedName : "p" + index;
            usedParameterNames.add((String)usedName);
            parameters2.add((String)usedName);
        }
        ArrayList<String> arrayList = parameters2;
        if (arrayList == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void addSignature(@NotNull CompletionResultSet result2, @NotNull List<String> parameterNames, CommonCodeStyleSettings commonSettings, JSCodeStyleSettings jsCodeStyleSettings, boolean generateArrowFunction, int localOrder) {
        if (result2 == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(5);
        }
        if (parameterNames == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(6);
        }
        if (generateArrowFunction) {
            String signature = JSFunctionCompletionContributor.getLambdaSignature(parameterNames, jsCodeStyleSettings);
            result2.addElement(this.createLookupElement(signature, (Function<? super LookupElementBuilder, ? extends LookupElementBuilder>)((Function)builder2 -> builder2.withPresentableText(builder2.getLookupString() + "{}")), localOrder));
        } else {
            String signature = JSFunctionCompletionContributor.getAnonymousFunctionSignature(parameterNames, commonSettings, jsCodeStyleSettings);
            result2.addElement(this.createLookupElement(signature, (Function<? super LookupElementBuilder, ? extends LookupElementBuilder>)((Function)builder2 -> builder2.withInsertHandler(FUNCTION_EXPRESSION_INSERT_HANDLER)), localOrder));
        }
    }

    @Nullable
    private static JSFunctionTypeImpl getFunctionTypeOrNull(@Nullable JSType expectedType, PsiElement context2) {
        JSGenericTypeImpl genericType;
        List<JSType> functionTypes = JSTypeUtils.getFunctionType(expectedType, false, context2).toList();
        JSType functionType = (JSType)ContainerUtil.getFirstItem(functionTypes);
        if (functionType == null) {
            return null;
        }
        JSGenericTypeImpl jSGenericTypeImpl = genericType = functionType instanceof JSGenericTypeImpl ? (JSGenericTypeImpl)functionType : null;
        if (genericType != null) {
            functionType = genericType.getType();
        }
        return functionType instanceof JSFunctionTypeImpl ? (JSFunctionTypeImpl)functionType : null;
    }

    @NotNull
    private LookupElement createLookupElement(@NotNull String signature, @NotNull Function<? super LookupElementBuilder, ? extends LookupElementBuilder> configureBuilder, int localOrder) {
        if (signature == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(7);
        }
        if (configureBuilder == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(8);
        }
        LookupElementBuilder elementBuilder = LookupElementBuilder.create((String)signature).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Function));
        LookupElement element = (LookupElement)configureBuilder.fun((Object)elementBuilder);
        element = PrioritizedLookupElement.withPriority((LookupElement)element, (double)localOrder);
        if (this.isUnitTest) {
            element.putUserData(TEST_MARKER, (Object)true);
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(9);
        }
        return lookupElement;
    }

    @NotNull
    private static String getAnonymousFunctionSignature(@NotNull List<String> parameterNames, @NotNull CommonCodeStyleSettings commonCodeStyleSettings, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (parameterNames == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(10);
        }
        if (commonCodeStyleSettings == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(11);
        }
        if (jsCodeStyleSettings == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(12);
        }
        StringBuilder builder2 = new StringBuilder("function");
        if (jsCodeStyleSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH) {
            builder2.append(' ');
        }
        builder2.append('(');
        String separator = commonCodeStyleSettings.SPACE_AFTER_COMMA ? ", " : ",";
        String parametersStr = StringUtil.join(parameterNames, (String)separator);
        builder2.append(parametersStr);
        builder2.append(')');
        if (commonCodeStyleSettings.SPACE_BEFORE_METHOD_LBRACE) {
            builder2.append(' ');
        }
        builder2.append("{  }");
        String string = builder2.toString();
        if (string == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getLambdaSignature(@NotNull List<String> parameterNames, @NotNull JSCodeStyleSettings codeStyleSettings) {
        if (parameterNames == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(14);
        }
        if (codeStyleSettings == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(15);
        }
        String parametersStr = StringUtil.join(parameterNames, (String)", ");
        StringBuilder builder2 = new StringBuilder();
        if (parameterNames.size() != 1) {
            builder2.append('(');
        }
        builder2.append(parametersStr);
        if (parameterNames.size() != 1) {
            builder2.append(')');
        }
        builder2.append(codeStyleSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR ? " => " : "=>");
        String string = builder2.toString();
        if (string == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configureBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCodeStyleSettings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCodeStyleSettings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousFunctionSignature";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLambdaSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNames";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSignature";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousFunctionSignature";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 13, 16 -> new IllegalStateException(string);
        };
    }
}

