/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.fus;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.collectors.fus.TerminalFusAwareHandler;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.terminal.TerminalShellCommandHandler;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.fus.BlockTerminalSwitchPlace;
import org.jetbrains.plugins.terminal.fus.TerminalCommandGenerationEvent;
import org.jetbrains.plugins.terminal.fus.TerminalCommandUsageStatistics;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackEvent;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackMoment;
import org.jetbrains.plugins.terminal.fus.TerminalShellInfoStatistics;
import org.jetbrains.plugins.terminal.fus.TimeSpanType;
import org.jetbrains.plugins.terminal.util.ShellType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007J \u00104\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u001eH\u0007J1\u00107\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020;H\u0001\u00a2\u0006\u0004\b<\u0010=J-\u0010>\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00105\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020;\u00a2\u0006\u0004\bB\u0010CJ:\u0010D\u001a\u0002012\u0006\u00102\u001a\u0002032\b\u0010E\u001a\u0004\u0018\u00010\u001d2\u0006\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001eH\u0007J+\u0010K\u001a\u0002012\u0006\u00102\u001a\u0002032\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001d0M2\u0006\u00106\u001a\u00020\u001eH\u0007\u00a2\u0006\u0002\u0010NJ%\u0010K\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010O\u001a\u00020\u001d2\u0006\u0010P\u001a\u00020QH\u0000\u00a2\u0006\u0002\bRJ\u0015\u0010S\u001a\u0002012\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\bTJ\u0015\u0010U\u001a\u0002012\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\bVJ \u0010W\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010X\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020)H\u0007J%\u0010Z\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010[\u001a\u00020+2\u0006\u0010\\\u001a\u00020,H\u0000\u00a2\u0006\u0002\b]J\u0016\u0010^\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010[\u001a\u00020/R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lorg/jetbrains/plugins/terminal/fus/TerminalUsageTriggerCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "TERMINAL_COMMAND_HANDLER_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "RUN_ANYTHING_PROVIDER_FIELD", "OS_VERSION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "SHELL_STR_FIELD", "SHELL_TYPE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lorg/jetbrains/plugins/terminal/util/ShellType;", "BLOCK_TERMINAL_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "EXIT_CODE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "EXECUTION_TIME_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "sshExecEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "terminalSmartCommandExecutedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "terminalSmartCommandNotExecutedEvent", "localExecEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "shellStartedEvent", "commandStartedEvent", "timespanFinishedEvent", "Lorg/jetbrains/plugins/terminal/fus/TimeSpanType;", "", "commandFinishedEvent", "promotionShownEvent", "promotionGotItClickedEvent", "blockTerminalSwitchedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lorg/jetbrains/plugins/terminal/fus/BlockTerminalSwitchPlace;", "feedbackSurveyEvent", "Lorg/jetbrains/plugins/terminal/fus/TerminalFeedbackEvent;", "Lorg/jetbrains/plugins/terminal/fus/TerminalFeedbackMoment;", "commandGenerationEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lorg/jetbrains/plugins/terminal/fus/TerminalCommandGenerationEvent;", "triggerSshShellStarted", "", "project", "Lcom/intellij/openapi/project/Project;", "triggerCommandStarted", "userCommandLine", "isBlockTerminal", "logBlockTerminalTimeSpanFinished", "shellType", "timeSpanType", "duration", "Lkotlin/time/Duration;", "logBlockTerminalTimeSpanFinished-Wn2Vu4Y$intellij_terminal", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/util/ShellType;Lorg/jetbrains/plugins/terminal/fus/TimeSpanType;J)V", "triggerCommandFinished", "exitCode", "", "executionTime", "triggerCommandFinished-Wn2Vu4Y", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;IJ)V", "triggerSmartCommand", "workingDirectory", "localSession", "command", "handler", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "executed", "triggerLocalShellStarted", "shellCommand", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;Z)V", "shellName", "shellInfo", "Lorg/jetbrains/plugins/terminal/fus/TerminalShellInfoStatistics$LoggableShellInfo;", "triggerLocalShellStarted$intellij_terminal", "triggerPromotionShown", "triggerPromotionShown$intellij_terminal", "triggerPromotionGotItClicked", "triggerPromotionGotItClicked$intellij_terminal", "triggerBlockTerminalSwitched", "enabled", "place", "triggerFeedbackSurveyEvent", "event", "moment", "triggerFeedbackSurveyEvent$intellij_terminal", "triggerCommandGenerationEvent", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalUsageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUsageCollector.kt\norg/jetbrains/plugins/terminal/fus/TerminalUsageTriggerCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,224:1\n249#2,3:225\n249#2,3:228\n249#2,3:231\n249#2,3:234\n249#2,3:237\n249#2,3:240\n*S KotlinDebug\n*F\n+ 1 TerminalUsageCollector.kt\norg/jetbrains/plugins/terminal/fus/TerminalUsageTriggerCollector\n*L\n29#1:225,3\n71#1:228,3\n87#1:231,3\n89#1:234,3\n90#1:237,3\n93#1:240,3\n*E\n"})
public final class TerminalUsageTriggerCollector
extends CounterUsagesCollector {
    @NotNull
    public static final TerminalUsageTriggerCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final ClassEventField TERMINAL_COMMAND_HANDLER_FIELD;
    @NotNull
    private static final ClassEventField RUN_ANYTHING_PROVIDER_FIELD;
    @NotNull
    private static final StringEventField OS_VERSION_FIELD;
    @NotNull
    private static final StringEventField SHELL_STR_FIELD;
    @NotNull
    private static final EnumEventField<ShellType> SHELL_TYPE_FIELD;
    @NotNull
    private static final BooleanEventField BLOCK_TERMINAL_FIELD;
    @NotNull
    private static final IntEventField EXIT_CODE_FIELD;
    @NotNull
    private static final LongEventField EXECUTION_TIME_FIELD;
    @NotNull
    private static final EventId sshExecEvent;
    @NotNull
    private static final VarargEventId terminalSmartCommandExecutedEvent;
    @NotNull
    private static final VarargEventId terminalSmartCommandNotExecutedEvent;
    @NotNull
    private static final EventId3<String, String, Boolean> localExecEvent;
    @NotNull
    private static final VarargEventId shellStartedEvent;
    @NotNull
    private static final EventId3<String, String, Boolean> commandStartedEvent;
    @NotNull
    private static final EventId3<ShellType, TimeSpanType, Long> timespanFinishedEvent;
    @NotNull
    private static final VarargEventId commandFinishedEvent;
    @NotNull
    private static final EventId promotionShownEvent;
    @NotNull
    private static final EventId promotionGotItClickedEvent;
    @NotNull
    private static final EventId2<Boolean, BlockTerminalSwitchPlace> blockTerminalSwitchedEvent;
    @NotNull
    private static final EventId2<TerminalFeedbackEvent, TerminalFeedbackMoment> feedbackSurveyEvent;
    @NotNull
    private static final EventId1<TerminalCommandGenerationEvent> commandGenerationEvent;

    private TerminalUsageTriggerCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void triggerSshShellStarted(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        sshExecEvent.log(project);
    }

    @JvmStatic
    public static final void triggerCommandStarted(@NotNull Project project, @NotNull String userCommandLine, boolean isBlockTerminal) {
        TerminalCommandUsageStatistics.CommandData commandData;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userCommandLine, (String)"userCommandLine");
        TerminalCommandUsageStatistics.CommandData commandData2 = commandData = TerminalCommandUsageStatistics.INSTANCE.getLoggableCommandData(userCommandLine);
        TerminalCommandUsageStatistics.CommandData commandData3 = commandData;
        commandStartedEvent.log(project, (Object)(commandData2 != null ? commandData2.getCommand() : null), (Object)(commandData3 != null ? commandData3.getSubCommand() : null), (Object)isBlockTerminal);
    }

    @JvmStatic
    public static final void logBlockTerminalTimeSpanFinished-Wn2Vu4Y$intellij_terminal(@Nullable Project project, @NotNull ShellType shellType, @NotNull TimeSpanType timeSpanType, long duration) {
        Intrinsics.checkNotNullParameter((Object)((Object)shellType), (String)"shellType");
        Intrinsics.checkNotNullParameter((Object)((Object)timeSpanType), (String)"timeSpanType");
        timespanFinishedEvent.log(project, (Object)shellType, (Object)timeSpanType, (Object)Duration.getInWholeMilliseconds-impl((long)duration));
    }

    public final void triggerCommandFinished-Wn2Vu4Y(@NotNull Project project, @NotNull String userCommandLine, int exitCode, long executionTime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userCommandLine, (String)"userCommandLine");
        TerminalCommandUsageStatistics.CommandData commandData = TerminalCommandUsageStatistics.INSTANCE.getLoggableCommandData(userCommandLine);
        EventPair[] eventPairArray = new EventPair[4];
        TerminalCommandUsageStatistics.CommandData commandData2 = commandData;
        eventPairArray[0] = TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal().with((Object)(commandData2 != null ? commandData2.getCommand() : null));
        TerminalCommandUsageStatistics.CommandData commandData3 = commandData;
        eventPairArray[1] = TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal().with((Object)(commandData3 != null ? commandData3.getSubCommand() : null));
        eventPairArray[2] = EXIT_CODE_FIELD.with((Object)exitCode);
        eventPairArray[3] = EXECUTION_TIME_FIELD.with((Object)Duration.getInWholeMilliseconds-impl((long)executionTime));
        commandFinishedEvent.log(project, eventPairArray);
    }

    @JvmStatic
    public static final void triggerSmartCommand(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command2, @NotNull TerminalShellCommandHandler handler, boolean executed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Object[] objectArray = new EventPair[]{TERMINAL_COMMAND_HANDLER_FIELD.with(handler.getClass())};
        List data = CollectionsKt.mutableListOf((Object[])objectArray);
        if (handler instanceof TerminalFusAwareHandler) {
            ((TerminalFusAwareHandler)handler).fillData(project, workingDirectory, localSession, command2, data);
        }
        if (executed) {
            terminalSmartCommandExecutedEvent.log(project, data);
        } else {
            terminalSmartCommandNotExecutedEvent.log(project, data);
        }
    }

    @JvmStatic
    public static final void triggerLocalShellStarted(@NotNull Project project, @NotNull String[] shellCommand, boolean isBlockTerminal) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        Object object = Version.parseVersion((String)SystemInfo.OS_VERSION);
        if (object == null || (object = object.toCompactString()) == null) {
            object = "unknown";
        }
        localExecEvent.log(project, object, (Object)TerminalShellInfoStatistics.INSTANCE.getShellNameForStat((String)ArraysKt.firstOrNull((Object[])shellCommand)), (Object)isBlockTerminal);
        if (isBlockTerminal) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            String string = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCodeAndSnapshot();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringWithoutProductCodeAndSnapshot(...)");
            String version = string;
            propertiesComponent.setValue("BLOCK_TERMINAL_LAST_USED_VERSION", version);
            propertiesComponent.setValue("BLOCK_TERMINAL_LAST_USED_DATE", (int)(System.currentTimeMillis() / (long)1000), 0);
        }
    }

    public final void triggerLocalShellStarted$intellij_terminal(@NotNull Project project, @NotNull String shellName, @NotNull TerminalShellInfoStatistics.LoggableShellInfo shellInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)shellName, (String)"shellName");
        Intrinsics.checkNotNullParameter((Object)shellInfo, (String)"shellInfo");
        Object object = Version.parseVersion((String)SystemInfo.OS_VERSION);
        if (object == null || (object = object.toCompactString()) == null) {
            object = "unknown";
        }
        Object osVersion = object;
        EventPair[] eventPairArray = new EventPair[12];
        eventPairArray[0] = OS_VERSION_FIELD.with(osVersion);
        String string = shellName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        eventPairArray[1] = SHELL_STR_FIELD.with((Object)string);
        eventPairArray[2] = TerminalShellInfoStatistics.INSTANCE.getShellVersionField().with((Object)shellInfo.getShellVersion());
        eventPairArray[3] = TerminalShellInfoStatistics.INSTANCE.getPromptThemeField().with((Object)shellInfo.getPromptTheme());
        eventPairArray[4] = TerminalShellInfoStatistics.INSTANCE.isOhMyZshField().with((Object)shellInfo.isOhMyZsh());
        eventPairArray[5] = TerminalShellInfoStatistics.INSTANCE.isOhMyPoshField().with((Object)shellInfo.isOhMyPosh());
        eventPairArray[6] = TerminalShellInfoStatistics.INSTANCE.isP10KField().with((Object)shellInfo.isP10K());
        eventPairArray[7] = TerminalShellInfoStatistics.INSTANCE.isStarshipField().with((Object)shellInfo.isStarship());
        eventPairArray[8] = TerminalShellInfoStatistics.INSTANCE.isSpaceshipField().with((Object)shellInfo.isSpaceship());
        eventPairArray[9] = TerminalShellInfoStatistics.INSTANCE.isPreztoField().with((Object)shellInfo.isPrezto());
        eventPairArray[10] = TerminalShellInfoStatistics.INSTANCE.isOhMyBashField().with((Object)shellInfo.isOhMyBash());
        eventPairArray[11] = TerminalShellInfoStatistics.INSTANCE.isBashItField().with((Object)shellInfo.isBashIt());
        shellStartedEvent.log(project, eventPairArray);
    }

    public final void triggerPromotionShown$intellij_terminal(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        promotionShownEvent.log(project);
    }

    public final void triggerPromotionGotItClicked$intellij_terminal(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        promotionGotItClickedEvent.log(project);
    }

    @JvmStatic
    public static final void triggerBlockTerminalSwitched(@NotNull Project project, boolean enabled, @NotNull BlockTerminalSwitchPlace place) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
        blockTerminalSwitchedEvent.log(project, (Object)enabled, (Object)place);
    }

    public final void triggerFeedbackSurveyEvent$intellij_terminal(@NotNull Project project, @NotNull TerminalFeedbackEvent event, @NotNull TerminalFeedbackMoment moment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)moment), (String)"moment");
        feedbackSurveyEvent.log(project, (Object)event, (Object)moment);
    }

    public final void triggerCommandGenerationEvent(@NotNull Project project, @NotNull TerminalCommandGenerationEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        commandGenerationEvent.log(project, (Object)event);
    }

    static {
        EventField[] $this$iv;
        INSTANCE = new TerminalUsageTriggerCollector();
        GROUP = new EventLogGroup("terminalShell", 29, null, 4, null);
        TERMINAL_COMMAND_HANDLER_FIELD = EventFields.Class((String)"terminalCommandHandler");
        RUN_ANYTHING_PROVIDER_FIELD = EventFields.Class((String)"runAnythingProvider");
        OS_VERSION_FIELD = EventFields.StringValidatedByRegexpReference$default((String)"os-version", (String)"version", null, (int)4, null);
        SHELL_STR_FIELD = EventFields.String((String)"shell", (List)CollectionsKt.toList((Iterable)TerminalShellInfoStatistics.INSTANCE.getKNOWN_SHELLS()));
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "shell";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        SHELL_TYPE_FIELD = new EnumEventField(name$iv, ShellType.class, null, transform$iv);
        BLOCK_TERMINAL_FIELD = EventFields.Boolean((String)"new_terminal");
        EXIT_CODE_FIELD = EventFields.Int((String)"exit_code");
        EXECUTION_TIME_FIELD = EventFields.Long((String)"execution_time", (String)"Time in milliseconds");
        sshExecEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"ssh.exec", null, (int)2, null);
        $this$iv = new EventFields[]{TERMINAL_COMMAND_HANDLER_FIELD, RUN_ANYTHING_PROVIDER_FIELD};
        terminalSmartCommandExecutedEvent = GROUP.registerVarargEvent("terminal.smart.command.executed", $this$iv);
        $this$iv = new EventField[]{TERMINAL_COMMAND_HANDLER_FIELD, RUN_ANYTHING_PROVIDER_FIELD};
        terminalSmartCommandNotExecutedEvent = GROUP.registerVarargEvent("terminal.smart.command.not.executed", $this$iv);
        localExecEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"local.exec", (EventField)((EventField)OS_VERSION_FIELD), (EventField)((EventField)SHELL_STR_FIELD), (EventField)((EventField)BLOCK_TERMINAL_FIELD), null, (int)16, null);
        $this$iv = new EventField[]{OS_VERSION_FIELD, SHELL_STR_FIELD, TerminalShellInfoStatistics.INSTANCE.getShellVersionField(), TerminalShellInfoStatistics.INSTANCE.getPromptThemeField(), TerminalShellInfoStatistics.INSTANCE.isOhMyZshField(), TerminalShellInfoStatistics.INSTANCE.isOhMyPoshField(), TerminalShellInfoStatistics.INSTANCE.isP10KField(), TerminalShellInfoStatistics.INSTANCE.isStarshipField(), TerminalShellInfoStatistics.INSTANCE.isSpaceshipField(), TerminalShellInfoStatistics.INSTANCE.isPreztoField(), TerminalShellInfoStatistics.INSTANCE.isOhMyBashField(), TerminalShellInfoStatistics.INSTANCE.isBashItField()};
        shellStartedEvent = GROUP.registerVarargEvent("local.shell.started", $this$iv);
        commandStartedEvent = GROUP.registerEvent("terminal.command.executed", (EventField)TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal(), (EventField)TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal(), (EventField)BLOCK_TERMINAL_FIELD, "Fired each time when command is started");
        $this$iv = EventFields.INSTANCE;
        name$iv = "time_span_type";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        timespanFinishedEvent = GROUP.registerEvent("terminal.timespan.finished", (EventField)SHELL_TYPE_FIELD, (EventField)new EnumEventField(name$iv, TimeSpanType.class, null, transform$iv), (EventField)EventFields.DurationMs, "Logs performance/responsiveness metrics");
        $this$iv = new EventField[]{TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal(), TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal(), EXIT_CODE_FIELD, EXECUTION_TIME_FIELD};
        commandFinishedEvent = GROUP.registerVarargEvent("terminal.command.finished", "Fired each time when command is finished. New Terminal only.", $this$iv);
        promotionShownEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"promotion.shown", null, (int)2, null);
        promotionGotItClickedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"promotion.got.it.clicked", null, (int)2, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "switch_place";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        blockTerminalSwitchedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"new.terminal.switched", (EventField)((EventField)EventFields.Boolean((String)"enabled")), (EventField)((EventField)new EnumEventField(name$iv, BlockTerminalSwitchPlace.class, null, transform$iv)), null, (int)8, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "event_type";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        EnumEventField enumEventField = new EnumEventField(name$iv, TerminalFeedbackEvent.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "moment";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        feedbackSurveyEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"feedback.event.happened", (EventField)((EventField)enumEventField), (EventField)((EventField)new EnumEventField(name$iv, TerminalFeedbackMoment.class, null, transform$iv)), null, (int)8, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "event_type";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        commandGenerationEvent = GROUP.registerEvent("command.generation.event.happened", (EventField)new EnumEventField(name$iv, TerminalCommandGenerationEvent.class, null, transform$iv), "Events related to generate command from natural language feature of New Terminal");
    }
}

