/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.wsl;

import com.intellij.execution.target.TargetBasedSdkAdditionalData;
import com.intellij.execution.target.TargetConfigurationWithLocalFsAccess;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.wsl.HelpersAwareWslTargetEnvironmentRequest;
import com.intellij.python.wsl.PyWSLUtilsKt;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.wsl.remoteSdk.WSLCredentialsHolder;
import com.intellij.wsl.remoteSdk.WSLCredentialsType;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.add.v1.TargetPanelExtension;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.target.targetWithVfs.TargetWithMappedLocalVfs;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J&\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/python/wsl/PythonWslInterpreterTargetEnvironmentFactory;", "Lcom/jetbrains/python/run/PythonInterpreterTargetEnvironmentFactory;", "<init>", "()V", "getPythonTargetInterpreter", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "getTargetModuleResidesOnImpl", "Lcom/intellij/execution/target/TargetConfigurationWithLocalFsAccess;", "module", "Lcom/intellij/openapi/module/Module;", "packageManagementSupported", "", "evConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "(Lcom/intellij/execution/target/TargetEnvironmentConfiguration;)Ljava/lang/Boolean;", "isFor", "configuration", "asTargetWithMappedLocalVfs", "Lcom/jetbrains/python/target/targetWithVfs/TargetWithMappedLocalVfs;", "envConfig", "getTargetType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "isMutable", "getDefaultSdkName", "", "data", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "version", "getPanelExtension", "Lcom/jetbrains/python/sdk/add/v1/TargetPanelExtension;", "intellij.python.wsl"})
@SourceDebugExtension(value={"SMAP\nPythonWslInterpreterTargetEnvironmentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonWslInterpreterTargetEnvironmentFactory.kt\ncom/intellij/python/wsl/PythonWslInterpreterTargetEnvironmentFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class PythonWslInterpreterTargetEnvironmentFactory
implements PythonInterpreterTargetEnvironmentFactory {
    @Nullable
    public HelpersAwareTargetEnvironmentRequest getPythonTargetInterpreter(@NotNull Sdk sdk, @NotNull Project project) {
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof TargetBasedSdkAdditionalData) {
            HelpersAwareWslTargetEnvironmentRequest helpersAwareWslTargetEnvironmentRequest;
            TargetEnvironmentConfiguration targetEnvironmentConfiguration = ((TargetBasedSdkAdditionalData)sdkAdditionalData).getTargetEnvironmentConfiguration();
            TargetEnvironmentRequest targetEnvironmentRequest = targetEnvironmentConfiguration != null ? targetEnvironmentConfiguration.createEnvironmentRequest(project) : null;
            WslTargetEnvironmentRequest wslTargetEnvironmentRequest = targetEnvironmentRequest instanceof WslTargetEnvironmentRequest ? (WslTargetEnvironmentRequest)targetEnvironmentRequest : null;
            if (wslTargetEnvironmentRequest != null) {
                WslTargetEnvironmentRequest it = wslTargetEnvironmentRequest;
                boolean bl = false;
                helpersAwareWslTargetEnvironmentRequest = new HelpersAwareWslTargetEnvironmentRequest(it);
            } else {
                helpersAwareWslTargetEnvironmentRequest = null;
            }
            helpersAwareTargetEnvironmentRequest = helpersAwareWslTargetEnvironmentRequest;
        } else if (sdkAdditionalData instanceof PyRemoteSdkAdditionalData) {
            HelpersAwareWslTargetEnvironmentRequest helpersAwareWslTargetEnvironmentRequest;
            Ref result = new Ref();
            CredentialsCase[] credentialsCaseArray = new CredentialsCase[]{CredentialsCase.create((CredentialsType)((CredentialsType)WSLCredentialsType.getInstance()), arg_0 -> PythonWslInterpreterTargetEnvironmentFactory.getPythonTargetInterpreter$lambda$1(result, arg_0))};
            ((PyRemoteSdkAdditionalData)sdkAdditionalData).connectionCredentials().switchType(credentialsCaseArray);
            WslTargetEnvironmentRequest wslTargetEnvironmentRequest = (WslTargetEnvironmentRequest)result.get();
            if (wslTargetEnvironmentRequest != null) {
                WslTargetEnvironmentRequest targetEnvironmentRequest = wslTargetEnvironmentRequest;
                boolean bl = false;
                helpersAwareWslTargetEnvironmentRequest = new HelpersAwareWslTargetEnvironmentRequest(targetEnvironmentRequest);
            } else {
                helpersAwareWslTargetEnvironmentRequest = null;
            }
            helpersAwareTargetEnvironmentRequest = helpersAwareWslTargetEnvironmentRequest;
        } else {
            helpersAwareTargetEnvironmentRequest = null;
        }
        return helpersAwareTargetEnvironmentRequest;
    }

    @Nullable
    public TargetConfigurationWithLocalFsAccess getTargetModuleResidesOnImpl(@NotNull Module module) {
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        WSLDistribution wSLDistribution = PyWSLUtilsKt.getDistroThisModuleResidesOn(module);
        if (wSLDistribution != null) {
            WSLDistribution it = wSLDistribution;
            boolean bl = false;
            wslTargetEnvironmentConfiguration = new WslTargetEnvironmentConfiguration(it);
        } else {
            wslTargetEnvironmentConfiguration = null;
        }
        return (TargetConfigurationWithLocalFsAccess)wslTargetEnvironmentConfiguration;
    }

    @Nullable
    public Boolean packageManagementSupported(@NotNull TargetEnvironmentConfiguration evConfiguration) {
        Intrinsics.checkNotNullParameter((Object)evConfiguration, (String)"evConfiguration");
        return evConfiguration instanceof WslTargetEnvironmentConfiguration ? Boolean.valueOf(true) : null;
    }

    public boolean isFor(@NotNull TargetEnvironmentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration instanceof WslTargetEnvironmentConfiguration;
    }

    @Nullable
    public TargetWithMappedLocalVfs asTargetWithMappedLocalVfs(@NotNull TargetEnvironmentConfiguration envConfig) {
        Intrinsics.checkNotNullParameter((Object)envConfig, (String)"envConfig");
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration = envConfig instanceof WslTargetEnvironmentConfiguration ? (WslTargetEnvironmentConfiguration)envConfig : null;
        if (wslTargetEnvironmentConfiguration == null || (wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.getDistribution()) == null) {
            return null;
        }
        WslTargetEnvironmentConfiguration distro = wslTargetEnvironmentConfiguration;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem vfs = localFileSystem;
        return new TargetWithMappedLocalVfs(vfs, (WSLDistribution)distro){
            final /* synthetic */ LocalFileSystem $vfs;
            final /* synthetic */ WSLDistribution $distro;
            {
                this.$vfs = $vfs;
                this.$distro = $distro;
            }

            public VirtualFile getVfsFromTargetPath(String targetPath) {
                Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
                return this.$vfs.findFileByPath(this.$distro.getWindowsPath(targetPath));
            }

            public String getTargetPathFromVfs(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return this.$distro.getWslPath(file.toNioPath());
            }

            public Path getLocalPath(String targetPath) {
                Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
                Path path = Path.of(this.$distro.getWindowsPath(targetPath), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                return path;
            }

            public String getTargetPath(Path localPath) {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                return this.$distro.getWslPath(localPath);
            }
        };
    }

    @NotNull
    public TargetEnvironmentType<?> getTargetType() {
        return (TargetEnvironmentType)TargetEnvironmentType.EXTENSION_NAME.findExtensionOrFail(WslTargetType.class);
    }

    @Nullable
    public Boolean isMutable(@NotNull TargetEnvironmentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return Intrinsics.areEqual((Object)configuration.getTypeId(), (Object)"wsl") ? Boolean.valueOf(true) : null;
    }

    @Nullable
    public String getDefaultSdkName(@Nullable Project project, @NotNull PyTargetAwareAdditionalData data, @Nullable String version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = data.getTargetEnvironmentConfiguration();
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration = targetEnvironmentConfiguration instanceof WslTargetEnvironmentConfiguration ? (WslTargetEnvironmentConfiguration)targetEnvironmentConfiguration : null;
        if (wslTargetEnvironmentConfiguration != null) {
            WslTargetEnvironmentConfiguration wsl = wslTargetEnvironmentConfiguration;
            boolean bl = false;
            String string2 = version;
            if (string2 == null) {
                string2 = "unknown interpreter";
            }
            WSLDistribution wSLDistribution = wsl.getDistribution();
            string = string2 + " WSL (" + (wSLDistribution != null ? wSLDistribution.getPresentableName() : null) + "): (" + data.getInterpreterPath() + ")";
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public TargetPanelExtension getPanelExtension(@NotNull Project project, @NotNull TargetEnvironmentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return null;
    }

    private static final void getPythonTargetInterpreter$lambda$1(Ref $result, WSLCredentialsHolder it) {
        WslTargetEnvironmentConfiguration config = new WslTargetEnvironmentConfiguration();
        config.setDistribution(it.getDistribution());
        $result.set((Object)new WslTargetEnvironmentRequest(config));
    }
}

