/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.ContextualMapping;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTarget;
import org.jetbrains.letsPlot.core.plot.base.tooltip.LineSpec;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TooltipAnchor;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.spec.TooltipSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory;", "", "contextualMapping", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/ContextualMapping;", "axisOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "flippedAxis", "", "xAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "yAxisTheme", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "(Lorg/jetbrains/letsPlot/core/plot/base/tooltip/ContextualMapping;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;ZLorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;)V", "create", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "geomTarget", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTarget;", "Helper", "plot-builder"})
public final class TooltipSpecFactory {
    @NotNull
    private final ContextualMapping contextualMapping;
    @NotNull
    private final DoubleVector axisOrigin;
    private final boolean flippedAxis;
    @NotNull
    private final AxisTheme xAxisTheme;
    @NotNull
    private final AxisTheme yAxisTheme;
    @NotNull
    private final PlotContext ctx;

    public TooltipSpecFactory(@NotNull ContextualMapping contextualMapping, @NotNull DoubleVector axisOrigin, boolean flippedAxis, @NotNull AxisTheme xAxisTheme, @NotNull AxisTheme yAxisTheme, @NotNull PlotContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)contextualMapping, (String)"contextualMapping");
        Intrinsics.checkNotNullParameter((Object)axisOrigin, (String)"axisOrigin");
        Intrinsics.checkNotNullParameter((Object)xAxisTheme, (String)"xAxisTheme");
        Intrinsics.checkNotNullParameter((Object)yAxisTheme, (String)"yAxisTheme");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.contextualMapping = contextualMapping;
        this.axisOrigin = axisOrigin;
        this.flippedAxis = flippedAxis;
        this.xAxisTheme = xAxisTheme;
        this.yAxisTheme = yAxisTheme;
        this.ctx = ctx2;
    }

    @NotNull
    public final List<TooltipSpec> create(@NotNull GeomTarget geomTarget) {
        Intrinsics.checkNotNullParameter((Object)geomTarget, (String)"geomTarget");
        return new ArrayList(new Helper(geomTarget, this.flippedAxis, this.ctx).createTooltipSpecs());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\nJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010!\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\u00180\"H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J\b\u0010$\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory$Helper;", "", "myGeomTarget", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTarget;", "flippedAxis", "", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTarget;ZLorg/jetbrains/letsPlot/core/plot/base/PlotContext;)V", "myDataPoints", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/LineSpec$DataPoint;", "myIsCrosshairEnabled", "myTooltipAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TooltipAnchor;", "myTooltipMinWidth", "", "Ljava/lang/Double;", "myTooltipTitle", "", "axisDataPoints", "axisTooltipSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "createHintForAxis", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TipLayoutHint;", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "createTooltipSpecs", "generalDataPoints", "generalTooltipSpec", "hitIndex", "", "sideDataPoints", "sideHints", "", "sideTooltipSpec", "tipLayoutHint", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nTooltipSpecFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipSpecFactory.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory$Helper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n215#2:181\n216#2:193\n215#2,2:216\n766#3:182\n857#3,2:183\n1549#3:185\n1620#3,3:186\n1549#3:189\n1620#3,3:190\n766#3:194\n857#3,2:195\n1549#3:197\n1620#3,3:198\n1549#3:201\n1620#3,3:202\n766#3:205\n857#3,2:206\n1549#3:208\n1620#3,3:209\n1549#3:212\n1620#3,3:213\n1549#3:218\n1620#3,3:219\n766#3:222\n857#3,2:223\n766#3:225\n857#3,2:226\n819#3:228\n847#3,2:229\n1603#3,9:231\n1855#3:240\n1856#3:242\n1612#3:243\n1603#3,9:244\n1855#3:253\n1856#3:255\n1612#3:256\n766#3:257\n857#3,2:258\n1#4:241\n1#4:254\n*S KotlinDebug\n*F\n+ 1 TooltipSpecFactory.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory$Helper\n*L\n57#1:181\n57#1:193\n90#1:216,2\n59#1:182\n59#1:183,2\n60#1:185\n60#1:186,3\n61#1:189\n61#1:190,3\n83#1:194\n83#1:195,2\n84#1:197\n84#1:198,3\n85#1:201\n85#1:202,3\n86#1:205\n86#1:206,2\n87#1:208\n87#1:209,3\n88#1:212\n88#1:213,3\n110#1:218\n110#1:219,3\n131#1:222\n131#1:223,2\n132#1:225\n132#1:226,2\n135#1:228\n135#1:229,2\n136#1:231,9\n136#1:240\n136#1:242\n136#1:243\n137#1:244,9\n137#1:253\n137#1:255\n137#1:256\n138#1:257\n138#1:258,2\n136#1:241\n137#1:254\n*E\n"})
    private final class Helper {
        @NotNull
        private final GeomTarget myGeomTarget;
        private final boolean flippedAxis;
        @NotNull
        private final List<LineSpec.DataPoint> myDataPoints;
        @Nullable
        private final TooltipAnchor myTooltipAnchor;
        @Nullable
        private final Double myTooltipMinWidth;
        private final boolean myIsCrosshairEnabled;
        @Nullable
        private final String myTooltipTitle;

        public Helper(GeomTarget myGeomTarget, @NotNull boolean flippedAxis, PlotContext ctx2) {
            Intrinsics.checkNotNullParameter((Object)myGeomTarget, (String)"myGeomTarget");
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            this.myGeomTarget = myGeomTarget;
            this.flippedAxis = flippedAxis;
            this.myDataPoints = TooltipSpecFactory.this.contextualMapping.getDataPoints(this.hitIndex(), ctx2);
            this.myTooltipAnchor = TooltipSpecFactory.this.contextualMapping.getTooltipAnchor();
            this.myTooltipMinWidth = TooltipSpecFactory.this.contextualMapping.getTooltipMinWidth();
            this.myIsCrosshairEnabled = TooltipSpecFactory.this.contextualMapping.isCrosshairEnabled();
            this.myTooltipTitle = TooltipSpecFactory.this.contextualMapping.getTitle(this.hitIndex(), ctx2);
        }

        @NotNull
        public final List<TooltipSpec> createTooltipSpecs() {
            ArrayList tooltipSpecs = new ArrayList();
            CollectionsKt.addAll((Collection)tooltipSpecs, (Iterable)this.axisTooltipSpec());
            CollectionsKt.addAll((Collection)tooltipSpecs, (Iterable)this.sideTooltipSpec());
            CollectionsKt.addAll((Collection)tooltipSpecs, (Iterable)this.generalTooltipSpec());
            return tooltipSpecs;
        }

        private final int hitIndex() {
            return this.myGeomTarget.getHitIndex();
        }

        private final TipLayoutHint tipLayoutHint() {
            return this.myGeomTarget.getTipLayoutHint();
        }

        private final Map<Aes<?>, TipLayoutHint> sideHints() {
            return this.myGeomTarget.getAesTipLayoutHints();
        }

        /*
         * WARNING - void declaration
         */
        private final List<TooltipSpec> sideTooltipSpec() {
            ArrayList<TooltipSpec> tooltipSpecs = new ArrayList<TooltipSpec>();
            List<LineSpec.DataPoint> sideDataPoints = this.sideDataPoints();
            Map<Aes<?>, TipLayoutHint> $this$forEach$iv = this.sideHints();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Aes<?>, TipLayoutHint>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                LineSpec.DataPoint it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Map.Entry<Aes<?>, TipLayoutHint> element$iv;
                Map.Entry<Aes<?>, TipLayoutHint> entry = element$iv = iterator2.next();
                boolean bl = false;
                Aes<?> aes2 = entry.getKey();
                TipLayoutHint hint = entry.getValue();
                Iterable iterable = sideDataPoints;
                boolean $i$f$filter = false;
                void var13_15 = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (LineSpec.DataPoint)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(aes2, it.getAes())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void p0;
                    it = (LineSpec.DataPoint)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(p0.getValue());
                }
                $this$map$iv = (List)destination$iv$iv;
                TooltipSpec.Line.Companion companion = TooltipSpec.Line.Companion;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String bl3 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(companion.withValue((String)p0));
                }
                List linesForAes = (List)destination$iv$iv2;
                if (!(!((Collection)linesForAes).isEmpty())) continue;
                Color color = hint.getFillColor();
                if (color == null && (color = this.tipLayoutHint().getFillColor()) == null && (color = (Color)CollectionsKt.firstOrNull(this.tipLayoutHint().getMarkerColors())) == null) {
                    color = Color.Companion.getWHITE();
                }
                tooltipSpecs.add(new TooltipSpec(hint, null, linesForAes, color, CollectionsKt.emptyList(), true, null, null, false, 448, null));
            }
            return tooltipSpecs;
        }

        /*
         * WARNING - void declaration
         */
        private final List<TooltipSpec> axisTooltipSpec() {
            Map axis;
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void p0;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv;
            LineSpec.DataPoint it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            ArrayList<TooltipSpec> tooltipSpecs = new ArrayList<TooltipSpec>();
            Pair[] pairArray = new Pair[2];
            Iterable iterable = this.axisDataPoints();
            Aes<Double> aes2 = Aes.Companion.getX();
            int n = 0;
            Pair[] pairArray2 = pairArray;
            boolean $i$f$filter = false;
            void var6_12 = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(Aes.Companion.getX(), it.getAes())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable<TooltipSpec.Line> iterable2 = (List)destination$iv$iv;
            $this$filter$iv = iterable2;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (LineSpec.DataPoint)item$iv$iv;
                iterable2 = destination$iv$iv;
                boolean bl = false;
                iterable2.add(p0.getValue());
            }
            iterable2 = (List)destination$iv$iv;
            $this$map$iv = iterable2;
            TooltipSpec.Line.Companion $i$f$map22 = TooltipSpec.Line.Companion;
            boolean $i$f$map32 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p02;
                String bl = (String)item$iv$iv;
                iterable2 = destination$iv$iv2;
                boolean bl2 = false;
                iterable2.add($i$f$map22.withValue((String)p02));
            }
            iterable2 = (List)destination$iv$iv2;
            pairArray2[n] = TuplesKt.to(aes2, iterable2);
            $this$map$iv = this.axisDataPoints();
            aes2 = Aes.Companion.getY();
            n = 1;
            pairArray2 = pairArray;
            $i$f$filter = false;
            Iterable $i$f$map32 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(Aes.Companion.getY(), it.getAes())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable2 = (List)destination$iv$iv;
            $this$filter$iv = iterable2;
            boolean $i$f$map = false;
            Iterable $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (LineSpec.DataPoint)item$iv$iv;
                iterable2 = destination$iv$iv;
                boolean bl = false;
                iterable2.add(p0.getValue());
            }
            iterable2 = (List)destination$iv$iv;
            $this$map$iv = iterable2;
            Object object = TooltipSpec.Line.Companion;
            boolean $i$f$map4 = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p03;
                String bl = (String)item$iv$iv;
                iterable2 = destination$iv$iv;
                boolean bl3 = false;
                iterable2.add((TooltipSpec.Line)((TooltipSpec.Line.Companion)object).withValue((String)p03));
            }
            iterable2 = (List)destination$iv$iv;
            pairArray2[n] = TuplesKt.to(aes2, iterable2);
            Map $this$forEach$iv = axis = MapsKt.mapOf((Pair[])pairArray);
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                Aes aes3 = (Aes)entry.getKey();
                List lines = (List)entry.getValue();
                if (!(!((Collection)lines).isEmpty())) continue;
                TipLayoutHint layoutHint = this.createHintForAxis(aes3, this.flippedAxis);
                Color color = layoutHint.getFillColor();
                Intrinsics.checkNotNull((Object)color);
                tooltipSpecs.add(new TooltipSpec(layoutHint, null, lines, color, CollectionsKt.emptyList(), true, null, null, false, 448, null));
            }
            return tooltipSpecs;
        }

        /*
         * WARNING - void declaration
         */
        private final List<TooltipSpec> generalTooltipSpec() {
            void $this$mapTo$iv$iv;
            List<LineSpec.DataPoint> generalDataPoints = this.generalDataPoints();
            Iterable $this$map$iv = generalDataPoints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LineSpec.DataPoint dataPoint = (LineSpec.DataPoint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TooltipSpec.Line.Companion.withLabelAndValue(it.getLabel(), it.getValue()));
            }
            List generalLines = (List)destination$iv$iv;
            return !((Collection)generalLines).isEmpty() ? CollectionsKt.listOf((Object)new TooltipSpec(this.tipLayoutHint(), this.myTooltipTitle, generalLines, null, this.tipLayoutHint().getMarkerColors(), false, this.myTooltipAnchor, this.myTooltipMinWidth, this.myIsCrosshairEnabled)) : CollectionsKt.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        private final List<LineSpec.DataPoint> sideDataPoints() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.myDataPoints;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LineSpec.DataPoint it = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (!(it.isSide() && !it.isAxis())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LineSpec.DataPoint> axisDataPoints() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.myDataPoints;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LineSpec.DataPoint p0 = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (!p0.isAxis()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LineSpec.DataPoint> generalDataPoints() {
            void $this$filterTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Object element$iv$iv$iv2;
            void $this$mapNotNullTo$iv$iv2;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = this.myDataPoints;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                LineSpec.DataPoint p0 = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (p0.isSide()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonSideDataPoints = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = this.sideDataPoints();
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Iterable<Aes<?>> destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                Aes<?> it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv2;
                boolean bl = false;
                LineSpec.DataPoint p0 = (LineSpec.DataPoint)element$iv$iv;
                boolean bl2 = false;
                if (p0.getAes() == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List sideDataPoints = (List)destination$iv$iv2;
            Iterable $this$mapNotNull$iv2 = nonSideDataPoints;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv2 = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                Aes<?> it$iv$iv;
                Object element$iv$iv$iv3;
                Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                boolean bl = false;
                LineSpec.DataPoint p0 = (LineSpec.DataPoint)element$iv$iv;
                boolean bl4 = false;
                if (p0.getAes() == null) continue;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List generalAesList = CollectionsKt.minus((Iterable)((List)destination$iv$iv3), (Iterable)sideDataPoints);
            Iterable $this$filter$iv = nonSideDataPoints;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LineSpec.DataPoint dataPoint = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                Aes<?> aes2 = dataPoint.getAes();
                boolean bl6 = aes2 == null ? true : CollectionsKt.contains((Iterable)generalAesList, aes2);
                if (!bl6) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            return (List)destination$iv$iv3;
        }

        private final TipLayoutHint createHintForAxis(Aes<?> aes2, boolean flippedAxis) {
            TipLayoutHint tipLayoutHint;
            Aes<?> it = aes2;
            boolean bl = false;
            Aes<Object> aes3 = flippedAxis && Intrinsics.areEqual(it, Aes.Companion.getX()) ? Aes.Companion.getY() : (flippedAxis && Intrinsics.areEqual(it, Aes.Companion.getY()) ? Aes.Companion.getX() : it);
            Aes<?> axis = aes3;
            Aes<?> aes4 = axis;
            if (Intrinsics.areEqual(aes4, Aes.Companion.getX())) {
                DoubleVector doubleVector = this.tipLayoutHint().getCoord();
                Intrinsics.checkNotNull((Object)doubleVector);
                tipLayoutHint = TipLayoutHint.Companion.xAxisTooltip$default(TipLayoutHint.Companion, new DoubleVector(doubleVector.getX(), TooltipSpecFactory.this.axisOrigin.getY()), 1.5, null, TooltipSpecFactory.this.xAxisTheme.tooltipFill(), 4, null);
            } else if (Intrinsics.areEqual(aes4, Aes.Companion.getY())) {
                double d = TooltipSpecFactory.this.axisOrigin.getX();
                DoubleVector doubleVector = this.tipLayoutHint().getCoord();
                Intrinsics.checkNotNull((Object)doubleVector);
                tipLayoutHint = TipLayoutHint.Companion.yAxisTooltip$default(TipLayoutHint.Companion, new DoubleVector(d, doubleVector.getY()), 1.5, null, TooltipSpecFactory.this.yAxisTheme.tooltipFill(), 4, null);
            } else {
                throw new IllegalStateException(("Not an axis aes: " + axis).toString());
            }
            return tipLayoutHint;
        }
    }
}

