/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.derby;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0014JP\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001f\u001a\u00020\nH\u0014J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u001c\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\b2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lcom/intellij/database/dialects/derby/DerbyPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "typeCanCastToText", "", "", "supportsInOperator", "", "getSupportsInOperator", "()Z", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "version", "Lcom/intellij/database/util/Version;", "alias", "likePredicate", "columnRef", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "isBitDataType", "typeName", "suffix", "intellij.database.dialects.derby"})
@SourceDebugExtension(value={"SMAP\nDerbyPredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DerbyPredicatesHelper.kt\ncom/intellij/database/dialects/derby/DerbyPredicatesHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class DerbyPredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final Set<String> typeCanCastToText;

    public DerbyPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        Object[] objectArray = new String[]{"time", "date", "timestamp", "clob"};
        this.typeCanCastToText = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public boolean getSupportsInOperator() {
        return true;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return this.isBitDataType(column2) ? null : super.equalsPredicate(column2, value, op, quote, version, alias);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (this.isBitDataType(columnRef)) {
            return null;
        }
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        v0 = domain;
        v1 = v0 != null ? v0.supports(OperationKt.LIKE_OPERATION) : (typeSupportsOperation = false);
        if (!canCastToText) ** GOTO lbl-1000
        v2 = domain;
        if (v2 != null ? v2.supports(OperationKt.EQUALS_TO_NUMBER_OPERATION) : false) ** GOTO lbl-1000
        v3 = columnRef.getTypeName();
        if (v3 != null) {
            it = v3;
            $i$a$-let-DerbyPredicatesHelper$likePredicate$canCast$1 = false;
            v4 = this.typeCanCastToText.contains(StringUtil.toLowerCase((String)it));
        } else {
            v4 = false;
        }
        if (v4) {
            v5 = true;
        } else lbl-1000:
        // 3 sources

        {
            v5 = canCast = false;
        }
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        v6 = PredicatesUtilKt.getLikeKeyword(op.getMatchCase(), op.isNotLike(), this.getDbms(), version, inUpdate);
        if (v6 == null) {
            return null;
        }
        likeWord = v6;
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, op, (Function1<? super DdlBuilder, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, likePredicate$lambda$1(boolean java.lang.String com.intellij.database.data.types.ColumnRef java.lang.String com.intellij.database.data.types.PredicateValue com.intellij.database.dialects.derby.DerbyPredicatesHelper com.intellij.database.data.types.LikePredicateOperation com.intellij.database.util.DdlBuilder ), (Lcom/intellij/database/util/DdlBuilder;)Lkotlin/Unit;)((boolean)typeSupportsOperation, (String)alias, (ColumnRef)columnRef, (String)likeWord, (PredicateValue)value, (DerbyPredicatesHelper)this, (LikePredicateOperation)op));
    }

    private final boolean isBitDataType(ColumnRef columnRef) {
        boolean bl;
        DasColumn dasColumn = PredicatesUtilKt.toDasColumn(columnRef);
        if (dasColumn != null) {
            DasType dasType = dasColumn.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasType dasType2 = dasType;
            DataType dataType = dasType2.toDataType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
            DataType dataType2 = dataType;
            bl = this.isBitDataType(DasTypeUtilsKt.getTypeName(dasType2), dataType2.suffix);
        } else if (columnRef instanceof ConsumerColumnRef) {
            String string = ((ConsumerColumnRef)columnRef).getCol().getTypeName();
            if (string == null) {
                string = "";
            }
            bl = DerbyPredicatesHelper.isBitDataType$default(this, string, null, 2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isBitDataType(String typeName, String suffix) {
        return StringUtil.equalsIgnoreCase((CharSequence)suffix, (CharSequence)"FOR BIT DATA") || StringUtil.endsWithIgnoreCase((String)typeName, (String)"FOR BIT DATA");
    }

    static /* synthetic */ boolean isBitDataType$default(DerbyPredicatesHelper derbyPredicatesHelper, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return derbyPredicatesHelper.isBitDataType(string, string2);
    }

    private static final Unit likePredicate$lambda$1(boolean $typeSupportsOperation, String $alias, ColumnRef $columnRef, String $likeWord, PredicateValue $value, DerbyPredicatesHelper this$0, LikePredicateOperation $op, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!$typeSupportsOperation) {
            DdlBuilder ddlBuilder = builder.keyword("CAST").symbol("(");
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"symbol(...)");
            v1 = PredicatesUtilKt.identifier(ddlBuilder, $alias, $columnRef).space().keyword("AS").space().type("VARCHAR(100)").symbol(")");
        } else {
            v1 = PredicatesUtilKt.identifier(builder, $alias, $columnRef);
        }
        DdlBuilder ddlBuilder = builder.space().keyword($likeWord).space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        PredicatesUtilKt.value(ddlBuilder, $value, $columnRef, this$0.getDbms(), $op.getLikeType().getDecorator());
        return Unit.INSTANCE;
    }
}

