/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.structure.DvStructureExtension;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.openapi.Disposable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u001a0\u0019H\u0004J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0004J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b$J)\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'H\u0010\u00a2\u0006\u0002\b)J\u0015\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b+J\u001d\u0010,\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b-J\r\u0010.\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b/J\b\u00100\u001a\u00020\u001fH&J\b\u00101\u001a\u00020\u001fH\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010\u001d\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0001\u000245\u00a8\u00066"}, d2={"Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "Lcom/intellij/database/view/structure/DvTreeLayer;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "base", "getBase", "()Lcom/intellij/database/view/structure/DvTreeLayer;", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "getContext", "()Lcom/intellij/database/view/structure/DvTreeContext;", "level", "", "getLevel", "()B", "vo", "Lcom/intellij/database/view/structure/DvViewOptions;", "getVo", "()Lcom/intellij/database/view/structure/DvViewOptions;", "extension", "Lcom/intellij/database/view/structure/DvStructureExtension;", "dbms", "Lcom/intellij/database/Dbms;", "extensions", "", "Lcom/intellij/database/DbmsExtension$Bean;", "baseParentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "onDataSourceAdded", "", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "onDataSourceAdded$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceModelReplaced", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "onDataSourceModelReplaced$intellij_database_core_impl", "onDataSourceChanged", "onDataSourceChanged$intellij_database_core_impl", "onDataSourceRemoved", "onDataSourceRemoved$intellij_database_core_impl", "onViewOptionsChanged", "onViewOptionsChanged$intellij_database_core_impl", "clearAll", "dispose", "isValid", "", "Lcom/intellij/database/view/structure/DvTreeFundamentLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "intellij.database.core.impl"})
public abstract class DvTreeAbstractLayer
implements DvTreeLayer,
Disposable {
    private DvTreeAbstractLayer() {
    }

    @Nullable
    public abstract DvTreeLayer getBase();

    @NotNull
    public abstract DvTreeContext getContext();

    public abstract byte getLevel();

    @NotNull
    protected final DvViewOptions getVo() {
        return this.getContext().vo;
    }

    @Nullable
    protected final DvStructureExtension extension(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return DvStructureExtension.Companion.getEP().forDbms(dbms);
    }

    @NotNull
    protected final Collection<DbmsExtension.Bean<DvStructureExtension>> extensions() {
        List<DbmsExtension.Bean<DvStructureExtension>> list = DvStructureExtension.Companion.getEP().allExtensions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"allExtensions(...)");
        return list;
    }

    @Nullable
    protected final BasicNode baseParentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.getBase();
        if (dvTreeLayer == null) {
            return null;
        }
        DvTreeLayer base = dvTreeLayer;
        BasicNode p2 = base.parentOf(node);
        if (p2 == node) {
            String layerClassName = base.getClass().getSimpleName();
            throw new InternalError("The method " + layerClassName + ".parentOf() works incorrectly for node: " + node + " (node class: " + node.getClass().getSimpleName() + ")");
        }
        return p2;
    }

    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
    }

    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
    }

    public void onDataSourceModelReplaced$intellij_database_core_impl(@NotNull RawDataSource dataSource, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
    }

    public void onDataSourceChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
    }

    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
    }

    public void onViewOptionsChanged$intellij_database_core_impl() {
    }

    public abstract void clearAll();

    public void dispose() {
        this.clearAll();
    }

    @Override
    public boolean isValid(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.getBase();
        return dvTreeLayer != null ? dvTreeLayer.isValid(node) : false;
    }

    public /* synthetic */ DvTreeAbstractLayer(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

