/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.completion.SassScssCompletionContributor;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.lexer.SCSSTokenTypes;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.psi.SassScssUseAtRule;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;
import org.jetbrains.plugins.scss.psi.stubs.ScssVariablesIndex;
import org.jetbrains.plugins.scss.references.SassScssQualifierReference;

public final class VariableNamesProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        boolean qualifiedVarCompletion;
        if (parameters == null) {
            VariableNamesProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            VariableNamesProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            VariableNamesProvider.$$$reportNull$$$0(2);
        }
        PsiElement originalElement = parameters.getOriginalPosition();
        PsiFile originalFile = parameters.getOriginalFile();
        PsiElement position = parameters.getPosition();
        Project project = parameters.getPosition().getProject();
        boolean bl = qualifiedVarCompletion = position.getNode().getElementType() != SCSSTokenTypes.VARIABLE;
        if (qualifiedVarCompletion) {
            VariableNamesProvider.addQualifiedVars(result, position);
            return;
        }
        String existingQualifier = SassScssCompletionContributor.getQualifier(position);
        if (existingQualifier != null) {
            VariableNamesProvider.addVarsForQualifier(result, position, existingQualifier);
            return;
        }
        SassScssVariableDeclaration originalParentDeclaration = (SassScssVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)originalElement, SassScssVariableDeclaration.class);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)originalFile, (PsiElement)position, (boolean)false);
        Map<PsiFile, SASSSCSSLangUtil.QualifierInfo> fileToQualifierInfoMap = SASSSCSSLangUtil.getFileToQualifierInfoMap(position);
        PsiElement parent = position.getParent();
        SassScssInclude parentInclude = (SassScssInclude)PsiTreeUtil.getParentOfType((PsiElement)position, SassScssInclude.class);
        SassScssInclude originalParentInclude = parentInclude != null ? (SassScssInclude)CompletionUtil.getOriginalElement((PsiElement)parentInclude) : null;
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        for (String name : StubIndex.getInstance().getAllKeys(ScssVariablesIndex.KEY, project)) {
            ScssVariablesIndex.process(name, project, scope, (Processor<? super SassScssVariableDeclaration>)((Processor)declaration -> {
                if (originalParentDeclaration == declaration || parent == declaration) {
                    return true;
                }
                if (originalParentInclude != null && PsiTreeUtil.getParentOfType((PsiElement)declaration, SassScssInclude.class) == originalParentInclude) {
                    return true;
                }
                if (declaration != null && SASSSCSSLangUtil.isVisibleDeclaration((PsiElement)declaration, position)) {
                    String prefix = result.getPrefixMatcher().getPrefix();
                    PsiFile declFile = declaration.getContainingFile();
                    SASSSCSSLangUtil.QualifierInfo info = (SASSSCSSLangUtil.QualifierInfo)fileToQualifierInfoMap.get(declFile);
                    if (info != null) {
                        String targetName = declaration.getName();
                        if (!targetName.startsWith("-") && !targetName.startsWith("_")) {
                            LookupElement lookupItem = SASSSCSSLangUtil.createVariableLookupItem(info.prefixFromForwards, declaration, info.qualifier, true, prefix, false);
                            result.addElement(lookupItem);
                        }
                    } else {
                        boolean validResult = importedFiles.contains(declaration.getContainingFile().getVirtualFile());
                        result.addElement(SASSSCSSLangUtil.createVariableLookupItem(null, declaration, null, validResult, prefix, false));
                    }
                }
                return true;
            }));
            result.restartCompletionOnPrefixChange(SassScssCompletionContributor.RESTART_IDENTIFIER_COMPLETION_CONDITION);
        }
    }

    private static void addQualifiedVars(@NotNull CompletionResultSet result, @NotNull PsiElement position) {
        Map<PsiFile, SASSSCSSLangUtil.QualifierInfo> fileToQualifierInfoMap;
        if (result == null) {
            VariableNamesProvider.$$$reportNull$$$0(3);
        }
        if (position == null) {
            VariableNamesProvider.$$$reportNull$$$0(4);
        }
        if ((fileToQualifierInfoMap = SASSSCSSLangUtil.getFileToQualifierInfoMap(position)).isEmpty()) {
            return;
        }
        for (Map.Entry<PsiFile, SASSSCSSLangUtil.QualifierInfo> entry : fileToQualifierInfoMap.entrySet()) {
            PsiFile file = entry.getKey();
            SASSSCSSLangUtil.QualifierInfo info = entry.getValue();
            if (!(file instanceof SassScssStylesheetFile)) continue;
            for (SassScssVariableDeclaration var : ((SassScssStylesheetFile)file).getTopLevelDeclarations(SassScssVariableDeclaration.class)) {
                String name = var.getName();
                if (name.isEmpty() || name.startsWith("-") || name.startsWith("_")) continue;
                String prefix = result.getPrefixMatcher().getPrefix();
                if (prefix.isEmpty()) {
                    result.addElement(SASSSCSSLangUtil.createVariableLookupItem(info.prefixFromForwards, var, null, true, prefix, true));
                    continue;
                }
                result.addElement(SASSSCSSLangUtil.createVariableLookupItem(info.prefixFromForwards, var, info.qualifier, true, prefix, false));
            }
        }
    }

    private static void addVarsForQualifier(@NotNull CompletionResultSet result, @NotNull PsiElement position, @NotNull String qualifier) {
        PsiElement resolve;
        SassScssUseAtRule useAtRule;
        if (result == null) {
            VariableNamesProvider.$$$reportNull$$$0(5);
        }
        if (position == null) {
            VariableNamesProvider.$$$reportNull$$$0(6);
        }
        if (qualifier == null) {
            VariableNamesProvider.$$$reportNull$$$0(7);
        }
        PsiFile[] files = (useAtRule = (SassScssUseAtRule)PsiTreeUtil.getParentOfType((PsiElement)(resolve = SassScssQualifierReference.resolve(position, qualifier)), SassScssUseAtRule.class)) != null ? useAtRule.resolveTargetFiles() : PsiFile.EMPTY_ARRAY;
        HashSet<PsiFile> visited = new HashSet<PsiFile>();
        visited.add(position.getContainingFile().getOriginalFile());
        for (PsiFile file : files) {
            if (!(file instanceof SassScssStylesheetFile)) continue;
            for (SassScssVariableDeclaration var : ((SassScssStylesheetFile)file).getTopLevelDeclarations(SassScssVariableDeclaration.class)) {
                String name = var.getName();
                if (name.isEmpty() || name.startsWith("-") || name.startsWith("_")) continue;
                result.addElement(SASSSCSSLangUtil.createVariableLookupItem(null, var, null, true, result.getPrefixMatcher().getPrefix(), false));
            }
        }
        for (PsiFile file : files) {
            if (!(file instanceof SassScssStylesheetFile)) continue;
            SASSSCSSLangUtil.processForwardsAndImports((SassScssStylesheetFile)file, "", visited, (PairConsumer<SassScssStylesheetFile, String>)((PairConsumer)(forwardedFile, prefix) -> {
                for (SassScssVariableDeclaration var : forwardedFile.getTopLevelDeclarations(SassScssVariableDeclaration.class)) {
                    String name = var.getName();
                    if (name.isEmpty() || name.startsWith("-") || name.startsWith("_")) continue;
                    result.addElement(SASSSCSSLangUtil.createVariableLookupItem(prefix, var, null, true, result.getPrefixMatcher().getPrefix(), false));
                }
            }));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/sass/completion/VariableNamesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addQualifiedVars";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addVarsForQualifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

