/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.notifications;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.codegen.autoImport.GeneratedCodeProcessor;
import com.intellij.swagger.core.model.remote.RemoteSpecificationModel;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.notifications.SwaggerNotifications;
import com.intellij.swagger.core.remote.RemoteSpecificationNotificationAction;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u00020\u00072\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J#\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0016J%\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001bJ+\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b!J.\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0014H\u0002J0\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020\u000e2\b\u0010(\u001a\u0004\u0018\u00010)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\t0+H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/swagger/core/notifications/SwaggerNotifications;", "", "<init>", "()V", "SWAGGER_DEFAULT_NOTIFICATIONS_GROUP", "Lcom/intellij/notification/NotificationGroup;", "myActiveNotification", "Lcom/intellij/notification/Notification;", "show", "", "project", "Lcom/intellij/openapi/project/Project;", "createNotification", "title", "", "content", "notificationType", "Lcom/intellij/notification/NotificationType;", "notifySuccessfulSpecificationsLoading", "processedSpecifications", "", "Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "notifySuccessfulSpecificationsLoading$intellij_swagger_core", "notifyFailedSpecificationsLoading", "successfullyLoadedCount", "", "requestedToLoad", "notifyFailedSpecificationsLoading$intellij_swagger_core", "notifySuccessfulGenerationWithOptions", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "importers", "Lcom/intellij/swagger/core/codegen/autoImport/GeneratedCodeProcessor;", "notifySuccessfulGenerationWithOptions$intellij_swagger_core", "showImportTargetChoosePopup", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "wrapToAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentableName", "icon", "Ljavax/swing/Icon;", "block", "Lkotlin/Function1;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerNotifications.kt\ncom/intellij/swagger/core/notifications/SwaggerNotifications\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1557#2:152\n1628#2,3:153\n1863#2,2:156\n*S KotlinDebug\n*F\n+ 1 SwaggerNotifications.kt\ncom/intellij/swagger/core/notifications/SwaggerNotifications\n*L\n53#1:152\n53#1:153,3\n59#1:156,2\n*E\n"})
public final class SwaggerNotifications {
    @NotNull
    public static final SwaggerNotifications INSTANCE = new SwaggerNotifications();
    @NotNull
    private static final NotificationGroup SWAGGER_DEFAULT_NOTIFICATIONS_GROUP;
    @Nullable
    private static Notification myActiveNotification;

    private SwaggerNotifications() {
    }

    private final void show(Notification $this$show, Project project) {
        Notification notification = myActiveNotification;
        if (notification != null) {
            notification.expire();
        }
        myActiveNotification = $this$show;
        $this$show.notify(project);
    }

    private final Notification createNotification(@NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String content, NotificationType notificationType) {
        return SWAGGER_DEFAULT_NOTIFICATIONS_GROUP.createNotification(title, content, notificationType);
    }

    /*
     * WARNING - void declaration
     */
    public final void notifySuccessfulSpecificationsLoading$intellij_swagger_core(@NotNull List<? extends SwSpecificationFile> processedSpecifications, @NotNull Project project) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Notification notification;
        Intrinsics.checkNotNullParameter(processedSpecifications, (String)"processedSpecifications");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Notification notification2 = notification = this.createNotification(SwaggerBundle.message("notifications.openapi.specifications.title", new Object[0]), SwaggerBundle.message("notifications.remote.specification.downloaded.successfully", new Object[0]), NotificationType.INFORMATION);
        SwaggerNotifications swaggerNotifications = this;
        boolean bl = false;
        Iterable iterable = RemoteSpecificationNotificationAction.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RemoteSpecificationNotificationAction remoteSpecificationNotificationAction = (RemoteSpecificationNotificationAction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(NotificationAction.createSimpleExpiring((String)it.getActionName(), () -> SwaggerNotifications.notifySuccessfulSpecificationsLoading$lambda$3$lambda$1$lambda$0((RemoteSpecificationNotificationAction)it, project, processedSpecifications)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$notifySuccessfulSpecificationsLoading_u24lambda_u243;
            NotificationAction it = (NotificationAction)element$iv;
            boolean bl3 = false;
            $this$notifySuccessfulSpecificationsLoading_u24lambda_u243.addAction((AnAction)it);
        }
        swaggerNotifications.show(notification, project);
    }

    public final void notifyFailedSpecificationsLoading$intellij_swagger_core(int successfullyLoadedCount, int requestedToLoad, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = new Object[]{requestedToLoad - successfullyLoadedCount, requestedToLoad};
        Notification notification = this.createNotification(SwaggerBundle.message("notifications.openapi.specifications.title", new Object[0]), SwaggerBundle.message("notifications.remote.specification.error.description", object), NotificationType.WARNING);
        object = SwaggerBundle.message("notifications.remote.specification.try.reload", new Object[0]);
        Icon icon = AllIcons.Actions.Refresh;
        notification.addAction(new AnAction(project, (String)object, icon){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RemoteSpecificationModel.fetchCachedRemoteSpecifications$default(RemoteSpecificationModel.Companion.getInstance(this.$project), false, false, 2, null);
            }
        });
        this.show(notification, project);
    }

    public final void notifySuccessfulGenerationWithOptions$intellij_swagger_core(@NotNull VirtualFile virtualFile, @NotNull List<? extends GeneratedCodeProcessor> importers, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(importers, (String)"importers");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Notification notification = this.createNotification(SwaggerBundle.message("notifications.openapi.specifications.title", new Object[0]), SwaggerBundle.message("notifications.codegen.success", new Object[0]), NotificationType.INFORMATION);
        Object[] objectArray = SwaggerBundle.message("actions.open.generated.file.title", new Object[0]);
        Object[] objectArray2 = AllIcons.Actions.EditSource;
        notification.addAction(new AnAction(project, virtualFile, (String)objectArray, (Icon)objectArray2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (ProjectFileIndex.getInstance((Project)this.$project).isInContent(this.$virtualFile)) {
                    new OpenFileDescriptor(this.$project, this.$virtualFile).navigate(true);
                } else {
                    RevealFileAction.openFile((File)VfsUtil.virtualToIoFile((VirtualFile)this.$virtualFile));
                }
            }
        });
        if (!((Collection)importers).isEmpty()) {
            if (importers.size() == 1) {
                GeneratedCodeProcessor processor = (GeneratedCodeProcessor)CollectionsKt.single(importers);
                objectArray2 = new Object[]{processor.getPresentableName()};
                v0 = notification.addAction(this.wrapToAction(SwaggerBundle.message("actions.import.to.0.model.title", objectArray2), AllIcons.General.Add, (Function1<? super AnActionEvent, Unit>)((Function1)arg_0 -> SwaggerNotifications.notifySuccessfulGenerationWithOptions$lambda$4(processor, virtualFile, project, arg_0))));
            } else {
                objectArray = new Object[]{".."};
                v0 = notification.addAction(this.wrapToAction(SwaggerBundle.message("actions.import.to.0.model.title", objectArray), AllIcons.General.Add, (Function1<? super AnActionEvent, Unit>)((Function1)arg_0 -> SwaggerNotifications.notifySuccessfulGenerationWithOptions$lambda$5(virtualFile, project, importers, arg_0))));
            }
        }
        this.show(notification, project);
    }

    private final void showImportTargetChoosePopup(AnActionEvent e, VirtualFile virtualFile, Project project, List<? extends GeneratedCodeProcessor> importers) {
        ApplicationManager.getApplication().invokeLater(() -> SwaggerNotifications.showImportTargetChoosePopup$lambda$6(e, importers, virtualFile, project));
    }

    private final AnAction wrapToAction(@NlsActions.ActionText String presentableName, Icon icon, Function1<? super AnActionEvent, Unit> block) {
        return new AnAction(presentableName, icon, block){
            final /* synthetic */ Function1<AnActionEvent, Unit> $block;
            {
                this.$block = $block;
                super($presentableName, null, $icon);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$block.invoke((Object)e);
            }
        };
    }

    private static final void notifySuccessfulSpecificationsLoading$lambda$3$lambda$1$lambda$0(RemoteSpecificationNotificationAction $it, Project $project, List $processedSpecifications) {
        $it.actionPerformed($project, $processedSpecifications);
    }

    private static final Unit notifySuccessfulGenerationWithOptions$lambda$4(GeneratedCodeProcessor $processor, VirtualFile $virtualFile, Project $project, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $processor.importToProject($virtualFile, $project);
        return Unit.INSTANCE;
    }

    private static final Unit notifySuccessfulGenerationWithOptions$lambda$5(VirtualFile $virtualFile, Project $project, List $importers, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.showImportTargetChoosePopup(it, $virtualFile, $project, $importers);
        return Unit.INSTANCE;
    }

    private static final void showImportTargetChoosePopup$lambda$6(AnActionEvent $e, List $importers, VirtualFile $virtualFile, Project $project) {
        JBPopupFactory.getInstance().createActionGroupPopup(null, new ActionGroup($importers, $virtualFile, $project){
            final /* synthetic */ List<GeneratedCodeProcessor> $importers;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Project $project;
            {
                this.$importers = $importers;
                this.$virtualFile = $virtualFile;
                this.$project = $project;
            }

            /*
             * WARNING - void declaration
             */
            public AnAction[] getChildren(AnActionEvent e) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$importers;
                VirtualFile virtualFile = this.$virtualFile;
                Project project = this.$project;
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void importer;
                    GeneratedCodeProcessor generatedCodeProcessor = (GeneratedCodeProcessor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(SwaggerNotifications.access$wrapToAction(SwaggerNotifications.INSTANCE, importer.getPresentableName(), null, arg_0 -> showImportTargetChoosePopup.1.1.getChildren$lambda$1$lambda$0((GeneratedCodeProcessor)importer, virtualFile, project, arg_0)));
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new AnAction[0]);
            }

            private static final Unit getChildren$lambda$1$lambda$0(GeneratedCodeProcessor $importer, VirtualFile $virtualFile, Project $project, AnActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $importer.importToProject($virtualFile, $project);
                return Unit.INSTANCE;
            }
        }, $e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showInBestPositionFor($e.getDataContext());
    }

    public static final /* synthetic */ AnAction access$wrapToAction(SwaggerNotifications $this, String presentableName, Icon icon, Function1 block) {
        return $this.wrapToAction(presentableName, icon, (Function1<? super AnActionEvent, Unit>)block);
    }

    static {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("OpenAPI Specifications");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        SWAGGER_DEFAULT_NOTIFICATIONS_GROUP = notificationGroup;
    }
}

