/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util.classFinder;

import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.List;
import java.util.regex.Pattern;

public interface ClassFilter {
    public boolean shouldInclude(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PatternFilter
    implements ClassFilter {
        private final List<Pattern> myIncludePatterns;
        private final List<Pattern> myExcludePatterns;

        /*
         * WARNING - void declaration
         */
        public PatternFilter(List<Pattern> includePatterns, List<Pattern> excludePatterns) {
            void var2_2;
            void var1_1;
            this.myIncludePatterns = var1_1;
            this.myExcludePatterns = var2_2;
        }

        @Override
        public boolean shouldInclude(String className) {
            String string;
            if (ClassNameUtil.matchesPatterns(className, this.myExcludePatterns)) {
                return false;
            }
            if (ClassNameUtil.matchesPatterns(string = ClassNameUtil.getOuterClassName(string), this.myIncludePatterns)) {
                return true;
            }
            return this.myIncludePatterns.isEmpty();
        }
    }
}

