/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.serialization.ClassUtil;
import com.intellij.util.ReflectionAssignabilityCache;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VisitorDescription;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.APP})
public final class DomApplicationComponent {
    private final MultiMap<String, DomFileMetaData> myRootTagName2FileDescription = MultiMap.createSet();
    private final Set<DomFileMetaData> myAcceptingOtherRootTagNamesDescriptions = new HashSet<DomFileMetaData>();
    private final ImplementationClassCache myCachedImplementationClasses = new ImplementationClassCache(DomImplementationClassEP.EP_NAME);
    private final TypeChooserManager myTypeChooserManager = new TypeChooserManager();
    final ReflectionAssignabilityCache assignabilityCache = new ReflectionAssignabilityCache();
    private final Map<Class<?>, DomElementsAnnotator> classToAnnotator = new ConcurrentHashMap();
    private final Map<Class<?>, DomFileDescription<?>> classToDescription = new ConcurrentHashMap();
    private final Map<Class<?>, InvocationCache> myInvocationCaches = CollectionFactory.createConcurrentSoftValueMap();
    private final Map<Class<? extends DomElementVisitor>, VisitorDescription> myVisitorDescriptions = new ConcurrentHashMap<Class<? extends DomElementVisitor>, VisitorDescription>();

    public DomApplicationComponent() {
        this.registerDescriptions();
        DomApplicationComponent.addChangeListener(DomFileDescription.EP_NAME, this::extensionsChanged);
        DomApplicationComponent.addChangeListener(DomFileMetaData.EP_NAME, this::extensionsChanged);
        DomApplicationComponent.addChangeListener(DomImplementationClassEP.EP_NAME, this::extensionsChanged);
    }

    private static <T> void addChangeListener(ExtensionPointName<T> ep, Runnable onChange) {
        Application app = ApplicationManager.getApplication();
        if (app.isDisposed()) {
            return;
        }
        ep.addChangeListener(onChange, (Disposable)app);
    }

    private void registerDescriptions() {
        for (DomFileDescription description : DomFileDescription.EP_NAME.getExtensionList()) {
            this.registerFileDescription(description);
        }
        for (DomFileMetaData meta : DomFileMetaData.EP_NAME.getExtensionList()) {
            this.registerFileDescription(meta);
        }
    }

    private synchronized void extensionsChanged() {
        this.myRootTagName2FileDescription.clear();
        this.myAcceptingOtherRootTagNamesDescriptions.clear();
        this.classToAnnotator.clear();
        this.classToDescription.clear();
        this.myCachedImplementationClasses.clearCache();
        this.myTypeChooserManager.clearCache();
        this.myInvocationCaches.clear();
        this.assignabilityCache.clear();
        this.myVisitorDescriptions.clear();
        this.registerDescriptions();
    }

    public static DomApplicationComponent getInstance() {
        return (DomApplicationComponent)ApplicationManager.getApplication().getService(DomApplicationComponent.class);
    }

    public synchronized int getCumulativeVersion(boolean forStubs) {
        return this.allMetas().mapToInt(meta -> {
            if (forStubs) {
                if (meta.stubVersion != null) {
                    return meta.stubVersion + StringUtil.notNullize((String)meta.rootTagName).hashCode();
                }
            } else {
                return meta.domVersion + StringUtil.notNullize((String)meta.rootTagName).hashCode();
            }
            return 0;
        }).sum();
    }

    @NotNull
    private Stream<DomFileMetaData> allMetas() {
        Stream<DomFileMetaData> stream = Stream.concat(this.myRootTagName2FileDescription.values().stream(), this.myAcceptingOtherRootTagNamesDescriptions.stream());
        if (stream == null) {
            DomApplicationComponent.$$$reportNull$$$0(0);
        }
        return stream;
    }

    @NotNull
    public synchronized List<DomFileMetaData> getStubBuildingMetadata() {
        List<DomFileMetaData> list2 = this.allMetas().filter(m -> m.hasStubs()).collect(Collectors.toList());
        if (list2 == null) {
            DomApplicationComponent.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    public synchronized DomFileMetaData findMeta(DomFileDescription<?> description) {
        return this.allMetas().filter(m -> m.lazyInstance == description).findFirst().orElse(null);
    }

    public synchronized @Unmodifiable Set<DomFileDescription<?>> getFileDescriptions(String rootTagName) {
        return ContainerUtil.map2Set((Collection)this.myRootTagName2FileDescription.get((Object)rootTagName), DomFileMetaData::getDescription);
    }

    public synchronized @Unmodifiable Set<DomFileDescription<?>> getAcceptingOtherRootTagNameDescriptions() {
        return ContainerUtil.map2Set(this.myAcceptingOtherRootTagNamesDescriptions, DomFileMetaData::getDescription);
    }

    @Nullable
    public DomFileDescription<?> findDescription(XmlFile file) {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        Condition condition = d -> d.isMyFile(file, module);
        String rootTagLocalName = DomService.getInstance().getXmlFileHeader(file).getRootTagLocalName();
        DomFileDescription description = (DomFileDescription)ContainerUtil.find(this.getFileDescriptions(rootTagLocalName), (Condition)condition);
        return description != null ? description : (DomFileDescription)ContainerUtil.find(this.getAcceptingOtherRootTagNameDescriptions(), (Condition)condition);
    }

    synchronized void registerFileDescription(DomFileDescription<?> description) {
        this.registerFileDescription(new DomFileMetaData(description));
        this.initDescription(description);
    }

    void registerFileDescription(@NotNull DomFileMetaData meta) {
        if (meta == null) {
            DomApplicationComponent.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)meta.rootTagName)) {
            this.myAcceptingOtherRootTagNamesDescriptions.add(meta);
        } else {
            this.myRootTagName2FileDescription.putValue((Object)meta.rootTagName, (Object)meta);
        }
    }

    void initDescription(@NotNull DomFileDescription<?> description) {
        if (description == null) {
            DomApplicationComponent.$$$reportNull$$$0(3);
        }
        for (Map.Entry entry : description.getImplementations().entrySet()) {
            this.registerImplementation((Class)entry.getKey(), (Class)entry.getValue(), null);
        }
        this.myTypeChooserManager.copyFrom(description.getTypeChooserManager());
    }

    synchronized void removeDescription(DomFileDescription<?> description) {
        DomFileMetaData meta = this.findMeta(description);
        this.myRootTagName2FileDescription.get((Object)description.getRootTagName()).remove(meta);
        this.myAcceptingOtherRootTagNamesDescriptions.remove(meta);
    }

    @Nullable
    public synchronized DomFileDescription<?> findFileDescription(@NotNull Class<?> rootElementClass) {
        if (rootElementClass == null) {
            DomApplicationComponent.$$$reportNull$$$0(4);
        }
        return this.classToDescription.computeIfAbsent(rootElementClass, this::_findFileDescription);
    }

    @Nullable
    private synchronized DomFileDescription<?> _findFileDescription(Class<?> rootElementClass) {
        return this.allMetas().map(meta -> meta.getDescription()).filter(description -> description.getRootElementClass() == rootElementClass).findAny().orElse(null);
    }

    public DomElementsAnnotator getAnnotator(@NotNull Class<?> rootElementClass) {
        if (rootElementClass == null) {
            DomApplicationComponent.$$$reportNull$$$0(5);
        }
        return this.classToAnnotator.computeIfAbsent(rootElementClass, key -> {
            DomFileDescription<?> desc = this.findFileDescription((Class<?>)key);
            return desc == null ? null : desc.createAnnotator();
        });
    }

    @Nullable
    Class<? extends DomElement> getImplementation(Class<?> concreteInterface) {
        return this.myCachedImplementationClasses.get(concreteInterface);
    }

    public void registerImplementation(Class<? extends DomElement> domElementClass, Class<? extends DomElement> implementationClass, @Nullable Disposable parentDisposable) {
        this.myCachedImplementationClasses.registerImplementation(domElementClass, implementationClass, parentDisposable);
    }

    TypeChooserManager getTypeChooserManager() {
        return this.myTypeChooserManager;
    }

    public StaticGenericInfo getStaticGenericInfo(Type type) {
        return this.getInvocationCache(ClassUtil.getRawType((Type)type)).genericInfo;
    }

    InvocationCache getInvocationCache(Class<?> type) {
        return this.myInvocationCaches.computeIfAbsent(type, InvocationCache::new);
    }

    public VisitorDescription getVisitorDescription(Class<? extends DomElementVisitor> aClass) {
        return this.myVisitorDescriptions.computeIfAbsent(aClass, VisitorDescription::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomApplicationComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "allMetas";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubBuildingMetadata";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomApplicationComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerFileDescription";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initDescription";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFileDescription";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

