/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceUtils;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.ui.cellsDnD.EditorCellDragAssistant;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001#BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001a\u001a\u00020\u000bH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0002J\u0006\u0010\u001d\u001a\u00020\u000bJ\f\u0010\u001e\u001a\u00060\u001fR\u00020\u0000H\u0002J\b\u0010 \u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "draggableAdapter", "Lcom/intellij/notebooks/visualization/ui/cellsDnD/EditorCellDragAssistant;", "yAndHeightSupplier", "Lkotlin/Function0;", "Lkotlin/Pair;", "", "toggleListener", "", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/cellsDnD/EditorCellDragAssistant;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "panel", "Ljavax/swing/JComponent;", "value", "", "visible", "getVisible", "()Z", "setVisible", "(Z)V", "selected", "getSelected", "setSelected", "registerListeners", "dispose", "removePanel", "updateBounds", "createFoldingBar", "Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar$EditorCellFoldingBarComponent;", "updateBarColor", "getBarColor", "Ljava/awt/Color;", "EditorCellFoldingBarComponent", "intellij.notebooks.visualization"})
@ApiStatus.Internal
public final class EditorCellFoldingBar
implements Disposable {
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private final EditorCellDragAssistant draggableAdapter;
    @NotNull
    private final Function0<Pair<Integer, Integer>> yAndHeightSupplier;
    @NotNull
    private final Function0<Unit> toggleListener;
    @Nullable
    private JComponent panel;
    private boolean selected;

    public EditorCellFoldingBar(@NotNull EditorImpl editor, @Nullable EditorCellDragAssistant draggableAdapter, @NotNull Function0<Pair<Integer, Integer>> yAndHeightSupplier, @NotNull Function0<Unit> toggleListener) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(yAndHeightSupplier, (String)"yAndHeightSupplier");
        Intrinsics.checkNotNullParameter(toggleListener, (String)"toggleListener");
        this.editor = editor;
        this.draggableAdapter = draggableAdapter;
        this.yAndHeightSupplier = yAndHeightSupplier;
        this.toggleListener = toggleListener;
        this.registerListeners();
    }

    public final boolean getVisible() {
        JComponent jComponent = this.panel;
        return jComponent != null ? jComponent.isVisible() : false;
    }

    public final void setVisible(boolean value) {
        if (this.getVisible() == value) {
            return;
        }
        if (!NotebookEditorAppearanceUtils.INSTANCE.isOrdinaryNotebookEditor((Editor)this.editor)) {
            return;
        }
        if (value) {
            EditorCellFoldingBarComponent panel = this.createFoldingBar();
            this.editor.getGutterComponentEx().add((Component)panel);
            this.panel = panel;
            this.updateBounds();
        } else {
            this.removePanel();
        }
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean value) {
        block1: {
            if (this.selected == value) break block1;
            this.selected = value;
            JComponent jComponent = this.panel;
            if (jComponent != null) {
                jComponent.setBackground(this.getBarColor());
            }
        }
    }

    private final void registerListeners() {
        JupyterBoundsChangeHandler.Companion.get((Editor)this.editor).subscribe(this, new JupyterBoundsChangeListener(this){
            final /* synthetic */ EditorCellFoldingBar $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void boundsChanged() {
                this.$tmp0.updateBounds();
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(0, (Object)this.$tmp0, EditorCellFoldingBar.class, "updateBounds", "updateBounds()V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof JupyterBoundsChangeListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellStripeSelectedColor().afterChange((Disposable)this, arg_0 -> EditorCellFoldingBar.registerListeners$lambda$0(this, arg_0));
        NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellStripeHoveredColor().afterChange((Disposable)this, arg_0 -> EditorCellFoldingBar.registerListeners$lambda$1(this, arg_0));
    }

    public void dispose() {
        this.removePanel();
    }

    private final void removePanel() {
        block0: {
            EditorGutterComponentEx editorGutterComponentEx;
            JComponent jComponent = this.panel;
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            EditorGutterComponentEx $this$removePanel_u24lambda_u243_u24lambda_u242 = editorGutterComponentEx = this.editor.getGutterComponentEx();
            boolean bl2 = false;
            $this$removePanel_u24lambda_u243_u24lambda_u242.remove((Component)it);
            $this$removePanel_u24lambda_u243_u24lambda_u242.repaint();
            this.panel = null;
        }
    }

    public final void updateBounds() {
        JComponent jComponent = this.panel;
        if (jComponent == null) {
            return;
        }
        JComponent panel = jComponent;
        Pair yAndHeight = (Pair)this.yAndHeightSupplier.invoke();
        panel.setBounds(this.editor.getGutterComponentEx().getAnnotationsAreaOffset() - 2, ((Number)yAndHeight.getFirst()).intValue(), 6, ((Number)yAndHeight.getSecond()).intValue());
    }

    private final EditorCellFoldingBarComponent createFoldingBar() {
        EditorCellFoldingBarComponent editorCellFoldingBarComponent;
        EditorCellFoldingBarComponent $this$createFoldingBar_u24lambda_u244 = editorCellFoldingBarComponent = new EditorCellFoldingBarComponent();
        boolean bl = false;
        $this$createFoldingBar_u24lambda_u244.setBackground(this.getBarColor());
        return editorCellFoldingBarComponent;
    }

    private final void updateBarColor() {
        block0: {
            JComponent jComponent = this.panel;
            if (jComponent == null) break block0;
            jComponent.setBackground(this.getBarColor());
        }
    }

    private final Color getBarColor() {
        return this.selected ? (Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellStripeSelectedColor().get() : (Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellStripeHoveredColor().get();
    }

    private static final Unit registerListeners$lambda$0(EditorCellFoldingBar this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateBarColor();
        return Unit.INSTANCE;
    }

    private static final Unit registerListeners$lambda$1(EditorCellFoldingBar this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateBarColor();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar$EditorCellFoldingBarComponent;", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar;)V", "mouseOver", "", "paint", "", "g", "Ljava/awt/Graphics;", "rect", "Ljava/awt/Rectangle;", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nEditorCellFoldingBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellFoldingBar.kt\ncom/intellij/notebooks/visualization/ui/EditorCellFoldingBar$EditorCellFoldingBarComponent\n+ 2 NotebookVisualizationUiUtil.kt\ncom/intellij/notebooks/visualization/NotebookVisualizationUiUtilKt\n*L\n1#1,177:1\n21#2,6:178\n*S KotlinDebug\n*F\n+ 1 EditorCellFoldingBar.kt\ncom/intellij/notebooks/visualization/ui/EditorCellFoldingBar$EditorCellFoldingBarComponent\n*L\n147#1:178,6\n*E\n"})
    public final class EditorCellFoldingBarComponent
    extends JComponent {
        private boolean mouseOver;

        public EditorCellFoldingBarComponent() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    mouseOver = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    mouseOver = false;
                    this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (!SwingUtilities.isLeftMouseButton(e)) break block1;
                        EditorCellDragAssistant editorCellDragAssistant = EditorCellFoldingBar.this.draggableAdapter;
                        if (editorCellDragAssistant != null) {
                            editorCellDragAssistant.initDrag(e);
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (!SwingUtilities.isLeftMouseButton(e)) break block1;
                        EditorCellDragAssistant editorCellDragAssistant = EditorCellFoldingBar.this.draggableAdapter;
                        if (editorCellDragAssistant != null) {
                            editorCellDragAssistant.finishDrag(e);
                        }
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (EditorCellFoldingBar.this.draggableAdapter == null) {
                        EditorCellFoldingBar.this.toggleListener.invoke();
                    } else if (!EditorCellFoldingBar.this.draggableAdapter.isDragging()) {
                        EditorCellFoldingBar.this.toggleListener.invoke();
                    }
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        EditorCellDragAssistant editorCellDragAssistant = EditorCellFoldingBar.this.draggableAdapter;
                        if (editorCellDragAssistant == null) break block0;
                        editorCellDragAssistant.updateDragOperation(e);
                    }
                }
            });
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Rectangle rect = this.rect();
            Double arc = ExperimentalUI.Companion.isNewUI() ? Double.valueOf(rect.width) : null;
            Graphics $this$use$iv = g.create();
            boolean $i$f$use = false;
            try {
                Graphics g2 = $this$use$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)g2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D cfr_ignored_0 = (Graphics2D)g2;
                ((Graphics2D)g2).setColor(this.getBackground());
                RectanglePainter2D.FILL.paint((Graphics2D)g2, (Rectangle2D)rect, arc, LinePainter2D.StrokeType.INSIDE, 1.0, RenderingHints.VALUE_ANTIALIAS_ON);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$use$iv.dispose();
            }
        }

        private final Rectangle rect() {
            Dimension size = this.getSize();
            int width = size.width;
            int height = size.height;
            return this.mouseOver ? new Rectangle(0, 0, width, height) : new Rectangle(1, 1, width - 2, height - 2);
        }
    }
}

