/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.core.statistics;

import com.intellij.dataWrangler.core.statistics.HistogramUnit;
import com.intellij.dataWrangler.core.statistics.model.CoreStatisticsDataTransformationUtilsKt;
import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualisationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.api.CountKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\u001a\u0017\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a<\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u00132\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0000\u00a8\u0006\u0017"}, d2={"getVisualizationType", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnVisualisationType;", "col", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "formatDouble", "", "x", "", "(Ljava/lang/Double;)Ljava/lang/String;", "computeHistogram", "", "Lcom/intellij/dataWrangler/core/statistics/HistogramUnit;", "data", "nBins", "", "kTypeToPythonDataFrame", "kType", "Lkotlin/reflect/KType;", "getValuesNeededFormat", "", "type", "xList", "yList", "intellij.dataWrangler.core"})
@SourceDebugExtension(value={"SMAP\nCoreStatisticsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreStatisticsUtils.kt\ncom/intellij/dataWrangler/core/statistics/CoreStatisticsUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1863#2,2:117\n1557#2:119\n1628#2,3:120\n1557#2:123\n1628#2,3:124\n1557#2:127\n1628#2,3:128\n*S KotlinDebug\n*F\n+ 1 CoreStatisticsUtils.kt\ncom/intellij/dataWrangler/core/statistics/CoreStatisticsUtilsKt\n*L\n60#1:117,2\n101#1:119\n101#1:120,3\n112#1:123\n112#1:124,3\n97#1:127\n97#1:128,3\n*E\n"})
public final class CoreStatisticsUtilsKt {
    @NotNull
    public static final ColumnVisualisationType getVisualizationType(@NotNull DataColumn<?> col2) {
        Intrinsics.checkNotNullParameter(col2, (String)"col");
        if (CoreStatisticsDataTransformationUtilsKt.isSubTypeOfNumber(DataColumnKt.getType(col2))) {
            return ColumnVisualisationType.HISTOGRAM;
        }
        double totalCount = CountKt.count$default(col2, null, 1, null);
        double totalDistinct = col2.countDistinct();
        double ratioUnique = totalDistinct / totalCount;
        if (totalDistinct <= 3.0 || ratioUnique * (double)100 <= 50.0) {
            return ColumnVisualisationType.PERCENTAGE;
        }
        return ColumnVisualisationType.UNIQUE;
    }

    @NotNull
    public static final String formatDouble(@Nullable Double x) {
        String string;
        if (x == null) {
            return "NaN";
        }
        if (((Object)(x % 1.0)).equals(0.0)) {
            string = String.valueOf((int)x.doubleValue());
        } else {
            Locale locale = Locale.US;
            String string2 = "%.1f";
            Object[] objectArray = new Object[]{x};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        }
        return string;
    }

    @NotNull
    public static final List<HistogramUnit> computeHistogram(@NotNull List<Double> data2, int nBins) {
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        if (data2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        double maxValue = CollectionsKt.maxOrThrow((Iterable)data2);
        double minValue = CollectionsKt.minOrThrow((Iterable)data2);
        double binWidth = (maxValue - minValue) / (double)nBins;
        int[] histogram = new int[nBins];
        Iterable $this$forEach$iv = data2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double point = ((Number)element$iv).doubleValue();
            boolean bl = false;
            int bin = RangesKt.coerceIn((int)((int)((point - minValue) / binWidth)), (int)0, (int)(nBins - 1));
            int n = histogram[bin];
            histogram[bin] = n + 1;
        }
        List list = new ArrayList();
        for (int i = 0; i < nBins; ++i) {
            list.add(new HistogramUnit((Pair<Double, Double>)new Pair((Object)(minValue + binWidth * (double)i), (Object)(minValue + binWidth * (double)(i + 1))), histogram[i]));
        }
        return list;
    }

    public static /* synthetic */ List computeHistogram$default(List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        return CoreStatisticsUtilsKt.computeHistogram(list, n);
    }

    @NotNull
    public static final String kTypeToPythonDataFrame(@NotNull KType kType) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Integer.TYPE), (Object)"int64"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), (Object)"int64"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Float.TYPE), (Object)"float64"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Double.TYPE), (Object)"float64"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(String.class), (Object)"object"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE), (Object)"bool")};
        Map typeMapping = MapsKt.mapOf((Pair[])pairArray);
        KClassifier kClassifier = kType.getClassifier();
        KClass classifier = kClassifier instanceof KClass ? (KClass)kClassifier : null;
        String string = (String)typeMapping.get(classifier);
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<?>> getValuesNeededFormat(@NotNull String type, @NotNull List<String> xList, @NotNull List<Integer> yList) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(xList, (String)"xList");
        Intrinsics.checkNotNullParameter(yList, (String)"yList");
        Iterable $this$map$iv = CoreStatisticsUtilsKt.getValuesNeededFormat$normalizeList(yList);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it == 0.0 ? 0.05 : (it < 0.08 ? 0.08 : it));
        }
        List barHeights = (List)destination$iv$iv;
        Pair[] $i$f$map22 = new Pair[]{TuplesKt.to((Object)"x", xList), TuplesKt.to((Object)"xLabel", xList), TuplesKt.to((Object)"yLabel", yList), TuplesKt.to((Object)"y", (Object)barHeights)};
        Map data2 = MapsKt.mutableMapOf((Pair[])$i$f$map22);
        if (StringsKt.startsWith$default((String)type, (String)"bool", (boolean)false, (int)2, null)) {
            void $this$mapTo$iv$iv2;
            int sum2 = CollectionsKt.sumOfInt((Iterable)yList);
            Iterable $this$map$iv2 = yList;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add((int)((double)it * 100.0 / (double)sum2));
            }
            List percentageList = (List)destination$iv$iv2;
            data2.put("percentage", percentageList);
        }
        return data2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Double> getValuesNeededFormat$normalizeList(List<Integer> listOfBarHeights) {
        void $this$mapTo$iv$iv;
        int maxValuesCountInBars = ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)listOfBarHeights))).intValue();
        Iterable $this$map$iv = listOfBarHeights;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)it / (double)maxValuesCountInBars);
        }
        return (List)destination$iv$iv;
    }
}

