/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.adapters;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.adapters.PuppetAbstractLibrarianAdapter;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.settings.PuppetProjectConfiguration;
import com.intellij.lang.puppet.settings.configurable.PuppetConfigurable;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetLibrarianAdapter
extends PuppetAbstractLibrarianAdapter {
    private static final Logger LOG = Logger.getInstance(PuppetLibrarianAdapter.class);

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            PuppetLibrarianAdapter.$$$reportNull$$$0(0);
        }
        return logger;
    }

    @Override
    protected void installDependencies(@NotNull PuppetEntity puppetEntity, @NotNull ProgressIndicator indicator) {
        if (puppetEntity == null) {
            PuppetLibrarianAdapter.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            PuppetLibrarianAdapter.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            final Project project = puppetEntity.getProject();
            if (project.isDisposed()) {
                return;
            }
            VirtualFile entityRoot = puppetEntity.getRoot();
            if (!entityRoot.isValid()) {
                return;
            }
            List<String> librarianArguments = this.createLibrarianArguments(puppetEntity);
            if (librarianArguments == null) {
                return;
            }
            GeneralCommandLine commandLine = new GeneralCommandLine(ArrayUtilRt.toStringArray(librarianArguments)).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(entityRoot.getCanonicalPath());
            this.configureEnvironment(commandLine.getEnvironment());
            boolean shouldExcludeLibrarianDir = PuppetLibrarianAdapter.getLibrarianInternalDir(entityRoot) == null;
            try {
                KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine){

                    protected void notifyProcessTerminated(int exitCode) {
                        RunContentDescriptor contentDescriptor = RunContentManager.getInstance((Project)project).findContentDescriptor(DefaultRunExecutor.getRunExecutorInstance(), (ProcessHandler)this);
                        if (contentDescriptor != null && contentDescriptor.getExecutionConsole() instanceof ConsoleView) {
                            ((ConsoleView)contentDescriptor.getExecutionConsole()).print("\n" + IdeCoreBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode}) + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                        }
                        super.notifyProcessTerminated(exitCode);
                    }
                };
                RunContentExecutor contentExecutor = new RunContentExecutor(project, (ProcessHandler)processHandler).withTitle(PuppetBundle.message("puppet.installing.dependencies", puppetEntity.getDescriptiveName(), puppetEntity.getName())).withFocusToolWindow(false).withAfterCompletion(() -> this.doPostInstallationWork(puppetEntity, () -> {
                    VirtualFile librarianInternalDir;
                    if (shouldExcludeLibrarianDir && (librarianInternalDir = PuppetLibrarianAdapter.getLibrarianInternalDir(entityRoot)) != null) {
                        PuppetLibrarianAdapter.excludeVirtualFile(project, librarianInternalDir);
                    }
                }));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!project.isDisposed() && entityRoot.isValid()) {
                        contentExecutor.run();
                    }
                });
            }
            catch (ExecutionException e) {
                ExecutionHelper.showErrors((Project)project, Collections.singletonList(e), (String)PuppetBundle.message("puppet.error.running.librarian", new Object[0]), null);
            }
        });
    }

    @Nullable
    protected List<String> createLibrarianArguments(@NotNull PuppetEntity entity) {
        Project project;
        String librarianPath;
        if (entity == null) {
            PuppetLibrarianAdapter.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(librarianPath = PuppetProjectConfiguration.getInstance(project = entity.getProject()).getLibrarianPath()))) {
            Notification notification = new Notification("PUPPET_CONFIGURATION_ERROR", PuppetBundle.message("puppet.error.librarian.not.configured.title", new Object[0]), PuppetBundle.message("puppet.error.librarian.not.configured.message", new Object[0]), NotificationType.ERROR);
            notification.addAction((AnAction)new DumbAwareAction(PuppetBundle.message("puppet.error.librarian.not.configured.action.configure", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PuppetConfigurable(project));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/puppet/adapters/PuppetLibrarianAdapter$2", "actionPerformed"));
                }
            });
            Notifications.Bus.notify((Notification)notification);
            return null;
        }
        List<String> parentArguments = super.createLibrarianArguments(entity);
        assert (parentArguments != null);
        ArrayList<String> arguments = new ArrayList<String>(parentArguments);
        arguments.add(0, librarianPath);
        return arguments;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/adapters/PuppetLibrarianAdapter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "puppetEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/adapters/PuppetLibrarianAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLibrarianArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

