/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add.v1;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.newProject.collector.InterpreterStatisticsInfo;
import com.jetbrains.python.pathValidation.PlatformAndRoot;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.configuration.PyProjectVirtualEnvConfiguration;
import com.jetbrains.python.statistics.InterpreterTarget;
import com.jetbrains.python.statistics.InterpreterType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010+\u001a\u00020,H\u0014J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0007H\u0016J\n\u0010/\u001a\u0004\u0018\u00010\bH\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\u0010\u00102\u001a\u00020,2\u0006\u00103\u001a\u000204H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u00105\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b68BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0011\u00a8\u00068"}, d2={"Lcom/jetbrains/python/sdk/add/v1/PyAddNewVirtualEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/util/UserDataHolder;)V", "envName", "getEnvName", "()Ljava/lang/String;", "value", "getNewProjectPath", "setNewProjectPath", "(Ljava/lang/String;)V", "path", "getPath", "panelName", "getPanelName", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "baseSdkField", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getBaseSdkField", "()Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getPathField", "()Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "inheritSitePackagesField", "Lcom/intellij/ui/components/JBCheckBox;", "getInheritSitePackagesField", "()Lcom/intellij/ui/components/JBCheckBox;", "makeSharedField", "layoutComponents", "", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "getOrCreateSdk", "getStatisticInfo", "Lcom/jetbrains/python/newProject/collector/InterpreterStatisticsInfo;", "addChangeListener", "listener", "Ljava/lang/Runnable;", "projectBasePath", "Lorg/jetbrains/annotations/SystemIndependent;", "getProjectBasePath", "intellij.python.community.impl"})
public class PyAddNewVirtualEnvPanel
extends PyAddNewEnvPanel {
    @Nullable
    private final Project project;
    @Nullable
    private final Module module;
    @NotNull
    private final List<Sdk> existingSdks;
    @NotNull
    private final UserDataHolder context;
    @NotNull
    private final String envName;
    @Nullable
    private String newProjectPath;
    @NotNull
    private final Icon icon;
    @NotNull
    private final PySdkPathChoosingComboBox baseSdkField;
    @NotNull
    private final TextFieldWithBrowseButton pathField;
    @NotNull
    private final JBCheckBox inheritSitePackagesField;
    @NotNull
    private final JBCheckBox makeSharedField;

    /*
     * WARNING - void declaration
     */
    public PyAddNewVirtualEnvPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @NotNull UserDataHolder context) {
        void $this$pathField_u24lambda_u240;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(null, 1, null);
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        this.context = context;
        this.envName = "Virtualenv";
        this.newProjectPath = newProjectPath;
        Icon icon = PythonIcons.Python.Virtualenv;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Virtualenv");
        this.icon = icon;
        this.baseSdkField = new PySdkPathChoosingComboBox(null, null, null, null, 15, null);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        PyAddNewVirtualEnvPanel pyAddNewVirtualEnvPanel = this;
        boolean bl = false;
        $this$pathField_u24lambda_u240.setText(FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(this.getProjectBasePath())));
        $this$pathField_u24lambda_u240.addBrowseFolderListener(this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(PySdkBundle.message("python.venv.location.chooser", new Object[0])));
        pyAddNewVirtualEnvPanel.pathField = textFieldWithBrowseButton;
        this.inheritSitePackagesField = new JBCheckBox(PyBundle.message("sdk.create.venv.dialog.label.inherit.global.site.packages", new Object[0]));
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        this.layoutComponents();
        PyAddSdkPanelKt.addBaseInterpretersAsync$default(this.baseSdkField, this.existingSdks, this.module, this.context, null, 16, null);
    }

    @Override
    @NotNull
    public String getEnvName() {
        return this.envName;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String value) {
        this.newProjectPath = value;
        this.pathField.setText(FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(this.getProjectBasePath())));
    }

    @NotNull
    public final String getPath() {
        String string = this.pathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.new.environment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected final PySdkPathChoosingComboBox getBaseSdkField() {
        return this.baseSdkField;
    }

    @NotNull
    protected final TextFieldWithBrowseButton getPathField() {
        return this.pathField;
    }

    @NotNull
    public final JBCheckBox getInheritSitePackagesField() {
        return this.inheritSitePackagesField;
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent(PySdkBundle.message("python.venv.location.label", new Object[0]), (JComponent)this.pathField).addLabeledComponent(PySdkBundle.message("python.venv.base.label", new Object[0]), (JComponent)((Object)this.baseSdkField)).addComponent((JComponent)this.inheritSitePackagesField).addComponent((JComponent)this.makeSharedField).getPanel();
        this.add((Component)formPanel, "North");
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        Object[] objectArray = new ValidationInfo[]{PyAddSdkPanel.Companion.validateEnvironmentDirectoryLocation(this.pathField, PlatformAndRoot.Companion.getLocal()), PyAddSdkPanel.Companion.validateSdkComboBox(this.baseSdkField, this)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk2 = this.baseSdkField.getSelectedSdk();
        String string = this.pathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return PyProjectVirtualEnvConfiguration.createVirtualEnvSynchronously$default(sdk2, this.existingSdks, string, this.getNewProjectPath(), this.project, this.module, this.context, this.inheritSitePackagesField.isSelected(), this.makeSharedField.isSelected(), null, 512, null);
    }

    @Override
    @Nullable
    public InterpreterStatisticsInfo getStatisticInfo() {
        return new InterpreterStatisticsInfo(InterpreterType.VIRTUALENV, InterpreterTarget.LOCAL, this.inheritSitePackagesField.isSelected(), this.makeSharedField.isSelected(), false, false, null, 96, null);
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.pathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(listener2){
            final /* synthetic */ Runnable $listener;
            {
                this.$listener = $listener;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.run();
            }
        });
        ((ComboBoxWithWidePopup)this.baseSdkField.getChildComponent()).addItemListener(arg_0 -> PyAddNewVirtualEnvPanel.addChangeListener$lambda$1(listener2, arg_0));
    }

    private final String getProjectBasePath() {
        String string = this.getNewProjectPath();
        if (string == null) {
            Module module = this.module;
            string = module != null ? BasePySdkExtKt.getBasePath(module) : null;
            if (string == null) {
                Project project = this.project;
                string = project != null ? project.getBasePath() : null;
            }
        }
        return string;
    }

    private static final void addChangeListener$lambda$1(Runnable $listener, ItemEvent it) {
        $listener.run();
    }
}

