/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.IGlobalVariable;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class GlobalAsgnNode
extends AssignableNode
implements IGlobalVariable {
    private String name;

    public GlobalAsgnNode(SourcePosition position, String name, Node valueNode) {
        super(position, valueNode);
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        this.name = name;
    }

    public boolean isSame(Node other) {
        return super.isSame(other) && this.isNameMatch(((GlobalAsgnNode)other).getName());
    }

    public NodeType getNodeType() {
        return NodeType.GLOBALASGNNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitGlobalAsgnNode(this);
    }

    public String getLexicalName() {
        return "$" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    public SourcePosition getNamePosition() {
        return this.getLexicalNamePosition().fromEnd(this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getPosition().fromBeginning(this.getLexicalName().length());
    }
}

