/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ImmutableImage;
import javax.microedition.lcdui.MutableImage;

public class Image {
    int width;
    int height;
    private byte[] data;

    Image() {
    }

    public static Image createImage(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        return new MutableImage(width, height);
    }

    public static Image createImage(Image source) {
        return new ImmutableImage(source);
    }

    public static Image createImage(String name) throws IOException {
        try {
            return new ImmutableImage(name);
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
    }

    public static Image createImage(byte[] imageData, int imageOffset, int imageLength) {
        if (imageOffset < 0 || imageOffset >= imageData.length || imageLength < 0 || imageOffset + imageLength > imageData.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new ImmutableImage(imageData, imageOffset, imageLength);
    }

    public Graphics getGraphics() {
        throw new IllegalStateException();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isMutable() {
        return false;
    }
}

