/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.EDT;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeInstalledPackageFinder {
    private static final Logger LOG = Logger.getInstance(NodeInstalledPackageFinder.class);
    private final Project myProject;
    private final VirtualFile myPackageJson;
    private final List<VirtualFile> myNodeModulesDirs;

    public NodeInstalledPackageFinder(@NotNull Project project, @NotNull VirtualFile initialLocation) {
        if (project == null) {
            NodeInstalledPackageFinder.$$$reportNull$$$0(0);
        }
        if (initialLocation == null) {
            NodeInstalledPackageFinder.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        VirtualFile initialDir = initialLocation.isDirectory() ? initialLocation : initialLocation.getParent();
        this.myPackageJson = PackageJsonUtil.findChildPackageJsonFile(initialDir);
        this.myNodeModulesDirs = new ArrayList<VirtualFile>();
        ReadAction.run(() -> {
            if (project.isDisposed()) {
                return;
            }
            NodeModuleSearchUtil.processUpNodeModulesDirs(project, initialLocation, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
                this.myNodeModulesDirs.add((VirtualFile)nodeModulesDir);
                return true;
            }));
        });
    }

    @Nullable
    public InstalledPackageVersion findInstalledPackage(@NotNull String packageName) {
        VirtualFile packageDir;
        InstalledPackageVersion version2;
        if (packageName == null) {
            NodeInstalledPackageFinder.$$$reportNull$$$0(2);
        }
        if (packageName.startsWith("node:") || packageName.startsWith("bun:")) {
            return null;
        }
        YarnPnpManager yarnPnpManager = YarnPnpManager.getInstance(this.myProject);
        if (this.myPackageJson != null && yarnPnpManager.isUnderPnp(this.myPackageJson) && (version2 = this.createVersion(packageDir = yarnPnpManager.findInstalledPackageDir(this.myPackageJson, packageName))) != null) {
            return version2;
        }
        for (VirtualFile nodeModulesDir : this.myNodeModulesDirs) {
            VirtualFile packageDir2 = nodeModulesDir.findFileByRelativePath(packageName);
            InstalledPackageVersion version3 = this.createVersion(packageDir2);
            if (version3 == null) continue;
            return version3;
        }
        return null;
    }

    @Nullable
    private InstalledPackageVersion createVersion(@Nullable VirtualFile packageDir) {
        if (packageDir != null && packageDir.isDirectory()) {
            VirtualFile packageJson = NodeInstalledPackageFinder.findPackageJson(packageDir);
            return new InstalledPackageVersion(packageDir, packageJson, () -> {
                SemVer version2 = this.fetchPackageVersion(packageDir, packageJson);
                if (version2 == null) {
                    LOG.info("Cannot fetch version of the installed package " + packageDir.getPath() + " (package.json: " + (packageJson != null));
                }
                return version2;
            });
        }
        return null;
    }

    @Nullable
    private static VirtualFile findPackageJson(@NotNull VirtualFile packageDir) {
        VirtualFile packageJson;
        if (packageDir == null) {
            NodeInstalledPackageFinder.$$$reportNull$$$0(3);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile(packageDir)) == null && NodeInstalledPackageFinder.canRefreshSync()) {
            packageJson = VfsUtil.refreshAndFindChild((VirtualFile)packageDir, (String)"package.json");
        }
        return packageJson;
    }

    @Nullable
    private SemVer fetchPackageVersion(@NotNull VirtualFile packageDir, @Nullable VirtualFile packageJson) {
        if (packageDir == null) {
            NodeInstalledPackageFinder.$$$reportNull$$$0(4);
        }
        Path nioPackageDir = null;
        try {
            nioPackageDir = packageDir.toNioPath();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (nioPackageDir != null) {
            SemVer nioVersion = NodePackageVersionUtil.getPackageVersion(nioPackageDir);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetched nio version " + String.valueOf(nioVersion) + " from " + String.valueOf(nioPackageDir));
            }
            return nioVersion;
        }
        if (packageJson == null) {
            return null;
        }
        boolean refreshedByWatcher = this.isRefreshedByFileWatcher(packageJson);
        if (!refreshedByWatcher) {
            VfsUtil.markDirtyAndRefresh((!NodeInstalledPackageFinder.canRefreshSync() ? 1 : 0) != 0, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{packageJson});
        }
        SemVer version2 = PackageJsonData.getOrCreate(packageJson).getVersion();
        if (LOG.isDebugEnabled()) {
            String refreshMsg = refreshedByWatcher ? "file_watcher" : (NodeInstalledPackageFinder.canRefreshSync() ? "sync" : "async");
            LOG.debug("(refreshed: " + refreshMsg + ") Fetched vfs version " + String.valueOf(version2) + " from " + packageJson.getPath());
        }
        return version2;
    }

    private boolean isRefreshedByFileWatcher(@NotNull VirtualFile file) {
        VirtualFileSystemEntry entry;
        if (file == null) {
            NodeInstalledPackageFinder.$$$reportNull$$$0(5);
        }
        if ((entry = (VirtualFileSystemEntry)ObjectUtils.tryCast((Object)file, VirtualFileSystemEntry.class)) == null) {
            return false;
        }
        if (entry.thisOrParentHaveSymlink()) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        return (Boolean)ReadAction.compute(() -> fileIndex.getContentRootForFile(file, false) != null);
    }

    private static boolean canRefreshSync() {
        return !ApplicationManager.getApplication().isReadAccessAllowed() && !EDT.isCurrentThreadEdt();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialLocation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NodeInstalledPackageFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findInstalledPackage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findPackageJson";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchPackageVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRefreshedByFileWatcher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

