/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoNameUtils;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmTaskTreeView;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonBuildFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class NpmScriptsService
extends JsbtService {
    private static final Logger LOG = Logger.getInstance(NpmScriptsService.class);
    private static final Key<CachedValue<NpmScriptsStructure>> STRUCTURE_KEY = Key.create((String)NpmScriptsService.class.getName());

    public NpmScriptsService(@NotNull Project project) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @NotNull
    public static NpmScriptsService getInstance(@NotNull Project project) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(1);
        }
        NpmScriptsService npmScriptsService = (NpmScriptsService)project.getService(NpmScriptsService.class);
        if (npmScriptsService == null) {
            NpmScriptsService.$$$reportNull$$$0(2);
        }
        return npmScriptsService;
    }

    @Override
    @NotNull
    public JsbtApplicationService getApplicationService() {
        NpmScriptsApplicationService npmScriptsApplicationService = NpmScriptsApplicationService.getInstance();
        if (npmScriptsApplicationService == null) {
            NpmScriptsService.$$$reportNull$$$0(3);
        }
        return npmScriptsApplicationService;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager() {
        PackageJsonBuildFileManager packageJsonBuildFileManager = PackageJsonBuildFileManager.getInstance(this.myProject);
        if (packageJsonBuildFileManager == null) {
            NpmScriptsService.$$$reportNull$$$0(4);
        }
        return packageJsonBuildFileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager() {
        return new JsbtToolWindowManager(this.myProject, "npm", JavaScriptLanguageIcons.BuildTools.Npm.Npm_13, "reference.tool.window.npm", this);
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@Nullable String layoutPlace) {
        return new NpmTaskTreeView(this, this.myProject, layoutPlace);
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles() {
        if (DumbService.isDumb((Project)this.myProject)) {
            List<VirtualFile> list = this.detectAllBuildfilesInContentRoots(false, false);
            if (list == null) {
                NpmScriptsService.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = (List)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return Collections.emptyList();
            }
            GlobalSearchScope scope2 = JSLibraryUtil.getContentScopeWithoutLibraries((Project)this.myProject);
            Collection files = FilenameIndex.getVirtualFilesByName((String)"package.json", (GlobalSearchScope)scope2);
            return new ArrayList(files);
        });
        if (list == null) {
            NpmScriptsService.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(boolean webModulesOnly, boolean filterOutEmptyBuildfiles) {
        SmartList buildfiles = new SmartList();
        JsbtUtil.iterateOverContentRoots(this.myProject, webModulesOnly, (Consumer<? super VirtualFile>)((Consumer)arg_0 -> this.lambda$detectAllBuildfilesInContentRoots$1(filterOutEmptyBuildfiles, (List)buildfiles, arg_0)));
        SmartList smartList = buildfiles;
        if (smartList == null) {
            NpmScriptsService.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static boolean hasScripts(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(8);
        }
        if (packageJson == null) {
            NpmScriptsService.$$$reportNull$$$0(9);
        }
        try {
            NpmScriptsStructure structure = NpmScriptsUtil.listTasks(project, packageJson);
            return !structure.getTaskNames().isEmpty();
        }
        catch (JsbtTaskFetchException jsbtTaskFetchException) {
            return false;
        }
    }

    @Override
    public boolean isBuildfile(@NotNull VirtualFile file) {
        if (file == null) {
            NpmScriptsService.$$$reportNull$$$0(10);
        }
        return PackageJsonCommonUtil.isPackageJsonFile((VirtualFile)file);
    }

    @Override
    @Nullable
    public VirtualFile findBuildfileInDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            NpmScriptsService.$$$reportNull$$$0(11);
        }
        return PackageJsonUtil.findChildPackageJsonFile(dir);
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            NpmScriptsService.$$$reportNull$$$0(12);
        }
        return new NpmScriptsStructure(buildfile);
    }

    @Override
    @NotNull
    public NpmScriptsStructure fetchBuildfileStructure(@NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        if (packageJson == null) {
            NpmScriptsService.$$$reportNull$$$0(13);
        }
        NpmScriptsStructure npmScriptsStructure = (NpmScriptsStructure)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                throw JsbtTaskFetchException.newGenericException(packageJson, String.valueOf(this.myProject) + " is disposed already");
            }
            if (!packageJson.isValid()) {
                throw JsbtTaskFetchException.newBuildfileSyntaxError(packageJson);
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(packageJson);
            if (psiFile == null) {
                throw JsbtTaskFetchException.newGenericException(packageJson, "Cannot find PSI file");
            }
            return (NpmScriptsStructure)CachedValuesManager.getCachedValue((PsiElement)psiFile, STRUCTURE_KEY, () -> {
                NpmScriptsStructure value;
                try {
                    value = NpmScriptsUtil.listTasks(this.myProject, packageJson);
                }
                catch (JsbtTaskFetchException ignored) {
                    value = new NpmScriptsStructure(packageJson);
                }
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{psiFile});
            });
        });
        if (npmScriptsStructure == null) {
            NpmScriptsService.$$$reportNull$$$0(14);
        }
        return npmScriptsStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        NpmConfigurationType npmConfigurationType = NpmConfigurationType.getInstance();
        if (npmConfigurationType == null) {
            NpmScriptsService.$$$reportNull$$$0(15);
        }
        return npmConfigurationType;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            NpmScriptsService.$$$reportNull$$$0(16);
        }
        if (patternObject == null) {
            NpmScriptsService.$$$reportNull$$$0(17);
        }
        if (runConfiguration instanceof NpmRunConfiguration) {
            NpmRunSettings runSettings = ((NpmRunConfiguration)runConfiguration).getRunSettings();
            NodePackageRef preferredNpmPackageRef = NpmScriptsApplicationService.getInstance().myPreferredNpmPackageRef;
            if (preferredNpmPackageRef != null && !preferredNpmPackageRef.equals(runSettings.getPackageManagerPackageRef())) {
                return false;
            }
            if (patternObject instanceof NpmRunSettings) {
                NpmRunSettings patternRunSettings = (NpmRunSettings)patternObject;
                return patternRunSettings.getCommand() == runSettings.getCommand() && JsbtUtil.equalsOrderless(patternRunSettings.getScriptNames(), runSettings.getScriptNames()) && patternRunSettings.getPackageJsonSystemIndependentPath().equals(runSettings.getPackageJsonSystemIndependentPath()) && patternRunSettings.getArguments().equals(runSettings.getArguments());
            }
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                return runSettings.getCommand() == NpmCommand.RUN_SCRIPT && JsbtUtil.equalsOrderless(patternTaskSet.getTaskNames(), runSettings.getScriptNames()) && patternTaskSet.getStructure().getBuildfile().getPath().equals(runSettings.getPackageJsonSystemIndependentPath()) && patternTaskSet.getArguments().equals(runSettings.getArguments());
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            NpmScriptsService.$$$reportNull$$$0(18);
        }
        if (taskSet == null) {
            NpmScriptsService.$$$reportNull$$$0(19);
        }
        NpmScriptsStructure structure = (NpmScriptsStructure)taskSet.getStructure();
        NpmRunConfiguration npmRunConfiguration = (NpmRunConfiguration)runConfiguration;
        NpmRunSettings.Builder builder2 = npmRunConfiguration.getRunSettings().toBuilder().setPackageJsonPath(structure.getBuildfile().getPath()).setCommand(NpmCommand.RUN_SCRIPT).setScriptNames(taskSet.getTaskNames()).setArguments(taskSet.getArguments());
        NodePackageRef preferredNpmPackageRef = NpmScriptsApplicationService.getInstance().myPreferredNpmPackageRef;
        if (preferredNpmPackageRef != null) {
            builder2.setPackageManagerPackageRef(preferredNpmPackageRef);
        }
        NpmRunSettings merged = builder2.build();
        NpmRunConfigurationProducer.setupConfigurationFromSettings(npmRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@Nullable VirtualFile contextBuildfile) {
        this.editConfigurations();
        return true;
    }

    private /* synthetic */ void lambda$detectAllBuildfilesInContentRoots$1(boolean filterOutEmptyBuildfiles, List buildfiles, VirtualFile contentRoot) {
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(contentRoot);
        LOG.info("Found package.json in " + contentRoot.getPath() + ": " + String.valueOf(packageJson));
        if (packageJson != null && (!filterOutEmptyBuildfiles || NpmScriptsService.hasScripts(this.myProject, packageJson))) {
            buildfiles.add(packageJson);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternObject";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchBuildfileStructure";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasScripts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isBuildfile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findBuildfileInDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyFileStructure";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fetchBuildfileStructure";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationMatched";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 14, 15 -> new IllegalStateException(string);
        };
    }

    public static final class NpmScriptsApplicationService
    extends JsbtApplicationService {
        private NodePackageRef myPreferredNpmPackageRef;

        private NpmScriptsApplicationService() {
        }

        @Override
        @NotNull
        public NpmScriptsService getProjectService(@NotNull Project project) {
            if (project == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(0);
            }
            NpmScriptsService npmScriptsService = NpmScriptsService.getInstance(project);
            if (npmScriptsService == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(1);
            }
            return npmScriptsService;
        }

        @NotNull
        public static NpmScriptsApplicationService getInstance() {
            NpmScriptsApplicationService npmScriptsApplicationService = (NpmScriptsApplicationService)EP_NAME.findExtensionOrFail(NpmScriptsApplicationService.class);
            if (npmScriptsApplicationService == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(2);
            }
            return npmScriptsApplicationService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runWithPreferredNpmPackage(@NotNull NodePackageRef preferredNpmPackageRef, @NotNull Runnable runnable) {
            if (preferredNpmPackageRef == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(3);
            }
            if (runnable == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(4);
            }
            NodePackageRef prevPreferredNpmPackage = this.myPreferredNpmPackageRef;
            this.myPreferredNpmPackageRef = preferredNpmPackageRef;
            try {
                runnable.run();
            }
            finally {
                this.myPreferredNpmPackageRef = prevPreferredNpmPackage;
            }
        }

        @Override
        @NotNull
        @NlsSafe
        public String getName() {
            return "npm";
        }

        @Override
        @NotNull
        public String getShowTasksActionName() {
            String string = JavaScriptBundle.message((String)"buildTools.JsbtShowTasksAction.npm.text", (Object[])new Object[0]);
            if (string == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        public String getSearchEverywhereDescription(@NotNull Project project, @NotNull JsbtTaskSet taskSet) {
            if (project == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(6);
            }
            if (taskSet == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(7);
            }
            String baseName = "'" + taskSet.getName() + "'";
            String contextName = JSMonorepoNameUtils.buildContextName(project, taskSet.getStructure().getBuildfile(), baseName);
            String string = JavaScriptBundle.message((String)"buildTools.searchEverywhere.npm.text", (Object[])new Object[]{contextName});
            if (string == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @NotNull
        public String getReloadTasksActionName() {
            String string = JavaScriptBundle.message((String)"buildTools.JsbtReloadTasksAction.npm.text", (Object[])new Object[0]);
            if (string == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Override
        @NotNull
        public String getToolWindowSettingsActionName() {
            String string = JavaScriptBundle.message((String)"buildTools.ShowSettingsAction.npm.text", (Object[])new Object[0]);
            if (string == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
            if (icon == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(11);
            }
            return icon;
        }

        @Override
        @NotNull
        public String getBuildfileCommonName() {
            return "package.json";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 5, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService$NpmScriptsApplicationService";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferredNpmPackageRef";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService$NpmScriptsApplicationService";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectService";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShowTasksActionName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchEverywhereDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReloadTasksActionName";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowSettingsActionName";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getProjectService";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "runWithPreferredNpmPackage";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getSearchEverywhereDescription";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 5, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }
}

