/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.indexing;

import com.intellij.jpa.jpb.model.backend.ed.indexing.EntityRegisterFileIndex;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntityRegisterSearch;
import com.intellij.jpa.jpb.model.backend.ed.indexing.JpaEntityRegisterFileIndex;
import com.intellij.jpa.jpb.model.util.JavaPersistence;
import com.intellij.jpa.jpb.model.util.XmlHelper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashSet;

public final class EntityRegisterSearchImpl
implements EntityRegisterSearch {
    private static final Logger LOGGER = Logger.getInstance(EntityRegisterSearchImpl.class);
    private final FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
    private final Project project;

    public EntityRegisterSearchImpl(Project project) {
        this.project = project;
    }

    @Override
    public void findPersistenceRecords(PsiClass entityClass, GlobalSearchScope scope, Processor<XmlTag> processor) {
        ReadAction.run(() -> {
            try {
                String fqn = entityClass.getQualifiedName();
                if (fqn == null) {
                    return;
                }
                String key = EntityRegisterFileIndex.getPersistenceKey(fqn);
                this.processClasses(key, scope, (Processor<XmlTag>)((Processor)tag -> {
                    if (fqn.equals(tag.getValue().getText())) {
                        return processor.process(tag);
                    }
                    return true;
                }));
            }
            catch (IndexNotReadyException e) {
                LOGGER.warn("IndexNotReady on EntityRegisterSearchImpl.findPersistenceRecords");
            }
        });
    }

    @Override
    public void getAllConfigs(GlobalSearchScope scope, Processor<XmlFile> processor) {
        ReadAction.run(() -> {
            try {
                HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
                Collection allKeys = this.fileBasedIndex.getAllKeys(JpaEntityRegisterFileIndex.NAME, this.project);
                PsiManager psiManager = PsiManager.getInstance((Project)this.project);
                for (String key : allKeys) {
                    Collection files = this.fileBasedIndex.getContainingFiles(JpaEntityRegisterFileIndex.NAME, (Object)key, scope);
                    for (VirtualFile file : files) {
                        boolean more;
                        XmlFile xmlFile;
                        PsiFile psiFile;
                        if (!file.isValid() || !processed.add(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile) || !EntityRegisterSearchImpl.isPersistence(xmlFile = (XmlFile)psiFile) || (more = processor.process((Object)xmlFile))) continue;
                        return;
                    }
                }
            }
            catch (IndexNotReadyException e) {
                LOGGER.warn("IndexNotReady on EntityRegisterSearchImpl.getAllConfigs");
            }
        });
    }

    public static boolean isPersistence(XmlFile xmlFile) {
        return JavaPersistence.PERSISTENCE_NAMESPACES.contains(XmlHelper.getNamespace(xmlFile));
    }

    private static boolean processFile(XmlFile xmlFile, Processor<XmlTag> processor) {
        XmlTag rootTag = xmlFile.getRootTag();
        if (rootTag == null) {
            return true;
        }
        String configElementTagName = "persistence-unit";
        XmlTag configTag = rootTag.findFirstSubTag(configElementTagName);
        if (configTag == null) {
            return true;
        }
        for (XmlTag classTag : configTag.findSubTags("class")) {
            if (processor.process((Object)classTag)) continue;
            return false;
        }
        return true;
    }

    private void processClasses(String key, GlobalSearchScope scope, Processor<XmlTag> processor) {
        Collection files = this.fileBasedIndex.getContainingFiles(JpaEntityRegisterFileIndex.NAME, (Object)key, scope);
        HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
        for (VirtualFile file : files) {
            boolean more;
            XmlFile configFile;
            PsiManager psiManager;
            PsiFile psiFile;
            if (!file.isValid() || !processed.add(file) || !((psiFile = (psiManager = PsiManager.getInstance((Project)this.project)).findFile(file)) instanceof XmlFile) || !EntityRegisterSearchImpl.isPersistence(configFile = (XmlFile)psiFile) || (more = EntityRegisterSearchImpl.processFile(configFile, processor))) continue;
            return;
        }
    }
}

