/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 54310308925012L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(447472980 - 20122, -447472980 - -11148, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(447472980 - 20121, -447472980 - -7247, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 1405772171767L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.F();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1317908850 - 24663, -1317908850 - -12846, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1317908850 - 24664, -1317908850 - -25271, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1317908850 - 24661, -1317908850 - -((char)-25388), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 126664780407881L;
                Object object = this.lock;
                String[] stringArray = SshAgentIpcService.F();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1899859650 + 11744, 1899859650 + 4509, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1899859650 + 11743, -1899859650 + -9735, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1899859650 + 11742, 1899859650 - 2342, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1899859650 + 11757, -1899859650 + -592, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1899859650 + 11756, 1899859650 + 23258, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1899859650 + 11755, -1899859650 + -13301, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1899859650 + 11757, -1899859650 + -592, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1899859650 + 11754, -1899859650 + -15495, (int)l2));
            if (ActionTimestamp.F() != null) {
                SshAgentIpcService.F(new String[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 24512198789917L;
                    stringArray = SshAgentIpcService.F();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block27: {
            block28: {
                l2 = 114253812390940L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                stringArray = SshAgentIpcService.F();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-907659750 - -20196, -907659750 - -((char)-16649), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-907659750 - -20192, 907659750 - 29483, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-907659750 - -20197, 907659750 - (char)-16621, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-907659750 - -20192, 907659750 - 29483, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-907659750 - -20194, -907659750 - -23924, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-907659750 - -20196, -907659750 - -((char)-16649), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-907659750 - -20192, 907659750 - 29483, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-907659750 - -20195, 907659750 - 29326, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-907659750 - -20196, -907659750 - -((char)-16649), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-907659750 - -20192, 907659750 - 29483, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-907659750 - -20168, 907659750 - (char)-16148, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-907659750 - -20192, 907659750 - 29483, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-907659750 - -20169, -907659750 - -((char)-30811), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-907659750 - -20192, 907659750 - 29483, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-907659750 - -20194, -907659750 - -23924, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-907659750 - -20196, -907659750 - -((char)-16649), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-907659750 - -20192, 907659750 - 29483, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-907659750 - -20166, 907659750 - 28403, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 33528576262711L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(2061600030 - (char)-15349, 2061600030 - (char)-25945, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 134155586683858L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-2011793430 - -18701, 2011793430 - 9888, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00a2\u00feKM\u00e6\u00f7F\u00cc\u00d7\u00dc\u00a3|gg\u00b1\u0095\u00feee\u0014\u00d5\u0093\u00a5\u00e6 @\u00e3\u00bf\u00e1\u00b4\u00a0\u00a5\u00c5\u00a5$F\u00a1\u00d9\u0089\u00b7";
                        var4_3 = "\u00a2\u00feKM\u00e6\u00f7F\u00cc\u00d7\u00dc\u00a3|gg\u00b1\u0095\u00feee\u0014\u00d5\u0093\u00a5\u00e6 @\u00e3\u00bf\u00e1\u00b4\u00a0\u00a5\u00c5\u00a5$F\u00a1\u00d9\u0089\u00b7".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 12;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 24;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 87;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 69;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 117;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 93;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 109;
                                        break;
                                    }
                                    default: {
                                        v11 = 106;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x324) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 134;
                            case 1 -> 216;
                            case 2 -> 1;
                            case 3 -> 43;
                            case 4 -> 203;
                            case 5 -> 107;
                            case 6 -> 34;
                            case 7 -> 178;
                            case 8 -> 17;
                            case 9 -> 147;
                            case 10 -> 217;
                            case 11 -> 23;
                            case 12 -> 3;
                            case 13 -> 251;
                            case 14 -> 21;
                            case 15 -> 106;
                            case 16 -> 112;
                            case 17 -> 119;
                            case 18 -> 49;
                            case 19 -> 55;
                            case 20 -> 196;
                            case 21 -> 186;
                            case 22 -> 0;
                            case 23 -> 86;
                            case 24 -> 25;
                            case 25 -> 239;
                            case 26 -> 36;
                            case 27 -> 97;
                            case 28 -> 60;
                            case 29 -> 20;
                            case 30 -> 205;
                            case 31 -> 254;
                            case 32 -> 74;
                            case 33 -> 209;
                            case 34 -> 152;
                            case 35 -> 246;
                            case 36 -> 22;
                            case 37 -> 128;
                            case 38 -> 32;
                            case 39 -> 52;
                            case 40 -> 50;
                            case 41 -> 189;
                            case 42 -> 154;
                            case 43 -> 207;
                            case 44 -> 146;
                            case 45 -> 54;
                            case 46 -> 66;
                            case 47 -> 116;
                            case 48 -> 163;
                            case 49 -> 143;
                            case 50 -> 10;
                            case 51 -> 13;
                            case 52 -> 148;
                            case 53 -> 61;
                            case 54 -> 109;
                            case 55 -> 169;
                            case 56 -> 93;
                            case 57 -> 92;
                            case 58 -> 162;
                            case 59 -> 115;
                            case 60 -> 228;
                            case 61 -> 133;
                            case 62 -> 95;
                            case 63 -> 192;
                            case 64 -> 213;
                            case 65 -> 201;
                            case 66 -> 76;
                            case 67 -> 159;
                            case 68 -> 132;
                            case 69 -> 69;
                            case 70 -> 240;
                            case 71 -> 145;
                            case 72 -> 211;
                            case 73 -> 80;
                            case 74 -> 100;
                            case 75 -> 89;
                            case 76 -> 79;
                            case 77 -> 156;
                            case 78 -> 70;
                            case 79 -> 84;
                            case 80 -> 141;
                            case 81 -> 183;
                            case 82 -> 129;
                            case 83 -> 58;
                            case 84 -> 243;
                            case 85 -> 12;
                            case 86 -> 81;
                            case 87 -> 28;
                            case 88 -> 164;
                            case 89 -> 90;
                            case 90 -> 38;
                            case 91 -> 62;
                            case 92 -> 2;
                            case 93 -> 238;
                            case 94 -> 110;
                            case 95 -> 64;
                            case 96 -> 59;
                            case 97 -> 219;
                            case 98 -> 177;
                            case 99 -> 91;
                            case 100 -> 173;
                            case 101 -> 120;
                            case 102 -> 9;
                            case 103 -> 19;
                            case 104 -> 215;
                            case 105 -> 208;
                            case 106 -> 195;
                            case 107 -> 72;
                            case 108 -> 30;
                            case 109 -> 142;
                            case 110 -> 200;
                            case 111 -> 140;
                            case 112 -> 184;
                            case 113 -> 212;
                            case 114 -> 194;
                            case 115 -> 123;
                            case 116 -> 255;
                            case 117 -> 167;
                            case 118 -> 108;
                            case 119 -> 242;
                            case 120 -> 98;
                            case 121 -> 85;
                            case 122 -> 188;
                            case 123 -> 57;
                            case 124 -> 29;
                            case 125 -> 6;
                            case 126 -> 150;
                            case 127 -> 210;
                            case 128 -> 117;
                            case 129 -> 202;
                            case 130 -> 253;
                            case 131 -> 27;
                            case 132 -> 232;
                            case 133 -> 220;
                            case 134 -> 65;
                            case 135 -> 224;
                            case 136 -> 191;
                            case 137 -> 248;
                            case 138 -> 101;
                            case 139 -> 46;
                            case 140 -> 190;
                            case 141 -> 227;
                            case 142 -> 172;
                            case 143 -> 82;
                            case 144 -> 5;
                            case 145 -> 33;
                            case 146 -> 244;
                            case 147 -> 193;
                            case 148 -> 121;
                            case 149 -> 87;
                            case 150 -> 68;
                            case 151 -> 88;
                            case 152 -> 125;
                            case 153 -> 47;
                            case 154 -> 236;
                            case 155 -> 41;
                            case 156 -> 225;
                            case 157 -> 241;
                            case 158 -> 139;
                            case 159 -> 198;
                            case 160 -> 176;
                            case 161 -> 165;
                            case 162 -> 83;
                            case 163 -> 127;
                            case 164 -> 137;
                            case 165 -> 122;
                            case 166 -> 138;
                            case 167 -> 53;
                            case 168 -> 223;
                            case 169 -> 171;
                            case 170 -> 180;
                            case 171 -> 187;
                            case 172 -> 130;
                            case 173 -> 144;
                            case 174 -> 237;
                            case 175 -> 8;
                            case 176 -> 249;
                            case 177 -> 181;
                            case 178 -> 113;
                            case 179 -> 199;
                            case 180 -> 155;
                            case 181 -> 42;
                            case 182 -> 104;
                            case 183 -> 40;
                            case 184 -> 206;
                            case 185 -> 204;
                            case 186 -> 18;
                            case 187 -> 16;
                            case 188 -> 67;
                            case 189 -> 233;
                            case 190 -> 226;
                            case 191 -> 24;
                            case 192 -> 75;
                            case 193 -> 245;
                            case 194 -> 44;
                            case 195 -> 37;
                            case 196 -> 77;
                            case 197 -> 11;
                            case 198 -> 179;
                            case 199 -> 45;
                            case 200 -> 73;
                            case 201 -> 160;
                            case 202 -> 158;
                            case 203 -> 15;
                            case 204 -> 175;
                            case 205 -> 124;
                            case 206 -> 214;
                            case 207 -> 250;
                            case 208 -> 94;
                            case 209 -> 247;
                            case 210 -> 51;
                            case 211 -> 126;
                            case 212 -> 111;
                            case 213 -> 157;
                            case 214 -> 222;
                            case 215 -> 166;
                            case 216 -> 63;
                            case 217 -> 114;
                            case 218 -> 26;
                            case 219 -> 229;
                            case 220 -> 136;
                            case 221 -> 235;
                            case 222 -> 170;
                            case 223 -> 96;
                            case 224 -> 78;
                            case 225 -> 131;
                            case 226 -> 221;
                            case 227 -> 35;
                            case 228 -> 218;
                            case 229 -> 56;
                            case 230 -> 135;
                            case 231 -> 185;
                            case 232 -> 102;
                            case 233 -> 105;
                            case 234 -> 234;
                            case 235 -> 153;
                            case 236 -> 99;
                            case 237 -> 149;
                            case 238 -> 31;
                            case 239 -> 48;
                            case 240 -> 252;
                            case 241 -> 182;
                            case 242 -> 197;
                            case 243 -> 161;
                            case 244 -> 118;
                            case 245 -> 168;
                            case 246 -> 151;
                            case 247 -> 71;
                            case 248 -> 231;
                            case 249 -> 14;
                            case 250 -> 174;
                            case 251 -> 39;
                            case 252 -> 4;
                            case 253 -> 230;
                            case 254 -> 7;
                            default -> 103;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (stringArray == null) {
                ActionTimestamp.F(new String[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 76792023309925L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.F();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1992001860 - -((char)-28725), -1991870790 + -((char)-174), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1992001860 - -((char)-28729), 1992001860 - (char)-19326, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1992001860 - -((char)-28708), 1992001860 - (char)-9233, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1992001860 - -((char)-28725), -1991870790 + -((char)-174), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1992001860 - -((char)-28729), 1992001860 - (char)-19326, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1992001860 - -((char)-28701), -1992001860 - -((char)-3076), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 113747013936275L;
                        String[] stringArray2 = SshAgentIpcService.F();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-899926620 - -18116, -899926620 - -18657, (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-899926620 - -18119, 899926620 - 16635, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 106183485160880L;
                String[] stringArray2 = SshAgentIpcService.F();
                this.assertConnectionThread();
                stringArray = stringArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27196), -991282410 + -26201, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27200), 991282410 + (char)-19923, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27187), 991282410 + 30501, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27200), 991282410 + (char)-19923, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27194), -991282410 + -((char)-30476), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27196), -991282410 + -26201, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27200), 991282410 + (char)-19923, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27184), -991282410 + -((char)-25749), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27196), -991282410 + -26201, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27200), 991282410 + (char)-19923, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27185), -991282410 + -((char)-19284), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27196), -991282410 + -26201, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27200), 991282410 + (char)-19923, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-991282410 + -((char)-27182), -991282410 + -((char)-31961), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 77492203508429L;
                    Object object = this.lock;
                    stringArray = SshAgentIpcService.F();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26255), -1891340100 + -((char)-2820), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26259), 1891471170 - (char)-18728, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26246), 1891340100 + (char)-822, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26239), 1891471170 - (char)-26432, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26255), -1891340100 + -((char)-2820), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26259), 1891471170 - (char)-18728, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26240), 1891471170 - (char)-26743, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26255), -1891340100 + -((char)-2820), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26259), 1891471170 - (char)-18728, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26241), 1891471170 - (char)-7757, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26255), -1891340100 + -((char)-2820), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26259), 1891471170 - (char)-18728, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26242), -1891471170 - -((char)-15312), (int)l2));
                    if (stringArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26255), -1891340100 + -((char)-2820), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26259), 1891471170 - (char)-18728, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26299), 1891471170 - (char)-15753, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1891471170 - -((char)-26300), 1891471170 - (char)-21215, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00bc\u0082\u00ddb\u00b7!\u00ae\u000b\u0014\u00c7J\u008a\u009c\u00a3v\u0083\u00fb\u001f\u00ce\u00ff\u00d6\u00f1%\u00ae\u00f4d]\u0092\u00ee\u0006P\u00c8@+nI\u0018\u0088\u0096\u00037\u0010\u00c6\u00f7-Yi8RoJ/\u009b\u00fd\u00d9\u008f\u00e3:\u001c23\t\u008b\u0013\u00fd6\u00a4yy\u0092\u00b4\u0005*\u001e\u000f\u00f1\u009d\b\u0097\u00f1\u00b8}I\u00e4wQ\u0014~\u00b8\u00c5Y'\u00c6&z\u00c5#\u000f\u00df\u00a5\u00a7\u009fIP9\u00ed \u0005\u0082;\u001aU?\u001e{j0\u001b\u00e7\u0087\u00ab\u007fw7\u00b6\u001e\u00f2\u00e3>\u00ca>b%`\u00c3C\u0001\u0015k\b7$\u00a2\u00d0\u0010\u00d9\u00e1\u0080\u00af\u00a6#u\u0012\u00d1(\u00ef\u0000\u00dfu4\u0087\t\u00e0\u008bF4\u0080\u001e\u00db\u00e1\u000e\u0010*\u000f\u00feri\u0098\u008ce\u00ee\u00c6\b\u00dd#\u00ce\u00ab\u00f0?\u0086\u00d4\u0087\u00cc\u001ctQmY\u00a46\u0097]$\u00f6\u000b\u00e2?\u00c3\u000e\u0091\u00dc0\u0080]R\u00fc\u00db\u00ecy^jK\u00d7W\u0090\u0093\u00bd\u0012\u00b6\b\u000b\u00c1\u00cf\u001d\u00c9M+}\u00f4\u0003\u00f4\u0019\u00c3[^\u00bb\u00b8cx\u00c0\u00e2\u00a9\b\u00feb\u0095\u000f\u00ec\u00aa\u00c3\u0098\fZX\u0011SaC\u009c\u00a2\u00c5v?\u00cfF$k\u00de5\u0098\u008f\u00a3;\"I\u00c9\u00ec4C\u00c4\u00c1X\u0001\u0094fi\u0083,Y\u00e8B\u00b9\u00d2\u00fbq\u0086Wl\u00c6q\u0093\u008d\u0090z\u00d7\u00962\u0099\u0013\u00c8\u00d7\u00a3\u0095G\u00db\"\u00bb\u00d2\u00bc4\u00aa\u00c9R\u00bb\u0099\u00e8\u00b7\u00f0\u0016\u00dd\"1\u00e7\u00c9\u00ab\u001f\u008b\u0090.D$l\u00d3\u0002x\u0098W\u00eb\u00ce@\u00b2\u000f\u00d42\u0005\u00a0\f\u00db/\u00ad\u00cf\u00cf\u00b4\u0010\u00cf\u00a7\u0002\u000bm\u00dd\u00f7\u00e3\u00bdU\u0007`\u00b6\"[\u0015t\u00ee\u00d4\u0086\u00de\u0091\u0087\u0085\u0098~V\u00fcP\u000e|\u0090\u00f6U\u009c5\t)\u00ea\u0018\u0002U\u00a1NcFn\u0010\u0095\u00fa\u0092h\u00a7\u000f)\u00baa\u0016puf`\u0089?\u00abv\u0003\u009f\u0019\u00b4a\u001f\u00b6%k[-\u0007\u00df\u0007\u00da_\u000e\u00a7\u0004ML\u0007\u00b9\u0001\u0006\u0000\u00e2V\u0086(\u00d9\u00d5(\u00cdT7+N\u0017\u00c6\u0090\u0016\u0011t\u0095\u000fh\u0017\u00e7\u00e0\u00c1\u0095?\u00b72yj\u00c5\f\u0089#o\u00dd\u000f\u00bf\u008a\u00f0\u00d3\u00cd\u00e5\u000fzx\u0012Q\u00fb\u00c8{rh\u00cc\u00de\u0006x\"&\"\u00c4<\u00c7\u00d1\u0019\u00detT\u008cR\u00c9\u00b2\u001am\u00d2al^C\u00c8\u00de\u00ae\u0013K\u00b4\u000e\u00c1\u008ej\u00b2\u0096\u0016\u00be\u00b8\u000e\u00015}\u00f8\u0016\u00fd\u00c6\u00d4\u00df\u0018(\u009c\u00aa{\u001b\u00d8\u00aaA\u000ej\u0096\u00dc\u00e5\u00cb\u00b9'\u00a9\u001b\u00eb\u00d4\u00a7\u0004,\u00f3\u001a\u00f3\u00c0\u00c5 %\u000e\u00a6\n\u0095!,x\u00d3\u00bc8\u008a\u00fc6\u0018\u000e\u0086\u009b\u00860;\u00b6\u000e\u0098\r\u008f\u00a0\u00b7\u0099\u00bd\u00c8^\u00c0o\u00fe\u0018\u0017\u00e3\u0089)D\u00d8\u00d7M\u001bM4&\u0084\u001c\u00c8{=Q\u00cdS\u001aD\u00d8\f}&\u008e\u0006\u00e1a;QB'\u008a26\u0011\u0089pR\u00d5\n\u00d6;\t\u00fa\u00e4\u0005\u00c7\u00e2\u00af\u00c1\u008c\u00f0";
                var4_3 = "\u00bc\u0082\u00ddb\u00b7!\u00ae\u000b\u0014\u00c7J\u008a\u009c\u00a3v\u0083\u00fb\u001f\u00ce\u00ff\u00d6\u00f1%\u00ae\u00f4d]\u0092\u00ee\u0006P\u00c8@+nI\u0018\u0088\u0096\u00037\u0010\u00c6\u00f7-Yi8RoJ/\u009b\u00fd\u00d9\u008f\u00e3:\u001c23\t\u008b\u0013\u00fd6\u00a4yy\u0092\u00b4\u0005*\u001e\u000f\u00f1\u009d\b\u0097\u00f1\u00b8}I\u00e4wQ\u0014~\u00b8\u00c5Y'\u00c6&z\u00c5#\u000f\u00df\u00a5\u00a7\u009fIP9\u00ed \u0005\u0082;\u001aU?\u001e{j0\u001b\u00e7\u0087\u00ab\u007fw7\u00b6\u001e\u00f2\u00e3>\u00ca>b%`\u00c3C\u0001\u0015k\b7$\u00a2\u00d0\u0010\u00d9\u00e1\u0080\u00af\u00a6#u\u0012\u00d1(\u00ef\u0000\u00dfu4\u0087\t\u00e0\u008bF4\u0080\u001e\u00db\u00e1\u000e\u0010*\u000f\u00feri\u0098\u008ce\u00ee\u00c6\b\u00dd#\u00ce\u00ab\u00f0?\u0086\u00d4\u0087\u00cc\u001ctQmY\u00a46\u0097]$\u00f6\u000b\u00e2?\u00c3\u000e\u0091\u00dc0\u0080]R\u00fc\u00db\u00ecy^jK\u00d7W\u0090\u0093\u00bd\u0012\u00b6\b\u000b\u00c1\u00cf\u001d\u00c9M+}\u00f4\u0003\u00f4\u0019\u00c3[^\u00bb\u00b8cx\u00c0\u00e2\u00a9\b\u00feb\u0095\u000f\u00ec\u00aa\u00c3\u0098\fZX\u0011SaC\u009c\u00a2\u00c5v?\u00cfF$k\u00de5\u0098\u008f\u00a3;\"I\u00c9\u00ec4C\u00c4\u00c1X\u0001\u0094fi\u0083,Y\u00e8B\u00b9\u00d2\u00fbq\u0086Wl\u00c6q\u0093\u008d\u0090z\u00d7\u00962\u0099\u0013\u00c8\u00d7\u00a3\u0095G\u00db\"\u00bb\u00d2\u00bc4\u00aa\u00c9R\u00bb\u0099\u00e8\u00b7\u00f0\u0016\u00dd\"1\u00e7\u00c9\u00ab\u001f\u008b\u0090.D$l\u00d3\u0002x\u0098W\u00eb\u00ce@\u00b2\u000f\u00d42\u0005\u00a0\f\u00db/\u00ad\u00cf\u00cf\u00b4\u0010\u00cf\u00a7\u0002\u000bm\u00dd\u00f7\u00e3\u00bdU\u0007`\u00b6\"[\u0015t\u00ee\u00d4\u0086\u00de\u0091\u0087\u0085\u0098~V\u00fcP\u000e|\u0090\u00f6U\u009c5\t)\u00ea\u0018\u0002U\u00a1NcFn\u0010\u0095\u00fa\u0092h\u00a7\u000f)\u00baa\u0016puf`\u0089?\u00abv\u0003\u009f\u0019\u00b4a\u001f\u00b6%k[-\u0007\u00df\u0007\u00da_\u000e\u00a7\u0004ML\u0007\u00b9\u0001\u0006\u0000\u00e2V\u0086(\u00d9\u00d5(\u00cdT7+N\u0017\u00c6\u0090\u0016\u0011t\u0095\u000fh\u0017\u00e7\u00e0\u00c1\u0095?\u00b72yj\u00c5\f\u0089#o\u00dd\u000f\u00bf\u008a\u00f0\u00d3\u00cd\u00e5\u000fzx\u0012Q\u00fb\u00c8{rh\u00cc\u00de\u0006x\"&\"\u00c4<\u00c7\u00d1\u0019\u00detT\u008cR\u00c9\u00b2\u001am\u00d2al^C\u00c8\u00de\u00ae\u0013K\u00b4\u000e\u00c1\u008ej\u00b2\u0096\u0016\u00be\u00b8\u000e\u00015}\u00f8\u0016\u00fd\u00c6\u00d4\u00df\u0018(\u009c\u00aa{\u001b\u00d8\u00aaA\u000ej\u0096\u00dc\u00e5\u00cb\u00b9'\u00a9\u001b\u00eb\u00d4\u00a7\u0004,\u00f3\u001a\u00f3\u00c0\u00c5 %\u000e\u00a6\n\u0095!,x\u00d3\u00bc8\u008a\u00fc6\u0018\u000e\u0086\u009b\u00860;\u00b6\u000e\u0098\r\u008f\u00a0\u00b7\u0099\u00bd\u00c8^\u00c0o\u00fe\u0018\u0017\u00e3\u0089)D\u00d8\u00d7M\u001bM4&\u0084\u001c\u00c8{=Q\u00cdS\u001aD\u00d8\f}&\u008e\u0006\u00e1a;QB'\u008a26\u0011\u0089pR\u00d5\n\u00d6;\t\u00fa\u00e4\u0005\u00c7\u00e2\u00af\u00c1\u008c\u00f0".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 35;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "l\u009d\u0011&\u0000\u00e3\u00940S\u001d\u00f1\u0098\u00d9\u00ee\u0092g2\rNb9\u00176=\u009e\u00d9\u0086\u00c0\u00a6\u0014\u009e\u001eb\u00d5}\u009c\u009be\u00df\u00de$\u0017I\u00dezH=\tz\u00a7";
                    var4_3 = "l\u009d\u0011&\u0000\u00e3\u00940S\u001d\u00f1\u0098\u00d9\u00ee\u0092g2\rNb9\u00176=\u009e\u00d9\u0086\u00c0\u00a6\u0014\u009e\u001eb\u00d5}\u009c\u009be\u00df\u00de$\u0017I\u00dezH=\tz\u00a7".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 4;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 73;
                            break;
                        }
                        case 1: {
                            v15 = 10;
                            break;
                        }
                        case 2: {
                            v15 = 42;
                            break;
                        }
                        case 3: {
                            v15 = 21;
                            break;
                        }
                        case 4: {
                            v15 = 32;
                            break;
                        }
                        case 5: {
                            v15 = 32;
                            break;
                        }
                        default: {
                            v15 = 53;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x58EE) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 218;
                case 1 -> 63;
                case 2 -> 189;
                case 3 -> 190;
                case 4 -> 47;
                case 5 -> 50;
                case 6 -> 94;
                case 7 -> 178;
                case 8 -> 211;
                case 9 -> 109;
                case 10 -> 199;
                case 11 -> 20;
                case 12 -> 129;
                case 13 -> 204;
                case 14 -> 167;
                case 15 -> 91;
                case 16 -> 241;
                case 17 -> 170;
                case 18 -> 206;
                case 19 -> 202;
                case 20 -> 126;
                case 21 -> 179;
                case 22 -> 125;
                case 23 -> 88;
                case 24 -> 39;
                case 25 -> 138;
                case 26 -> 192;
                case 27 -> 52;
                case 28 -> 142;
                case 29 -> 239;
                case 30 -> 12;
                case 31 -> 28;
                case 32 -> 222;
                case 33 -> 235;
                case 34 -> 194;
                case 35 -> 34;
                case 36 -> 130;
                case 37 -> 233;
                case 38 -> 232;
                case 39 -> 93;
                case 40 -> 248;
                case 41 -> 66;
                case 42 -> 144;
                case 43 -> 9;
                case 44 -> 7;
                case 45 -> 207;
                case 46 -> 46;
                case 47 -> 163;
                case 48 -> 58;
                case 49 -> 84;
                case 50 -> 17;
                case 51 -> 43;
                case 52 -> 89;
                case 53 -> 168;
                case 54 -> 105;
                case 55 -> 143;
                case 56 -> 150;
                case 57 -> 253;
                case 58 -> 1;
                case 59 -> 221;
                case 60 -> 209;
                case 61 -> 151;
                case 62 -> 254;
                case 63 -> 169;
                case 64 -> 230;
                case 65 -> 146;
                case 66 -> 81;
                case 67 -> 153;
                case 68 -> 33;
                case 69 -> 102;
                case 70 -> 220;
                case 71 -> 21;
                case 72 -> 164;
                case 73 -> 175;
                case 74 -> 215;
                case 75 -> 65;
                case 76 -> 139;
                case 77 -> 135;
                case 78 -> 114;
                case 79 -> 157;
                case 80 -> 3;
                case 81 -> 29;
                case 82 -> 174;
                case 83 -> 166;
                case 84 -> 184;
                case 85 -> 236;
                case 86 -> 244;
                case 87 -> 5;
                case 88 -> 10;
                case 89 -> 201;
                case 90 -> 247;
                case 91 -> 245;
                case 92 -> 73;
                case 93 -> 112;
                case 94 -> 25;
                case 95 -> 116;
                case 96 -> 111;
                case 97 -> 173;
                case 98 -> 171;
                case 99 -> 68;
                case 100 -> 22;
                case 101 -> 197;
                case 102 -> 36;
                case 103 -> 55;
                case 104 -> 107;
                case 105 -> 212;
                case 106 -> 193;
                case 107 -> 14;
                case 108 -> 214;
                case 109 -> 32;
                case 110 -> 132;
                case 111 -> 75;
                case 112 -> 237;
                case 113 -> 74;
                case 114 -> 158;
                case 115 -> 242;
                case 116 -> 2;
                case 117 -> 252;
                case 118 -> 225;
                case 119 -> 85;
                case 120 -> 145;
                case 121 -> 62;
                case 122 -> 53;
                case 123 -> 113;
                case 124 -> 176;
                case 125 -> 185;
                case 126 -> 223;
                case 127 -> 238;
                case 128 -> 35;
                case 129 -> 19;
                case 130 -> 98;
                case 131 -> 208;
                case 132 -> 127;
                case 133 -> 147;
                case 134 -> 196;
                case 135 -> 16;
                case 136 -> 155;
                case 137 -> 186;
                case 138 -> 78;
                case 139 -> 122;
                case 140 -> 110;
                case 141 -> 140;
                case 142 -> 103;
                case 143 -> 83;
                case 144 -> 121;
                case 145 -> 8;
                case 146 -> 69;
                case 147 -> 49;
                case 148 -> 228;
                case 149 -> 154;
                case 150 -> 231;
                case 151 -> 234;
                case 152 -> 148;
                case 153 -> 90;
                case 154 -> 210;
                case 155 -> 227;
                case 156 -> 45;
                case 157 -> 205;
                case 158 -> 79;
                case 159 -> 219;
                case 160 -> 23;
                case 161 -> 95;
                case 162 -> 76;
                case 163 -> 57;
                case 164 -> 11;
                case 165 -> 224;
                case 166 -> 100;
                case 167 -> 42;
                case 168 -> 160;
                case 169 -> 117;
                case 170 -> 250;
                case 171 -> 165;
                case 172 -> 229;
                case 173 -> 203;
                case 174 -> 70;
                case 175 -> 120;
                case 176 -> 86;
                case 177 -> 123;
                case 178 -> 59;
                case 179 -> 44;
                case 180 -> 226;
                case 181 -> 48;
                case 182 -> 96;
                case 183 -> 141;
                case 184 -> 31;
                case 185 -> 67;
                case 186 -> 0;
                case 187 -> 172;
                case 188 -> 131;
                case 189 -> 30;
                case 190 -> 51;
                case 191 -> 181;
                case 192 -> 71;
                case 193 -> 213;
                case 194 -> 26;
                case 195 -> 54;
                case 196 -> 80;
                case 197 -> 246;
                case 198 -> 136;
                case 199 -> 187;
                case 200 -> 162;
                case 201 -> 4;
                case 202 -> 216;
                case 203 -> 108;
                case 204 -> 137;
                case 205 -> 99;
                case 206 -> 24;
                case 207 -> 6;
                case 208 -> 104;
                case 209 -> 87;
                case 210 -> 40;
                case 211 -> 82;
                case 212 -> 156;
                case 213 -> 72;
                case 214 -> 198;
                case 215 -> 133;
                case 216 -> 101;
                case 217 -> 128;
                case 218 -> 243;
                case 219 -> 37;
                case 220 -> 106;
                case 221 -> 18;
                case 222 -> 191;
                case 223 -> 180;
                case 224 -> 77;
                case 225 -> 200;
                case 226 -> 240;
                case 227 -> 255;
                case 228 -> 38;
                case 229 -> 64;
                case 230 -> 251;
                case 231 -> 118;
                case 232 -> 15;
                case 233 -> 41;
                case 234 -> 97;
                case 235 -> 115;
                case 236 -> 249;
                case 237 -> 149;
                case 238 -> 134;
                case 239 -> 217;
                case 240 -> 92;
                case 241 -> 161;
                case 242 -> 60;
                case 243 -> 27;
                case 244 -> 61;
                case 245 -> 159;
                case 246 -> 119;
                case 247 -> 182;
                case 248 -> 13;
                case 249 -> 56;
                case 250 -> 195;
                case 251 -> 152;
                case 252 -> 177;
                case 253 -> 183;
                case 254 -> 188;
                default -> 124;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 47520570863929L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1052623170 + (char)-6598, 1052754240 - (char)-12613, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 110575628184214L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.F();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1695128310 + 8668, 1695128310 + 8359, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1695128310 + 8667, -1695128310 + -18290, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1695128310 + 8666, -1695128310 - -2751, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = ">\u008b\u00e7\u0080\u009b\u008b\u00a2\u00fa\u0010\u00db\u00d0\u00aaJ\u0088i9\u00ff+\u00ffs\u0091\u00ba\u00ce<\u0083";
                    var4_3 = ">\u008b\u00e7\u0080\u009b\u008b\u00a2\u00fa\u0010\u00db\u00d0\u00aaJ\u0088i9\u00ff+\u00ffs\u0091\u00ba\u00ce<\u0083".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 123;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "7fK\u00b0\u00f35k\u00d8\u00d7\u000b\u00b2\u00f5\u00ebJ\u008b\u007fx\u00cc\u00a1\u0002\u00d7\u001d?z\tL\u00d08J\u00af=\u00fe\u0094`X\u00c0\u00feTE\u00d7\u0096\u00f8\u0090}x#\u008e\u0092\u00af\u00eab\u00c8\u00b6\u00e2\u00b2\u0012\u0017\u00ea\u0090";
                        var4_3 = "7fK\u00b0\u00f35k\u00d8\u00d7\u000b\u00b2\u00f5\u00ebJ\u008b\u007fx\u00cc\u00a1\u0002\u00d7\u001d?z\tL\u00d08J\u00af=\u00fe\u0094`X\u00c0\u00feTE\u00d7\u0096\u00f8\u0090}x#\u008e\u0092\u00af\u00eab\u00c8\u00b6\u00e2\u00b2\u0012\u0017\u00ea\u0090".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 119;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 91;
                                break;
                            }
                            case 1: {
                                v15 = 44;
                                break;
                            }
                            case 2: {
                                v15 = 81;
                                break;
                            }
                            case 3: {
                                v15 = 65;
                                break;
                            }
                            case 4: {
                                v15 = 119;
                                break;
                            }
                            case 5: {
                                v15 = 15;
                                break;
                            }
                            default: {
                                v15 = 5;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x5645) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 229;
                    case 1 -> 239;
                    case 2 -> 147;
                    case 3 -> 181;
                    case 4 -> 40;
                    case 5 -> 176;
                    case 6 -> 214;
                    case 7 -> 77;
                    case 8 -> 150;
                    case 9 -> 8;
                    case 10 -> 165;
                    case 11 -> 212;
                    case 12 -> 253;
                    case 13 -> 188;
                    case 14 -> 135;
                    case 15 -> 46;
                    case 16 -> 173;
                    case 17 -> 125;
                    case 18 -> 22;
                    case 19 -> 65;
                    case 20 -> 103;
                    case 21 -> 234;
                    case 22 -> 131;
                    case 23 -> 246;
                    case 24 -> 128;
                    case 25 -> 102;
                    case 26 -> 95;
                    case 27 -> 163;
                    case 28 -> 231;
                    case 29 -> 139;
                    case 30 -> 78;
                    case 31 -> 9;
                    case 32 -> 220;
                    case 33 -> 152;
                    case 34 -> 192;
                    case 35 -> 23;
                    case 36 -> 171;
                    case 37 -> 88;
                    case 38 -> 183;
                    case 39 -> 145;
                    case 40 -> 209;
                    case 41 -> 25;
                    case 42 -> 127;
                    case 43 -> 47;
                    case 44 -> 98;
                    case 45 -> 248;
                    case 46 -> 115;
                    case 47 -> 142;
                    case 48 -> 74;
                    case 49 -> 1;
                    case 50 -> 245;
                    case 51 -> 215;
                    case 52 -> 138;
                    case 53 -> 48;
                    case 54 -> 3;
                    case 55 -> 217;
                    case 56 -> 5;
                    case 57 -> 118;
                    case 58 -> 225;
                    case 59 -> 228;
                    case 60 -> 162;
                    case 61 -> 205;
                    case 62 -> 143;
                    case 63 -> 224;
                    case 64 -> 38;
                    case 65 -> 230;
                    case 66 -> 53;
                    case 67 -> 2;
                    case 68 -> 44;
                    case 69 -> 179;
                    case 70 -> 164;
                    case 71 -> 226;
                    case 72 -> 148;
                    case 73 -> 14;
                    case 74 -> 140;
                    case 75 -> 11;
                    case 76 -> 170;
                    case 77 -> 136;
                    case 78 -> 172;
                    case 79 -> 180;
                    case 80 -> 93;
                    case 81 -> 20;
                    case 82 -> 204;
                    case 83 -> 94;
                    case 84 -> 195;
                    case 85 -> 19;
                    case 86 -> 255;
                    case 87 -> 137;
                    case 88 -> 66;
                    case 89 -> 54;
                    case 90 -> 87;
                    case 91 -> 109;
                    case 92 -> 33;
                    case 93 -> 71;
                    case 94 -> 100;
                    case 95 -> 63;
                    case 96 -> 221;
                    case 97 -> 97;
                    case 98 -> 52;
                    case 99 -> 240;
                    case 100 -> 73;
                    case 101 -> 105;
                    case 102 -> 251;
                    case 103 -> 82;
                    case 104 -> 160;
                    case 105 -> 59;
                    case 106 -> 116;
                    case 107 -> 178;
                    case 108 -> 175;
                    case 109 -> 76;
                    case 110 -> 197;
                    case 111 -> 149;
                    case 112 -> 86;
                    case 113 -> 42;
                    case 114 -> 62;
                    case 115 -> 182;
                    case 116 -> 203;
                    case 117 -> 6;
                    case 118 -> 0;
                    case 119 -> 235;
                    case 120 -> 146;
                    case 121 -> 174;
                    case 122 -> 187;
                    case 123 -> 213;
                    case 124 -> 84;
                    case 125 -> 110;
                    case 126 -> 57;
                    case 127 -> 15;
                    case 128 -> 69;
                    case 129 -> 216;
                    case 130 -> 27;
                    case 131 -> 126;
                    case 132 -> 210;
                    case 133 -> 34;
                    case 134 -> 21;
                    case 135 -> 154;
                    case 136 -> 58;
                    case 137 -> 201;
                    case 138 -> 168;
                    case 139 -> 83;
                    case 140 -> 41;
                    case 141 -> 50;
                    case 142 -> 199;
                    case 143 -> 218;
                    case 144 -> 81;
                    case 145 -> 189;
                    case 146 -> 185;
                    case 147 -> 208;
                    case 148 -> 134;
                    case 149 -> 120;
                    case 150 -> 49;
                    case 151 -> 85;
                    case 152 -> 202;
                    case 153 -> 206;
                    case 154 -> 51;
                    case 155 -> 4;
                    case 156 -> 91;
                    case 157 -> 121;
                    case 158 -> 242;
                    case 159 -> 92;
                    case 160 -> 108;
                    case 161 -> 114;
                    case 162 -> 67;
                    case 163 -> 223;
                    case 164 -> 133;
                    case 165 -> 167;
                    case 166 -> 24;
                    case 167 -> 132;
                    case 168 -> 99;
                    case 169 -> 32;
                    case 170 -> 96;
                    case 171 -> 104;
                    case 172 -> 26;
                    case 173 -> 191;
                    case 174 -> 101;
                    case 175 -> 68;
                    case 176 -> 56;
                    case 177 -> 112;
                    case 178 -> 177;
                    case 179 -> 243;
                    case 180 -> 194;
                    case 181 -> 16;
                    case 182 -> 18;
                    case 183 -> 244;
                    case 184 -> 90;
                    case 185 -> 129;
                    case 186 -> 79;
                    case 187 -> 30;
                    case 188 -> 45;
                    case 189 -> 207;
                    case 190 -> 156;
                    case 191 -> 13;
                    case 192 -> 70;
                    case 193 -> 247;
                    case 194 -> 28;
                    case 195 -> 130;
                    case 196 -> 113;
                    case 197 -> 119;
                    case 198 -> 60;
                    case 199 -> 80;
                    case 200 -> 233;
                    case 201 -> 31;
                    case 202 -> 36;
                    case 203 -> 166;
                    case 204 -> 107;
                    case 205 -> 12;
                    case 206 -> 227;
                    case 207 -> 252;
                    case 208 -> 161;
                    case 209 -> 157;
                    case 210 -> 249;
                    case 211 -> 151;
                    case 212 -> 236;
                    case 213 -> 124;
                    case 214 -> 196;
                    case 215 -> 72;
                    case 216 -> 39;
                    case 217 -> 141;
                    case 218 -> 222;
                    case 219 -> 123;
                    case 220 -> 10;
                    case 221 -> 153;
                    case 222 -> 169;
                    case 223 -> 155;
                    case 224 -> 122;
                    case 225 -> 61;
                    case 226 -> 144;
                    case 227 -> 219;
                    case 228 -> 89;
                    case 229 -> 193;
                    case 230 -> 254;
                    case 231 -> 211;
                    case 232 -> 238;
                    case 233 -> 190;
                    case 234 -> 117;
                    case 235 -> 250;
                    case 236 -> 159;
                    case 237 -> 37;
                    case 238 -> 241;
                    case 239 -> 106;
                    case 240 -> 75;
                    case 241 -> 158;
                    case 242 -> 64;
                    case 243 -> 35;
                    case 244 -> 237;
                    case 245 -> 55;
                    case 246 -> 7;
                    case 247 -> 232;
                    case 248 -> 184;
                    case 249 -> 43;
                    case 250 -> 17;
                    case 251 -> 111;
                    case 252 -> 29;
                    case 253 -> 198;
                    case 254 -> 200;
                    default -> 186;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 92205890074886L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "q\u0017$6j;<(\tv\u001d7<'y!4[";
                    var5_4 = "q\u0017$6j;<(\tv\u001d7<'y!4[".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 80;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 74;
                                    break;
                                }
                                case 1: {
                                    v11 = 34;
                                    break;
                                }
                                case 2: {
                                    v11 = 6;
                                    break;
                                }
                                case 3: {
                                    v11 = 8;
                                    break;
                                }
                                case 4: {
                                    v11 = 95;
                                    break;
                                }
                                case 5: {
                                    v11 = 7;
                                    break;
                                }
                                default: {
                                    v11 = 95;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 63351293723391L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "7F|E\u0011x\u001a\u00041Xp_\n=G{_\u001dz\u0002\u0017Fr\t=G{_\u001dz\u0002\u001bL\r:AfR\u0017w\u0018\u001bKaX\u0016~";
                    var5_4 = "7F|E\u0011x\u001a\u00041Xp_\n=G{_\u001dz\u0002\u0017Fr\t=G{_\u001dz\u0002\u001bL\r:AfR\u0017w\u0018\u001bKaX\u0016~".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 60;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u000brLt'A'\u0006\u000brLt+K";
                        var5_4 = "\u000brLt'A'\u0006\u000brLt+K".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 10;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 66;
                                break;
                            }
                            case 1: {
                                v15 = 20;
                                break;
                            }
                            case 2: {
                                v15 = 41;
                                break;
                            }
                            case 3: {
                                v15 = 13;
                                break;
                            }
                            case 4: {
                                v15 = 68;
                                break;
                            }
                            case 5: {
                                v15 = 37;
                                break;
                            }
                            default: {
                                v15 = 74;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 61087798570954L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-478667640 + -((char)-3629), 478667640 + (char)-17567, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 8345243773509L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00a2\u00f6e\u00b8B\u0003\u0019\u00cc\u00a6\u0005\u00db\u00e2l\u00fe\u0080\r!\u0091\u0005\u00daX>\u00b0\u00b9y\u0084\u0089\u00a9\u00d3\u0010|\u00bci\u0094\u00eab\u00cd\u000f\u001f\u00d6\u00a6\u00ae\u00d0\u0091\u00e0\u00c2\u0005\u00a8N\u0002kM3\u001b\u00d5eo\u00beYw|5Eh\u00f5\u00cf\u00ab/\u009a\u00aaO[\u00b7\b]\u00101c%\u00ebx\u0015P\u00d2\u00c5\u0096\u001e9\u00b6\u00b8L\u0013\u0098#\u008a\u0017\u00fc\u00be\u00a6\u00d4XBi\u00de";
                    var4_3 = "\u00a2\u00f6e\u00b8B\u0003\u0019\u00cc\u00a6\u0005\u00db\u00e2l\u00fe\u0080\r!\u0091\u0005\u00daX>\u00b0\u00b9y\u0084\u0089\u00a9\u00d3\u0010|\u00bci\u0094\u00eab\u00cd\u000f\u001f\u00d6\u00a6\u00ae\u00d0\u0091\u00e0\u00c2\u0005\u00a8N\u0002kM3\u001b\u00d5eo\u00beYw|5Eh\u00f5\u00cf\u00ab/\u009a\u00aaO[\u00b7\b]\u00101c%\u00ebx\u0015P\u00d2\u00c5\u0096\u001e9\u00b6\u00b8L\u0013\u0098#\u008a\u0017\u00fc\u00be\u00a6\u00d4XBi\u00de".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 25;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "=\u00df\u00dbb&&\u00ce\u001d\u00e5\u000ec/\u00f2;>\rL4\u0090\rA\u00d6\u008a\u00be\u00e6b\u00e2?\u000bw1\u001d5s\u00f1\u0005\f1\u00d4\u00878(u=.\u00afI\u00f0\u0013X\u00b0\u000b\u00e5Vbn\u00a1 \u00ca\"\u0013\u0097\u001f\u00a0\u00cd\u00a4up\u00b2R9qXU\u00ef\u00b6\u00a1\u00a5\u001d\u0006\u00995\u0014\u00dc\u00aba\u00de\u0089\u0018\u000ek\u00a7\u00c8";
                        var4_3 = "=\u00df\u00dbb&&\u00ce\u001d\u00e5\u000ec/\u00f2;>\rL4\u0090\rA\u00d6\u008a\u00be\u00e6b\u00e2?\u000bw1\u001d5s\u00f1\u0005\f1\u00d4\u00878(u=.\u00afI\u00f0\u0013X\u00b0\u000b\u00e5Vbn\u00a1 \u00ca\"\u0013\u0097\u001f\u00a0\u00cd\u00a4up\u00b2R9qXU\u00ef\u00b6\u00a1\u00a5\u001d\u0006\u00995\u0014\u00dc\u00aba\u00de\u0089\u0018\u000ek\u00a7\u00c8".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 36;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 75;
                                break;
                            }
                            case 1: {
                                v15 = 39;
                                break;
                            }
                            case 2: {
                                v15 = 74;
                                break;
                            }
                            case 3: {
                                v15 = 93;
                                break;
                            }
                            case 4: {
                                v15 = 32;
                                break;
                            }
                            case 5: {
                                v15 = 114;
                                break;
                            }
                            default: {
                                v15 = 121;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF857F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 234;
                    case 1 -> 10;
                    case 2 -> 177;
                    case 3 -> 203;
                    case 4 -> 191;
                    case 5 -> 183;
                    case 6 -> 86;
                    case 7 -> 185;
                    case 8 -> 237;
                    case 9 -> 139;
                    case 10 -> 171;
                    case 11 -> 95;
                    case 12 -> 106;
                    case 13 -> 93;
                    case 14 -> 143;
                    case 15 -> 44;
                    case 16 -> 140;
                    case 17 -> 204;
                    case 18 -> 100;
                    case 19 -> 207;
                    case 20 -> 37;
                    case 21 -> 94;
                    case 22 -> 7;
                    case 23 -> 23;
                    case 24 -> 141;
                    case 25 -> 78;
                    case 26 -> 243;
                    case 27 -> 120;
                    case 28 -> 135;
                    case 29 -> 56;
                    case 30 -> 214;
                    case 31 -> 187;
                    case 32 -> 6;
                    case 33 -> 102;
                    case 34 -> 149;
                    case 35 -> 189;
                    case 36 -> 199;
                    case 37 -> 227;
                    case 38 -> 73;
                    case 39 -> 88;
                    case 40 -> 89;
                    case 41 -> 112;
                    case 42 -> 62;
                    case 43 -> 77;
                    case 44 -> 63;
                    case 45 -> 3;
                    case 46 -> 25;
                    case 47 -> 90;
                    case 48 -> 114;
                    case 49 -> 9;
                    case 50 -> 136;
                    case 51 -> 224;
                    case 52 -> 22;
                    case 53 -> 105;
                    case 54 -> 58;
                    case 55 -> 71;
                    case 56 -> 103;
                    case 57 -> 21;
                    case 58 -> 27;
                    case 59 -> 144;
                    case 60 -> 57;
                    case 61 -> 166;
                    case 62 -> 232;
                    case 63 -> 194;
                    case 64 -> 128;
                    case 65 -> 151;
                    case 66 -> 242;
                    case 67 -> 8;
                    case 68 -> 173;
                    case 69 -> 180;
                    case 70 -> 127;
                    case 71 -> 5;
                    case 72 -> 211;
                    case 73 -> 217;
                    case 74 -> 16;
                    case 75 -> 155;
                    case 76 -> 45;
                    case 77 -> 70;
                    case 78 -> 154;
                    case 79 -> 67;
                    case 80 -> 87;
                    case 81 -> 35;
                    case 82 -> 92;
                    case 83 -> 122;
                    case 84 -> 150;
                    case 85 -> 99;
                    case 86 -> 101;
                    case 87 -> 212;
                    case 88 -> 81;
                    case 89 -> 40;
                    case 90 -> 43;
                    case 91 -> 53;
                    case 92 -> 48;
                    case 93 -> 96;
                    case 94 -> 68;
                    case 95 -> 132;
                    case 96 -> 42;
                    case 97 -> 79;
                    case 98 -> 181;
                    case 99 -> 33;
                    case 100 -> 239;
                    case 101 -> 80;
                    case 102 -> 218;
                    case 103 -> 14;
                    case 104 -> 222;
                    case 105 -> 20;
                    case 106 -> 198;
                    case 107 -> 164;
                    case 108 -> 134;
                    case 109 -> 84;
                    case 110 -> 113;
                    case 111 -> 163;
                    case 112 -> 156;
                    case 113 -> 157;
                    case 114 -> 153;
                    case 115 -> 110;
                    case 116 -> 2;
                    case 117 -> 254;
                    case 118 -> 59;
                    case 119 -> 91;
                    case 120 -> 133;
                    case 121 -> 64;
                    case 122 -> 193;
                    case 123 -> 152;
                    case 124 -> 216;
                    case 125 -> 231;
                    case 126 -> 115;
                    case 127 -> 145;
                    case 128 -> 169;
                    case 129 -> 51;
                    case 130 -> 158;
                    case 131 -> 52;
                    case 132 -> 196;
                    case 133 -> 12;
                    case 134 -> 213;
                    case 135 -> 249;
                    case 136 -> 85;
                    case 137 -> 220;
                    case 138 -> 41;
                    case 139 -> 46;
                    case 140 -> 116;
                    case 141 -> 230;
                    case 142 -> 121;
                    case 143 -> 26;
                    case 144 -> 72;
                    case 145 -> 11;
                    case 146 -> 118;
                    case 147 -> 236;
                    case 148 -> 223;
                    case 149 -> 28;
                    case 150 -> 29;
                    case 151 -> 167;
                    case 152 -> 188;
                    case 153 -> 34;
                    case 154 -> 146;
                    case 155 -> 240;
                    case 156 -> 82;
                    case 157 -> 255;
                    case 158 -> 244;
                    case 159 -> 229;
                    case 160 -> 32;
                    case 161 -> 179;
                    case 162 -> 142;
                    case 163 -> 15;
                    case 164 -> 200;
                    case 165 -> 165;
                    case 166 -> 98;
                    case 167 -> 4;
                    case 168 -> 208;
                    case 169 -> 221;
                    case 170 -> 162;
                    case 171 -> 60;
                    case 172 -> 160;
                    case 173 -> 178;
                    case 174 -> 54;
                    case 175 -> 161;
                    case 176 -> 104;
                    case 177 -> 206;
                    case 178 -> 24;
                    case 179 -> 170;
                    case 180 -> 13;
                    case 181 -> 97;
                    case 182 -> 38;
                    case 183 -> 76;
                    case 184 -> 190;
                    case 185 -> 1;
                    case 186 -> 241;
                    case 187 -> 252;
                    case 188 -> 245;
                    case 189 -> 201;
                    case 190 -> 250;
                    case 191 -> 235;
                    case 192 -> 49;
                    case 193 -> 202;
                    case 194 -> 131;
                    case 195 -> 117;
                    case 196 -> 225;
                    case 197 -> 69;
                    case 198 -> 209;
                    case 199 -> 39;
                    case 200 -> 47;
                    case 201 -> 219;
                    case 202 -> 129;
                    case 203 -> 215;
                    case 204 -> 226;
                    case 205 -> 55;
                    case 206 -> 18;
                    case 207 -> 253;
                    case 208 -> 168;
                    case 209 -> 75;
                    case 210 -> 50;
                    case 211 -> 148;
                    case 212 -> 61;
                    case 213 -> 31;
                    case 214 -> 159;
                    case 215 -> 111;
                    case 216 -> 147;
                    case 217 -> 119;
                    case 218 -> 30;
                    case 219 -> 125;
                    case 220 -> 137;
                    case 221 -> 197;
                    case 222 -> 123;
                    case 223 -> 247;
                    case 224 -> 184;
                    case 225 -> 248;
                    case 226 -> 124;
                    case 227 -> 126;
                    case 228 -> 83;
                    case 229 -> 172;
                    case 230 -> 107;
                    case 231 -> 108;
                    case 232 -> 205;
                    case 233 -> 186;
                    case 234 -> 238;
                    case 235 -> 65;
                    case 236 -> 174;
                    case 237 -> 36;
                    case 238 -> 176;
                    case 239 -> 19;
                    case 240 -> 130;
                    case 241 -> 210;
                    case 242 -> 138;
                    case 243 -> 228;
                    case 244 -> 66;
                    case 245 -> 17;
                    case 246 -> 251;
                    case 247 -> 0;
                    case 248 -> 246;
                    case 249 -> 109;
                    case 250 -> 233;
                    case 251 -> 182;
                    case 252 -> 175;
                    case 253 -> 192;
                    case 254 -> 195;
                    default -> 74;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 63320186264283L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(516546870 + 13417, -516546870 + -13862, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 41267579596070L;
                    String[] stringArray = SshAgentIpcService.F();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1533781140 + -((char)-18167), 1533781140 + (char)-13537, (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 138851460143151L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "7\u007f\u00aev\u00ff\u0003\u00e6q\u00c2";
                var4_3 = "7\u007f\u00aev\u00ff\u0003\u00e6q\u00c2".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 95;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 116;
                                break;
                            }
                            case 1: {
                                v11 = 55;
                                break;
                            }
                            case 2: {
                                v11 = 90;
                                break;
                            }
                            case 3: {
                                v11 = 46;
                                break;
                            }
                            case 4: {
                                v11 = 104;
                                break;
                            }
                            case 5: {
                                v11 = 109;
                                break;
                            }
                            default: {
                                v11 = 4;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8F44) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 160;
                    case 1 -> 42;
                    case 2 -> 219;
                    case 3 -> 15;
                    case 4 -> 200;
                    case 5 -> 237;
                    case 6 -> 148;
                    case 7 -> 23;
                    case 8 -> 1;
                    case 9 -> 121;
                    case 10 -> 152;
                    case 11 -> 242;
                    case 12 -> 167;
                    case 13 -> 132;
                    case 14 -> 98;
                    case 15 -> 222;
                    case 16 -> 183;
                    case 17 -> 87;
                    case 18 -> 165;
                    case 19 -> 22;
                    case 20 -> 144;
                    case 21 -> 145;
                    case 22 -> 205;
                    case 23 -> 247;
                    case 24 -> 224;
                    case 25 -> 139;
                    case 26 -> 133;
                    case 27 -> 81;
                    case 28 -> 2;
                    case 29 -> 255;
                    case 30 -> 203;
                    case 31 -> 226;
                    case 32 -> 112;
                    case 33 -> 236;
                    case 34 -> 107;
                    case 35 -> 171;
                    case 36 -> 254;
                    case 37 -> 232;
                    case 38 -> 17;
                    case 39 -> 68;
                    case 40 -> 116;
                    case 41 -> 86;
                    case 42 -> 220;
                    case 43 -> 54;
                    case 44 -> 235;
                    case 45 -> 138;
                    case 46 -> 47;
                    case 47 -> 76;
                    case 48 -> 51;
                    case 49 -> 180;
                    case 50 -> 21;
                    case 51 -> 13;
                    case 52 -> 166;
                    case 53 -> 29;
                    case 54 -> 55;
                    case 55 -> 10;
                    case 56 -> 80;
                    case 57 -> 151;
                    case 58 -> 246;
                    case 59 -> 193;
                    case 60 -> 56;
                    case 61 -> 73;
                    case 62 -> 53;
                    case 63 -> 230;
                    case 64 -> 248;
                    case 65 -> 189;
                    case 66 -> 60;
                    case 67 -> 201;
                    case 68 -> 70;
                    case 69 -> 89;
                    case 70 -> 153;
                    case 71 -> 4;
                    case 72 -> 118;
                    case 73 -> 164;
                    case 74 -> 83;
                    case 75 -> 130;
                    case 76 -> 194;
                    case 77 -> 158;
                    case 78 -> 149;
                    case 79 -> 113;
                    case 80 -> 103;
                    case 81 -> 234;
                    case 82 -> 37;
                    case 83 -> 178;
                    case 84 -> 161;
                    case 85 -> 223;
                    case 86 -> 109;
                    case 87 -> 61;
                    case 88 -> 6;
                    case 89 -> 77;
                    case 90 -> 72;
                    case 91 -> 212;
                    case 92 -> 16;
                    case 93 -> 95;
                    case 94 -> 163;
                    case 95 -> 181;
                    case 96 -> 185;
                    case 97 -> 157;
                    case 98 -> 140;
                    case 99 -> 105;
                    case 100 -> 36;
                    case 101 -> 79;
                    case 102 -> 27;
                    case 103 -> 238;
                    case 104 -> 3;
                    case 105 -> 50;
                    case 106 -> 62;
                    case 107 -> 173;
                    case 108 -> 245;
                    case 109 -> 106;
                    case 110 -> 46;
                    case 111 -> 24;
                    case 112 -> 172;
                    case 113 -> 253;
                    case 114 -> 30;
                    case 115 -> 197;
                    case 116 -> 93;
                    case 117 -> 196;
                    case 118 -> 19;
                    case 119 -> 0;
                    case 120 -> 125;
                    case 121 -> 34;
                    case 122 -> 252;
                    case 123 -> 162;
                    case 124 -> 38;
                    case 125 -> 204;
                    case 126 -> 195;
                    case 127 -> 146;
                    case 128 -> 52;
                    case 129 -> 202;
                    case 130 -> 218;
                    case 131 -> 208;
                    case 132 -> 206;
                    case 133 -> 216;
                    case 134 -> 190;
                    case 135 -> 228;
                    case 136 -> 239;
                    case 137 -> 134;
                    case 138 -> 32;
                    case 139 -> 177;
                    case 140 -> 124;
                    case 141 -> 213;
                    case 142 -> 9;
                    case 143 -> 117;
                    case 144 -> 43;
                    case 145 -> 5;
                    case 146 -> 101;
                    case 147 -> 155;
                    case 148 -> 179;
                    case 149 -> 122;
                    case 150 -> 150;
                    case 151 -> 199;
                    case 152 -> 127;
                    case 153 -> 63;
                    case 154 -> 240;
                    case 155 -> 65;
                    case 156 -> 90;
                    case 157 -> 97;
                    case 158 -> 187;
                    case 159 -> 111;
                    case 160 -> 170;
                    case 161 -> 100;
                    case 162 -> 49;
                    case 163 -> 136;
                    case 164 -> 191;
                    case 165 -> 123;
                    case 166 -> 154;
                    case 167 -> 8;
                    case 168 -> 114;
                    case 169 -> 207;
                    case 170 -> 209;
                    case 171 -> 129;
                    case 172 -> 119;
                    case 173 -> 126;
                    case 174 -> 211;
                    case 175 -> 40;
                    case 176 -> 176;
                    case 177 -> 241;
                    case 178 -> 33;
                    case 179 -> 85;
                    case 180 -> 175;
                    case 181 -> 221;
                    case 182 -> 25;
                    case 183 -> 231;
                    case 184 -> 78;
                    case 185 -> 198;
                    case 186 -> 186;
                    case 187 -> 233;
                    case 188 -> 192;
                    case 189 -> 20;
                    case 190 -> 28;
                    case 191 -> 41;
                    case 192 -> 159;
                    case 193 -> 92;
                    case 194 -> 143;
                    case 195 -> 142;
                    case 196 -> 45;
                    case 197 -> 249;
                    case 198 -> 35;
                    case 199 -> 88;
                    case 200 -> 214;
                    case 201 -> 168;
                    case 202 -> 39;
                    case 203 -> 75;
                    case 204 -> 174;
                    case 205 -> 215;
                    case 206 -> 57;
                    case 207 -> 12;
                    case 208 -> 188;
                    case 209 -> 147;
                    case 210 -> 184;
                    case 211 -> 64;
                    case 212 -> 69;
                    case 213 -> 18;
                    case 214 -> 182;
                    case 215 -> 59;
                    case 216 -> 7;
                    case 217 -> 91;
                    case 218 -> 210;
                    case 219 -> 128;
                    case 220 -> 94;
                    case 221 -> 244;
                    case 222 -> 14;
                    case 223 -> 74;
                    case 224 -> 120;
                    case 225 -> 67;
                    case 226 -> 96;
                    case 227 -> 104;
                    case 228 -> 110;
                    case 229 -> 115;
                    case 230 -> 251;
                    case 231 -> 227;
                    case 232 -> 11;
                    case 233 -> 108;
                    case 234 -> 169;
                    case 235 -> 250;
                    case 236 -> 58;
                    case 237 -> 243;
                    case 238 -> 102;
                    case 239 -> 156;
                    case 240 -> 131;
                    case 241 -> 217;
                    case 242 -> 26;
                    case 243 -> 229;
                    case 244 -> 66;
                    case 245 -> 71;
                    case 246 -> 44;
                    case 247 -> 31;
                    case 248 -> 141;
                    case 249 -> 48;
                    case 250 -> 225;
                    case 251 -> 82;
                    case 252 -> 99;
                    case 253 -> 84;
                    case 254 -> 137;
                    default -> 135;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

