/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.kernel.executor;

import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatusKt;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutorResult;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallback;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterKernelState;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterStatusMessage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/kernel/executor/JupyterFinishKernelExecutionCallback;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterExecutionCallback;", "taskScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "result", "Lkotlinx/coroutines/CompletableDeferred;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutorResult;", "getResult", "()Lkotlinx/coroutines/CompletableDeferred;", "pendingFinishTimer", "Lkotlinx/coroutines/Job;", "resultState", "Lcom/intellij/jupyter/core/kernel/executor/JupyterFinishKernelExecutionCallback$FinishState;", "dispose", "", "onStatus", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterStatusMessage;", "onExecuteReply", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "onFinishStateUpdate", "FinishState", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFinishKernelExecutionCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFinishKernelExecutionCallback.kt\ncom/intellij/jupyter/core/kernel/executor/JupyterFinishKernelExecutionCallback\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n23#2:133\n*S KotlinDebug\n*F\n+ 1 JupyterFinishKernelExecutionCallback.kt\ncom/intellij/jupyter/core/kernel/executor/JupyterFinishKernelExecutionCallback\n*L\n67#1:133\n*E\n"})
public final class JupyterFinishKernelExecutionCallback
implements JupyterExecutionCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope taskScope;
    @NotNull
    private final CompletableDeferred<JupyterTaskExecutorResult> result;
    @Nullable
    private Job pendingFinishTimer;
    @NotNull
    private FinishState resultState;
    private static final long WAIT_FOR_EXECUTE_REPLY_TIMEOUT = 3000L;

    public JupyterFinishKernelExecutionCallback(@NotNull CoroutineScope taskScope) {
        Intrinsics.checkNotNullParameter((Object)taskScope, (String)"taskScope");
        this.taskScope = taskScope;
        this.result = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.result.invokeOnCompletion(arg_0 -> JupyterFinishKernelExecutionCallback._init_$lambda$0(this, arg_0));
        this.resultState = new FinishState(null, null);
    }

    @NotNull
    public final CompletableDeferred<JupyterTaskExecutorResult> getResult() {
        return this.result;
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.taskScope, null, (int)1, null);
        if (this.result.isCompleted()) {
            return;
        }
        this.result.complete((Object)JupyterTaskExecutorResult.Aborted.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatus(@NotNull JupyterStatusMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JupyterKernelState kernelState = message.getExecutionState();
        switch (WhenMappings.$EnumSwitchMapping$0[kernelState.ordinal()]) {
            case 1: 
            case 2: {
                JupyterFinishKernelExecutionCallback jupyterFinishKernelExecutionCallback = this;
                synchronized (jupyterFinishKernelExecutionCallback) {
                    boolean bl = false;
                    this.resultState = FinishState.copy$default(this.resultState, kernelState, null, 2, null);
                    this.onFinishStateUpdate();
                    Unit unit = Unit.INSTANCE;
                    break;
                }
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecuteReply(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JupyterExecutionStatus jupyterExecutionStatus = JupyterExecutionStatusKt.getSafeExecutionStatus(message);
        if (jupyterExecutionStatus == null) {
            jupyterExecutionStatus = JupyterExecutionStatus.ERROR;
        }
        JupyterExecutionStatus executionStatus = jupyterExecutionStatus;
        JupyterFinishKernelExecutionCallback jupyterFinishKernelExecutionCallback = this;
        synchronized (jupyterFinishKernelExecutionCallback) {
            boolean bl = false;
            this.resultState = FinishState.copy$default(this.resultState, null, executionStatus, 1, null);
            this.onFinishStateUpdate();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void onFinishStateUpdate() {
        boolean isBothStatusReceived = this.resultState.isBothStatusReceived();
        if (isBothStatusReceived) {
            JupyterTaskExecutorResult jupyterTaskExecutorResult = this.resultState.getTaskExecutorResult();
            Intrinsics.checkNotNull((Object)jupyterTaskExecutorResult);
            JupyterTaskExecutorResult taskResult = jupyterTaskExecutorResult;
            Job job = this.pendingFinishTimer;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            JupyterFinishKernelExecutionCallback $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterFinishKernelExecutionCallback.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Finish state update received. Set finish result: " + taskResult);
            this.result.complete((Object)taskResult);
            return;
        }
        if (this.pendingFinishTimer != null) {
            return;
        }
        this.pendingFinishTimer = BuildersKt.launch$default((CoroutineScope)this.taskScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ JupyterFinishKernelExecutionCallback this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$thisLogger$iv = $this$launch;
                        $i$f$thisLogger = false;
                        v0 = Logger.getInstance(CoroutineScope.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                        v0.debug("Waiting for finish state update, execution status: " + JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getExecutionStatus() + ", kernel state: " + JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getKernelState());
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v1 = DelayKt.delay((long)3000L, (Continuation)((Continuation)this));
                        if (v1 == var8_3) {
                            return var8_3;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl20:
                        // 2 sources

                        $this$thisLogger$iv = $this$launch;
                        $i$f$thisLogger = false;
                        v2 = Logger.getInstance(CoroutineScope.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                        v2.debug("No finish update available. Set error finish " + JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getExecutionStatus() + ", kernel state: " + JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getKernelState());
                        $i$f$thisLogger = this.this$0;
                        var5_8 = $this$launch;
                        synchronized (var5_8) {
                            $i$a$-synchronized-JupyterFinishKernelExecutionCallback$onFinishStateUpdate$1$isBothStatusReceived$1 = false;
                            $i$a$-synchronized-JupyterFinishKernelExecutionCallback$onFinishStateUpdate$1$isBothStatusReceived$1 = JupyterFinishKernelExecutionCallback.access$getResultState$p($i$f$thisLogger).isBothStatusReceived();
                        }
                        isBothStatusReceived = $i$a$-synchronized-JupyterFinishKernelExecutionCallback$onFinishStateUpdate$1$isBothStatusReceived$1;
                        if (!isBothStatusReceived) {
                            $this$thisLogger$iv = $this$launch;
                            $i$f$thisLogger = false;
                            v3 = Logger.getInstance(CoroutineScope.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                            v3.warn("Finish state update timeout. Execution " + JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getExecutionStatus() + ", kernel state: " + JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getKernelState());
                            v4 = JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getTaskExecutorResult();
                            if (v4 == null) {
                                v4 = JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getKernelResult();
                            }
                        } else {
                            v4 = JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getTaskExecutorResult();
                        }
                        if ((taskResult = v4) == null) {
                            failError = new JupyterTaskExecutorResult.Failed("Execution failed with status: " + JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getExecutionStatus() + " and kernel state: " + JupyterFinishKernelExecutionCallback.access$getResultState$p(this.this$0).getKernelState());
                            v5 = this.this$0.getResult().complete((Object)failError);
                        } else {
                            v5 = this.this$0.getResult().complete((Object)taskResult);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final Unit _init_$lambda$0(JupyterFinishKernelExecutionCallback this$0, Throwable it) {
        Disposer.dispose((Disposable)((Disposable)this$0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FinishState access$getResultState$p(JupyterFinishKernelExecutionCallback $this) {
        return $this.resultState;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/core/kernel/executor/JupyterFinishKernelExecutionCallback$Companion;", "", "<init>", "()V", "WAIT_FOR_EXECUTE_REPLY_TIMEOUT", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jupyter/core/kernel/executor/JupyterFinishKernelExecutionCallback$FinishState;", "", "kernelState", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterKernelState;", "executionStatus", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterKernelState;Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;)V", "getKernelState", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterKernelState;", "getExecutionStatus", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "taskExecutorResult", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutorResult;", "getTaskExecutorResult", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutorResult;", "kernelResult", "getKernelResult", "isBothStatusReceived", "", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.jupyter.core"})
    private static final class FinishState {
        @Nullable
        private final JupyterKernelState kernelState;
        @Nullable
        private final JupyterExecutionStatus executionStatus;
        @Nullable
        private final JupyterTaskExecutorResult taskExecutorResult;
        @Nullable
        private final JupyterTaskExecutorResult kernelResult;

        public FinishState(@Nullable JupyterKernelState kernelState, @Nullable JupyterExecutionStatus executionStatus) {
            this.kernelState = kernelState;
            JupyterExecutionStatus jupyterExecutionStatus = this.executionStatus = executionStatus;
            this.taskExecutorResult = switch (jupyterExecutionStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jupyterExecutionStatus.ordinal()]) {
                case 1 -> JupyterTaskExecutorResult.FinishedSuccessfully.INSTANCE;
                case 2 -> new JupyterTaskExecutorResult.Failed("Execution failed with status: " + this.executionStatus);
                case 3 -> JupyterTaskExecutorResult.Aborted.INSTANCE;
                default -> null;
            };
            JupyterKernelState jupyterKernelState = this.kernelState;
            this.kernelResult = switch (jupyterKernelState == null ? -1 : WhenMappings.$EnumSwitchMapping$1[jupyterKernelState.ordinal()]) {
                case 1 -> JupyterTaskExecutorResult.FinishedSuccessfully.INSTANCE;
                case 2 -> new JupyterTaskExecutorResult.Failed("Kernel execution failed with status: " + this.kernelState);
                case 3 -> null;
                case 4 -> null;
                case -1 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Nullable
        public final JupyterKernelState getKernelState() {
            return this.kernelState;
        }

        @Nullable
        public final JupyterExecutionStatus getExecutionStatus() {
            return this.executionStatus;
        }

        @Nullable
        public final JupyterTaskExecutorResult getTaskExecutorResult() {
            return this.taskExecutorResult;
        }

        @Nullable
        public final JupyterTaskExecutorResult getKernelResult() {
            return this.kernelResult;
        }

        public final boolean isBothStatusReceived() {
            JupyterTaskExecutorResult executorResult = this.taskExecutorResult;
            JupyterTaskExecutorResult kernelResult = this.kernelResult;
            return executorResult != null && kernelResult != null;
        }

        @Nullable
        public final JupyterKernelState component1() {
            return this.kernelState;
        }

        @Nullable
        public final JupyterExecutionStatus component2() {
            return this.executionStatus;
        }

        @NotNull
        public final FinishState copy(@Nullable JupyterKernelState kernelState, @Nullable JupyterExecutionStatus executionStatus) {
            return new FinishState(kernelState, executionStatus);
        }

        public static /* synthetic */ FinishState copy$default(FinishState finishState, JupyterKernelState jupyterKernelState, JupyterExecutionStatus jupyterExecutionStatus, int n, Object object) {
            if ((n & 1) != 0) {
                jupyterKernelState = finishState.kernelState;
            }
            if ((n & 2) != 0) {
                jupyterExecutionStatus = finishState.executionStatus;
            }
            return finishState.copy(jupyterKernelState, jupyterExecutionStatus);
        }

        @NotNull
        public String toString() {
            return "FinishState(kernelState=" + this.kernelState + ", executionStatus=" + this.executionStatus + ")";
        }

        public int hashCode() {
            int result2 = this.kernelState == null ? 0 : this.kernelState.hashCode();
            result2 = result2 * 31 + (this.executionStatus == null ? 0 : this.executionStatus.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FinishState)) {
                return false;
            }
            FinishState finishState = (FinishState)other;
            if (this.kernelState != finishState.kernelState) {
                return false;
            }
            return this.executionStatus == finishState.executionStatus;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[JupyterExecutionStatus.values().length];
                try {
                    nArray[JupyterExecutionStatus.OK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterExecutionStatus.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterExecutionStatus.ABORTED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[JupyterKernelState.values().length];
                try {
                    nArray[JupyterKernelState.IDLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterKernelState.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterKernelState.STARTING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterKernelState.BUSY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterKernelState.values().length];
            try {
                nArray[JupyterKernelState.IDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterKernelState.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterKernelState.STARTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterKernelState.BUSY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

