/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.yaml.reference.provider.value;

import com.intellij.ktor.configurations.meta.key.reference.value.env.EnvVariable;
import com.intellij.ktor.configurations.meta.key.reference.value.env.KtorEnvVariableReference;
import com.intellij.ktor.configurations.meta.key.reference.value.hint.HintReferenceUtilsKt;
import com.intellij.ktor.configurations.yaml.reference.provider.value.reference.env.YamlEnvVariableUtilsKt;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.MicroservicesConfigUtils;
import com.intellij.microservices.jvm.config.hints.NumberHintReferenceBase;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0015J5\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ktor/configurations/yaml/reference/provider/value/KtorYamlValueReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "canHaveMultipleValues", "", "valueElement", "Lorg/jetbrains/yaml/psi/YAMLValue;", "key", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "getMultipleValueReferences", "yamlScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "(Lcom/intellij/microservices/jvm/config/MetaConfigKey;Lorg/jetbrains/yaml/psi/YAMLScalar;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "getSingleValueReferences", "valueRange", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/microservices/jvm/config/MetaConfigKey;Lorg/jetbrains/yaml/psi/YAMLScalar;Lcom/intellij/util/ProcessingContext;Lcom/intellij/openapi/util/TextRange;)[Lcom/intellij/psi/PsiReference;", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorYamlValueReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorYamlValueReferenceProvider.kt\ncom/intellij/ktor/configurations/yaml/reference/provider/value/KtorYamlValueReferenceProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class KtorYamlValueReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        YAMLScalar yamlScalar = element instanceof YAMLScalar ? (YAMLScalar)element : null;
        YAMLKeyValue yamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)yamlScalar), YAMLKeyValue.class);
        if (yamlKeyValue == null || yamlScalar == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Pair<EnvVariable, TextRange> pair = YamlEnvVariableUtilsKt.getEnvVariableAndValueRange(yamlScalar);
        EnvVariable envVariable = (EnvVariable)pair.component1();
        TextRange valueRange = (TextRange)pair.component2();
        EnvVariable envVariable2 = envVariable;
        if (envVariable2 != null) {
            EnvVariable it = envVariable2;
            boolean bl = false;
            PsiReference[] psiReferenceArray = new PsiReference[]{new KtorEnvVariableReference((PsiElement)yamlScalar, it)};
            objectArray = psiReferenceArray;
        } else {
            objectArray = new PsiReference[]{};
        }
        Object[] envVariableReference = objectArray;
        MetaConfigKey metaConfigKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)yamlKeyValue));
        if (metaConfigKey == null) {
            return envVariableReference;
        }
        MetaConfigKey key = metaConfigKey;
        context.put(NumberHintReferenceBase.NUMBER_VALUE_SANITIZER_KEY, (Object)ConfigYamlUtils.getYamlNumberValueSanitizer());
        Object[] references = this.canHaveMultipleValues(yamlKeyValue.getValue(), key) ? this.getMultipleValueReferences(key, yamlScalar, context) : this.getSingleValueReferences(key, yamlScalar, context, valueRange);
        return (PsiReference[])ArraysKt.plus((Object[])references, (Object[])envVariableReference);
    }

    private final boolean canHaveMultipleValues(YAMLValue valueElement, MetaConfigKey key) {
        boolean bl;
        if (valueElement instanceof YAMLSequence) {
            bl = false;
        } else {
            MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
            if (key.isAccessType(accessTypeArray)) {
                bl = false;
            } else {
                accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED};
                if (key.isAccessType(accessTypeArray)) {
                    bl = true;
                } else {
                    PsiType psiType = key.getEffectiveValueType();
                    if (psiType == null) {
                        return false;
                    }
                    PsiType mapValueType = psiType;
                    MetaConfigKey.AccessType mapValueAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)mapValueType);
                    bl = mapValueAccessType == MetaConfigKey.AccessType.INDEXED;
                }
            }
        }
        return bl;
    }

    private final PsiReference[] getMultipleValueReferences(MetaConfigKey key, YAMLScalar yamlScalar, ProcessingContext context) {
        List valueRanges = MicroservicesConfigUtils.getListValueRanges((PsiElement)((PsiElement)yamlScalar));
        PsiElement psiElement = (PsiElement)yamlScalar;
        Intrinsics.checkNotNull((Object)valueRanges);
        return HintReferenceUtilsKt.getValueReferences(key, psiElement, valueRanges, context);
    }

    private final PsiReference[] getSingleValueReferences(MetaConfigKey key, YAMLScalar yamlScalar, ProcessingContext context, TextRange valueRange) {
        return HintReferenceUtilsKt.getValueReferences(key, (PsiElement)yamlScalar, CollectionsKt.listOfNotNull((Object)valueRange), context);
    }
}

