/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.psi.PbSymbolVisibility;
import com.intellij.protobuf.lang.psi.PbVisitor;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class BeforeEdition2024Annotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        PbElement pbElement;
        if (element == null) {
            BeforeEdition2024Annotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            BeforeEdition2024Annotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PbElement) || (pbElement = (PbElement)element).getPbFile().getSyntaxLevel() instanceof SyntaxLevel.Edition && pbElement.getPbFile().getSyntaxLevel().getVersion().compareTo("2024") >= 0) {
            return;
        }
        element.accept((PsiElementVisitor)new PbVisitor(this){

            @Override
            public void visitSymbolVisibility(@NotNull PbSymbolVisibility symbolVisibility) {
                if (symbolVisibility == null) {
                    1.$$$reportNull$$$0(0);
                }
                BeforeEdition2024Annotator.annotateSymbolVisibility(symbolVisibility, holder);
            }

            @Override
            public void visitImportStatement(@NotNull PbImportStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                BeforeEdition2024Annotator.annotateImportStatement(statement, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbolVisibility";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/protobuf/lang/annotation/BeforeEdition2024Annotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSymbolVisibility";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitImportStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void annotateSymbolVisibility(PbSymbolVisibility symbolVisibility, AnnotationHolder holder) {
        if (symbolVisibility != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("editions.2024.symbol.visibility", new Object[0])).range((PsiElement)symbolVisibility).create();
        }
    }

    private static void annotateImportStatement(PbImportStatement statement, AnnotationHolder holder) {
        PsiElement label = statement.getImportLabel();
        if (label != null && statement.isOption()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("editions.2024.option.imports", new Object[0])).range(label).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/protobuf/lang/annotation/BeforeEdition2024Annotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

