/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.liquibase.common.ddl.model.JIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Relation;
import liquibase.structure.core.UniqueConstraint;

public class UnexpectedUniqueConstraintChangeGenerator
extends liquibase.diff.output.changelog.core.UnexpectedUniqueConstraintChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (UniqueConstraint.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        IntellijDatabase intellijDatabase = LiquibaseUtils.getIntellijDatabase(referenceDatabase, comparisonDatabase);
        if (intellijDatabase != null && this.isLegalUniqueConstraint(unexpectedObject, intellijDatabase)) {
            return null;
        }
        return super.fixUnexpected(unexpectedObject, control, referenceDatabase, comparisonDatabase, chain);
    }

    private boolean isLegalUniqueConstraint(DatabaseObject unexpectedObject, IntellijDatabase intellijDatabase) {
        UniqueConstraint uc = (UniqueConstraint)unexpectedObject;
        Relation relation = uc.getRelation();
        if (relation == null) {
            return false;
        }
        OrmEntity ormEntity = intellijDatabase.findOrmEntityByTableName(relation.getName());
        if (ormEntity == null) {
            return false;
        }
        return this.hasUniqueIdxWithTheSameName(intellijDatabase, ormEntity, uc) || UnexpectedUniqueConstraintChangeGenerator.isUniqueConstraintFromEntityAttr(ormEntity, uc);
    }

    public boolean hasUniqueIdxWithTheSameName(IntellijDatabase intellijDatabase, OrmEntity ormEntity, UniqueConstraint uc) {
        String ucName = uc.getName();
        if (StringUtil.isEmpty((String)ucName)) {
            return false;
        }
        LiquibaseGenerator liquibaseGenerator = intellijDatabase.getLiquibaseGenerator();
        List<JIndex> indexes = liquibaseGenerator.generateIndexes(ormEntity);
        return ContainerUtil.or(indexes, jIndex -> ucName.equalsIgnoreCase(jIndex.getName()));
    }

    private static boolean isUniqueConstraintFromEntityAttr(OrmEntity ormEntity, UniqueConstraint uc) {
        List columns = uc.getColumns();
        if (columns == null || columns.size() != 1) {
            return false;
        }
        Entity entity = OrmUtil.INSTANCE.getEntityByOrmEntity(ormEntity);
        if (entity == null) {
            return false;
        }
        EntityAttribute attribute = entity.getAttributeByColumnName(((Column)columns.get(0)).getName(), true);
        return attribute != null && attribute.isUnique();
    }
}

