/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.inspection;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.fus.PackageCheckerUsageStat;
import com.intellij.packageChecker.inspection.AbstractLocalLibrariesInspection;
import com.intellij.packageChecker.inspection.MaliciousLibrariesUtilsKt;
import com.intellij.packageChecker.inspection.problemDescriptor.LocalProblemDescriptorBuilder;
import com.intellij.packageChecker.inspection.problemDescriptor.ProblemDescriptorsHolder;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.service.Malicious;
import com.intellij.packageChecker.service.PackageChecker;
import com.intellij.packageChecker.service.PackageService;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0005H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/packageChecker/inspection/MaliciousLibrariesLocalInspection;", "Lcom/intellij/packageChecker/inspection/AbstractLocalLibrariesInspection;", "<init>", "()V", "collectProblemDescriptors", "Lcom/intellij/packageChecker/inspection/problemDescriptor/ProblemDescriptorsHolder;", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "service", "Lcom/intellij/packageChecker/service/PackageService;", "isHeadlessMode", "", "reportStatistics", "", "problemDescriptors", "intellij.packageChecker"})
public final class MaliciousLibrariesLocalInspection
extends AbstractLocalLibrariesInspection {
    @Override
    @NotNull
    public ProblemDescriptorsHolder collectProblemDescriptors(@NotNull PsiFile file, @NotNull Project project, @NotNull Module module, @NotNull PackageService service, boolean isHeadlessMode) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Map<Package, PackageDeclaration> declaredDependencies = MaliciousLibrariesUtilsKt.getDeclaredDependencies(file, service);
        PackageChecker packageChecker = PackageChecker.Companion.getInstance(project);
        List<Malicious> maliciousPackages = MaliciousLibrariesUtilsKt.findMaliciousPackages(declaredDependencies, packageChecker);
        String moduleModelId = MaliciousLibrariesUtilsKt.getModuleId(file, project);
        String string = this.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        LocalProblemDescriptorBuilder descriptorBuilder = new LocalProblemDescriptorBuilder(file, declaredDependencies, service, isHeadlessMode, module, moduleModelId, string);
        ProblemDescriptorsHolder problemDescriptorsHolder = descriptorBuilder.descriptorsForMalicious(maliciousPackages);
        return problemDescriptorsHolder;
    }

    @Override
    protected void reportStatistics(@NotNull Project project, @NotNull ProblemDescriptorsHolder problemDescriptors) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)problemDescriptors, (String)"problemDescriptors");
        PackageCheckerUsageStat.INSTANCE.getLocalInspectionResultMalicious().log(project, (Object)problemDescriptors.getDirectProblemDescriptors().size());
        PackageCheckerUsageStat.INSTANCE.getLocalInspectionResultTransitiveMalicious().log(project, (Object)problemDescriptors.getTransitiveProblemDescriptors().size());
    }
}

