/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TeamCityLogger {
    private static final Logger LOG = Logger.getInstance(TeamCityLogger.class);
    public static final boolean isUnderTC = System.getenv("TEAMCITY_VERSION") != null;
    @Nullable
    public static final String currentBuildUrl = System.getenv("BUILD_URL");

    private TeamCityLogger() {
    }

    private static File reportFile() {
        return new File(PathManager.getHomePath() + "/reports/report.txt");
    }

    public static void info(@NotNull String message) {
        if (message == null) {
            TeamCityLogger.$$$reportNull$$$0(0);
        }
        if (isUnderTC) {
            TeamCityLogger.tcLog(message, null);
        } else {
            LOG.info(message);
        }
    }

    public static void warning(@NotNull String message) {
        if (message == null) {
            TeamCityLogger.$$$reportNull$$$0(1);
        }
        TeamCityLogger.warning(message, new Throwable());
    }

    public static void warning(@NotNull String message, @Nullable Throwable throwable) {
        if (message == null) {
            TeamCityLogger.$$$reportNull$$$0(2);
        }
        if (isUnderTC) {
            TeamCityLogger.tcLog(message, "WARNING");
        } else {
            LOG.warn(message, throwable);
        }
    }

    public static void error(@NotNull String message) {
        if (message == null) {
            TeamCityLogger.$$$reportNull$$$0(3);
        }
        TeamCityLogger.error(message, new Throwable());
    }

    public static void error(@NotNull String message, @Nullable Throwable throwable) {
        if (message == null) {
            TeamCityLogger.$$$reportNull$$$0(4);
        }
        if (isUnderTC) {
            TeamCityLogger.tcLog(message, "ERROR");
        } else {
            LOG.error(message, throwable);
        }
    }

    private static void tcLog(@NotNull String message, String level) {
        if (message == null) {
            TeamCityLogger.$$$reportNull$$$0(5);
        }
        if (((String)message).isEmpty()) {
            return;
        }
        try {
            while (((String)message).charAt(0) == '\n') {
                message = ((String)message).substring(1);
            }
            if (level != null) {
                message = level + ": " + (String)message;
            }
            if (!((String)message).endsWith("\n")) {
                message = (String)message + "\n";
            }
            FileUtil.appendToFile((File)TeamCityLogger.reportFile(), (String)message);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static <T extends Throwable> void block(@NotNull String caption, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (caption == null) {
            TeamCityLogger.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            TeamCityLogger.$$$reportNull$$$0(7);
        }
        if (isUnderTC) {
            TeamCityLogger.block(caption, () -> {
                runnable.run();
                return null;
            });
        } else {
            runnable.run();
        }
    }

    public static void publishArtifact(@NotNull Path artifactPath, @Nullable String artifactName) {
        if (artifactPath == null) {
            TeamCityLogger.$$$reportNull$$$0(8);
        }
        Object suffix = artifactName != null ? "=>" + artifactName : "";
        System.out.println("##teamcity[publishArtifacts '" + TeamCityLogger.escapeTeamcityServiceMessage(artifactPath.toString()) + (String)suffix + "']");
    }

    public static <R, T extends Throwable> R block(@NotNull String caption, @NotNull ThrowableComputable<R, T> computable) throws T {
        if (caption == null) {
            TeamCityLogger.$$$reportNull$$$0(9);
        }
        if (computable == null) {
            TeamCityLogger.$$$reportNull$$$0(10);
        }
        if (!isUnderTC) {
            return (R)computable.compute();
        }
        caption = TeamCityLogger.escapeTeamcityServiceMessage(caption);
        System.out.flush();
        System.out.println("##teamcity[blockOpened name='" + caption + "']");
        System.out.flush();
        try {
            Object object = computable.compute();
            return (R)object;
        }
        finally {
            System.out.flush();
            System.out.println("##teamcity[blockClosed name='" + caption + "']");
            System.out.flush();
        }
    }

    @NotNull
    private static String escapeTeamcityServiceMessage(@NotNull String s) {
        if (s == null) {
            TeamCityLogger.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char escape;
            char ch = s.charAt(i2);
            switch (ch) {
                case '\n': {
                    char c = 'n';
                    break;
                }
                case '\r': {
                    char c = 'r';
                    break;
                }
                case '\'': 
                case '[': 
                case ']': 
                case '|': {
                    char c = ch;
                    break;
                }
                default: {
                    char c = escape = '\u0000';
                }
            }
            if (escape != '\u0000') {
                sb.append('|').append(escape);
                continue;
            }
            if (ch < ' ' || ch >= '\u007f') {
                sb.append(String.format("0x%04x", (short)ch));
                continue;
            }
            sb.append(ch);
        }
        String string = sb.toString();
        if (string == null) {
            TeamCityLogger.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/TeamCityLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/TeamCityLogger";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeTeamcityServiceMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "warning";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tcLog";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "block";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "publishArtifact";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escapeTeamcityServiceMessage";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

