/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile.providers;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.inspectionProfile.YamlInspectionProfileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.util.PlatformUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileProvider;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaToolRegistrar;
import org.jetbrains.qodana.staticAnalysis.profile.providers.QodanaEmbeddedProfile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/providers/QodanaEmbeddedProfilesProvider;", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfileProvider;", "<init>", "()V", "provideProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "profileName", "", "project", "Lcom/intellij/openapi/project/Project;", "getAllProfileNames", "", "getInputStreamForProfile", "Ljava/io/InputStream;", "embeddedProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/providers/QodanaEmbeddedProfile;", "getProfileResourceName", "createResourceStream", "profileFilename", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaEmbeddedProfilesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaEmbeddedProfilesProvider.kt\norg/jetbrains/qodana/staticAnalysis/profile/providers/QodanaEmbeddedProfilesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n295#2,2:88\n774#2:90\n865#2,2:91\n1563#2:93\n1634#2,3:94\n*S KotlinDebug\n*F\n+ 1 QodanaEmbeddedProfilesProvider.kt\norg/jetbrains/qodana/staticAnalysis/profile/providers/QodanaEmbeddedProfilesProvider\n*L\n29#1:88,2\n51#1:90\n51#1:91,2\n51#1:93\n51#1:94,3\n*E\n"})
public final class QodanaEmbeddedProfilesProvider
implements QodanaInspectionProfileProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public QodanaInspectionProfile provideProfile(@NotNull String profileName, @Nullable Project project) {
        Object v0;
        block14: {
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            Iterable $this$firstOrNull$iv = (Iterable)QodanaEmbeddedProfile.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                QodanaEmbeddedProfile it = (QodanaEmbeddedProfile)((Object)element$iv);
                boolean bl = false;
                if (!it.matchesName(profileName)) continue;
                v0 = element$iv;
                break block14;
            }
            v0 = null;
        }
        QodanaEmbeddedProfile qodanaEmbeddedProfile = v0;
        if (qodanaEmbeddedProfile == null) {
            return null;
        }
        QodanaEmbeddedProfile embeddedProfile = qodanaEmbeddedProfile;
        QodanaInspectionProfileManager profileManager = QodanaInspectionProfileManager.Companion.getInstance(project);
        Closeable closeable = this.getInputStreamForProfile(embeddedProfile);
        Throwable throwable = null;
        try {
            InputStream profileStream = (InputStream)closeable;
            boolean bl = false;
            if (embeddedProfile.isYaml()) {
                InspectionProfileImpl inspectionProfileImpl;
                Closeable closeable2 = new InputStreamReader(profileStream);
                Throwable throwable2 = null;
                try {
                    InputStreamReader reader = (InputStreamReader)closeable2;
                    boolean bl2 = false;
                    inspectionProfileImpl = YamlInspectionProfileImpl.Companion.loadFrom((Reader)reader, arg_0 -> QodanaEmbeddedProfilesProvider.provideProfile$lambda$1$0$0(this, arg_0), (InspectionToolsSupplier)QodanaToolRegistrar.Companion.getInstance(project), (BaseInspectionProfileManager)profileManager).buildEffectiveProfile();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                InspectionProfileImpl yamlProfile = inspectionProfileImpl;
                String string = yamlProfile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                QodanaInspectionProfile qodanaInspectionProfile = QodanaInspectionProfile.Companion.clone(yamlProfile, string, profileManager);
                return qodanaInspectionProfile;
            }
            Element element = JDOMUtil.load((InputStream)profileStream);
            Intrinsics.checkNotNull((Object)element);
            QodanaInspectionProfile qodanaInspectionProfile = QodanaInspectionProfile.Companion.newFromXml(element, embeddedProfile.getProfileName(), profileManager);
            return qodanaInspectionProfile;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getAllProfileNames(@Nullable Project project) {
        void $this$mapTo$iv$iv;
        QodanaEmbeddedProfile it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)QodanaEmbeddedProfile.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (QodanaEmbeddedProfile)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.isYaml()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (QodanaEmbeddedProfile)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProfileName());
        }
        return (List)destination$iv$iv;
    }

    @VisibleForTesting
    @NotNull
    public final InputStream getInputStreamForProfile(@NotNull QodanaEmbeddedProfile embeddedProfile) {
        Intrinsics.checkNotNullParameter((Object)((Object)embeddedProfile), (String)"embeddedProfile");
        String profileFilename = this.getProfileResourceName(embeddedProfile);
        return this.createResourceStream(profileFilename);
    }

    private final String getProfileResourceName(QodanaEmbeddedProfile embeddedProfile) {
        return switch (WhenMappings.$EnumSwitchMapping$0[embeddedProfile.ordinal()]) {
            case 1 -> "qodana.recommended.full.xml";
            case 2 -> "qodana.starter.full.xml";
            case 3 -> "qodana.sanity.yaml";
            case 4 -> {
                if (PlatformUtils.isWebStorm() || PlatformUtils.isPhpStorm()) {
                    yield "qodana-js.starter.yaml";
                }
                if (PlatformUtils.isRider()) {
                    yield "qodana-dotnet.starter.yaml";
                }
                yield "qodana.starter.yaml";
            }
            case 5 -> {
                if (PlatformUtils.isWebStorm() || PlatformUtils.isPhpStorm()) {
                    yield "qodana-js.recommended.yaml";
                }
                if (PlatformUtils.isRider()) {
                    yield "qodana-dotnet.recommended.yaml";
                }
                yield "qodana.recommended.yaml";
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final InputStream createResourceStream(String profileFilename) {
        InputStream inputStream = this.getClass().getResourceAsStream("/qodana-profiles/.idea/inspectionProfiles/" + profileFilename);
        if (inputStream == null) {
            throw new QodanaException("Cannot find file profile file " + profileFilename + " in resources");
        }
        return inputStream;
    }

    private static final Reader provideProfile$lambda$1$0$0(QodanaEmbeddedProfilesProvider this$0, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new InputStreamReader(this$0.createResourceStream(((Object)path).toString()));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QodanaEmbeddedProfile.values().length];
            try {
                nArray[QodanaEmbeddedProfile.QODANA_RECOMMENDED_OLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaEmbeddedProfile.QODANA_STARTER_OLD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaEmbeddedProfile.QODANA_SANITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaEmbeddedProfile.QODANA_STARTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaEmbeddedProfile.QODANA_RECOMMENDED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

