/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import org.jetbrains.annotations.NotNull;

public final class FreeMarkerEnterHandler
implements EnterHandlerDelegate {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            FreeMarkerEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FreeMarkerEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            FreeMarkerEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            FreeMarkerEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            FreeMarkerEnterHandler.$$$reportNull$$$0(4);
        }
        if (!(file instanceof FtlFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int offset = (Integer)caretOffset.get();
        if (offset <= 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement at = file.findElementAt(offset);
        if (at == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement prev = file.findElementAt(offset - 1);
        if (prev == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if ((FreeMarkerEnterHandler.isOfType(at, FtlElementTypes.END_DIRECTIVE_START) || FreeMarkerEnterHandler.isOfType(at, FtlElementTypes.END_MACRO_START)) && FreeMarkerEnterHandler.isOfType(prev, FtlElementTypes.DIRECTIVE_END)) {
            originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
            editor.getCaretModel().moveToOffset(offset);
            originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
            int indentSize = CodeStyle.getSettings((PsiFile)file).getIndentSize(file.getFileType());
            String indentText = IndentHelperImpl.fillIndent((CommonCodeStyleSettings.IndentOptions)CodeStyle.getIndentOptions((PsiFile)file), (int)indentSize);
            editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)indentText);
            editor.getCaretModel().moveCaretRelatively(indentSize, 0, false, false, true);
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isOfType(@NotNull PsiElement at, FtlTokenType type) {
        ASTNode node;
        if (at == null) {
            FreeMarkerEnterHandler.$$$reportNull$$$0(5);
        }
        return (node = at.getNode()) != null && node.getElementType() == type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
        }
        objectArray2[1] = "com/intellij/freemarker/editorActions/FreeMarkerEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isOfType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

