/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedDataBuilder;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.stubs.impl.JSTypeHolderOwner;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFunctionCachedData
implements JSTypeHolderOwner {
    public static final JSFunctionCachedData EMPTY = new JSFunctionCachedData();
    private static final BooleanStructureElement REFERENCES_ARGUMENTS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement REFERENCES_THIS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement CONSTRUCTOR_CAN_BE_INVOKED_WITHOUT_NEW_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_OVERRIDE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement RETURN_TYPE_STRICT_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_RETURN_TYPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_EXPLICITLY_DECLARED_RETURN_TYPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_TYPE_FROM_JSDOC_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(REFERENCES_ARGUMENTS_FLAG, REFERENCES_THIS_FLAG, CONSTRUCTOR_CAN_BE_INVOKED_WITHOUT_NEW_FLAG, IS_OVERRIDE_FLAG, HAS_RETURN_TYPE_FLAG, HAS_EXPLICITLY_DECLARED_RETURN_TYPE_FLAG, RETURN_TYPE_STRICT_FLAG, IS_TYPE_FROM_JSDOC_FLAG);
    private final int myFlags;
    @Nullable
    private final JSStubElementTypeHolder myReturnTypeHolder;

    public JSFunctionCachedData(@NotNull JSFunctionBaseImpl psi) {
        if (psi == null) {
            JSFunctionCachedData.$$$reportNull$$$0(0);
        }
        JSFunctionCachedDataBuilder builder = psi.getCachedDataBuilder();
        int flags = 0;
        flags = JSFunctionCachedData.writeFlag(REFERENCES_ARGUMENTS_FLAG, builder.referencesArguments, flags);
        flags = JSFunctionCachedData.writeFlag(REFERENCES_THIS_FLAG, builder.referencesThis, flags);
        flags = JSFunctionCachedData.writeFlag(CONSTRUCTOR_CAN_BE_INVOKED_WITHOUT_NEW_FLAG, builder.constructorCanBeInvokedWithoutNew, flags);
        flags = JSFunctionCachedData.writeFlag(IS_OVERRIDE_FLAG, builder.overrides, flags);
        JSType type = builder.returnTypeToSerialize;
        flags = JSFunctionCachedData.writeFlag(HAS_RETURN_TYPE_FLAG, type != null, flags);
        flags = JSFunctionCachedData.writeFlag(HAS_EXPLICITLY_DECLARED_RETURN_TYPE_FLAG, psi.initHasExplicitlyDeclaredReturnType(builder), flags);
        flags = JSFunctionCachedData.writeFlag(RETURN_TYPE_STRICT_FLAG, type != null && type.isSourceStrict(), flags);
        this.myFlags = flags = JSFunctionCachedData.writeFlag(IS_TYPE_FROM_JSDOC_FLAG, JSDocComment.isAstBasedTypeFromJSDoc(type), flags);
        this.myReturnTypeHolder = JSStubElementTypeHolder.fromJSType(type);
    }

    public JSFunctionCachedData(@NotNull DataInput in) throws IOException {
        if (in == null) {
            JSFunctionCachedData.$$$reportNull$$$0(1);
        }
        this.myFlags = DataInputOutputUtil.readINT((DataInput)in);
        this.myReturnTypeHolder = this.readFlag(HAS_RETURN_TYPE_FLAG) != false ? JSStubElementTypeHolder.fromDataStream(in) : null;
    }

    private JSFunctionCachedData() {
        this.myFlags = 0;
        this.myReturnTypeHolder = null;
    }

    public void save(@NotNull DataOutput out) throws IOException {
        if (out == null) {
            JSFunctionCachedData.$$$reportNull$$$0(2);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myFlags);
        if (this.readFlag(HAS_RETURN_TYPE_FLAG).booleanValue()) {
            JSStubElementTypeHolder.serialize(Objects.requireNonNull(this.myReturnTypeHolder), out);
        }
    }

    @Nullable
    public JSType getReturnType(@NotNull JSFunction function) {
        if (function == null) {
            JSFunctionCachedData.$$$reportNull$$$0(3);
        }
        if (this.myReturnTypeHolder == null) {
            return null;
        }
        return this.myReturnTypeHolder.getTypeOrFromSerialized(function, this.readFlag(IS_TYPE_FROM_JSDOC_FLAG), this.readFlag(RETURN_TYPE_STRICT_FLAG));
    }

    private <T> T readFlag(FlagsStructureElement<T> structureElement) {
        return IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, structureElement, this.myFlags);
    }

    public boolean isOverride() {
        return this.readFlag(IS_OVERRIDE_FLAG);
    }

    public boolean isReferencesArguments() {
        return this.readFlag(REFERENCES_ARGUMENTS_FLAG);
    }

    public boolean constructorCanBeInvokedWithoutNew() {
        return this.readFlag(CONSTRUCTOR_CAN_BE_INVOKED_WITHOUT_NEW_FLAG);
    }

    public boolean referencesThis() {
        return this.readFlag(REFERENCES_THIS_FLAG);
    }

    public boolean hasExplicitlyDeclaredReturnType() {
        return this.readFlag(HAS_EXPLICITLY_DECLARED_RETURN_TYPE_FLAG);
    }

    @Override
    @Nullable
    public JSStubElementTypeHolder getJSTypeHolder() {
        return this.myReturnTypeHolder;
    }

    private static <T> int writeFlag(FlagsStructureElement<T> structureElement, T value, int flags) {
        return IntFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, structureElement, value, flags);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionCachedData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getReturnType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum ReferenceStatus {
        Read,
        Write;

    }
}

