// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package codegurusecurityiface provides an interface to enable mocking the Amazon CodeGuru Security service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package codegurusecurityiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/codegurusecurity"
)

// CodeGuruSecurityAPI provides an interface to enable mocking the
// codegurusecurity.CodeGuruSecurity service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon CodeGuru Security.
//	func myFunc(svc codegurusecurityiface.CodeGuruSecurityAPI) bool {
//	    // Make svc.BatchGetFindings request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := codegurusecurity.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockCodeGuruSecurityClient struct {
//	    codegurusecurityiface.CodeGuruSecurityAPI
//	}
//	func (m *mockCodeGuruSecurityClient) BatchGetFindings(input *codegurusecurity.BatchGetFindingsInput) (*codegurusecurity.BatchGetFindingsOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockCodeGuruSecurityClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type CodeGuruSecurityAPI interface {
	BatchGetFindings(*codegurusecurity.BatchGetFindingsInput) (*codegurusecurity.BatchGetFindingsOutput, error)
	BatchGetFindingsWithContext(aws.Context, *codegurusecurity.BatchGetFindingsInput, ...request.Option) (*codegurusecurity.BatchGetFindingsOutput, error)
	BatchGetFindingsRequest(*codegurusecurity.BatchGetFindingsInput) (*request.Request, *codegurusecurity.BatchGetFindingsOutput)

	CreateScan(*codegurusecurity.CreateScanInput) (*codegurusecurity.CreateScanOutput, error)
	CreateScanWithContext(aws.Context, *codegurusecurity.CreateScanInput, ...request.Option) (*codegurusecurity.CreateScanOutput, error)
	CreateScanRequest(*codegurusecurity.CreateScanInput) (*request.Request, *codegurusecurity.CreateScanOutput)

	CreateUploadUrl(*codegurusecurity.CreateUploadUrlInput) (*codegurusecurity.CreateUploadUrlOutput, error)
	CreateUploadUrlWithContext(aws.Context, *codegurusecurity.CreateUploadUrlInput, ...request.Option) (*codegurusecurity.CreateUploadUrlOutput, error)
	CreateUploadUrlRequest(*codegurusecurity.CreateUploadUrlInput) (*request.Request, *codegurusecurity.CreateUploadUrlOutput)

	GetAccountConfiguration(*codegurusecurity.GetAccountConfigurationInput) (*codegurusecurity.GetAccountConfigurationOutput, error)
	GetAccountConfigurationWithContext(aws.Context, *codegurusecurity.GetAccountConfigurationInput, ...request.Option) (*codegurusecurity.GetAccountConfigurationOutput, error)
	GetAccountConfigurationRequest(*codegurusecurity.GetAccountConfigurationInput) (*request.Request, *codegurusecurity.GetAccountConfigurationOutput)

	GetFindings(*codegurusecurity.GetFindingsInput) (*codegurusecurity.GetFindingsOutput, error)
	GetFindingsWithContext(aws.Context, *codegurusecurity.GetFindingsInput, ...request.Option) (*codegurusecurity.GetFindingsOutput, error)
	GetFindingsRequest(*codegurusecurity.GetFindingsInput) (*request.Request, *codegurusecurity.GetFindingsOutput)

	GetFindingsPages(*codegurusecurity.GetFindingsInput, func(*codegurusecurity.GetFindingsOutput, bool) bool) error
	GetFindingsPagesWithContext(aws.Context, *codegurusecurity.GetFindingsInput, func(*codegurusecurity.GetFindingsOutput, bool) bool, ...request.Option) error

	GetMetricsSummary(*codegurusecurity.GetMetricsSummaryInput) (*codegurusecurity.GetMetricsSummaryOutput, error)
	GetMetricsSummaryWithContext(aws.Context, *codegurusecurity.GetMetricsSummaryInput, ...request.Option) (*codegurusecurity.GetMetricsSummaryOutput, error)
	GetMetricsSummaryRequest(*codegurusecurity.GetMetricsSummaryInput) (*request.Request, *codegurusecurity.GetMetricsSummaryOutput)

	GetScan(*codegurusecurity.GetScanInput) (*codegurusecurity.GetScanOutput, error)
	GetScanWithContext(aws.Context, *codegurusecurity.GetScanInput, ...request.Option) (*codegurusecurity.GetScanOutput, error)
	GetScanRequest(*codegurusecurity.GetScanInput) (*request.Request, *codegurusecurity.GetScanOutput)

	ListFindingsMetrics(*codegurusecurity.ListFindingsMetricsInput) (*codegurusecurity.ListFindingsMetricsOutput, error)
	ListFindingsMetricsWithContext(aws.Context, *codegurusecurity.ListFindingsMetricsInput, ...request.Option) (*codegurusecurity.ListFindingsMetricsOutput, error)
	ListFindingsMetricsRequest(*codegurusecurity.ListFindingsMetricsInput) (*request.Request, *codegurusecurity.ListFindingsMetricsOutput)

	ListFindingsMetricsPages(*codegurusecurity.ListFindingsMetricsInput, func(*codegurusecurity.ListFindingsMetricsOutput, bool) bool) error
	ListFindingsMetricsPagesWithContext(aws.Context, *codegurusecurity.ListFindingsMetricsInput, func(*codegurusecurity.ListFindingsMetricsOutput, bool) bool, ...request.Option) error

	ListScans(*codegurusecurity.ListScansInput) (*codegurusecurity.ListScansOutput, error)
	ListScansWithContext(aws.Context, *codegurusecurity.ListScansInput, ...request.Option) (*codegurusecurity.ListScansOutput, error)
	ListScansRequest(*codegurusecurity.ListScansInput) (*request.Request, *codegurusecurity.ListScansOutput)

	ListScansPages(*codegurusecurity.ListScansInput, func(*codegurusecurity.ListScansOutput, bool) bool) error
	ListScansPagesWithContext(aws.Context, *codegurusecurity.ListScansInput, func(*codegurusecurity.ListScansOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*codegurusecurity.ListTagsForResourceInput) (*codegurusecurity.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *codegurusecurity.ListTagsForResourceInput, ...request.Option) (*codegurusecurity.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*codegurusecurity.ListTagsForResourceInput) (*request.Request, *codegurusecurity.ListTagsForResourceOutput)

	TagResource(*codegurusecurity.TagResourceInput) (*codegurusecurity.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *codegurusecurity.TagResourceInput, ...request.Option) (*codegurusecurity.TagResourceOutput, error)
	TagResourceRequest(*codegurusecurity.TagResourceInput) (*request.Request, *codegurusecurity.TagResourceOutput)

	UntagResource(*codegurusecurity.UntagResourceInput) (*codegurusecurity.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *codegurusecurity.UntagResourceInput, ...request.Option) (*codegurusecurity.UntagResourceOutput, error)
	UntagResourceRequest(*codegurusecurity.UntagResourceInput) (*request.Request, *codegurusecurity.UntagResourceOutput)

	UpdateAccountConfiguration(*codegurusecurity.UpdateAccountConfigurationInput) (*codegurusecurity.UpdateAccountConfigurationOutput, error)
	UpdateAccountConfigurationWithContext(aws.Context, *codegurusecurity.UpdateAccountConfigurationInput, ...request.Option) (*codegurusecurity.UpdateAccountConfigurationOutput, error)
	UpdateAccountConfigurationRequest(*codegurusecurity.UpdateAccountConfigurationInput) (*request.Request, *codegurusecurity.UpdateAccountConfigurationOutput)
}

var _ CodeGuruSecurityAPI = (*codegurusecurity.CodeGuruSecurity)(nil)
