/*
  Copyright(C) 2013  Kouhei Sutou <kou@clear-code.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; version 2
  of the License.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
  MA 02110-1335  USA

  This file uses normalization table defined in
  mysql-5.6.23/strings/ctype-utf8.c.
  The following is the header of the file:

    Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; version 2
    of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
    MA 02110-1335  USA

    UTF8 according RFC 2279
    Written by Alexander Barkov <bar@udm.net>
*/

#ifndef MYSQL_UTF8_H
#define MYSQL_UTF8_H

#include <stdint.h>

static uint32_t general_ci_page_00[] = {
  0x00000, 0x00001, 0x00002, 0x00003, 0x00004, 0x00005, 0x00006, 0x00007,
  0x00008, 0x00009, 0x0000a, 0x0000b, 0x0000c, 0x0000d, 0x0000e, 0x0000f,
  0x00010, 0x00011, 0x00012, 0x00013, 0x00014, 0x00015, 0x00016, 0x00017,
  0x00018, 0x00019, 0x0001a, 0x0001b, 0x0001c, 0x0001d, 0x0001e, 0x0001f,
  0x00020, 0x00021, 0x00022, 0x00023, 0x00024, 0x00025, 0x00026, 0x00027,
  0x00028, 0x00029, 0x0002a, 0x0002b, 0x0002c, 0x0002d, 0x0002e, 0x0002f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0003a, 0x0003b, 0x0003c, 0x0003d, 0x0003e, 0x0003f,
  0x00040, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0005b, 0x0005c, 0x0005d, 0x0005e, 0x0005f,
  0x00060, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0007b, 0x0007c, 0x0007d, 0x0007e, 0x0007f,
  0x00080, 0x00081, 0x00082, 0x00083, 0x00084, 0x00085, 0x00086, 0x00087,
  0x00088, 0x00089, 0x0008a, 0x0008b, 0x0008c, 0x0008d, 0x0008e, 0x0008f,
  0x00090, 0x00091, 0x00092, 0x00093, 0x00094, 0x00095, 0x00096, 0x00097,
  0x00098, 0x00099, 0x0009a, 0x0009b, 0x0009c, 0x0009d, 0x0009e, 0x0009f,
  0x000a0, 0x000a1, 0x000a2, 0x000a3, 0x000a4, 0x000a5, 0x000a6, 0x000a7,
  0x000a8, 0x000a9, 0x000aa, 0x000ab, 0x000ac, 0x000ad, 0x000ae, 0x000af,
  0x000b0, 0x000b1, 0x000b2, 0x000b3, 0x000b4, 0x0039c, 0x000b6, 0x000b7,
  0x000b8, 0x000b9, 0x000ba, 0x000bb, 0x000bc, 0x000bd, 0x000be, 0x000bf,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x000c6, 0x00043,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00049, 0x00049, 0x00049, 0x00049,
  0x000d0, 0x0004e, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x000d7,
  0x000d8, 0x00055, 0x00055, 0x00055, 0x00055, 0x00059, 0x000de, 0x00053,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x000c6, 0x00043,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00049, 0x00049, 0x00049, 0x00049,
  0x000d0, 0x0004e, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x000f7,
  0x000d8, 0x00055, 0x00055, 0x00055, 0x00055, 0x00059, 0x000de, 0x00059
};

static uint32_t general_ci_page_01[] = {
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00043, 0x00043,
  0x00043, 0x00043, 0x00043, 0x00043, 0x00043, 0x00043, 0x00044, 0x00044,
  0x00110, 0x00110, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00047, 0x00047, 0x00047, 0x00047,
  0x00047, 0x00047, 0x00047, 0x00047, 0x00048, 0x00048, 0x00126, 0x00126,
  0x00049, 0x00049, 0x00049, 0x00049, 0x00049, 0x00049, 0x00049, 0x00049,
  0x00049, 0x00049, 0x00132, 0x00132, 0x0004a, 0x0004a, 0x0004b, 0x0004b,
  0x00138, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0013f,
  0x0013f, 0x00141, 0x00141, 0x0004e, 0x0004e, 0x0004e, 0x0004e, 0x0004e,
  0x0004e, 0x00149, 0x0014a, 0x0014a, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x00152, 0x00152, 0x00052, 0x00052, 0x00052, 0x00052,
  0x00052, 0x00052, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053,
  0x00053, 0x00053, 0x00054, 0x00054, 0x00054, 0x00054, 0x00166, 0x00166,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00057, 0x00057, 0x00059, 0x00059,
  0x00059, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x00053,
  0x00180, 0x00181, 0x00182, 0x00182, 0x00184, 0x00184, 0x00186, 0x00187,
  0x00187, 0x00189, 0x0018a, 0x0018b, 0x0018b, 0x0018d, 0x0018e, 0x0018f,
  0x00190, 0x00191, 0x00191, 0x00193, 0x00194, 0x001f6, 0x00196, 0x00197,
  0x00198, 0x00198, 0x0019a, 0x0019b, 0x0019c, 0x0019d, 0x0019e, 0x0019f,
  0x0004f, 0x0004f, 0x001a2, 0x001a2, 0x001a4, 0x001a4, 0x001a6, 0x001a7,
  0x001a7, 0x001a9, 0x001aa, 0x001ab, 0x001ac, 0x001ac, 0x001ae, 0x00055,
  0x00055, 0x001b1, 0x001b2, 0x001b3, 0x001b3, 0x001b5, 0x001b5, 0x001b7,
  0x001b8, 0x001b8, 0x001ba, 0x001bb, 0x001bc, 0x001bc, 0x001be, 0x001f7,
  0x001c0, 0x001c1, 0x001c2, 0x001c3, 0x001c4, 0x001c4, 0x001c4, 0x001c7,
  0x001c7, 0x001c7, 0x001ca, 0x001ca, 0x001ca, 0x00041, 0x00041, 0x00049,
  0x00049, 0x0004f, 0x0004f, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x0018e, 0x00041, 0x00041,
  0x00041, 0x00041, 0x000c6, 0x000c6, 0x001e4, 0x001e4, 0x00047, 0x00047,
  0x0004b, 0x0004b, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x001b7, 0x001b7,
  0x0004a, 0x001f1, 0x001f1, 0x001f1, 0x00047, 0x00047, 0x001f6, 0x001f7,
  0x0004e, 0x0004e, 0x00041, 0x00041, 0x000c6, 0x000c6, 0x000d8, 0x000d8
};

static uint32_t general_ci_page_02[] = {
  0x00041, 0x00041, 0x00041, 0x00041, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00049, 0x00049, 0x00049, 0x00049, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x00052, 0x00052, 0x00052, 0x00052, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00053, 0x00053, 0x00054, 0x00054, 0x0021c, 0x0021c, 0x00048, 0x00048,
  0x00220, 0x00221, 0x00222, 0x00222, 0x00224, 0x00224, 0x00041, 0x00041,
  0x00045, 0x00045, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x00059, 0x00059, 0x00234, 0x00235, 0x00236, 0x00237,
  0x00238, 0x00239, 0x0023a, 0x0023b, 0x0023c, 0x0023d, 0x0023e, 0x0023f,
  0x00240, 0x00241, 0x00242, 0x00243, 0x00244, 0x00245, 0x00246, 0x00247,
  0x00248, 0x00249, 0x0024a, 0x0024b, 0x0024c, 0x0024d, 0x0024e, 0x0024f,
  0x00250, 0x00251, 0x00252, 0x00181, 0x00186, 0x00255, 0x00189, 0x0018a,
  0x00258, 0x0018f, 0x0025a, 0x00190, 0x0025c, 0x0025d, 0x0025e, 0x0025f,
  0x00193, 0x00261, 0x00262, 0x00194, 0x00264, 0x00265, 0x00266, 0x00267,
  0x00197, 0x00196, 0x0026a, 0x0026b, 0x0026c, 0x0026d, 0x0026e, 0x0019c,
  0x00270, 0x00271, 0x0019d, 0x00273, 0x00274, 0x0019f, 0x00276, 0x00277,
  0x00278, 0x00279, 0x0027a, 0x0027b, 0x0027c, 0x0027d, 0x0027e, 0x0027f,
  0x001a6, 0x00281, 0x00282, 0x001a9, 0x00284, 0x00285, 0x00286, 0x00287,
  0x001ae, 0x00289, 0x001b1, 0x001b2, 0x0028c, 0x0028d, 0x0028e, 0x0028f,
  0x00290, 0x00291, 0x001b7, 0x00293, 0x00294, 0x00295, 0x00296, 0x00297,
  0x00298, 0x00299, 0x0029a, 0x0029b, 0x0029c, 0x0029d, 0x0029e, 0x0029f,
  0x002a0, 0x002a1, 0x002a2, 0x002a3, 0x002a4, 0x002a5, 0x002a6, 0x002a7,
  0x002a8, 0x002a9, 0x002aa, 0x002ab, 0x002ac, 0x002ad, 0x002ae, 0x002af,
  0x002b0, 0x002b1, 0x002b2, 0x002b3, 0x002b4, 0x002b5, 0x002b6, 0x002b7,
  0x002b8, 0x002b9, 0x002ba, 0x002bb, 0x002bc, 0x002bd, 0x002be, 0x002bf,
  0x002c0, 0x002c1, 0x002c2, 0x002c3, 0x002c4, 0x002c5, 0x002c6, 0x002c7,
  0x002c8, 0x002c9, 0x002ca, 0x002cb, 0x002cc, 0x002cd, 0x002ce, 0x002cf,
  0x002d0, 0x002d1, 0x002d2, 0x002d3, 0x002d4, 0x002d5, 0x002d6, 0x002d7,
  0x002d8, 0x002d9, 0x002da, 0x002db, 0x002dc, 0x002dd, 0x002de, 0x002df,
  0x002e0, 0x002e1, 0x002e2, 0x002e3, 0x002e4, 0x002e5, 0x002e6, 0x002e7,
  0x002e8, 0x002e9, 0x002ea, 0x002eb, 0x002ec, 0x002ed, 0x002ee, 0x002ef,
  0x002f0, 0x002f1, 0x002f2, 0x002f3, 0x002f4, 0x002f5, 0x002f6, 0x002f7,
  0x002f8, 0x002f9, 0x002fa, 0x002fb, 0x002fc, 0x002fd, 0x002fe, 0x002ff
};

static uint32_t general_ci_page_03[] = {
  0x00300, 0x00301, 0x00302, 0x00303, 0x00304, 0x00305, 0x00306, 0x00307,
  0x00308, 0x00309, 0x0030a, 0x0030b, 0x0030c, 0x0030d, 0x0030e, 0x0030f,
  0x00310, 0x00311, 0x00312, 0x00313, 0x00314, 0x00315, 0x00316, 0x00317,
  0x00318, 0x00319, 0x0031a, 0x0031b, 0x0031c, 0x0031d, 0x0031e, 0x0031f,
  0x00320, 0x00321, 0x00322, 0x00323, 0x00324, 0x00325, 0x00326, 0x00327,
  0x00328, 0x00329, 0x0032a, 0x0032b, 0x0032c, 0x0032d, 0x0032e, 0x0032f,
  0x00330, 0x00331, 0x00332, 0x00333, 0x00334, 0x00335, 0x00336, 0x00337,
  0x00338, 0x00339, 0x0033a, 0x0033b, 0x0033c, 0x0033d, 0x0033e, 0x0033f,
  0x00340, 0x00341, 0x00342, 0x00343, 0x00344, 0x00399, 0x00346, 0x00347,
  0x00348, 0x00349, 0x0034a, 0x0034b, 0x0034c, 0x0034d, 0x0034e, 0x0034f,
  0x00350, 0x00351, 0x00352, 0x00353, 0x00354, 0x00355, 0x00356, 0x00357,
  0x00358, 0x00359, 0x0035a, 0x0035b, 0x0035c, 0x0035d, 0x0035e, 0x0035f,
  0x00360, 0x00361, 0x00362, 0x00363, 0x00364, 0x00365, 0x00366, 0x00367,
  0x00368, 0x00369, 0x0036a, 0x0036b, 0x0036c, 0x0036d, 0x0036e, 0x0036f,
  0x00370, 0x00371, 0x00372, 0x00373, 0x00374, 0x00375, 0x00376, 0x00377,
  0x00378, 0x00379, 0x0037a, 0x0037b, 0x0037c, 0x0037d, 0x0037e, 0x0037f,
  0x00380, 0x00381, 0x00382, 0x00383, 0x00384, 0x00385, 0x00391, 0x00387,
  0x00395, 0x00397, 0x00399, 0x0038b, 0x0039f, 0x0038d, 0x003a5, 0x003a9,
  0x00399, 0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396, 0x00397,
  0x00398, 0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e, 0x0039f,
  0x003a0, 0x003a1, 0x003a2, 0x003a3, 0x003a4, 0x003a5, 0x003a6, 0x003a7,
  0x003a8, 0x003a9, 0x00399, 0x003a5, 0x00391, 0x00395, 0x00397, 0x00399,
  0x003a5, 0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396, 0x00397,
  0x00398, 0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e, 0x0039f,
  0x003a0, 0x003a1, 0x003a3, 0x003a3, 0x003a4, 0x003a5, 0x003a6, 0x003a7,
  0x003a8, 0x003a9, 0x00399, 0x003a5, 0x0039f, 0x003a5, 0x003a9, 0x003cf,
  0x00392, 0x00398, 0x003d2, 0x003d2, 0x003d2, 0x003a6, 0x003a0, 0x003d7,
  0x003d8, 0x003d9, 0x003da, 0x003da, 0x003dc, 0x003dc, 0x003de, 0x003de,
  0x003e0, 0x003e0, 0x003e2, 0x003e2, 0x003e4, 0x003e4, 0x003e6, 0x003e6,
  0x003e8, 0x003e8, 0x003ea, 0x003ea, 0x003ec, 0x003ec, 0x003ee, 0x003ee,
  0x0039a, 0x003a1, 0x003a3, 0x003f3, 0x003f4, 0x003f5, 0x003f6, 0x003f7,
  0x003f8, 0x003f9, 0x003fa, 0x003fb, 0x003fc, 0x003fd, 0x003fe, 0x003ff
};

static uint32_t general_ci_page_04[] = {
  0x00415, 0x00415, 0x00402, 0x00413, 0x00404, 0x00405, 0x00406, 0x00406,
  0x00408, 0x00409, 0x0040a, 0x0040b, 0x0041a, 0x00418, 0x00423, 0x0040f,
  0x00410, 0x00411, 0x00412, 0x00413, 0x00414, 0x00415, 0x00416, 0x00417,
  0x00418, 0x00419, 0x0041a, 0x0041b, 0x0041c, 0x0041d, 0x0041e, 0x0041f,
  0x00420, 0x00421, 0x00422, 0x00423, 0x00424, 0x00425, 0x00426, 0x00427,
  0x00428, 0x00429, 0x0042a, 0x0042b, 0x0042c, 0x0042d, 0x0042e, 0x0042f,
  0x00410, 0x00411, 0x00412, 0x00413, 0x00414, 0x00415, 0x00416, 0x00417,
  0x00418, 0x00419, 0x0041a, 0x0041b, 0x0041c, 0x0041d, 0x0041e, 0x0041f,
  0x00420, 0x00421, 0x00422, 0x00423, 0x00424, 0x00425, 0x00426, 0x00427,
  0x00428, 0x00429, 0x0042a, 0x0042b, 0x0042c, 0x0042d, 0x0042e, 0x0042f,
  0x00415, 0x00415, 0x00402, 0x00413, 0x00404, 0x00405, 0x00406, 0x00406,
  0x00408, 0x00409, 0x0040a, 0x0040b, 0x0041a, 0x00418, 0x00423, 0x0040f,
  0x00460, 0x00460, 0x00462, 0x00462, 0x00464, 0x00464, 0x00466, 0x00466,
  0x00468, 0x00468, 0x0046a, 0x0046a, 0x0046c, 0x0046c, 0x0046e, 0x0046e,
  0x00470, 0x00470, 0x00472, 0x00472, 0x00474, 0x00474, 0x00474, 0x00474,
  0x00478, 0x00478, 0x0047a, 0x0047a, 0x0047c, 0x0047c, 0x0047e, 0x0047e,
  0x00480, 0x00480, 0x00482, 0x00483, 0x00484, 0x00485, 0x00486, 0x00487,
  0x00488, 0x00489, 0x0048a, 0x0048b, 0x0048c, 0x0048c, 0x0048e, 0x0048e,
  0x00490, 0x00490, 0x00492, 0x00492, 0x00494, 0x00494, 0x00496, 0x00496,
  0x00498, 0x00498, 0x0049a, 0x0049a, 0x0049c, 0x0049c, 0x0049e, 0x0049e,
  0x004a0, 0x004a0, 0x004a2, 0x004a2, 0x004a4, 0x004a4, 0x004a6, 0x004a6,
  0x004a8, 0x004a8, 0x004aa, 0x004aa, 0x004ac, 0x004ac, 0x004ae, 0x004ae,
  0x004b0, 0x004b0, 0x004b2, 0x004b2, 0x004b4, 0x004b4, 0x004b6, 0x004b6,
  0x004b8, 0x004b8, 0x004ba, 0x004ba, 0x004bc, 0x004bc, 0x004be, 0x004be,
  0x004c0, 0x00416, 0x00416, 0x004c3, 0x004c3, 0x004c5, 0x004c6, 0x004c7,
  0x004c7, 0x004c9, 0x004ca, 0x004cb, 0x004cb, 0x004cd, 0x004ce, 0x004cf,
  0x00410, 0x00410, 0x00410, 0x00410, 0x004d4, 0x004d4, 0x00415, 0x00415,
  0x004d8, 0x004d8, 0x004d8, 0x004d8, 0x00416, 0x00416, 0x00417, 0x00417,
  0x004e0, 0x004e0, 0x00418, 0x00418, 0x00418, 0x00418, 0x0041e, 0x0041e,
  0x004e8, 0x004e8, 0x004e8, 0x004e8, 0x0042d, 0x0042d, 0x00423, 0x00423,
  0x00423, 0x00423, 0x00423, 0x00423, 0x00427, 0x00427, 0x004f6, 0x004f7,
  0x0042b, 0x0042b, 0x004fa, 0x004fb, 0x004fc, 0x004fd, 0x004fe, 0x004ff
};

static uint32_t general_ci_page_05[] = {
  0x00500, 0x00501, 0x00502, 0x00503, 0x00504, 0x00505, 0x00506, 0x00507,
  0x00508, 0x00509, 0x0050a, 0x0050b, 0x0050c, 0x0050d, 0x0050e, 0x0050f,
  0x00510, 0x00511, 0x00512, 0x00513, 0x00514, 0x00515, 0x00516, 0x00517,
  0x00518, 0x00519, 0x0051a, 0x0051b, 0x0051c, 0x0051d, 0x0051e, 0x0051f,
  0x00520, 0x00521, 0x00522, 0x00523, 0x00524, 0x00525, 0x00526, 0x00527,
  0x00528, 0x00529, 0x0052a, 0x0052b, 0x0052c, 0x0052d, 0x0052e, 0x0052f,
  0x00530, 0x00531, 0x00532, 0x00533, 0x00534, 0x00535, 0x00536, 0x00537,
  0x00538, 0x00539, 0x0053a, 0x0053b, 0x0053c, 0x0053d, 0x0053e, 0x0053f,
  0x00540, 0x00541, 0x00542, 0x00543, 0x00544, 0x00545, 0x00546, 0x00547,
  0x00548, 0x00549, 0x0054a, 0x0054b, 0x0054c, 0x0054d, 0x0054e, 0x0054f,
  0x00550, 0x00551, 0x00552, 0x00553, 0x00554, 0x00555, 0x00556, 0x00557,
  0x00558, 0x00559, 0x0055a, 0x0055b, 0x0055c, 0x0055d, 0x0055e, 0x0055f,
  0x00560, 0x00531, 0x00532, 0x00533, 0x00534, 0x00535, 0x00536, 0x00537,
  0x00538, 0x00539, 0x0053a, 0x0053b, 0x0053c, 0x0053d, 0x0053e, 0x0053f,
  0x00540, 0x00541, 0x00542, 0x00543, 0x00544, 0x00545, 0x00546, 0x00547,
  0x00548, 0x00549, 0x0054a, 0x0054b, 0x0054c, 0x0054d, 0x0054e, 0x0054f,
  0x00550, 0x00551, 0x00552, 0x00553, 0x00554, 0x00555, 0x00556, 0x00587,
  0x00588, 0x00589, 0x0058a, 0x0058b, 0x0058c, 0x0058d, 0x0058e, 0x0058f,
  0x00590, 0x00591, 0x00592, 0x00593, 0x00594, 0x00595, 0x00596, 0x00597,
  0x00598, 0x00599, 0x0059a, 0x0059b, 0x0059c, 0x0059d, 0x0059e, 0x0059f,
  0x005a0, 0x005a1, 0x005a2, 0x005a3, 0x005a4, 0x005a5, 0x005a6, 0x005a7,
  0x005a8, 0x005a9, 0x005aa, 0x005ab, 0x005ac, 0x005ad, 0x005ae, 0x005af,
  0x005b0, 0x005b1, 0x005b2, 0x005b3, 0x005b4, 0x005b5, 0x005b6, 0x005b7,
  0x005b8, 0x005b9, 0x005ba, 0x005bb, 0x005bc, 0x005bd, 0x005be, 0x005bf,
  0x005c0, 0x005c1, 0x005c2, 0x005c3, 0x005c4, 0x005c5, 0x005c6, 0x005c7,
  0x005c8, 0x005c9, 0x005ca, 0x005cb, 0x005cc, 0x005cd, 0x005ce, 0x005cf,
  0x005d0, 0x005d1, 0x005d2, 0x005d3, 0x005d4, 0x005d5, 0x005d6, 0x005d7,
  0x005d8, 0x005d9, 0x005da, 0x005db, 0x005dc, 0x005dd, 0x005de, 0x005df,
  0x005e0, 0x005e1, 0x005e2, 0x005e3, 0x005e4, 0x005e5, 0x005e6, 0x005e7,
  0x005e8, 0x005e9, 0x005ea, 0x005eb, 0x005ec, 0x005ed, 0x005ee, 0x005ef,
  0x005f0, 0x005f1, 0x005f2, 0x005f3, 0x005f4, 0x005f5, 0x005f6, 0x005f7,
  0x005f8, 0x005f9, 0x005fa, 0x005fb, 0x005fc, 0x005fd, 0x005fe, 0x005ff
};

static uint32_t general_ci_page_1e[] = {
  0x00041, 0x00041, 0x00042, 0x00042, 0x00042, 0x00042, 0x00042, 0x00042,
  0x00043, 0x00043, 0x00044, 0x00044, 0x00044, 0x00044, 0x00044, 0x00044,
  0x00044, 0x00044, 0x00044, 0x00044, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00046, 0x00046,
  0x00047, 0x00047, 0x00048, 0x00048, 0x00048, 0x00048, 0x00048, 0x00048,
  0x00048, 0x00048, 0x00048, 0x00048, 0x00049, 0x00049, 0x00049, 0x00049,
  0x0004b, 0x0004b, 0x0004b, 0x0004b, 0x0004b, 0x0004b, 0x0004c, 0x0004c,
  0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004d, 0x0004d,
  0x0004d, 0x0004d, 0x0004d, 0x0004d, 0x0004e, 0x0004e, 0x0004e, 0x0004e,
  0x0004e, 0x0004e, 0x0004e, 0x0004e, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x00050, 0x00050, 0x00050, 0x00050,
  0x00052, 0x00052, 0x00052, 0x00052, 0x00052, 0x00052, 0x00052, 0x00052,
  0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053,
  0x00053, 0x00053, 0x00054, 0x00054, 0x00054, 0x00054, 0x00054, 0x00054,
  0x00054, 0x00054, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00056, 0x00056, 0x00056, 0x00056,
  0x00057, 0x00057, 0x00057, 0x00057, 0x00057, 0x00057, 0x00057, 0x00057,
  0x00057, 0x00057, 0x00058, 0x00058, 0x00058, 0x00058, 0x00059, 0x00059,
  0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x00048, 0x00054,
  0x00057, 0x00059, 0x01e9a, 0x00053, 0x01e9c, 0x01e9d, 0x01e9e, 0x01e9f,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00049, 0x00049, 0x00049, 0x00049, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00059, 0x00059, 0x00059, 0x00059, 0x00059, 0x00059,
  0x00059, 0x00059, 0x01efa, 0x01efb, 0x01efc, 0x01efd, 0x01efe, 0x01eff
};

static uint32_t general_ci_page_1f[] = {
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391,
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391,
  0x00395, 0x00395, 0x00395, 0x00395, 0x00395, 0x00395, 0x01f16, 0x01f17,
  0x00395, 0x00395, 0x00395, 0x00395, 0x00395, 0x00395, 0x01f1e, 0x01f1f,
  0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397,
  0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397,
  0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399,
  0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399,
  0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x01f46, 0x01f47,
  0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x01f4e, 0x01f4f,
  0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a5,
  0x01f58, 0x003a5, 0x01f5a, 0x003a5, 0x01f5c, 0x003a5, 0x01f5e, 0x003a5,
  0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9,
  0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9,
  0x00391, 0x01fbb, 0x00395, 0x01fc9, 0x00397, 0x01fcb, 0x00399, 0x01fdb,
  0x0039f, 0x01ff9, 0x003a5, 0x01feb, 0x003a9, 0x01ffb, 0x01f7e, 0x01f7f,
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391,
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391,
  0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397,
  0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397,
  0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9,
  0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9,
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x01fb5, 0x00391, 0x00391,
  0x00391, 0x00391, 0x00391, 0x01fbb, 0x00391, 0x01fbd, 0x00399, 0x01fbf,
  0x01fc0, 0x01fc1, 0x00397, 0x00397, 0x00397, 0x01fc5, 0x00397, 0x00397,
  0x00395, 0x01fc9, 0x00397, 0x01fcb, 0x00397, 0x01fcd, 0x01fce, 0x01fcf,
  0x00399, 0x00399, 0x00399, 0x01fd3, 0x01fd4, 0x01fd5, 0x00399, 0x00399,
  0x00399, 0x00399, 0x00399, 0x01fdb, 0x01fdc, 0x01fdd, 0x01fde, 0x01fdf,
  0x003a5, 0x003a5, 0x003a5, 0x01fe3, 0x003a1, 0x003a1, 0x003a5, 0x003a5,
  0x003a5, 0x003a5, 0x003a5, 0x01feb, 0x003a1, 0x01fed, 0x01fee, 0x01fef,
  0x01ff0, 0x01ff1, 0x003a9, 0x003a9, 0x003a9, 0x01ff5, 0x003a9, 0x003a9,
  0x0039f, 0x01ff9, 0x003a9, 0x01ffb, 0x003a9, 0x01ffd, 0x01ffe, 0x01fff
};

static uint32_t general_ci_page_21[] = {
  0x02100, 0x02101, 0x02102, 0x02103, 0x02104, 0x02105, 0x02106, 0x02107,
  0x02108, 0x02109, 0x0210a, 0x0210b, 0x0210c, 0x0210d, 0x0210e, 0x0210f,
  0x02110, 0x02111, 0x02112, 0x02113, 0x02114, 0x02115, 0x02116, 0x02117,
  0x02118, 0x02119, 0x0211a, 0x0211b, 0x0211c, 0x0211d, 0x0211e, 0x0211f,
  0x02120, 0x02121, 0x02122, 0x02123, 0x02124, 0x02125, 0x02126, 0x02127,
  0x02128, 0x02129, 0x0212a, 0x0212b, 0x0212c, 0x0212d, 0x0212e, 0x0212f,
  0x02130, 0x02131, 0x02132, 0x02133, 0x02134, 0x02135, 0x02136, 0x02137,
  0x02138, 0x02139, 0x0213a, 0x0213b, 0x0213c, 0x0213d, 0x0213e, 0x0213f,
  0x02140, 0x02141, 0x02142, 0x02143, 0x02144, 0x02145, 0x02146, 0x02147,
  0x02148, 0x02149, 0x0214a, 0x0214b, 0x0214c, 0x0214d, 0x0214e, 0x0214f,
  0x02150, 0x02151, 0x02152, 0x02153, 0x02154, 0x02155, 0x02156, 0x02157,
  0x02158, 0x02159, 0x0215a, 0x0215b, 0x0215c, 0x0215d, 0x0215e, 0x0215f,
  0x02160, 0x02161, 0x02162, 0x02163, 0x02164, 0x02165, 0x02166, 0x02167,
  0x02168, 0x02169, 0x0216a, 0x0216b, 0x0216c, 0x0216d, 0x0216e, 0x0216f,
  0x02160, 0x02161, 0x02162, 0x02163, 0x02164, 0x02165, 0x02166, 0x02167,
  0x02168, 0x02169, 0x0216a, 0x0216b, 0x0216c, 0x0216d, 0x0216e, 0x0216f,
  0x02180, 0x02181, 0x02182, 0x02183, 0x02184, 0x02185, 0x02186, 0x02187,
  0x02188, 0x02189, 0x0218a, 0x0218b, 0x0218c, 0x0218d, 0x0218e, 0x0218f,
  0x02190, 0x02191, 0x02192, 0x02193, 0x02194, 0x02195, 0x02196, 0x02197,
  0x02198, 0x02199, 0x0219a, 0x0219b, 0x0219c, 0x0219d, 0x0219e, 0x0219f,
  0x021a0, 0x021a1, 0x021a2, 0x021a3, 0x021a4, 0x021a5, 0x021a6, 0x021a7,
  0x021a8, 0x021a9, 0x021aa, 0x021ab, 0x021ac, 0x021ad, 0x021ae, 0x021af,
  0x021b0, 0x021b1, 0x021b2, 0x021b3, 0x021b4, 0x021b5, 0x021b6, 0x021b7,
  0x021b8, 0x021b9, 0x021ba, 0x021bb, 0x021bc, 0x021bd, 0x021be, 0x021bf,
  0x021c0, 0x021c1, 0x021c2, 0x021c3, 0x021c4, 0x021c5, 0x021c6, 0x021c7,
  0x021c8, 0x021c9, 0x021ca, 0x021cb, 0x021cc, 0x021cd, 0x021ce, 0x021cf,
  0x021d0, 0x021d1, 0x021d2, 0x021d3, 0x021d4, 0x021d5, 0x021d6, 0x021d7,
  0x021d8, 0x021d9, 0x021da, 0x021db, 0x021dc, 0x021dd, 0x021de, 0x021df,
  0x021e0, 0x021e1, 0x021e2, 0x021e3, 0x021e4, 0x021e5, 0x021e6, 0x021e7,
  0x021e8, 0x021e9, 0x021ea, 0x021eb, 0x021ec, 0x021ed, 0x021ee, 0x021ef,
  0x021f0, 0x021f1, 0x021f2, 0x021f3, 0x021f4, 0x021f5, 0x021f6, 0x021f7,
  0x021f8, 0x021f9, 0x021fa, 0x021fb, 0x021fc, 0x021fd, 0x021fe, 0x021ff
};

static uint32_t general_ci_page_24[] = {
  0x02400, 0x02401, 0x02402, 0x02403, 0x02404, 0x02405, 0x02406, 0x02407,
  0x02408, 0x02409, 0x0240a, 0x0240b, 0x0240c, 0x0240d, 0x0240e, 0x0240f,
  0x02410, 0x02411, 0x02412, 0x02413, 0x02414, 0x02415, 0x02416, 0x02417,
  0x02418, 0x02419, 0x0241a, 0x0241b, 0x0241c, 0x0241d, 0x0241e, 0x0241f,
  0x02420, 0x02421, 0x02422, 0x02423, 0x02424, 0x02425, 0x02426, 0x02427,
  0x02428, 0x02429, 0x0242a, 0x0242b, 0x0242c, 0x0242d, 0x0242e, 0x0242f,
  0x02430, 0x02431, 0x02432, 0x02433, 0x02434, 0x02435, 0x02436, 0x02437,
  0x02438, 0x02439, 0x0243a, 0x0243b, 0x0243c, 0x0243d, 0x0243e, 0x0243f,
  0x02440, 0x02441, 0x02442, 0x02443, 0x02444, 0x02445, 0x02446, 0x02447,
  0x02448, 0x02449, 0x0244a, 0x0244b, 0x0244c, 0x0244d, 0x0244e, 0x0244f,
  0x02450, 0x02451, 0x02452, 0x02453, 0x02454, 0x02455, 0x02456, 0x02457,
  0x02458, 0x02459, 0x0245a, 0x0245b, 0x0245c, 0x0245d, 0x0245e, 0x0245f,
  0x02460, 0x02461, 0x02462, 0x02463, 0x02464, 0x02465, 0x02466, 0x02467,
  0x02468, 0x02469, 0x0246a, 0x0246b, 0x0246c, 0x0246d, 0x0246e, 0x0246f,
  0x02470, 0x02471, 0x02472, 0x02473, 0x02474, 0x02475, 0x02476, 0x02477,
  0x02478, 0x02479, 0x0247a, 0x0247b, 0x0247c, 0x0247d, 0x0247e, 0x0247f,
  0x02480, 0x02481, 0x02482, 0x02483, 0x02484, 0x02485, 0x02486, 0x02487,
  0x02488, 0x02489, 0x0248a, 0x0248b, 0x0248c, 0x0248d, 0x0248e, 0x0248f,
  0x02490, 0x02491, 0x02492, 0x02493, 0x02494, 0x02495, 0x02496, 0x02497,
  0x02498, 0x02499, 0x0249a, 0x0249b, 0x0249c, 0x0249d, 0x0249e, 0x0249f,
  0x024a0, 0x024a1, 0x024a2, 0x024a3, 0x024a4, 0x024a5, 0x024a6, 0x024a7,
  0x024a8, 0x024a9, 0x024aa, 0x024ab, 0x024ac, 0x024ad, 0x024ae, 0x024af,
  0x024b0, 0x024b1, 0x024b2, 0x024b3, 0x024b4, 0x024b5, 0x024b6, 0x024b7,
  0x024b8, 0x024b9, 0x024ba, 0x024bb, 0x024bc, 0x024bd, 0x024be, 0x024bf,
  0x024c0, 0x024c1, 0x024c2, 0x024c3, 0x024c4, 0x024c5, 0x024c6, 0x024c7,
  0x024c8, 0x024c9, 0x024ca, 0x024cb, 0x024cc, 0x024cd, 0x024ce, 0x024cf,
  0x024b6, 0x024b7, 0x024b8, 0x024b9, 0x024ba, 0x024bb, 0x024bc, 0x024bd,
  0x024be, 0x024bf, 0x024c0, 0x024c1, 0x024c2, 0x024c3, 0x024c4, 0x024c5,
  0x024c6, 0x024c7, 0x024c8, 0x024c9, 0x024ca, 0x024cb, 0x024cc, 0x024cd,
  0x024ce, 0x024cf, 0x024ea, 0x024eb, 0x024ec, 0x024ed, 0x024ee, 0x024ef,
  0x024f0, 0x024f1, 0x024f2, 0x024f3, 0x024f4, 0x024f5, 0x024f6, 0x024f7,
  0x024f8, 0x024f9, 0x024fa, 0x024fb, 0x024fc, 0x024fd, 0x024fe, 0x024ff
};

static uint32_t general_ci_page_ff[] = {
  0x0ff00, 0x0ff01, 0x0ff02, 0x0ff03, 0x0ff04, 0x0ff05, 0x0ff06, 0x0ff07,
  0x0ff08, 0x0ff09, 0x0ff0a, 0x0ff0b, 0x0ff0c, 0x0ff0d, 0x0ff0e, 0x0ff0f,
  0x0ff10, 0x0ff11, 0x0ff12, 0x0ff13, 0x0ff14, 0x0ff15, 0x0ff16, 0x0ff17,
  0x0ff18, 0x0ff19, 0x0ff1a, 0x0ff1b, 0x0ff1c, 0x0ff1d, 0x0ff1e, 0x0ff1f,
  0x0ff20, 0x0ff21, 0x0ff22, 0x0ff23, 0x0ff24, 0x0ff25, 0x0ff26, 0x0ff27,
  0x0ff28, 0x0ff29, 0x0ff2a, 0x0ff2b, 0x0ff2c, 0x0ff2d, 0x0ff2e, 0x0ff2f,
  0x0ff30, 0x0ff31, 0x0ff32, 0x0ff33, 0x0ff34, 0x0ff35, 0x0ff36, 0x0ff37,
  0x0ff38, 0x0ff39, 0x0ff3a, 0x0ff3b, 0x0ff3c, 0x0ff3d, 0x0ff3e, 0x0ff3f,
  0x0ff40, 0x0ff21, 0x0ff22, 0x0ff23, 0x0ff24, 0x0ff25, 0x0ff26, 0x0ff27,
  0x0ff28, 0x0ff29, 0x0ff2a, 0x0ff2b, 0x0ff2c, 0x0ff2d, 0x0ff2e, 0x0ff2f,
  0x0ff30, 0x0ff31, 0x0ff32, 0x0ff33, 0x0ff34, 0x0ff35, 0x0ff36, 0x0ff37,
  0x0ff38, 0x0ff39, 0x0ff3a, 0x0ff5b, 0x0ff5c, 0x0ff5d, 0x0ff5e, 0x0ff5f,
  0x0ff60, 0x0ff61, 0x0ff62, 0x0ff63, 0x0ff64, 0x0ff65, 0x0ff66, 0x0ff67,
  0x0ff68, 0x0ff69, 0x0ff6a, 0x0ff6b, 0x0ff6c, 0x0ff6d, 0x0ff6e, 0x0ff6f,
  0x0ff70, 0x0ff71, 0x0ff72, 0x0ff73, 0x0ff74, 0x0ff75, 0x0ff76, 0x0ff77,
  0x0ff78, 0x0ff79, 0x0ff7a, 0x0ff7b, 0x0ff7c, 0x0ff7d, 0x0ff7e, 0x0ff7f,
  0x0ff80, 0x0ff81, 0x0ff82, 0x0ff83, 0x0ff84, 0x0ff85, 0x0ff86, 0x0ff87,
  0x0ff88, 0x0ff89, 0x0ff8a, 0x0ff8b, 0x0ff8c, 0x0ff8d, 0x0ff8e, 0x0ff8f,
  0x0ff90, 0x0ff91, 0x0ff92, 0x0ff93, 0x0ff94, 0x0ff95, 0x0ff96, 0x0ff97,
  0x0ff98, 0x0ff99, 0x0ff9a, 0x0ff9b, 0x0ff9c, 0x0ff9d, 0x0ff9e, 0x0ff9f,
  0x0ffa0, 0x0ffa1, 0x0ffa2, 0x0ffa3, 0x0ffa4, 0x0ffa5, 0x0ffa6, 0x0ffa7,
  0x0ffa8, 0x0ffa9, 0x0ffaa, 0x0ffab, 0x0ffac, 0x0ffad, 0x0ffae, 0x0ffaf,
  0x0ffb0, 0x0ffb1, 0x0ffb2, 0x0ffb3, 0x0ffb4, 0x0ffb5, 0x0ffb6, 0x0ffb7,
  0x0ffb8, 0x0ffb9, 0x0ffba, 0x0ffbb, 0x0ffbc, 0x0ffbd, 0x0ffbe, 0x0ffbf,
  0x0ffc0, 0x0ffc1, 0x0ffc2, 0x0ffc3, 0x0ffc4, 0x0ffc5, 0x0ffc6, 0x0ffc7,
  0x0ffc8, 0x0ffc9, 0x0ffca, 0x0ffcb, 0x0ffcc, 0x0ffcd, 0x0ffce, 0x0ffcf,
  0x0ffd0, 0x0ffd1, 0x0ffd2, 0x0ffd3, 0x0ffd4, 0x0ffd5, 0x0ffd6, 0x0ffd7,
  0x0ffd8, 0x0ffd9, 0x0ffda, 0x0ffdb, 0x0ffdc, 0x0ffdd, 0x0ffde, 0x0ffdf,
  0x0ffe0, 0x0ffe1, 0x0ffe2, 0x0ffe3, 0x0ffe4, 0x0ffe5, 0x0ffe6, 0x0ffe7,
  0x0ffe8, 0x0ffe9, 0x0ffea, 0x0ffeb, 0x0ffec, 0x0ffed, 0x0ffee, 0x0ffef,
  0x0fff0, 0x0fff1, 0x0fff2, 0x0fff3, 0x0fff4, 0x0fff5, 0x0fff6, 0x0fff7,
  0x0fff8, 0x0fff9, 0x0fffa, 0x0fffb, 0x0fffc, 0x0fffd, 0x0fffe, 0x0ffff
};

static uint32_t *general_ci_table[256] = {
  general_ci_page_00, general_ci_page_01,
  general_ci_page_02, general_ci_page_03,
  general_ci_page_04, general_ci_page_05,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
  general_ci_page_1e, general_ci_page_1f,
                NULL, general_ci_page_21,
                NULL,               NULL,
  general_ci_page_24,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL,               NULL,
                NULL, general_ci_page_ff
};

#endif
