/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.ccs.CcsServer;
import charm.debug.inspect.Inspector;

public class Consumer {
    public static final int lengthLen_single = 0;
    public static final int lengthLen_byte = 1;
    public static final int lengthLen_int = 2;
    public static final int lengthLen_long = 3;
    public static final int typeCode_byte = 0;
    public static final int typeCode_int = 2;
    public static final int typeCode_long = 3;
    public static final int typeCode_float = 5;
    public static final int typeCode_double = 6;
    public static final int typeCode_comment = 10;
    public static final int typeCode_sync = 11;
    public static final int typeCode_pointer = 12;
    public static final int sync_builtin = 0x70000000;
    public static final int sync_begin = 0x71000000;
    public static final int sync_end = 0x72000000;
    public static final int sync_last_system = 0x79000000;
    public static final int sync_array_m = 0x100000;
    public static final int sync_list_m = 0x200000;
    public static final int sync_object_m = 0x300000;
    public static final int sync_begin_array = 0x71100000;
    public static final int sync_begin_list = 1897922560;
    public static final int sync_begin_object = 1898971136;
    public static final int sync_end_array = 1913651200;
    public static final int sync_end_list = 0x72200000;
    public static final int sync_end_object = 1915748352;
    public static final int sync_item = 0x70110000;
    public static final int sync_index = 1880227840;
    public static final int sync_last = 0;

    public void listByte(byte[] data) {
    }

    public void listInt(int[] data) {
    }

    public void listFloat(float[] data) {
    }

    public void listLong(long[] data) {
    }

    public void listDouble(double[] data) {
    }

    public void listComment(String cmt) {
    }

    public void listSync(int syncCode) {
    }

    private void bad(String why) {
        System.out.println("FATAL ERROR in CpdList Decoding> " + why);
        System.exit(1);
    }

    public void decode(byte[] buf) {
        this.decode(buf, 0, buf.length);
    }

    public void decode(byte[] buf, int off, int buf_length) {
        int end = off + buf_length;
        block15: while (off < end) {
            byte intro = buf[off++];
            int lengthLen = intro >> 4 & 3;
            int typeCode = intro & 0xF;
            int length = 0;
            int intLen = 4;
            int longLen = 8;
            switch (lengthLen) {
                case 0: {
                    length = 1;
                    break;
                }
                case 1: {
                    length = 0xFF & buf[off++];
                    break;
                }
                case 2: {
                    length = CcsServer.readInt(buf, off);
                    off += 4;
                    break;
                }
                default: {
                    this.bad("Unrecognized lengthLen " + lengthLen);
                }
            }
            switch (typeCode) {
                case 0: {
                    int i;
                    Object[] data = new byte[length];
                    for (i = 0; i < length; ++i) {
                        data[i] = buf[off++];
                    }
                    this.listByte((byte[])data);
                    continue block15;
                }
                case 2: {
                    int i;
                    Object[] data = new int[length];
                    for (i = 0; i < length; ++i) {
                        data[i] = CcsServer.readInt(buf, off);
                        off += 4;
                    }
                    this.listInt((int[])data);
                    continue block15;
                }
                case 5: {
                    int i;
                    Object[] data = new float[length];
                    for (i = 0; i < length; ++i) {
                        data[i] = (byte)CcsServer.readFloat(buf, off);
                        off += 4;
                    }
                    this.listFloat((float[])data);
                    continue block15;
                }
                case 3: {
                    int i;
                    Object[] data = new long[length];
                    for (i = 0; i < length; ++i) {
                        data[i] = (byte)CcsServer.readLong(buf, off);
                        off += 8;
                    }
                    this.listLong((long[])data);
                    continue block15;
                }
                case 6: {
                    int i;
                    Object[] data = new double[length];
                    for (i = 0; i < length; ++i) {
                        data[i] = (byte)CcsServer.readDouble(buf, off);
                        off += 8;
                    }
                    this.listDouble((double[])data);
                    continue block15;
                }
                case 10: {
                    this.listComment(new String(buf, off, length));
                    off += length;
                    continue block15;
                }
                case 11: {
                    this.listSync(CcsServer.readInt(buf, off));
                    off += 4;
                    continue block15;
                }
                case 12: {
                    int i;
                    Object[] data;
                    if (Inspector.is64bit()) {
                        data = new long[length];
                        for (i = 0; i < length; ++i) {
                            data[i] = (byte)CcsServer.readLong(buf, off);
                            off += 8;
                        }
                        this.listLong((long[])data);
                        continue block15;
                    }
                    data = new int[length];
                    for (i = 0; i < length; ++i) {
                        data[i] = CcsServer.readInt(buf, off);
                        off += 4;
                    }
                    this.listInt((int[])data);
                    continue block15;
                }
            }
            this.bad("Unrecognized typeCode " + typeCode);
        }
    }
}

