/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PDisplayStyle;

public class PNative
extends PAbstract {
    private float[] v_float;
    private double[] v_double;
    private int[] v_int;
    private long[] v_long;
    private int len;

    PNative(int[] v) {
        this.v_int = v;
        this.v_long = null;
        this.v_float = null;
        this.v_double = null;
        this.len = v.length;
    }

    PNative(long[] v) {
        this.v_int = null;
        this.v_long = v;
        this.v_float = null;
        this.v_double = null;
        this.len = v.length;
    }

    PNative(float[] v) {
        this.v_int = null;
        this.v_long = null;
        this.v_float = v;
        this.v_double = null;
        this.len = v.length;
    }

    PNative(double[] v) {
        this.v_int = null;
        this.v_long = null;
        this.v_float = null;
        this.v_double = v;
        this.len = v.length;
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer(super.toString());
        if (this.len > 1) {
            ret.append("{");
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.v_int != null) {
                ret.append("" + this.v_int[i]);
            }
            if (this.v_long != null) {
                ret.append("" + this.v_long[i]);
            }
            if (this.v_float != null) {
                ret.append("" + this.v_float[i]);
            }
            if (this.v_double != null) {
                ret.append("" + this.v_double[i]);
            }
            if (i + 1 == this.len) continue;
            ret.append(", ");
        }
        if (this.len > 1) {
            ret.append("} ");
        }
        return ret.toString();
    }

    public int length() {
        return this.len;
    }

    public int getIntValue(int i) {
        return this.v_int[i];
    }

    public long getLongValue(int i) {
        return this.v_long[i];
    }

    public float getFloatValue(int i) {
        return this.v_float[i];
    }

    public double getDoubleValue(int i) {
        return this.v_double[i];
    }

    @Override
    public boolean draw(PDisplayStyle p, int drawStyle) {
        super.draw(p, drawStyle);
        for (int i = 0; i < this.len; ++i) {
            String v = "??";
            if (this.v_int != null) {
                v = Integer.toString(this.v_int[i]);
            }
            if (this.v_long != null) {
                v = Long.toString(this.v_int[i]);
            }
            if (this.v_float != null) {
                v = Float.toString(this.v_float[i]);
            }
            if (this.v_double != null) {
                v = Double.toString(this.v_double[i]);
            }
            if (p.drawString(v)) continue;
            return false;
        }
        return true;
    }
}

