/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.VariableElement;
import java.nio.ByteBuffer;
import java.util.Stack;

public abstract class TypeVisitor {
    ByteBuffer buf;
    int offset;
    int status;
    Stack seeks;
    boolean valid;
    public static final int SUPERCLASS = 2;

    public TypeVisitor(ByteBuffer b, int start) {
        this.buf = b;
        this.offset = start;
        this.status = 0;
        this.valid = true;
        this.seeks = new Stack();
    }

    public void visit(GenericType gt) {
        int children = gt.getChildren();
        if (children > 0) {
            this.push();
            for (int i = 0; i < children; ++i) {
                GenericElement e = gt.getChild(i);
                this.visit(e);
            }
            this.pop();
        }
    }

    public void visit(GenericElement e) {
        this.seek(e.getOffset());
        GenericType t = e.getType();
        String value = null;
        int pointer = e.getPointer() + t.getPointer();
        int size = 1;
        if (e instanceof VariableElement && ((VariableElement)e).getArray() > 0) {
            size = ((VariableElement)e).getArray();
        }
        if (size > 1) {
            this.addElement(e, "[]");
            this.push();
        }
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.reseek(e.getOffset() + i * t.getSize());
            }
            value = this.valid ? t.getValue(this) : null;
            if (pointer > 0 && this.valid) {
                value = GenericType.printPointer(this.buf, this.offset);
            }
            if (size > 1) {
                value = "[" + i + "] " + value;
            }
            this.addElement(e, value);
            if (pointer != 0) continue;
            this.visit(t);
        }
        if (size > 1) {
            this.pop();
        }
        this.revertSeek();
    }

    public abstract Object getResult();

    public abstract void addElement(GenericElement var1, String var2);

    public void addType(String str) {
    }

    public void addName(String str) {
    }

    public void addValue(String str) {
    }

    public abstract void push();

    public abstract void pop();

    public boolean isValid() {
        return this.valid;
    }

    public void setPointer(int p) {
    }

    public void setStatus(int s) {
        this.status |= s;
    }

    public void seek(int size) {
        if (this.valid) {
            this.seeks.push(new Integer(size));
            this.offset += size;
            if (size < 0) {
                this.valid = false;
            }
        } else {
            this.seeks.push(new Integer(0));
        }
    }

    public void reseek(int size) {
        this.revertSeek();
        this.seek(size);
    }

    public void revertSeek() {
        int change = (Integer)this.seeks.pop();
        if (change < 0) {
            this.valid = true;
        }
        this.offset -= change;
    }

    public byte getByte() {
        return this.buf.get(this.offset);
    }

    public short getShort() {
        return this.buf.getShort(this.offset);
    }

    public int getInteger() {
        return this.buf.getInt(this.offset);
    }

    public long getLong() {
        return this.buf.getLong(this.offset);
    }

    public float getFloat() {
        return this.buf.getFloat(this.offset);
    }

    public double getDouble() {
        return this.buf.getDouble(this.offset);
    }

    public String printPointer() {
        return GenericType.printPointer(this.buf, this.offset);
    }
}

