# VeriT

veriT is a SMT (Satisfiability Modulo Theories) solver. It is
open-source, proof-producing, and complete for quantifier-free formulas
with uninterpreted functions and linear arithmetic on real numbers and
integers. It also offers good support for quantifiers.

This release is a remix of veriT adapted for the usage inside proof
assistants. Towards this some features, especially non-linear arithmetic
support, were removed.  Please reach out to us if you are interested
in those.

veriT is available under the BSD license.  The front-end uses the
SMTLIB-2 language (documented at http://www.smtlib.org), but not all
features are supported.


## Compilation

veriT uses the a standard autotools based build system. A C compiler,
*make*, and *libgmp* (the GNU Multiple Precision Arithmetic Library)
are required.  Building should then be as easy as running:

```bash
$ ./configure
$ make -j
```

## Installation

To install veriT run:
```bash
$ sudo make install
```

### Usage

The following command produces a short proof:
```
$ ./veriT -s example/proof/step-simp_1.smt2
```

Here, the command line option `-s` suppresses the printing of `success`
for each input command. To get some basic usage instructions run
`veriT -h`.

To force veriT to produce a proof the command `--proof=FILENAME` can be used.
If `FILENAME` is `-` the proof is printed to `stdout`. When creating proofs
the options `--proof-prune` and `--proof-merge` are useful. The first one
removes unused branches from proofs and the second one merges branches with
identical conclusions. The option `--proof-with-sharing` activates sharing.

When calling veriT on problems generated by a proof assistant our
experience shows that using the options
`--triggers-new --index-sorts --index-fresh-sorts --triggers-sel-rm-specific`
results in good performance.

## SMT-LIB Support

The SMT-LIB logics LIA, QF_IDL, QF_LIA, QF_LRA, QF_LIRA, QF_RDL, QF_UF,
QF_UFIDL, QF_UFLIA, QF_UFLRA, UF, UFIDL, UFLIA, and UFLRA are supported
by veriT. The variants of those logics with arrays (A...) can be parsed,
but no array solver is currently implemented. Hence, array symbols are
treated as uninterpreted symbols.

Furthermore, the following restrictions apply:
* Incremental solving and related commands are not supported.
* `get-model` does not produce a sensible model.
* `define-fun` is only supported when not in proof production mode.


## Development

The dependencies required for development are: A C compiler, the autotools
toolchain, *sed*, *lex*, *bison*, and *gmp* (the GNU Multiple Precision
Arithmetic Library).

To build veriT from a fresh clone of the repository run:

```bash
$ autoreconf -i
$ ./configure
$ make
```

`./configure` accepts the option `--enable-debug` to compile in debug
mode.  This mode deactivates optimizations and enables a huge number
of asserts.

On NixOS the included `shell.nix` file can be used to bring the
development dependencies and some development tools into scope.

