[![](https://git.sr.ht/~alip/jja/blob/main/misc/jja-logo.png)](https://git.sr.ht/~alip/jja)

Schweizer Taschenmesser für Schachdateiformate
==============================================
[![Jin, Jîyan, Azadî](https://img.shields.io/badge/Jin,%20J%C3%AEyan,%20Azad%C3%AE!-8A2BE2)](https://en.wikipedia.org/wiki/Woman,_Life,_Freedom)
[![crates.io](https://img.shields.io/crates/v/jja.svg)](https://crates.io/crates/jja)
[![repology](https://repology.org/badge/latest-versions/jja.svg)](https://repology.org/project/jja/versions)
[![msrv](https://img.shields.io/badge/rustc-1.70%2B-green?style=plastic)](https://blog.rust-lang.org/2022/09/22/Rust-1.70.0.html)
[![documentation](https://docs.rs/jja/badge.svg)](https://docs.rs/jja)
[![build status](https://builds.sr.ht/~alip/jja.svg)](https://builds.sr.ht/~alip/jja?)
[![downloads](https://img.shields.io/crates/d/jja.svg)](https://crates.io/crates/jja)
[![Crowdin](https://badges.crowdin.net/jja/localized.svg)](https://crowdin.com/project/jja)
[![stability-beta](https://img.shields.io/badge/stability-beta-33bbff.svg)](https://github.com/mkenney/software-guides/blob/master/STABILITY-BADGES.md#beta)
[![license](https://img.shields.io/crates/l/jja.svg)](https://git.sr.ht/~alip/jja/tree/main/item/COPYING)
[![dependency status](https://deps.rs/repo/sourcehut/~alip/jja/status.svg)](https://deps.rs/repo/sourcehut/~alip/jja)
[![maintenance-status](https://img.shields.io/badge/maintenance-actively--developed-brightgreen.svg)](https://git.sr.ht/~alip/jja)

Dies ist ___jja___, ein Befehlszeilen-Utility, um mit verschiedenen
Schach-Dateiformaten zu interagieren. Es befindet sich noch in den frühen
Entwicklungsstadien. Die ursprüngliche Absicht des Autors bestand darin, ihre
Eröffnungsbücher, die im proprietären
[CTG](https://www.chessprogramming.org/CTG)-Format von ChessBase gespeichert
wurden, in das freie und offene
[PolyGlot](http://hgm.nubati.net/book_format.html)-Format zu konvertieren. Mit
der Zeit beabsichtigt der Author, Unterstützung für andere Schach-Dateiformate
hinzuzufügen (
[cbh](https://www.chessprogramming.org%2FChessBase_%28Database%29%23Formats),
[epd](https://www.chessprogramming.org/Extended_Position_Description),
[pgn](https://www.chessprogramming.org/Portable_Game_Notation),
[si4](https://www.chessprogramming.org/SCID#Database_Format),
[si5](https://www.chessprogramming.org/SCID#Database_Format)
und so weiter).

# Demo

<img src="https://chesswob.org/jja/jja-intro-20230326.gif"
alt="jja intro"
title="jja intro"
/>

# Jin, Jîyan, Azadî

Ich habe damit begonnen, an diesem Projekt am Internationalen Frauentag 2023 zu
arbeiten, einem Tag, an dem die Errungenschaften von Frauen geehrt und für ihre
Rechte weltweit eingetreten wird. Als Person mit kurdischem Hintergrund bin ich
besonders bewegt von dem Slogan "Jin, Jîyan, Azadî" - "Frau, Leben, Freiheit" -
der zu einem Symbol des Widerstands gegen Unterdrückung und einem Ruf nach
Gleichberechtigung geworden ist. Im Geiste freier Software und freier
Meinungsäußerung bemühe ich mich, zur Schaffung einer gerechteren und
inklusiveren Gesellschaft beizutragen, in der jedem Menschen die Freiheit
gewährt wird, sich auszudrücken und seinen Träumen nachzugehen. Ich ehre auch
das Andenken an Mahsa Amini, deren tragischer Tod uns an die dringende
Notwendigkeit erinnert, für die Freiheit und Sicherheit von Frauen zu kämpfen.

Mehr auf Wikipedia,
[WikiPedia::Frau, Leben, Freiheit](https://de.wikipedia.org/wiki/Frau,_Leben,_Freiheit)

# Formate

In der Version 0.7.0 unterstützt jja das Lesen/Abfragen von:

- [PolyGlot](http://hgm.nubati.net/book_format.html), auch bekannt als `bin`
- [Arena](https://www.chessprogramming.org/ABK), auch bekannt als `abk`
- [ChessBase](https://www.chessprogramming.org/CTG), auch bekannt als `ctg`
- [ChessMaster](https://www.chessprogramming.org/Chessmaster), auch bekannt als
`obk` (Version 1 und 2, ohne/mit Textnotizen)
- [BrainLearn](https://github.com/amchess/BrainLearn), auch bekannt als `exp`

Eröffnungsbuchdateien, während des Schreibens/Konvertierens unterstützt in:

- [PolyGlot](http://hgm.nubati.net/book_format.html), auch bekannt als `bin`
- [Arena](https://www.chessprogramming.org/ABK), auch bekannt als `abk`
- [BrainLearn](https://github.com/amchess/BrainLearn), auch bekannt als `exp`

Eröffnungsbuchdateien.

Ab Version 0.5.0 unterstützt ___jja___ den Export aller unterstützten
Eröffnungsbuchformate nach
[PGN](http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm). Um diese
Funktion zu nutzen, geben Sie eine Ausgabedatei mit `pgn` Erweiterung als
Argument für `jja edit` an.

Bei der Konvertierung von Eröffnungsbüchern verwendet ___jja___ die
Informationen aus verschiedenen Eingabeformaten dieser, um ein
**Zuggewicht** zu ermitteln, das dem Zug in der
[PolyGlot](http://hgm.nubati.net/book_format.html)-Eröffnungsdatei beiliegt.
___jja___ schreibt auch einige benutzerdefinierte Zahlen in das **Lernfeld**,
wie zum Beispiel
[NAGs](https://en.wikipedia.org/wiki/Numeric_Annotation_Glyphs) während der
`ctg`-Konvertierung oder **Priorität** während der `abk`-Konvertierung. Sie
können diese benutzerdefinierte Verwendung mit `--no-learn` deaktivieren, da
sie andere Software, die dieses Feld verwendet, verwirren könnte.

Beachten Sie, dass das Schreiben von
[Arena](https://www.chessprogramming.org/ABK)-Eröffnungsbuchdateien, auch
bekannt als `abk`, nur von
[ChessBase](https://www.chessprogramming.org/CTG)-Eröffnungsbüchern, auch
bekannt als `ctg`, unterstützt wird. Verwenden Sie die Befehlszeilenoptionen
`--author`, `--comment`, `--probability-priority`, `--probability-games`,
`--probability-win-percent`, um die
[ABK](https://www.chessprogramming.org/ABK)-Header-Metadaten zu konfigurieren.
Spielstatistiken (Mindestanzahl von Spielen/Siegen, Siegprozentzahlen für beide
Seiten) werden automatisch von ___jja___ verwaltet.

Eine In-Place-Bearbeitung für
[Arena](https://www.chessprogramming.org/ABK)-Eröffnungsbücher ist ebenfalls
möglich - mit der Befehlszeilenoption `-i, --in-place=SUFFIX`. Die Konvertierung
von [PolyGlot](http://hgm.nubati.net/book_format.html)-, auch bekannt als
`bin`- und [ChessMaster](https://www.chessprogramming.org/Chessmaster)-, auch
bekannt als `obk`-Eröffnungsbüchern, in
[Arena](https://www.chessprogramming.org/ABK)-, auch bekannt als
`abk`-Eröffnungsbuchdateien, ist für eine zukünftige Veröffentlichung geplant.

# Verwendung

- Verwenden Sie `jja info`, um kurze Informationen über die Schachdatei zu
erhalten.
- Verwenden Sie `jja find`, um nach einer Position in einer Schachdatei zu
suchen.
- Verwenden Sie `jja edit`, um Eröffnungsbuchdateien zu bearbeiten und in
[PolyGlot](http://hgm.nubati.net/book_format.html)-Dateien umzuwandeln.
- Verwenden Sie `jja make`, um
[PGN](https://en.wikipedia.org/wiki/Portable_Game_Notation)-Dateien in
[PolyGlot](http://hgm.nubati.net/book_format.html)-Eröffnungsbücher zu
kompilieren.

___jja___ bestimmt den Dateityp anhand der Dateierweiterung. Dateien mit der
Erweiterung `.bin` gelten als
[PolyGlot](http://hgm.nubati.net/book_format.html)-Bücher. Dateien mit der
Erweiterung `.ctg` gelten als
[ChessBase](https://www.chessprogramming.org/CTG)-Bücher. Dateien mit der
Erweiterung `.abk` gelten als
[Arena](https://www.chessprogramming.org/ABK)-Bücher. Dateien mit der
Erweiterung `.obk` gelten als
[ChessMaster](https://www.chessprogramming.org/Chessmaster)-Bücher.

Standardmäßig zeigt ___jja___, wenn die Standardausgabe ein
[TTY](https://en.wikipedia.org/wiki/Computer_terminal) ist, Informationen in
ansprechenden Tabellen an. Verwenden Sie die Befehlszeilenoption `--porcelain`,
um die Ausgabe stattdessen im
[CSV](https://en.wikipedia.org/wiki/Comma-separated_values)-Format
(Comma-separated values) zu erhalten.

# Installation

Um aus dem Quellcode zu kompilieren, verwenden Sie `cargo install jja`. Dies
erfordert, dass die [Rust-Toolchain](https://rustup.rs/) installiert ist.
Zusätzlich benötigen Sie [OpenSSL](https://www.openssl.org/)-Bibliotheken auf
[UNIX](https://en.wikipedia.org/wiki/Unix)-Systemen. Außerdem benötigen Sie
[liburing](https://github.com/axboe/liburing) auf [Linux](https://kernel.org).
Wenn Sie sich auf einem [Linux](https://kernel.org)-System älter als
[5.1](https://en.wikipedia.org/wiki/Io_uring#History) befinden oder aus einem
anderen Grund [liburing](https://github.com/axboe/liburing) nicht installieren
können, können Sie die Funktion deaktivieren, indem Sie jja mit `cargo install
jja --no-default-features` erstellen.

Alternativ werden Release-Builds von ___jja___ auf
[chesswob.org](https://chesswob.org/jja) für
[64-Bit](https://en.wikipedia.org/wiki/64-bit_computing)-[Linux](https://en.wikipedia.org/wiki/Linux)
und [Windows](https://en.wikipedia.org/wiki/Microsoft_Windows) gehostet. Diese
Versionen sind mit [GnuPG](https://gnupg.org/) signiert, unter Verwendung des
Schlüssels [D076A377FB27DE70](https://keybase.io/alip/pgp_keys.asc). Um zu
installieren, besorgen Sie sich die neueste Version von chesswob.org,
überprüfen Sie die Prüfsumme und die [GnuPG](https://gnupg.org/)-Signatur:

```
$> export JJA_VERSION=0.6.1
$> export JJA_FLAVOUR=glibc
$> curl https://keybase.io/alip/pgp_keys.asc | gpg --import
  % Total    % Received % Xferd  Average Speed   Time    Time     Time  Current
                                 Dload  Upload   Total   Spent    Left  Speed
100 13292  100 13292    0     0  13535      0 --:--:-- --:--:-- --:--:-- 26584
gpg: key D076A377FB27DE70: public key "Ali Polatel (Caissa AI) <alip@caissa.ai>" imported
gpg: Total number processed: 1
gpg:               imported: 1
$> for f in jja-${JJA_VERSION}-${JJA_FLAVOUR}.bin{,.sha512sum,.sha512sum.asc}; do wget -q https://chesswob.org/jja/${f}; done
$> gpg --verify jja-${JJA_VERSION}.bin.sha512sum.asc jja-${JJA_VERSION}.bin.sha512sum
gpg: Signature made Sun Mar 19 20:52:41 2023 CET
gpg:                using RSA key 5DF763560390A149AC6C14C7D076A377FB27DE70
gpg: Good signature from "Ali Polatel (Caissa AI) ...
$> sha512sum -c jja-${JJA_VERSION}.bin.sha512sum
jja: OK
$> sudo install -m755 jja-${JJA_VERSION}-${JJA_FLAVOUR}.bin /usr/local/bin
```

Schließlich können Sie die Builds der neuesten Git-Version über den
[SourceHut-Build-Server](https://builds.sr.ht/~alip/jja?) herunterladen. Es
gibt drei Varianten: `Windows`, `Linux-Glibc` und `Linux-Musl`. Navigieren Sie
einfach zur neuesten Build und laden Sie das auf der linken Seite aufgelistete
Artefakt herunter. Hinweis: Diese Artefakte werden 90 Tage lang aufbewahrt.

# Lizenz

___jja___ ist freie Software. Sie können es unter den Bedingungen der ___GNU
General Public License___, wie von der Free Software Foundation veröffentlicht,
weitergeben und/oder modifizieren, entweder gemäß ___Version 3___ der Lizenz
oder (nach Ihrer Option) jeder späteren Version.

Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
Nutzen sein wird, aber ___OHNE IRGENDEINE GARANTIE___, sogar ohne die implizite
Garantie der ___MARKTREIFE___ oder der ___VERWENDBARKEIT FÜR EINEN BESTIMMTEN
ZWECK___.  Details finden Sie in der GNU General Public License.

Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.

# Fehler

```
Hey you, out there beyond the wall,
Breaking bottles in the hall,
Can you help me?
```

Melden Sie Fehler im Fehlerverfolgungssystem von ___jja___ unter <https://todo.sr.ht/~alip/jja/>:

1. Seien Sie immer **höflich**, respektvoll und freundlich:
<https://css-tricks.com/open-source-etiquette-guidebook/>
2. Halten Sie Ihre letzte Änderung so **klein und ordentlich** wie möglich:
<https://tirania.org/blog/archive/2010/Dec-31.html>
3. Das Anhängen von Gedichten an den Fehlerbericht fördert die Berücksichtigung
enorm.

# PGN-Buchherstellung

Seit Version 0.4.0 kann ___jja___
[PolyGlot](http://hgm.nubati.net/book_format.html)-Bücher aus
[PGN](http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm)-Dateien
erstellen. Diese Funktion ähnelt `polyglot make-book` mit den folgenden
Unterschieden:

1. ___jja___ kann direkt komprimierte
[PGN](http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm)-Dateien
.pgn.{bz2,gz,lz4,xz,zst} lesen.
2. ___jja___ kann
[PGN](http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm)-Dateien
verarbeiten, die größer sind als der verfügbare Speicher Ihres Systems, indem
Statistiken in einer temporären [RocksDB](https://rocksdb.org/)-Datenbank
gespeichert werden.
3. ___jja___ skaliert Zuggewichte standardmäßig, um mögliche Überläufe bei
riesigen
[PGN](http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm)-Dateien zu
verhindern. Verwenden Sie `--no-scale`, um dies zu deaktivieren.
4. ___jja___ kann Züge mit *Filterausdrücken* filtern, sodass der Benutzer
unerwünschte Partien ausblenden und spezialisierte Eröffnungsbücher erstellen
kann.

## Filterausdrücke

Der Filterausdrucks-String sollte Filterbedingungen enthalten, die aus einem
Tag-Namen, einem Vergleichsoperator und einem Wert bestehen. Die folgenden
Operatoren werden unterstützt:

- `>` (größer als)
- `>=` (größer oder gleich)
- `<` (kleiner als)
- `<=` (kleiner oder gleich)
- `=` (gleich)
- `!=` (ungleich)
- `=~` (Regex-Übereinstimmung, nicht beachtung der Groß-/Kleinschreibung)
- `!~` (negierte Regex-Übereinstimmung, nicht beachtung der Groß-/Kleinschreibung)

Filterbedingungen können mit den folgenden logischen Operatoren kombiniert werden:

- `AND` (logisches UND)
- `OR` (logisches ODER)

Beispiel:

`--filter="Event =~ World AND White =~ Carlsen AND ( Result = 1-0 OR ECO = B33 )"`

Unterstützte Tags sind Event, Site, Date, UTCDate, Round, Black, White, Result,
BlackElo, WhiteElo, BlackRatingDiff, WhiteRatingDiff, BlackTitle, WhiteTitle,
ECO, Opening, TimeControl, Termination, TotalPlyCount und ScidFlags.

Zusätzlich gibt es vier spezielle Variablen, nämlich Player, Elo, Title und
RatingDiff. Diese Variablen können verwendet werden, um den entsprechenden
Header von einer der Seiten abzugleichen. Zum Beispiel ist der Filter:

`--filter="Player =~ Carlsen"`

funktional äquivalent zu

`--filter="( White =~ Carlsen OR Black =~ Carlsen )"`

Hinweis: Das Filtern ist darauf ausgelegt, einfach und schnell zu sein. Die
Tokens, einschließlich Klammern, werden durch Leerzeichen getrennt. Das Setzen
von Anführungszeichen um Werte herum ist nicht erlaubt. Für anspruchsvollere
Filterbedürfnisse können Sie pgn-extract verwenden.

## Scid-Flags

Scid verwendet für jedes Feld ein Zeichenflag, `DWBMENPTKQ!?U123456`, bei dem:

- `D` - Gelöscht
- `W` - Weiße Eröffnung
- `B` - Schwarze Eröffnung
- `M` - Mittelspiel
- `E` - Endspiel
- `N` - Neuerung
- `P` - Bauernstruktur
- `T` - Taktik
- `K` - Königsflügelspiel
- `Q` - Damenflügelspiel
- `!` - Brillianz
- `?` - Patzer
- `U` - Benutzerdefiniert
- `1..6` - Benutzerdefinierte Flags

Es wird davon abgeraten, sich auf die Reihenfolge der Zeichenflags zu
verlassen.

Verwenden Sie eine Regex-Übereinstimmung, wenn/wann immer möglich.

## Tipps und Tricks zur PGN-Buch-Erstellung

0. Die Standardeinstellungen funktionieren am besten auf meinem Laptop und bei
meinen persönlichen Benchmarks auf dem
[SourceHut-Build-Server](https://builds.sr.ht/~alip/jja/commits/main/benchmark.yml),
sie sind jedoch keine universelle Wahrheit.
1. ___jja___ verarbeitet Eingabe-PGN-Dateien parallel. Nutzen Sie dies zu Ihrem
Vorteil, indem Sie viele aufgeteilte PGNs als Eingabe angeben, um Parallelität
und Leistung zu erhöhen.
2. Eine Erhöhung der Batch-Größe ist gut, solange Sie eine konstante
Speichernutzung haben. Wenn die Threads nicht mithalten können, erhalten Sie
eine erhöhte Speichernutzung, und das ist der Punkt, an dem Sie wirklich Ihre
Grenze kennen.
3. Versuchen Sie, das Limit für maximale offene Dateien zu erhöhen, aber nur
bis zu dem Punkt, an dem Sie keine Systemfehler wegen zu vieler offenen Dateien
mehr erhalten. Sie können `--max-open-files=-1` spezifizieren, um Dateien
ständig offen zu halten.
4. Testen Sie verschiedene Kompressionsalgorithmen für die temporäre
[RocksDB](https://rocksdb.org)-Datenbank oder deaktivieren Sie die Kompression
vollständig, wenn Sie genügend Speicherplatz haben. jja schreibt die temporäre
[RocksDB](https://rocksdb.org)-Datenbank in das selbe Verzeichnis wie das erste
PGN-Dateiargument. Der Standardkompressionsalgorithmus
[Lz4](https://lz4.github.io/lz4/) und die Standardkompressionsstufe `4` zielen
auf eine schnelle Konvertierung mit relativ moderater Speichernutzung ab. Wenn
Ihnen während der Konvertierung der Speicherplatz ausgeht, versuchen Sie, einen
Algorithmus wie [Zstd](https://github.com/facebook/zstd) mit einer
"Ultra"-Stufe, d.h. einer Stufe größer oder gleich `20`, zu verwenden.
5. Verwenden Sie, wenn möglich, Filter, die während der PGN-Durchquerung
verarbeitet werden. Da diese Filter vor dem Schreiben der Spieldaten in die
temporäre Datenbank abgeglichen werden, können sie bei kluger Verwendung einen
großen Einfluss auf Speicher- und Speicherkosten haben und somit die
Gesamtleistung verbessern. Diese Filter sind `--filter=<expr>`,
`--max-ply=<ply>`, `--min-pieces=<piece-count>`, `--only-white` und `--only-black`.

# Danksagungen

Vielen Dank an ___Steinar H. Gunderson___, der die
[CTG-Spezifikation](https://web.archive.org/web/20210129162445/https://rybkaforum.net/cgi-bin/rybkaforum/topic_show.pl?tid=2319)
veröffentlicht und das
[remoteglot](http://git.sesse.net/?p=remoteglot;a=summary)-Tool entwickelt hat:
Der [CTG](https://www.chessprogramming.org/CTG)-Sondierungscode in ___jja___
ist direkt von seinem
[C](https://en.wikipedia.org%2Fwiki%2FC_%28programming_language%29%)-Sondierungscode
portiert und die Spezifikation war eine enorme Hilfe bei der Klärung
verschiedener Unstimmigkeiten. Vielen Dank an ___Fabien Letouzey___, den Autor
der ursprünglichen [PolyGlot](http://hgm.nubati.net/book_format.html)-Software:
Der [PolyGlot](http://hgm.nubati.net/book_format.html)-Sondierungs-,
Bucherstellungs- und Zusammenführungscode in ___jja___ ist größtenteils von
seinem entsprechenden
[C](https://en.wikipedia.org%2Fwiki%2FC_%28programming_language%29%)-Code
portiert. Vielen Dank an ___Michel Van den Bergh___, den Autor von pg\_utils,
einer Sammlung von Tools zur Interaktion mit PolyGlot-Eröffnungsbüchern: Der
[PolyGlot](http://hgm.nubati.net/book_format.html)-Buchbearbeitungscode von
___jja___ verwendet viele Ideen und Codeausschnitte aus pg\_utils. Vielen Dank
an ___Peter Österlund___, den Autor von
[DroidFish](https://www.chessprogramming.org/DroidFish): Der
[ABK](https://www.chessprogramming.org/ABK)-Eröffnungsbuch-Interface-Code in
___jja___ verwendet Ideen und Codeausschnitte aus
[DroidFish](https://www.chessprogramming.org/DroidFish). Vielen Dank an ___Jens
Nissen___, den Autor von [ChessX](https://chessx.sourceforge.io/): Die
[CTG](https://www.chessprogramming.org/CTG)- und
[ABK](https://www.chessprogramming.org/ABK)-Sondierungscodes in ___jja___
verwenden Ideen und Codeausschnitte aus
[ChessX](https://chessx.sourceforge.io/). Vielen Dank an
[LiChess](https://lichess.org), die beste Schach-Website auf dem Planeten. Der
`quote` Befehl von ___jja___ enthält eine Auswahl von Zitaten, die aus der
[LiChess](https://lichess.org)-Codebasis importiert wurden. Vielen Dank an
___Shane Hudson___, den Autor von [Scid vs.
PC](https://scidvspc.sourceforge.net/): Der `jja eco`-Befehl verwendet die
[ECO](https://www.chessprogramming.org/ECO)-Klassifizierung, die vom
[Scid](https://scidvspc.sourceforge.net/)-Projekt durchgeführt wurde.
Zusätzlich verwendet der
[PolyGlot](http://hgm.nubati.net/book_format.html)-Bearbeitungscode von
___jja___ Ideen und Code von [Scid](https://scidvspc.sourceforge.net/). Vielen
Dank an ___Marcus Bufett___, den Autor von
[chess-tactics-cli](https://github.com/marcusbuffett/chess-tactics-cli): Der
Schachbrett-Anzeigecode in den
[PolyGlot](http://hgm.nubati.net/book_format.html)- und
[ABK](https://www.chessprogramming.org/ABK)-Bearbeitungsbildschirmen ist aus
[chess-tactics-cli](https://github.com/marcusbuffett/chess-tactics-cli)
entlehnt.

# ChangeLog

Wir haben leider nicht die Zeit oder Ressourcen, um das ChangeLog ins Deutsche
zu übersetzen. Bitte beziehen Sie sich auf die originale
[README](https://git.sr.ht/~alip/jja/tree/main/item/README.md#changelog)-Datei.
